/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable(value={DistributionContext.DAEMON})
public final class PercMonitor
extends SnmpMonitorStrategy {
    private static final String SERVICE_NAME = "PERC";
    private static final String LOGICAL_BASE_OID = ".1.3.6.1.4.1.3582.1.1.2.1.3";
    private static final String PHYSICAL_BASE_OID = ".1.3.6.1.4.1.3582.1.1.3.1.4";
    private static final String ARRAY_POSITION_BASE_OID = ".1.3.6.1.4.1.3582.1.1.3.1.5";

    public String serviceName() {
        return SERVICE_NAME;
    }

    public void initialize(Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (MarshalException ex) {
            this.log().fatal("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void initialize(MonitoredService svc) {
        super.initialize(svc);
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        this.log().debug("poll: setting SNMP peer attribute for interface " + ipaddr.getHostAddress());
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        String arrayNumber = ParameterMap.getKeyedString(parameters, (String)"array", (String)"0.0");
        if (this.log().isDebugEnabled()) {
            this.log().debug("poll: service= SNMP address= " + agentConfig);
        }
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug("PercMonitor.poll: SnmpAgentConfig address: " + agentConfig);
            }
            SnmpObjId snmpObjectId = SnmpObjId.get((String)(".1.3.6.1.4.1.3582.1.1.2.1.3." + arrayNumber));
            String returnValue = new String();
            SnmpValue value = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)snmpObjectId);
            if (value.toInt() != 2) {
                this.log().debug("PercMonitor.poll: Bad Disk Found");
                returnValue = "log vol(" + arrayNumber + ") degraded";
                SnmpObjId arrayPositionSnmpObject = SnmpObjId.get((String)ARRAY_POSITION_BASE_OID);
                SnmpObjId diskStatesSnmpObject = SnmpObjId.get((String)PHYSICAL_BASE_OID);
                Map arrayDisks = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"PercMonitor", (SnmpObjId)arrayPositionSnmpObject);
                Map diskStates = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"PercMonitor", (SnmpObjId)diskStatesSnmpObject);
                Iterator i$ = arrayDisks.entrySet().iterator();
                if (i$.hasNext()) {
                    Map.Entry disk = i$.next();
                    if (((SnmpValue)disk.getValue()).toString().contains("A" + arrayNumber.toString() + "-") && ((SnmpValue)diskStates.get(disk.getKey())).toInt() != 3) {
                        returnValue = returnValue + "phy drv(" + ((SnmpInstId)disk.getKey()).toString() + ")";
                    }
                    return PollStatus.unavailable((String)returnValue);
                }
            }
            status = PollStatus.available();
        }
        catch (NumberFormatException e) {
            status = this.logDown(Level.ERROR, "Number operator used on a non-number " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            status = this.logDown(Level.ERROR, "Invalid Snmp Criteria: " + e.getMessage());
        }
        catch (Throwable t) {
            status = this.logDown(Level.WARN, "Unexpected exception during SNMP poll of interface " + ipaddr.getHostAddress(), t);
        }
        return status;
    }
}

