/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.MatchTable;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.pagesequence.Page;
import org.opennms.netmgt.config.pagesequence.PageSequence;
import org.opennms.netmgt.config.pagesequence.Parameter;
import org.opennms.netmgt.config.pagesequence.SessionVariable;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public class PageSequenceMonitor
extends IPv4Monitor {
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final int DEFAULT_RETRY = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameterMap) {
        PollStatus pollStatus;
        HttpClient client = null;
        PollStatus serviceStatus = PollStatus.unavailable((String)"");
        LinkedHashMap<String, Double> responseTimes = new LinkedHashMap<String, Double>();
        try {
            try {
                PageSequenceMonitorParameters parms = PageSequenceMonitorParameters.get(parameterMap);
                client = parms.createHttpClient();
                long startTime = System.nanoTime();
                responseTimes.put("response-time", Double.NaN);
                parms.getPageSequence().execute(client, svc, responseTimes);
                long endTime = System.nanoTime();
                double responseTime = (double)(endTime - startTime) / 1000000.0;
                serviceStatus = PollStatus.available();
                responseTimes.put("response-time", responseTime);
                serviceStatus.setProperties(responseTimes);
                pollStatus = serviceStatus;
                Object var15_15 = null;
                if (client == null) return pollStatus;
            }
            catch (PageSequenceMonitorException e) {
                serviceStatus = PollStatus.unavailable((String)e.getMessage());
                serviceStatus.setProperties(responseTimes);
                PollStatus pollStatus2 = serviceStatus;
                Object var15_16 = null;
                if (client == null) return pollStatus2;
                client.getHttpConnectionManager().closeIdleConnections(0L);
                return pollStatus2;
            }
            catch (IllegalArgumentException e) {
                this.log().error("Invalid parameters to monitor: " + e, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)("Invalid parameter to monitor: " + e.getMessage() + ".  See log for details."));
                serviceStatus.setProperties(responseTimes);
                PollStatus pollStatus3 = serviceStatus;
                Object var15_17 = null;
                if (client == null) return pollStatus3;
                client.getHttpConnectionManager().closeIdleConnections(0L);
                return pollStatus3;
            }
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            if (client == null) throw throwable;
            client.getHttpConnectionManager().closeIdleConnections(0L);
            throw throwable;
        }
        client.getHttpConnectionManager().closeIdleConnections(0L);
        return pollStatus;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageSequenceMonitorParameters {
        public static final String KEY = PageSequenceMonitorParameters.class.getName();
        private Map<String, String> m_parameterMap;
        private HttpClientParams m_clientParams;
        private HttpPageSequence m_pageSequence;

        static synchronized PageSequenceMonitorParameters get(Map paramterMap) {
            PageSequenceMonitorParameters parms = (PageSequenceMonitorParameters)paramterMap.get(KEY);
            if (parms == null) {
                parms = new PageSequenceMonitorParameters(paramterMap);
                paramterMap.put(KEY, parms);
            }
            return parms;
        }

        PageSequenceMonitorParameters(Map<String, String> parameterMap) {
            this.m_parameterMap = parameterMap;
            String pageSequence = this.getStringParm("page-sequence", null);
            if (pageSequence == null) {
                throw new IllegalArgumentException("page-sequence must be set in monitor parameters");
            }
            PageSequence sequence = this.parsePageSequence(pageSequence);
            this.m_pageSequence = new HttpPageSequence(sequence);
            this.createClientParams();
        }

        Map<String, String> getParameterMap() {
            return this.m_parameterMap;
        }

        HttpPageSequence getPageSequence() {
            return this.m_pageSequence;
        }

        PageSequence parsePageSequence(String sequenceString) {
            try {
                return (PageSequence)CastorUtils.unmarshal(PageSequence.class, (Reader)new StringReader(sequenceString));
            }
            catch (MarshalException e) {
                throw new IllegalArgumentException("Unable to parse page-sequence for HttpMonitor: " + (Object)((Object)e) + "\nConfig: " + sequenceString, e);
            }
            catch (ValidationException e) {
                throw new IllegalArgumentException("Unable to validate page-sequence for HttpMonitor: " + (Object)((Object)e) + "\nConfig: " + sequenceString, e);
            }
        }

        private String getStringParm(String key, String deflt) {
            return ParameterMap.getKeyedString(this.getParameterMap(), (String)key, (String)deflt);
        }

        private int getIntParm(String key, int defValue) {
            return ParameterMap.getKeyedInteger(this.getParameterMap(), (String)key, (int)defValue);
        }

        private void createClientParams() {
            this.m_clientParams = new HttpClientParams();
            this.m_clientParams.setConnectionManagerTimeout((long)this.getTimeout());
            this.m_clientParams.setSoTimeout(this.getTimeout());
            this.m_clientParams.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(this.getRetries(), false));
            this.m_clientParams.setCookiePolicy("compatibility");
        }

        public int getRetries() {
            return this.getIntParm("retry", 0);
        }

        public int getTimeout() {
            return this.getIntParm("timeout", 3000);
        }

        public HttpClientParams getClientParams() {
            return this.m_clientParams;
        }

        HttpClient createHttpClient() {
            HttpClient client = new HttpClient(this.getClientParams());
            client.getHttpConnectionManager().getParams().setConnectionTimeout(this.getTimeout());
            return client;
        }
    }

    public static class HttpPage {
        private Page m_page;
        private HttpResponseRange m_range;
        private Pattern m_successPattern;
        private Pattern m_failurePattern;
        private HttpPageSequence m_parentSequence;
        private double m_responseTime;
        private NameValuePair[] m_parms;

        HttpPage(HttpPageSequence parent, Page page) {
            this.m_page = page;
            this.m_range = new HttpResponseRange(page.getResponseRange());
            this.m_successPattern = page.getSuccessMatch() == null ? null : Pattern.compile(page.getSuccessMatch());
            this.m_failurePattern = page.getFailureMatch() == null ? null : Pattern.compile(page.getFailureMatch());
            this.m_parentSequence = parent;
            ArrayList<NameValuePair> parms = new ArrayList<NameValuePair>();
            for (Parameter parm : this.m_page.getParameter()) {
                parms.add(new NameValuePair(parm.getKey(), parm.getValue()));
            }
            this.m_parms = parms.toArray(new NameValuePair[parms.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute(HttpClient client, MonitoredService svc, Properties sequenceProperties) {
            try {
                Matcher matcher;
                String userInfo;
                String[] streetCred;
                URI uri = this.getURI(svc);
                PageSequenceHttpMethod method = this.getMethod();
                method.setURI(uri);
                if (this.getVirtualHost(svc) != null) {
                    method.getParams().setVirtualHost(this.getVirtualHost(svc));
                }
                if (this.getUserAgent() != null) {
                    method.addRequestHeader("User-Agent", this.getUserAgent());
                } else {
                    method.addRequestHeader("User-Agent", "OpenNMS PageSequenceMonitor (Service name: " + svc.getSvcName() + ")");
                }
                if (this.m_parms.length > 0) {
                    method.setParameters(this.expandParms(svc));
                }
                if (this.m_page.getUserInfo() != null && (streetCred = (userInfo = this.m_page.getUserInfo()).split(":", 2)).length == 2) {
                    client.getState().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)new UsernamePasswordCredentials(streetCred[0], streetCred[1]));
                    method.setDoAuthentication(true);
                }
                long startTime = System.nanoTime();
                int code = client.executeMethod((HttpMethod)method);
                long endTime = System.nanoTime();
                this.m_responseTime = (double)(endTime - startTime) / 1000000.0;
                if (!this.getRange().contains(code)) {
                    throw new PageSequenceMonitorException("response code out of range for uri:" + uri + ".  Expected " + this.getRange() + " but received " + code);
                }
                InputStream inputStream = method.getResponseBodyAsStream();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                    Object var14_16 = null;
                }
                catch (Throwable throwable) {
                    Object var14_17 = null;
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                String responseString = outputStream.toString();
                if (this.getFailurePattern() != null && (matcher = this.getFailurePattern().matcher(responseString)).find()) {
                    throw new PageSequenceMonitorException(this.getResolvedFailureMessage(matcher));
                }
                if (this.getSuccessPattern() != null) {
                    matcher = this.getSuccessPattern().matcher(responseString);
                    if (!matcher.find()) {
                        throw new PageSequenceMonitorException("failed to find '" + this.getSuccessPattern() + "' in page content at " + uri);
                    }
                    this.updateSequenceProperties(sequenceProperties, matcher);
                }
            }
            catch (URIException e) {
                throw new IllegalArgumentException("unable to construct URL for page: " + (Object)((Object)e), e);
            }
            catch (HttpException e) {
                throw new PageSequenceMonitorException("HTTP Error " + (Object)((Object)e), e);
            }
            catch (IOException e) {
                throw new PageSequenceMonitorException("I/O Error " + e, e);
            }
        }

        private NameValuePair[] expandParms(MonitoredService svc) {
            Properties seqProps;
            ArrayList<NameValuePair> expandedParms = new ArrayList<NameValuePair>();
            Properties svcProps = this.getServiceProperties(svc);
            if (svcProps != null && this.log().isDebugEnabled()) {
                this.log().debug("I have " + svcProps.size() + " service properties.");
            }
            if ((seqProps = this.getSequenceProperties()) != null && this.log().isDebugEnabled()) {
                this.log().debug("I have " + seqProps.size() + " sequence properties.");
            }
            for (NameValuePair nvp : this.m_parms) {
                NameValuePair expanded = new NameValuePair();
                expanded.setName(nvp.getName());
                expanded.setValue(PropertiesUtils.substitute((String)nvp.getValue(), (Properties[])new Properties[]{this.getServiceProperties(svc), this.getSequenceProperties()}));
                expandedParms.add(expanded);
                if (!this.log().isDebugEnabled() || nvp.getValue().equals(expanded.getValue())) continue;
                this.log().debug("Expanded parm with name '" + nvp.getName() + "' from '" + nvp.getValue() + "' to '" + expanded.getValue() + "'");
            }
            return expandedParms.toArray(new NameValuePair[expandedParms.size()]);
        }

        private void updateSequenceProperties(Properties props, Matcher matcher) {
            for (SessionVariable varBinding : this.m_page.getSessionVariableCollection()) {
                String vbName = varBinding.getName();
                String vbValue = matcher.group(varBinding.getMatchGroup());
                if (vbValue == null) {
                    vbValue = "";
                }
                props.put(vbName, vbValue);
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug("Just set session variable '" + vbName + "' to '" + vbValue + "'");
            }
            this.setSequenceProperties(props);
        }

        private String getUserAgent() {
            return this.m_page.getUserAgent();
        }

        private String getVirtualHost(MonitoredService svc) {
            return PropertiesUtils.substitute((String)this.m_page.getVirtualHost(), (Properties[])new Properties[]{this.getServiceProperties(svc), this.getSequenceProperties()});
        }

        private URI getURI(MonitoredService svc) throws URIException {
            Properties svcProps = this.getServiceProperties(svc);
            Properties seqProps = this.getSequenceProperties();
            return new URI(this.getScheme(), this.getUserInfo(), this.getHost(seqProps, svcProps), this.getPort(new Properties[0]), this.getPath(seqProps, svcProps), this.getQuery(seqProps, svcProps), this.getFragment(seqProps, svcProps));
        }

        private String getFragment(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getFragment(), (Properties[])p);
        }

        private String getQuery(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getQuery(), (Properties[])p);
        }

        private String getPath(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getPath(), (Properties[])p);
        }

        private int getPort(Properties ... p) {
            return Integer.valueOf(PropertiesUtils.substitute((String)String.valueOf(this.m_page.getPort()), (Properties[])p));
        }

        private String getHost(Properties ... p) {
            return PropertiesUtils.substitute((String)this.m_page.getHost(), (Properties[])p);
        }

        private Properties getServiceProperties(MonitoredService svc) {
            Properties properties = new Properties();
            properties.put("ipaddr", svc.getIpAddr());
            properties.put("nodeid", (Object)svc.getNodeId());
            properties.put("nodelabel", svc.getNodeLabel());
            properties.put("svcname", svc.getSvcName());
            return properties;
        }

        private String getUserInfo() {
            return this.m_page.getUserInfo();
        }

        private String getScheme() {
            return this.m_page.getScheme();
        }

        private PageSequenceHttpMethod getMethod() {
            String method = this.m_page.getMethod();
            return "GET".equalsIgnoreCase(method) ? new PageSequenceHttpGetMethod() : new PageSequenceHttpPostMethod();
        }

        private HttpResponseRange getRange() {
            return this.m_range;
        }

        private Pattern getSuccessPattern() {
            return this.m_successPattern;
        }

        private Pattern getFailurePattern() {
            return this.m_failurePattern;
        }

        private String getFailureMessage() {
            return this.m_page.getFailureMessage();
        }

        private String getResolvedFailureMessage(Matcher matcher) {
            return PropertiesUtils.substitute((String)this.getFailureMessage(), (PropertiesUtils.SymbolTable[])new PropertiesUtils.SymbolTable[]{new MatchTable(matcher)});
        }

        private Properties getSequenceProperties() {
            return this.m_parentSequence.getSequenceProperties();
        }

        private void setSequenceProperties(Properties props) {
            this.m_parentSequence.setSequenceProperties(props);
        }

        public Number getResponseTime() {
            return this.m_responseTime;
        }

        public String getDsName() {
            return this.m_page.getDsName();
        }

        private ThreadCategory log() {
            return ThreadCategory.getInstance(this.getClass());
        }
    }

    public static class PageSequenceHttpGetMethod
    extends GetMethod
    implements PageSequenceHttpMethod {
        public void setParameters(NameValuePair[] parms) {
            this.setQueryString(parms);
        }
    }

    public static class PageSequenceHttpPostMethod
    extends PostMethod
    implements PageSequenceHttpMethod {
        public void setParameters(NameValuePair[] parms) {
            this.setRequestBody(parms);
        }

        public boolean getFollowRedirects() {
            return true;
        }
    }

    public static interface PageSequenceHttpMethod
    extends HttpMethod {
        public void setParameters(NameValuePair[] var1);
    }

    public static class HttpResponseRange {
        private static final Pattern RANGE_PATTERN = Pattern.compile("([1-5][0-9][0-9])(?:-([1-5][0-9][0-9]))?");
        private int m_begin;
        private int m_end;

        HttpResponseRange(String rangeSpec) {
            Matcher matcher = RANGE_PATTERN.matcher(rangeSpec);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Invalid range spec: " + rangeSpec);
            }
            String beginSpec = matcher.group(1);
            String endSpec = matcher.group(2);
            this.m_begin = Integer.parseInt(beginSpec);
            this.m_end = endSpec == null ? this.m_begin : Integer.parseInt(endSpec);
        }

        public boolean contains(int responseCode) {
            return this.m_begin <= responseCode && responseCode <= this.m_end;
        }

        public String toString() {
            if (this.m_begin == this.m_end) {
                return Integer.toString(this.m_begin);
            }
            return Integer.toString(this.m_begin) + '-' + Integer.toString(this.m_end);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HttpPageSequence {
        PageSequence m_sequence;
        List<HttpPage> m_pages;
        Properties m_sequenceProperties;

        HttpPageSequence(PageSequence sequence) {
            this.m_sequence = sequence;
            this.m_pages = new ArrayList<HttpPage>(this.m_sequence.getPageCount());
            for (Page page : this.m_sequence.getPage()) {
                this.m_pages.add(new HttpPage(this, page));
            }
            this.m_sequenceProperties = new Properties();
        }

        List<HttpPage> getPages() {
            return this.m_pages;
        }

        private void execute(HttpClient client, MonitoredService svc, Map<String, Number> responseTimes) {
            this.clearSequenceProperties();
            for (HttpPage page : this.getPages()) {
                if (page.getDsName() == null) continue;
                responseTimes.put(page.getDsName(), Double.NaN);
            }
            for (HttpPage page : this.getPages()) {
                page.execute(client, svc, this.m_sequenceProperties);
                if (page.getDsName() == null) continue;
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Recording response time " + page.getResponseTime() + " for ds " + page.getDsName());
                }
                responseTimes.put(page.getDsName(), page.getResponseTime());
            }
        }

        protected Properties getSequenceProperties() {
            return this.m_sequenceProperties;
        }

        protected void setSequenceProperties(Properties newProps) {
            this.m_sequenceProperties = newProps;
        }

        protected void clearSequenceProperties() {
            this.m_sequenceProperties.clear();
        }

        private ThreadCategory log() {
            return ThreadCategory.getInstance(this.getClass());
        }
    }

    public static class PageSequenceMonitorException
    extends RuntimeException {
        private static final long serialVersionUID = 1346757238604080088L;

        public PageSequenceMonitorException(String message) {
            super(message);
        }

        public PageSequenceMonitorException(Throwable cause) {
            super(cause);
        }

        public PageSequenceMonitorException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

