/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Level;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

@Distributable(value={DistributionContext.DAEMON})
public final class OpenManageChassisMonitor
extends SnmpMonitorStrategy {
    private static final String m_serviceName = "Dell_OpenManageChassis";
    private static final String CHASSIS_STATUS_OID = ".1.3.6.1.4.1.674.10892.1.300.10.1.4.1";
    private static final String EVENT_LOG_STATUS_OID = ".1.3.6.1.4.1.674.10892.1.200.10.1.41.1";
    private static final String MANUFACTURER_OID = ".1.3.6.1.4.1.674.10892.1.300.10.1.8.1";
    private static final String MODEL_NAME_OID = "1.3.6.1.4.1.674.10892.1.300.10.1.9.1";
    private static final String SERVICE_TAG_OID = ".1.3.6.1.4.1.674.10892.1.300.10.1.11.1";

    public String serviceName() {
        return m_serviceName;
    }

    public void initialize(Map parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (MarshalException ex) {
            this.log().fatal("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().fatal("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().fatal("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public void initialize(MonitoredService svc) {
        super.initialize(svc);
    }

    public PollStatus poll(MonitoredService svc, Map parameters) {
        NetworkInterface iface = svc.getNetInterface();
        String returnValue = new String();
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = (InetAddress)iface.getAddress();
        String eventLogStatusTxt = "N/A";
        String manufacturerName = "N/A";
        String modelName = "N/A";
        String serviceTagTxt = "N/A";
        String chassisStatusTxt = "N/A";
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        this.log().debug("poll: setting SNMP peer attribute for interface " + ipaddr.getHostAddress());
        agentConfig.setTimeout(ParameterMap.getKeyedInteger((Map)parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger((Map)parameters, (String)"retry", (int)ParameterMap.getKeyedInteger((Map)parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger((Map)parameters, (String)"port", (int)agentConfig.getPort()));
        try {
            SnmpObjId chassisStatusSnmpObject;
            SnmpValue chassisStatus;
            if (this.log().isDebugEnabled()) {
                this.log().debug("poll: SnmpAgentConfig address: " + agentConfig);
            }
            if ((chassisStatus = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)(chassisStatusSnmpObject = SnmpObjId.get((String)CHASSIS_STATUS_OID)))) == null) {
                this.log().warn("No chassis status received!");
                return status;
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("poll: chassis status: " + chassisStatus);
            }
            if (chassisStatus.toInt() == DELL_STATUS.OK.value()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("poll: chassis status: " + chassisStatus.toInt());
                }
                return PollStatus.available();
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("poll: chassis status: " + chassisStatus.toInt());
            }
            chassisStatusTxt = this.resolveDellStatus(chassisStatus.toInt());
            SnmpObjId eventLogStatusSnmpObject = SnmpObjId.get((String)EVENT_LOG_STATUS_OID);
            SnmpValue eventLogStatus = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)eventLogStatusSnmpObject);
            if (eventLogStatus == null) {
                this.log().warn("Cannot receive eventLogStatus.");
            } else {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("poll: eventLogStatus: " + eventLogStatus);
                }
                eventLogStatusTxt = this.resolveDellStatus(eventLogStatus.toInt());
            }
            SnmpObjId manufacturerSnmpObject = SnmpObjId.get((String)MANUFACTURER_OID);
            SnmpValue manufacturer = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)manufacturerSnmpObject);
            if (manufacturer == null) {
                this.log().warn("Cannot receive manufacturer.");
            } else {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("poll: manufacturer: " + manufacturer);
                }
                manufacturerName = manufacturer.toString();
            }
            SnmpObjId modelSnmpObject = SnmpObjId.get((String)MODEL_NAME_OID);
            SnmpValue model = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)modelSnmpObject);
            if (model == null) {
                this.log().warn("Cannot receive model name.");
            } else {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("poll: model name: " + model);
                }
                modelName = model.toString();
            }
            SnmpObjId serviceTagSnmpObject = SnmpObjId.get((String)SERVICE_TAG_OID);
            SnmpValue serviceTag = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)serviceTagSnmpObject);
            if (serviceTag == null) {
                this.log().warn("Cannot receive service tag");
            } else {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("poll: service tag: " + serviceTag);
                }
                serviceTagTxt = serviceTag.toString();
            }
            returnValue = "Chassis status from " + manufacturerName + " " + modelName + " with service tag " + serviceTagTxt + " is " + chassisStatusTxt + ". Last event log status is " + eventLogStatusTxt + ". For further information, check your OpenManage website!";
            status = PollStatus.unavailable((String)returnValue);
        }
        catch (NullPointerException e) {
            status = this.logDown(Level.WARN, "Unexpected error during SNMP poll of interface " + ipaddr.getHostAddress(), e);
        }
        catch (NumberFormatException e) {
            status = this.logDown(Level.WARN, "Number operator used on a non-number " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            status = this.logDown(Level.WARN, "Invalid Snmp Criteria: " + e.getMessage());
        }
        catch (Throwable t) {
            status = this.logDown(Level.WARN, "Unexpected exception during SNMP poll of interface " + ipaddr.getHostAddress(), t);
        }
        return status;
    }

    private String resolveDellStatus(int sc) {
        String name = "N/A";
        if (DELL_STATUS.OTHER.value() == sc) {
            name = DELL_STATUS.OTHER.name();
        }
        if (DELL_STATUS.UNKNOWN.value() == sc) {
            name = DELL_STATUS.UNKNOWN.name();
        }
        if (DELL_STATUS.OK.value() == sc) {
            name = DELL_STATUS.OK.name();
        }
        if (DELL_STATUS.NON_CRITICAL.value() == sc) {
            name = DELL_STATUS.NON_CRITICAL.name();
        }
        if (DELL_STATUS.CRITICAL.value() == sc) {
            name = DELL_STATUS.CRITICAL.name();
        }
        if (DELL_STATUS.NON_RECOVERABLE.value() == sc) {
            name = DELL_STATUS.NON_RECOVERABLE.name();
        }
        return name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DELL_STATUS {
        OTHER(1),
        UNKNOWN(2),
        OK(3),
        NON_CRITICAL(4),
        CRITICAL(5),
        NON_RECOVERABLE(6);

        private final int state;

        private DELL_STATUS(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }
}

