/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Level;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;
import org.opennms.protocols.jmx.connectors.ConnectionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Distributable
public abstract class JMXMonitor
extends IPv4Monitor {
    public abstract ConnectionWrapper getMBeanServerConnection(Map<String, Object> var1, InetAddress var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> map) {
        NetworkInterface iface = svc.getNetInterface();
        PollStatus serviceStatus = PollStatus.unavailable();
        String dsName = null;
        InetAddress ipv4Addr = (InetAddress)iface.getAddress();
        ConnectionWrapper connection = null;
        try {
            int retry = ParameterMap.getKeyedInteger(map, (String)"retry", (int)3);
            long t0 = 0L;
            for (int attempts = 0; attempts <= retry && !serviceStatus.isAvailable(); ++attempts) {
                try {
                    t0 = System.nanoTime();
                    connection = this.getMBeanServerConnection(map, ipv4Addr);
                    if (connection == null) continue;
                    connection.getMBeanServer().getMBeanCount();
                    long nanoResponseTime = System.nanoTime() - t0;
                    serviceStatus = PollStatus.available((Double)((double)nanoResponseTime / 1000000.0));
                }
                catch (IOException e) {
                    serviceStatus = this.logDown(Level.DEBUG, dsName + ": IOException while polling address: " + ipv4Addr);
                }
                break;
            }
        }
        catch (Exception e) {
            serviceStatus = this.logDown(Level.DEBUG, dsName + " Monitor - failed! " + ipv4Addr.getHostAddress());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return serviceStatus;
    }
}

