/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.IOUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.monitors.IPv4Monitor;

@Distributable(value={DistributionContext.DAEMON})
public class BSFMonitor
extends IPv4Monitor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map map) {
        BSFManager bsfManager = new BSFManager();
        PollStatus pollStatus = PollStatus.unavailable();
        String fileName = ParameterMap.getKeyedString((Map)map, (String)"file-name", null);
        String lang = ParameterMap.getKeyedString((Map)map, (String)"lang-class", null);
        String langEngine = ParameterMap.getKeyedString((Map)map, (String)"bsf-engine", null);
        String[] langExtensions = ParameterMap.getKeyedString((Map)map, (String)"file-extensions", (String)"").split(",");
        File file = new File(fileName);
        try {
            if (lang == null) {
                lang = BSFManager.getLangFromFilename((String)fileName);
            }
            if (langEngine != null && lang != null && langExtensions.length > 0) {
                BSFManager.registerScriptingEngine((String)lang, (String)langEngine, (String[])langExtensions);
            }
            if (file.exists() && file.canRead()) {
                String code = IOUtils.getStringFromReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                String status = new String();
                bsfManager.declareBean("map", (Object)map, Map.class);
                bsfManager.declareBean("ip_addr", (Object)svc.getIpAddr(), String.class);
                bsfManager.declareBean("node_id", (Object)svc.getNodeId(), Integer.TYPE);
                bsfManager.declareBean("node_label", (Object)svc.getNodeLabel(), String.class);
                bsfManager.declareBean("svc_name", (Object)svc.getSvcName(), String.class);
                for (Object obj : map.keySet()) {
                    bsfManager.declareBean(obj.toString(), map.get(obj), String.class);
                }
                status = bsfManager.eval(lang, "BSFMonitor", 0, 0, (Object)code).toString();
                pollStatus = status == "OK" ? PollStatus.available() : PollStatus.unavailable((String)status);
            } else {
                pollStatus = PollStatus.unavailable((String)("can not locate or read file: " + fileName));
            }
        }
        catch (BSFException e) {
            pollStatus = PollStatus.unavailable((String)e.toString());
        }
        catch (FileNotFoundException e) {
            pollStatus = PollStatus.unavailable((String)("Could not find file: " + fileName));
        }
        catch (IOException e) {
            pollStatus = PollStatus.unavailable((String)e.toString());
        }
        finally {
            bsfManager.terminate();
        }
        return pollStatus;
    }
}

