/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import org.opennms.core.utils.Argument;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.notifd.NotificationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IrcCatNotificationStrategy
implements NotificationStrategy {
    @Override
    public int send(List<Argument> arguments) {
        try {
            String message = this.buildMessage(arguments);
            Socket s = new Socket(this.getRemoteAddr(), this.getRemotePort());
            PrintStream stream = new PrintStream(s.getOutputStream());
            stream.println(message);
            stream.close();
        }
        catch (Exception e) {
            this.log().error("send: Error sending IRCcat notification: " + e, (Throwable)e);
            return 1;
        }
        return 0;
    }

    private InetAddress getRemoteAddr() throws UnknownHostException {
        return InetAddress.getByName(System.getProperty("irccat.host", "127.0.0.1"));
    }

    private int getRemotePort() {
        return Integer.parseInt(System.getProperty("irccat.port", "12345"));
    }

    private String buildMessage(List<Argument> arguments) {
        String recipient = null;
        String message = null;
        for (Argument arg : arguments) {
            if ("-email".equals(arg.getSwitch())) {
                recipient = arg.getValue();
                continue;
            }
            if ("-tm".equals(arg.getSwitch())) {
                message = arg.getValue();
                continue;
            }
            throw new IllegalArgumentException("Unsupported notification argument switch '" + arg.getSwitch() + "'");
        }
        if (recipient == null) {
            throw new IllegalArgumentException("no recipient specified, but is required");
        }
        if (message == null) {
            throw new IllegalArgumentException("no message specified, but is required");
        }
        return recipient + " " + message;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

