/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.linkd.AtInterface;
import org.opennms.netmgt.linkd.BridgeStpInterface;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.MacToNodeLink;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.Vlan;
import org.opennms.netmgt.linkd.scheduler.ReadyRunnable;
import org.opennms.netmgt.linkd.scheduler.Scheduler;
import org.opennms.netmgt.linkd.snmp.FdbTableGet;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiscoveryLink
implements ReadyRunnable {
    private static final int SNMP_IF_TYPE_ETHERNET = 6;
    private static final int SNMP_IF_TYPE_PROP_VIRTUAL = 53;
    private static final int SNMP_IF_TYPE_L2_VLAN = 135;
    private static final int SNMP_IF_TYPE_L3_VLAN = 136;
    private String packageName;
    private List<NodeToNodeLink> links = new ArrayList<NodeToNodeLink>();
    private List<MacToNodeLink> maclinks = new ArrayList<MacToNodeLink>();
    private HashMap<Integer, LinkableNode> bridgeNodes = new HashMap();
    private List<LinkableNode> routerNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> cdpNodes = new ArrayList<LinkableNode>();
    private List<LinkableNode> atNodes = new ArrayList<LinkableNode>();
    private List<String> macsParsed = new ArrayList<String>();
    private List<String> macsExcluded = new ArrayList<String>();
    private Map<String, List<AtInterface>> macToAtinterface = new HashMap<String, List<AtInterface>>();
    private boolean enableDownloadDiscovery = false;
    private boolean discoveryUsingRoutes = true;
    private boolean discoveryUsingCdp = true;
    private boolean discoveryUsingBridge = true;
    private boolean suspendCollection = false;
    private boolean isRunned = false;
    private boolean forceIpRouteDiscoveryOnEtherNet = false;
    private Scheduler m_scheduler;
    private long snmp_poll_interval = 1800000L;
    private long discovery_interval = 300000L;
    private long initial_sleep_time = 600000L;

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public void run() {
        if (this.suspendCollection) {
            this.log().warn("DiscoveryLink.run: Suspended!");
        } else {
            Iterator<Object> sub_ite;
            Collection<LinkableNode> all_snmplinknodes = Linkd.getInstance().getLinkableNodesOnPackage(this.getPackageName());
            if (this.log().isDebugEnabled()) {
                this.log().debug("run: LinkableNodes/package found: " + all_snmplinknodes.size() + "/" + this.getPackageName());
                this.log().debug("run: discoveryUsingBridge/discoveryUsingCdp/discoveryUsingRoutes: " + this.discoveryUsingBridge + "/" + this.discoveryUsingCdp + "/" + this.discoveryUsingRoutes);
                this.log().debug("run: enableDownloadDiscovery: " + this.enableDownloadDiscovery);
            }
            Iterator<LinkableNode> ite = all_snmplinknodes.iterator();
            while (ite.hasNext()) {
                LinkableNode curNode = ite.next();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("run: Iterating on LinkableNode's found node: " + curNode.getNodeId());
                }
                if (curNode == null) {
                    this.log().error("run: null linkable node found for iterator " + ite);
                    continue;
                }
                if (curNode.isBridgeNode && this.discoveryUsingBridge) {
                    this.bridgeNodes.put(new Integer(curNode.getNodeId()), curNode);
                }
                if (curNode.hasCdpInterfaces() && this.discoveryUsingCdp) {
                    this.cdpNodes.add(curNode);
                }
                if (curNode.hasRouteInterfaces() && this.discoveryUsingRoutes) {
                    this.routerNodes.add(curNode);
                }
                if (!curNode.hasAtInterfaces()) continue;
                this.atNodes.add(curNode);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("run: using atNodes to populate macToAtinterface");
            }
            ite = this.atNodes.iterator();
            while (ite.hasNext()) {
                for (AtInterface at : ite.next().getAtInterfaces()) {
                    int nodeid = at.getNodeId();
                    String ipaddr = at.getIpAddress();
                    String macAddress = at.getMacAddress();
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("Parsing at Interface nodeid/ipaddr/macaddr: " + nodeid + "/" + ipaddr + "/" + macAddress);
                    }
                    if (!Linkd.getInstance().isInterfaceInPackage(at.getIpAddress(), this.getPackageName())) {
                        if (this.log().isInfoEnabled()) {
                            this.log().info("run: at interface: " + ipaddr + " does not belong to package: " + this.getPackageName() + "! Not adding to discoverable atinterface.");
                        }
                        this.macsExcluded.add(macAddress);
                        continue;
                    }
                    if (this.isMacIdentifierOfBridgeNode(macAddress)) {
                        if (this.log().isInfoEnabled()) {
                            this.log().info("run: at interface " + macAddress + " belongs to bridge node! Not adding to discoverable atinterface.");
                        }
                        this.macsExcluded.add(macAddress);
                        continue;
                    }
                    if (macAddress.indexOf("00000c07ac") == 0) {
                        this.log().info("run: at interface " + macAddress + " is cisco hsrp address! Not adding to discoverable atinterface.");
                        this.macsExcluded.add(macAddress);
                        continue;
                    }
                    List<AtInterface> ats = this.macToAtinterface.get(macAddress);
                    if (ats == null) {
                        ats = new ArrayList<AtInterface>();
                    }
                    if (this.log().isInfoEnabled()) {
                        this.log().info("parseAtNodes: Adding to discoverable atinterface.");
                    }
                    ats.add(at);
                    this.macToAtinterface.put(macAddress, ats);
                    if (!this.log().isDebugEnabled()) continue;
                    this.log().debug("parseAtNodes: mac:" + macAddress + " has now atinterface reference: " + ats.size());
                }
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("run: end populate macToAtinterface");
            }
            if (this.enableDownloadDiscovery) {
                if (this.log().isInfoEnabled()) {
                    this.log().info("run: get further unknown mac address snmp bridge table info");
                }
                this.snmpParseBridgeNodes();
            } else if (this.log().isInfoEnabled()) {
                this.log().info("run: skipping get further unknown mac address snmp bridge table info");
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("run: finding links among nodes using Cisco Discovery Protocol");
            }
            for (LinkableNode curNode : this.cdpNodes) {
                int curCdpNodeId = curNode.getNodeId();
                String curCdpIpAddr = curNode.getSnmpPrimaryIpAddr();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("run: parsing nodeid " + curCdpNodeId + " ip address " + curCdpIpAddr + " with " + curNode.getCdpInterfaces().size() + " Cdp Interfaces. ");
                }
                for (CdpInterface cdpIface : curNode.getCdpInterfaces()) {
                    LinkableNode targetNode;
                    int cdpIfIndex = cdpIface.getCdpIfIndex();
                    if (cdpIfIndex < 0) {
                        this.log().warn("run: found not valid CDP IfIndex " + cdpIfIndex + " . Skipping");
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: found CDP ifindex " + cdpIfIndex);
                    }
                    InetAddress targetIpAddr = cdpIface.getCdpTargetIpAddr();
                    if (!Linkd.getInstance().isInterfaceInPackage(targetIpAddr.getHostAddress(), this.getPackageName())) {
                        this.log().warn("run: ip address " + targetIpAddr.getHostAddress() + " Not in package: " + this.getPackageName() + ". Skipping");
                        continue;
                    }
                    int targetCdpNodeId = cdpIface.getCdpTargetNodeId();
                    if (targetCdpNodeId == -1) {
                        this.log().warn("run: no node id found for ip address " + targetIpAddr.getHostAddress() + ". Skipping");
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: found nodeid/CDP target ipaddress: " + targetCdpNodeId + ":" + targetIpAddr);
                    }
                    if (targetCdpNodeId == curCdpNodeId) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug("run: node id found for ip address " + targetIpAddr.getHostAddress() + " is itself. Skipping");
                        continue;
                    }
                    int cdpDestIfindex = cdpIface.getCdpTargetIfIndex();
                    if (cdpDestIfindex < 0) {
                        this.log().warn("run: found not valid CDP destination IfIndex " + cdpDestIfindex + " . Skipping");
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: found CDP target ifindex " + cdpDestIfindex);
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: parsing CDP link: nodeid=" + curCdpNodeId + " ifindex=" + cdpIfIndex + " nodeparentid=" + targetCdpNodeId + " parentifindex=" + cdpDestIfindex);
                    }
                    boolean add = false;
                    if (curNode.isBridgeNode() && this.isBridgeNode(targetCdpNodeId)) {
                        targetNode = this.bridgeNodes.get(new Integer(targetCdpNodeId));
                        add = this.parseCdpLinkOn(curNode, cdpIfIndex, targetNode, cdpDestIfindex);
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: both node are bridge nodes! Adding: " + add);
                        }
                    } else if (curNode.isBridgeNode) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: source node is bridge node, target node is not bridge node! Adding: " + add);
                        }
                        add = this.parseCdpLinkOn(curNode, cdpIfIndex, targetCdpNodeId);
                    } else if (this.isBridgeNode(targetCdpNodeId)) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: source node is not bridge node, target node is bridge node! Adding: " + add);
                        }
                        targetNode = this.bridgeNodes.get(new Integer(targetCdpNodeId));
                        add = this.parseCdpLinkOn(targetNode, cdpDestIfindex, curCdpNodeId);
                    } else {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: no node is bridge node! Adding CDP link");
                        }
                        add = true;
                    }
                    if (!add) continue;
                    NodeToNodeLink lk = new NodeToNodeLink(targetCdpNodeId, cdpDestIfindex);
                    lk.setNodeparentid(curCdpNodeId);
                    lk.setParentifindex(cdpIfIndex);
                    this.addNodetoNodeLink(lk);
                    if (!this.log().isDebugEnabled()) continue;
                    this.log().debug("run: CDP link added: " + lk.toString());
                }
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("run: try to found backbone ethernet links among bridge nodes using Spanning Tree Protocol");
            }
            for (LinkableNode curNode : this.bridgeNodes.values()) {
                int curNodeId = curNode.getNodeId();
                String cupIpAddr = curNode.getSnmpPrimaryIpAddr();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("run: parsing bridge nodeid " + curNodeId + " ip address " + cupIpAddr);
                }
                sub_ite = curNode.getStpInterfaces().entrySet().iterator();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("run: parsing " + curNode.getStpInterfaces().size() + " Vlan. ");
                }
                while (sub_ite.hasNext()) {
                    Map.Entry me = (Map.Entry)sub_ite.next();
                    String vlan = (String)me.getKey();
                    String curBaseBridgeAddress = curNode.getBridgeIdentifier(vlan);
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: found bridge identifier " + curBaseBridgeAddress);
                    }
                    String designatedRoot = null;
                    if (!curNode.hasStpRoot(vlan)) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug("run: desigated root bridge identifier not found. Skipping" + curBaseBridgeAddress);
                        continue;
                    }
                    designatedRoot = curNode.getStpRoot(vlan);
                    if (designatedRoot.equals("0000000000000000")) {
                        this.log().warn("run: designated root is invalid. Skipping");
                        continue;
                    }
                    if (curNode.isBridgeIdentifier(designatedRoot.substring(4))) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug("run: STP designated root is the bridge itself. Skipping");
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: STP designated root is another bridge. " + designatedRoot + " Parsing Stp Interface");
                    }
                    for (BridgeStpInterface stpIface : (List)me.getValue()) {
                        int stpbridgeport = stpIface.getBridgeport();
                        if (curNode.isBackBoneBridgePort(stpbridgeport)) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("run: bridge port " + stpbridgeport + " already found .... Skipping");
                            continue;
                        }
                        String stpPortDesignatedPort = stpIface.getStpPortDesignatedPort();
                        String stpPortDesignatedBridge = stpIface.getStpPortDesignatedBridge();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: parsing bridge port " + stpbridgeport + " with stp designated bridge " + stpPortDesignatedBridge + " and with stp designated port " + stpPortDesignatedPort);
                        }
                        if (stpPortDesignatedBridge.equals("0000000000000000") || stpPortDesignatedBridge.equals("")) {
                            this.log().warn("run: designated bridge is invalid " + stpPortDesignatedBridge);
                            continue;
                        }
                        if (curNode.isBridgeIdentifier(stpPortDesignatedBridge.substring(4))) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("run: designated bridge for port " + stpbridgeport + " is bridge itself ");
                            continue;
                        }
                        if (stpPortDesignatedPort.equals("0000")) {
                            this.log().warn("run: designated port is invalid " + stpPortDesignatedPort);
                            continue;
                        }
                        int designatedbridgeport = Integer.parseInt(stpPortDesignatedPort.substring(1), 16);
                        LinkableNode designatedNode = this.getNodeFromMacIdentifierOfBridgeNode(stpPortDesignatedBridge.substring(4));
                        if (designatedNode == null) {
                            this.log().warn("run: no nodeid found for stp bridge address " + stpPortDesignatedBridge + " . Nothing to save to db");
                            continue;
                        }
                        int designatednodeid = designatedNode.getNodeId();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: found designated nodeid " + designatednodeid);
                        }
                        if (!this.isNearestBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport)) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("run: other bridge found between nodes. No links to save!");
                            continue;
                        }
                        int curIfIndex = curNode.getIfindex(stpbridgeport);
                        if (curIfIndex == -1) {
                            this.log().warn("run: got invalid ifindex");
                            continue;
                        }
                        int designatedifindex = designatedNode.getIfindex(designatedbridgeport);
                        if (designatedifindex == -1) {
                            this.log().warn("run: got invalid ifindex on designated node");
                            continue;
                        }
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: backbone port found for node " + curNodeId + ". Adding to bridge" + stpbridgeport);
                        }
                        curNode.addBackBoneBridgePorts(stpbridgeport);
                        this.bridgeNodes.put(new Integer(curNodeId), curNode);
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: backbone port found for node " + designatednodeid + " .Adding to helper class bb port " + " bridge port " + designatedbridgeport);
                        }
                        designatedNode.addBackBoneBridgePorts(designatedbridgeport);
                        this.bridgeNodes.put(new Integer(designatednodeid), designatedNode);
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: adding links on bb bridge port " + designatedbridgeport);
                        }
                        this.addLinks(this.getMacsOnBridgeLink(curNode, stpbridgeport, designatedNode, designatedbridgeport), curNodeId, curIfIndex);
                        NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex);
                        lk.setNodeparentid(designatednodeid);
                        lk.setParentifindex(designatedifindex);
                        this.addNodetoNodeLink(lk);
                    }
                }
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("run: try to found links using Mac Address Forwarding Table");
            }
            for (LinkableNode curNode : this.bridgeNodes.values()) {
                int curNodeId = curNode.getNodeId();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("run: parsing node bridge " + curNodeId);
                }
                block9: for (Integer intePort : curNode.getPortMacs().keySet()) {
                    int curBridgePort = intePort;
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: parsing bridge port " + curBridgePort + " with mac addresses " + curNode.getMacAddressesOnBridgePort(curBridgePort).toString());
                    }
                    if (curNode.isBackBoneBridgePort(curBridgePort)) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug("run: parsing backbone bridge port " + curBridgePort + " .... Skipping");
                        continue;
                    }
                    int curIfIndex = curNode.getIfindex(curBridgePort);
                    if (curIfIndex == -1) {
                        this.log().warn("run: got invalid ifindex on bridge port " + curBridgePort);
                        continue;
                    }
                    Set<String> macs = curNode.getMacAddressesOnBridgePort(curBridgePort);
                    List<LinkableNode> bridgesOnPort = this.getBridgesFromMacs(macs);
                    if (bridgesOnPort.isEmpty()) {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: no bridge info found on port " + curBridgePort + " .... Saving Macs");
                        }
                        this.addLinks(macs, curNodeId, curIfIndex);
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: bridge info found on port " + curBridgePort + " .... Finding nearest.");
                    }
                    for (LinkableNode endNode : bridgesOnPort) {
                        int endNodeid = endNode.getNodeId();
                        int endBridgePort = this.getBridgePortOnEndBridge(curNode, endNode);
                        if (endBridgePort == -1) {
                            this.log().error("run: no valid port found on bridge nodeid " + endNodeid + " for node bridge identifiers nodeid " + curNodeId + " . .....Skipping");
                            continue;
                        }
                        boolean isTargetNode = this.isNearestBridgeLink(curNode, curBridgePort, endNode, endBridgePort);
                        if (!isTargetNode) continue;
                        int endIfindex = endNode.getIfindex(endBridgePort);
                        if (endIfindex == -1) {
                            this.log().warn("run: got invalid ifindex o designated bridge port " + endBridgePort);
                            continue block9;
                        }
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: backbone port found for node " + curNodeId + ". Adding backbone port " + curBridgePort + " to bridge");
                        }
                        curNode.addBackBoneBridgePorts(curBridgePort);
                        this.bridgeNodes.put(new Integer(curNodeId), curNode);
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: backbone port found for node " + endNodeid + " .Adding to helper class bb port " + " bridge port " + endBridgePort);
                        }
                        endNode.addBackBoneBridgePorts(endBridgePort);
                        this.bridgeNodes.put(new Integer(endNodeid), endNode);
                        this.addLinks(this.getMacsOnBridgeLink(curNode, curBridgePort, endNode, endBridgePort), curNodeId, curIfIndex);
                        NodeToNodeLink lk = new NodeToNodeLink(curNodeId, curIfIndex);
                        lk.setNodeparentid(endNodeid);
                        lk.setParentifindex(endIfindex);
                        this.addNodetoNodeLink(lk);
                        continue block9;
                    }
                }
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("run: try to found  not ethernet links on Router nodes");
            }
            for (LinkableNode curNode : this.routerNodes) {
                int curNodeId = curNode.getNodeId();
                String curIpAddr = curNode.getSnmpPrimaryIpAddr();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("run: parsing router nodeid " + curNodeId + " ip address " + curIpAddr);
                }
                sub_ite = curNode.getRouteInterfaces().iterator();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("run: parsing " + curNode.getRouteInterfaces().size() + " Route Interface. ");
                }
                while (sub_ite.hasNext()) {
                    InetAddress nexthop;
                    RouterInterface routeIface = (RouterInterface)sub_ite.next();
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: parsing RouterInterface: " + routeIface.toString());
                    }
                    if (routeIface.getMetric() == -1) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info("run: Router interface has invalid metric " + routeIface.getMetric() + ". Skipping");
                        continue;
                    }
                    if (this.forceIpRouteDiscoveryOnEtherNet) {
                        if (this.log().isInfoEnabled()) {
                            this.log().info("run: force ip route discovery not getting SnmpIfType");
                        }
                    } else {
                        int snmpiftype = routeIface.getSnmpiftype();
                        if (this.log().isInfoEnabled()) {
                            this.log().info("run: force ip route discovery getting SnmpIfType: " + snmpiftype);
                        }
                        if (snmpiftype == 6) {
                            if (!this.log().isInfoEnabled()) continue;
                            this.log().info("run: Ethernet interface for nodeid. Skipping ");
                            continue;
                        }
                        if (snmpiftype == 53) {
                            if (!this.log().isInfoEnabled()) continue;
                            this.log().info("run: PropVirtual interface for nodeid. Skipping ");
                            continue;
                        }
                        if (snmpiftype == 135) {
                            if (!this.log().isInfoEnabled()) continue;
                            this.log().info("run: Layer2 Vlan interface for nodeid. Skipping ");
                            continue;
                        }
                        if (snmpiftype == 136) {
                            if (!this.log().isInfoEnabled()) continue;
                            this.log().info("run: Layer3 Vlan interface for nodeid. Skipping ");
                            continue;
                        }
                        if (snmpiftype == -1) {
                            if (!this.log().isInfoEnabled()) continue;
                            this.log().info("store: interface has unknown snmpiftype " + snmpiftype + " . Skipping ");
                            continue;
                        }
                    }
                    if ((nexthop = routeIface.getNextHop()).getHostAddress().equals("0.0.0.0")) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info("run: nexthop address is broadcast address " + nexthop.getHostAddress() + " . Skipping ");
                        continue;
                    }
                    if (nexthop.isLoopbackAddress()) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info("run: nexthop address is localhost address " + nexthop.getHostAddress() + " . Skipping ");
                        continue;
                    }
                    if (!Linkd.getInstance().isInterfaceInPackage(nexthop.getHostAddress(), this.getPackageName())) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info("run: nexthop address is not in package " + nexthop.getHostAddress() + "/" + this.getPackageName() + " . Skipping ");
                        continue;
                    }
                    int nextHopNodeid = routeIface.getNextHopNodeid();
                    if (nextHopNodeid == -1) {
                        if (!this.log().isInfoEnabled()) continue;
                        this.log().info("run: no node id found for ip next hop address " + nexthop.getHostAddress() + " , skipping ");
                        continue;
                    }
                    if (nextHopNodeid == curNodeId) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug("run: node id found for ip next hop address " + nexthop.getHostAddress() + " is itself, skipping ");
                        continue;
                    }
                    int ifindex = routeIface.getIfindex();
                    if (ifindex == 0) {
                        if (this.log().isInfoEnabled()) {
                            this.log().info("run: route interface has ifindex " + ifindex + " . trying to get ifindex from nextHopNet: " + routeIface.getNextHopNet());
                        }
                        if ((ifindex = this.getIfIndexFromRouter(curNode, routeIface.getNextHopNet())) == -1) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("run: found not correct ifindex " + ifindex + " skipping.");
                            continue;
                        }
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("run: found correct ifindex " + ifindex + " .");
                        }
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: saving route link");
                    }
                    NodeToNodeLink lk = new NodeToNodeLink(nextHopNodeid, routeIface.getNextHopIfindex());
                    lk.setNodeparentid(curNodeId);
                    lk.setParentifindex(ifindex);
                    this.addNodetoNodeLink(lk);
                }
            }
            this.bridgeNodes.clear();
            this.routerNodes.clear();
            this.cdpNodes.clear();
            this.macsParsed.clear();
            this.macsExcluded.clear();
            this.macToAtinterface.clear();
            this.atNodes.clear();
            Linkd.getInstance().updateDiscoveryLinkCollection(this);
            this.links.clear();
            this.maclinks.clear();
        }
        this.isRunned = true;
        this.reschedule();
    }

    private int getIfIndexFromRouter(LinkableNode parentnode, InetAddress nextHopNet) {
        if (!parentnode.hasRouteInterfaces()) {
            return -1;
        }
        for (RouterInterface curIface : parentnode.getRouteInterfaces()) {
            int ifindex;
            if (curIface.getMetric() == -1 || (ifindex = curIface.getIfindex()) == 0 || ifindex == -1 || !curIface.getRouteNet().equals(nextHopNet)) continue;
            return ifindex;
        }
        return -1;
    }

    boolean isBridgeNode(int nodeid) {
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    boolean isRouterNode(int nodeid) {
        for (LinkableNode curNode : this.routerNodes) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    boolean isCdpNode(int nodeid) {
        for (LinkableNode curNode : this.cdpNodes) {
            if (nodeid != curNode.getNodeId()) continue;
            return true;
        }
        return false;
    }

    private boolean isEndBridgePort(LinkableNode bridge, int bridgeport) {
        Set<String> macsOnBridge = bridge.getMacAddressesOnBridgePort(bridgeport);
        if (macsOnBridge == null || macsOnBridge.isEmpty()) {
            return true;
        }
        for (String macaddr : macsOnBridge) {
            if (!this.isMacIdentifierOfBridgeNode(macaddr)) continue;
            return false;
        }
        return true;
    }

    private boolean isNearestBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        boolean hasbridge2forwardingRule = false;
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return false;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return false;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1)) {
                hasbridge2forwardingRule = true;
                continue;
            }
            if (bridge1.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1) || !this.isMacIdentifierOfBridgeNode(curMacOnBridge1)) continue;
            return false;
        }
        return hasbridge2forwardingRule;
    }

    private Set<String> getMacsOnBridgeLink(LinkableNode bridge1, int bp1, LinkableNode bridge2, int bp2) {
        HashSet<String> macsOnLink = new HashSet<String>();
        Set<String> macsOnBridge1 = bridge1.getMacAddressesOnBridgePort(bp1);
        Set<String> macsOnBridge2 = bridge2.getMacAddressesOnBridgePort(bp2);
        if (macsOnBridge2 == null || macsOnBridge1 == null) {
            return null;
        }
        if (macsOnBridge2.isEmpty() || macsOnBridge1.isEmpty()) {
            return null;
        }
        for (String curMacOnBridge1 : macsOnBridge1) {
            if (bridge2.isBridgeIdentifier(curMacOnBridge1) || !macsOnBridge2.contains(curMacOnBridge1)) continue;
            macsOnLink.add(curMacOnBridge1);
        }
        return macsOnLink;
    }

    private boolean isMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return true;
        }
        return false;
    }

    private LinkableNode getNodeFromMacIdentifierOfBridgeNode(String macAddress) {
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            if (!curNode.isBridgeIdentifier(macAddress)) continue;
            return curNode;
        }
        return null;
    }

    private List<LinkableNode> getBridgesFromMacs(Set<String> macs) {
        ArrayList<LinkableNode> bridges = new ArrayList<LinkableNode>();
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            for (String curBridgeIdentifier : curNode.getBridgeIdentifiers()) {
                if (!macs.contains(curBridgeIdentifier)) continue;
                bridges.add(curNode);
            }
        }
        return bridges;
    }

    private int getBridgePortOnEndBridge(LinkableNode startBridge, LinkableNode endBridge) {
        int port2 = -1;
        for (String curBridgeIdentifier : startBridge.getBridgeIdentifiers()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("getBridgePortOnEndBridge: parsing bridge identifier " + curBridgeIdentifier);
            }
            if (endBridge.hasMacAddress(curBridgeIdentifier)) {
                List<Integer> ports = endBridge.getBridgePortsFromMac(curBridgeIdentifier);
                for (int port2 : ports) {
                    if (endBridge.isBackBoneBridgePort(port2)) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug("getBridgePortOnEndBridge: found backbone bridge port " + port2 + " .... Skipping");
                        continue;
                    }
                    if (port2 == -1) {
                        if (!this.log().isDebugEnabled()) continue;
                        this.log().debug("run: no port found on bridge nodeid " + endBridge.getNodeId() + " for node bridge identifiers nodeid " + startBridge.getNodeId() + " . .....Skipping");
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("run: using mac address table found bridge port " + port2 + " on node " + endBridge.getNodeId());
                    }
                    return port2;
                }
                continue;
            }
            if (!this.log().isDebugEnabled()) continue;
            this.log().debug("run: bridge identifier not found on node " + endBridge.getNodeId());
        }
        return -1;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    @Override
    public void schedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("schedule: Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.snmp_poll_interval + this.discovery_interval + this.initial_sleep_time, this);
    }

    private void reschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        this.m_scheduler.schedule(this.snmp_poll_interval, this);
    }

    public long getInitialSleepTime() {
        return this.initial_sleep_time;
    }

    public void setInitialSleepTime(long initial_sleep_time) {
        this.initial_sleep_time = initial_sleep_time;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    public long getDiscoveryInterval() {
        return this.discovery_interval;
    }

    public void setSnmpPollInterval(long interval) {
        this.snmp_poll_interval = interval;
    }

    public long getSnmpPollInterval() {
        return this.snmp_poll_interval;
    }

    public void setDiscoveryInterval(long interval) {
        this.discovery_interval = interval;
    }

    public NodeToNodeLink[] getLinks() {
        return this.links.toArray(new NodeToNodeLink[0]);
    }

    public MacToNodeLink[] getMacLinks() {
        return this.maclinks.toArray(new MacToNodeLink[0]);
    }

    @Override
    public boolean isSuspended() {
        return this.suspendCollection;
    }

    @Override
    public void suspend() {
        this.suspendCollection = true;
    }

    @Override
    public void wakeUp() {
        this.suspendCollection = false;
    }

    @Override
    public void unschedule() {
        if (this.m_scheduler == null) {
            throw new IllegalStateException("rescedule: Cannot schedule a service whose scheduler is set to null");
        }
        if (this.isRunned) {
            this.m_scheduler.unschedule(this, this.snmp_poll_interval);
        } else {
            this.m_scheduler.unschedule(this, this.snmp_poll_interval + this.initial_sleep_time + this.discovery_interval);
        }
    }

    private boolean parseCdpLinkOn(LinkableNode node1, int ifindex1, int nodeid2) {
        int bridgeport = node1.getBridgePort(ifindex1);
        if (node1.isBackBoneBridgePort(bridgeport)) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("parseCdpLinkOn: node/backbone bridge port " + node1.getNodeId() + "/" + bridgeport + " already parsed. Skipping");
            }
            return false;
        }
        if (!this.isEndBridgePort(node1, bridgeport)) {
            this.log().warn("parseCdpLinkOn: link cannot be saved. Skipping");
            return false;
        }
        node1.addBackBoneBridgePorts(bridgeport);
        this.bridgeNodes.put(new Integer(node1.getNodeId()), node1);
        Set<String> macs = node1.getMacAddressesOnBridgePort(bridgeport);
        this.addLinks(macs, node1.getNodeId(), ifindex1);
        return true;
    }

    private boolean parseCdpLinkOn(LinkableNode node1, int ifindex1, LinkableNode node2, int ifindex2) {
        int bridgeport1 = node1.getBridgePort(ifindex1);
        if (node1.isBackBoneBridgePort(bridgeport1)) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("parseCdpLinkOn: backbone bridge port " + bridgeport1 + " already parsed. Skipping");
            }
            return false;
        }
        int bridgeport2 = node2.getBridgePort(ifindex2);
        if (node2.isBackBoneBridgePort(bridgeport2)) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("parseCdpLinkOn: backbone bridge port " + bridgeport2 + " already parsed. Skipping");
            }
            return false;
        }
        if (this.isNearestBridgeLink(node1, bridgeport1, node2, bridgeport2)) {
            node1.addBackBoneBridgePorts(bridgeport1);
            this.bridgeNodes.put(new Integer(node1.getNodeId()), node1);
            node2.addBackBoneBridgePorts(bridgeport2);
            this.bridgeNodes.put(new Integer(node2.getNodeId()), node2);
            if (this.log().isDebugEnabled()) {
                this.log().debug("parseCdpLinkOn: Adding node on links.");
            }
        } else {
            if (this.log().isDebugEnabled()) {
                this.log().debug("parseCdpLinkOn: link found not on nearest. Skipping");
            }
            return false;
        }
        this.addLinks(this.getMacsOnBridgeLink(node1, bridgeport1, node2, bridgeport2), node1.getNodeId(), ifindex1);
        return true;
    }

    private void addNodetoNodeLink(NodeToNodeLink nnlink) {
        if (nnlink == null) {
            this.log().warn("addNodetoNodeLink: node link is null.");
            return;
        }
        if (!this.links.isEmpty()) {
            for (NodeToNodeLink curNnLink : this.links) {
                if (!curNnLink.equals(nnlink)) continue;
                if (this.log().isInfoEnabled()) {
                    this.log().info("addNodetoNodeLink: link " + nnlink.toString() + " exists, not adding");
                }
                return;
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("addNodetoNodeLink: adding link " + nnlink.toString());
        }
        this.links.add(nnlink);
    }

    private void addLinks(Set<String> macs, int nodeid, int ifindex) {
        if (macs == null || macs.isEmpty()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("addLinks: mac's list on link is empty.");
            }
        } else {
            for (String curMacAddress : macs) {
                if (this.macsParsed.contains(curMacAddress)) {
                    this.log().warn("addLinks: mac address " + curMacAddress + " just found on other bridge port! Skipping...");
                    continue;
                }
                if (this.macsExcluded.contains(curMacAddress)) {
                    this.log().warn("addLinks: mac address " + curMacAddress + " is excluded from discovery package! Skipping...");
                    continue;
                }
                if (this.macToAtinterface.containsKey(curMacAddress)) {
                    List<AtInterface> ats = this.macToAtinterface.get(curMacAddress);
                    for (AtInterface at : ats) {
                        NodeToNodeLink lNode = new NodeToNodeLink(at.getNodeId(), at.getIfindex());
                        lNode.setNodeparentid(nodeid);
                        lNode.setParentifindex(ifindex);
                        this.addNodetoNodeLink(lNode);
                    }
                } else {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("addLinks: not find nodeid for ethernet mac address " + curMacAddress + " found on node/ifindex" + nodeid + "/" + ifindex);
                    }
                    MacToNodeLink lMac = new MacToNodeLink(curMacAddress);
                    lMac.setNodeparentid(nodeid);
                    lMac.setParentifindex(ifindex);
                    this.maclinks.add(lMac);
                }
                this.macsParsed.add(curMacAddress);
            }
        }
    }

    @Override
    public boolean equals(ReadyRunnable r) {
        return r instanceof DiscoveryLink && this.getPackageName().equals(r.getPackageName());
    }

    @Override
    public String getInfo() {
        return " Ready Runnable Discovery Link discoveryUsingBridge/discoveryUsingCdp/discoveryUsingRoutes/package: " + this.discoveryUsingBridge() + "/" + this.discoveryUsingCdp() + "/" + this.discoveryUsingRoutes() + "/" + this.getPackageName();
    }

    public boolean discoveryUsingBridge() {
        return this.discoveryUsingBridge;
    }

    public void setDiscoveryUsingBridge(boolean discoveryUsingBridge) {
        this.discoveryUsingBridge = discoveryUsingBridge;
    }

    public boolean discoveryUsingCdp() {
        return this.discoveryUsingCdp;
    }

    public void setDiscoveryUsingCdp(boolean discoveryUsingCdp) {
        this.discoveryUsingCdp = discoveryUsingCdp;
    }

    public boolean discoveryUsingRoutes() {
        return this.discoveryUsingRoutes;
    }

    public void setDiscoveryUsingRoutes(boolean discoveryUsingRoutes) {
        this.discoveryUsingRoutes = discoveryUsingRoutes;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    private void snmpParseBridgeNodes() {
        if (this.log().isDebugEnabled()) {
            this.log().debug("parseBridgeNodes: searching bridge port for bridge identifier not yet already found. Iterating on bridge nodes.");
        }
        ArrayList<LinkableNode> bridgenodeschanged = new ArrayList<LinkableNode>();
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            List<String> macs;
            if (this.log().isDebugEnabled()) {
                this.log().debug("parseBridgeNodes: parsing bridge: " + curNode.getNodeId() + "/" + curNode.getSnmpPrimaryIpAddr());
            }
            if ((macs = this.getNotAlreadyFoundMacsOnNode(curNode)).isEmpty()) continue;
            SnmpAgentConfig agentConfig = null;
            String className = null;
            boolean useVlan = Linkd.getInstance().getLinkdConfig().enableVlanDiscovery();
            if (Linkd.getInstance().getLinkdConfig().getPackage(this.getPackageName()).hasEnableVlanDiscovery()) {
                useVlan = Linkd.getInstance().getLinkdConfig().getPackage(this.getPackageName()).getEnableVlanDiscovery();
            }
            if (useVlan && Linkd.getInstance().getLinkdConfig().hasClassName(curNode.getSysoid())) {
                className = Linkd.getInstance().getLinkdConfig().getClassName(curNode.getSysoid());
            }
            try {
                agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName(curNode.getSnmpPrimaryIpAddr()));
            }
            catch (UnknownHostException e) {
                this.log().error("parseBridgeNodes: Failed to load snmp parameter from snmp configuration file " + e);
                return;
            }
            String community = agentConfig.getReadCommunity();
            for (String mac : macs) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("parseBridgeNodes: parsing mac: " + mac);
                }
                if (className != null && (className.equals("org.opennms.netmgt.linkd.snmp.CiscoVlanTable") || className.equals("org.opennms.netmgt.linkd.snmp.IntelVlanTable"))) {
                    for (Vlan vlan : curNode.getVlans()) {
                        if (vlan.getVlanStatus() != 1 || vlan.getVlanType() != 1) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("parseBridgeNodes: skipping vlan: " + vlan.getVlanName());
                            continue;
                        }
                        agentConfig.setReadCommunity(community + "@" + vlan.getVlanIndex());
                        curNode = this.collectMacAddress(agentConfig, curNode, mac, vlan.getVlanIndex());
                        agentConfig.setReadCommunity(community);
                    }
                    continue;
                }
                int vlan = 1;
                if (useVlan) {
                    vlan = 0;
                }
                curNode = this.collectMacAddress(agentConfig, curNode, mac, vlan);
            }
            bridgenodeschanged.add(curNode);
        }
        for (LinkableNode node : bridgenodeschanged) {
            this.bridgeNodes.put(new Integer(node.getNodeId()), node);
        }
    }

    private LinkableNode collectMacAddress(SnmpAgentConfig agentConfig, LinkableNode node, String mac, int vlan) {
        int bridgeport;
        FdbTableGet coll = new FdbTableGet(agentConfig, mac);
        if (this.log().isInfoEnabled()) {
            this.log().info("collectMacAddress: finding entry in bridge forwarding table for mac on node: " + mac + "/" + node.getNodeId());
        }
        if ((bridgeport = coll.getBridgePort()) > 0 && coll.getBridgePortStatus() == 3) {
            node.addMacAddress(bridgeport, mac, Integer.toString(vlan));
            if (this.log().isInfoEnabled()) {
                this.log().info("collectMacAddress: found mac on bridge port: " + bridgeport);
            }
        } else {
            bridgeport = coll.getQBridgePort();
            if (bridgeport > 0 && coll.getQBridgePortStatus() == 3) {
                node.addMacAddress(bridgeport, mac, Integer.toString(vlan));
            }
            if (this.log().isInfoEnabled()) {
                this.log().info("collectMacAddress: found mac on bridge port: " + bridgeport);
            } else if (this.log().isInfoEnabled()) {
                this.log().info("collectMacAddress: mac not found: " + bridgeport);
            }
        }
        return node;
    }

    private List<String> getNotAlreadyFoundMacsOnNode(LinkableNode node) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("Searching Not Yet Found Bridge Identifier Occurrence on Node: " + node.getNodeId());
        }
        ArrayList<String> macs = new ArrayList<String>();
        for (LinkableNode curNode : this.bridgeNodes.values()) {
            if (node.getNodeId() == curNode.getNodeId()) continue;
            for (String curMac : curNode.getBridgeIdentifiers()) {
                if (node.hasMacAddress(curMac) || macs.contains(curMac)) continue;
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Found a node/Bridge Identifier " + curNode.getNodeId() + "/" + curMac + " that was not found in bridge forwarding table for bridge node: " + node.getNodeId());
                }
                macs.add(curMac);
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug("Searching Not Yet Found Mac Address Occurrence on Node: " + node.getNodeId());
        }
        for (String curMac : this.macToAtinterface.keySet()) {
            if (node.hasMacAddress(curMac) || macs.contains(curMac)) continue;
            if (this.log().isDebugEnabled()) {
                this.log().debug("Found a Mac Address " + curMac + " that was not found in bridge forwarding table for bridge node: " + node.getNodeId());
            }
            macs.add(curMac);
        }
        return macs;
    }

    public boolean isEnableDownloadDiscovery() {
        return this.enableDownloadDiscovery;
    }

    public void setEnableDownloadDiscovery(boolean enableDownloaddiscovery) {
        this.enableDownloadDiscovery = enableDownloaddiscovery;
    }

    public boolean isForceIpRouteDiscoveryOnEtherNet() {
        return this.forceIpRouteDiscoveryOnEtherNet;
    }

    public void setForceIpRouteDiscoveryOnEtherNet(boolean forceIpRouteDiscoveryOnEtherNet) {
        this.forceIpRouteDiscoveryOnEtherNet = forceIpRouteDiscoveryOnEtherNet;
    }
}

