/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.snmp.SnmpTableEntry;
import org.opennms.netmgt.linkd.AtInterface;
import org.opennms.netmgt.linkd.BridgeStpInterface;
import org.opennms.netmgt.linkd.CdpInterface;
import org.opennms.netmgt.linkd.DbAtInterfaceEntry;
import org.opennms.netmgt.linkd.DbDataLinkInterfaceEntry;
import org.opennms.netmgt.linkd.DbIpRouteInterfaceEntry;
import org.opennms.netmgt.linkd.DbStpInterfaceEntry;
import org.opennms.netmgt.linkd.DbStpNodeEntry;
import org.opennms.netmgt.linkd.DbVlanEntry;
import org.opennms.netmgt.linkd.DiscoveryLink;
import org.opennms.netmgt.linkd.EventUtils;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.Linkd;
import org.opennms.netmgt.linkd.MacToNodeLink;
import org.opennms.netmgt.linkd.NodeToNodeLink;
import org.opennms.netmgt.linkd.QueryManager;
import org.opennms.netmgt.linkd.RouterInterface;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.netmgt.linkd.SnmpVlanCollection;
import org.opennms.netmgt.linkd.Vlan;
import org.opennms.netmgt.linkd.snmp.CdpCacheTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dBaseGroup;
import org.opennms.netmgt.linkd.snmp.Dot1dBasePortTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dStpGroup;
import org.opennms.netmgt.linkd.snmp.Dot1dStpPortTableEntry;
import org.opennms.netmgt.linkd.snmp.Dot1dTpFdbTableEntry;
import org.opennms.netmgt.linkd.snmp.IpNetToMediaTableEntry;
import org.opennms.netmgt.linkd.snmp.IpRouteTableEntry;
import org.opennms.netmgt.linkd.snmp.QBridgeDot1dTpFdbTableEntry;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbEventWriter
implements QueryManager {
    JdbcTemplate jdbcTemplate;
    private static final String SQL_SELECT_SNMP_NODE = "SELECT nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE node.nodeid = ? AND nodetype = 'A' AND issnmpprimary = 'P'";
    private static final String SQL_SELECT_SNMP_IP_ADDR = "SELECT ipaddr FROM ipinterface WHERE nodeid = ? AND issnmpprimary = 'P'";
    private static final String SQL_GET_NODEID = "SELECT node.nodeid FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ?";
    private static final String SQL_GET_NODEID__IFINDEX_MASK = "SELECT node.nodeid,snmpinterface.snmpifindex,snmpinterface.snmpipadentnetmask FROM node LEFT JOIN snmpinterface ON node.nodeid = snmpinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ?";
    private static final String SQL_GET_NODEID_IFINDEX_IPINT = "SELECT node.nodeid,ipinterface.ifindex FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ?";
    private static final String SQL_UPDATE_DATALINKINTERFACE = "UPDATE datalinkinterface set status = 'N'  WHERE lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_ATINTERFACE = "UPDATE atinterface set status = 'N'  WHERE sourcenodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_IPROUTEINTERFACE = "UPDATE iprouteinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_STPNODE = "UPDATE stpnode set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_STPINTERFACE = "UPDATE stpinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_VLAN = "UPDATE vlan set status = 'N'  WHERE nodeid =? AND lastpolltime < ? AND status = 'A'";
    private static final String SQL_UPDATE_ATINTERFACE_STATUS = "UPDATE atinterface set status = ?  WHERE sourcenodeid = ? OR nodeid = ?";
    private static final String SQL_UPDATE_IPROUTEINTERFACE_STATUS = "UPDATE iprouteinterface set status = ? WHERE nodeid = ? ";
    private static final String SQL_UPDATE_STPNODE_STATUS = "UPDATE stpnode set status = ?  WHERE nodeid = ? ";
    private static final String SQL_UPDATE_STPINTERFACE_STATUS = "UPDATE stpinterface set status = ? WHERE nodeid = ? ";
    private static final String SQL_UPDATE_VLAN_STATUS = "UPDATE vlan set status = ?  WHERE nodeid = ? ";
    private static final String SQL_UPDATE_DATALINKINTERFACE_STATUS = "UPDATE datalinkinterface set status = ? WHERE nodeid = ? OR nodeparentid = ? ";
    private static final String SQL_GET_NODEID_IFINDEX = "SELECT atinterface.nodeid, atinterface.ipaddr, ipinterface.ifindex from atinterface left JOIN ipinterface ON atinterface.nodeid = ipinterface.nodeid AND atinterface.ipaddr = ipinterface.ipaddr WHERE atphysaddr = ? AND atinterface.status <> 'D'";
    private static final String SQL_GET_SNMPIFTYPE = "SELECT snmpiftype FROM snmpinterface WHERE nodeid = ? AND snmpifindex = ?";
    private static final String SQL_GET_IFINDEX_SNMPINTERFACE_NAME = "SELECT snmpifindex FROM snmpinterface WHERE nodeid = ? AND (snmpifname = ? OR snmpifdescr = ?) ";
    private static final String SQL_GET_SNMPPHYSADDR_SNMPINTERFACE = "SELECT snmpphysaddr FROM snmpinterface WHERE nodeid = ? AND  snmpphysaddr <> ''";
    private static final String SQL_SELECT_SNMP_NODES = "SELECT node.nodeid, nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND issnmpprimary = 'P'";
    private static final String SQL_UPDATE_VLAN_D = "UPDATE vlan set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ";
    private static final String SQL_UPDATE_ATINTERFACE_D = "UPDATE atinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ";
    private static final String SQL_UPDATE_STPNODE_D = "UPDATE stpnode set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'";
    private static final String SQL_UPDATE_STPINTERFACE_D = "UPDATE stpinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'";
    private static final String SQL_UPDATE_IPROUTEINTERFACE_D = "UPDATE iprouteinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'";
    private static final String SQL_UPDATE_DATALINKINTERFACE_D = "UPDATE datalinkinterface set status = 'D' WHERE (nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) OR nodeparentid IN (SELECT nodeid from node WHERE nodetype = 'D' )) AND status <> 'D'";
    private static final String SQL_UPDATE_ATINTERFACE_STATUS_INTFC = "UPDATE atinterface set status = ?  WHERE nodeid = ? AND ipaddr = ?";
    private static final String SQL_UPDATE_ATINTERFACE_STATUS_SRC_INTFC = "UPDATE atinterface set status = ?  WHERE sourcenodeid = ? AND ifindex = ?";
    private static final String SQL_UPDATE_STPINTERFACE_STATUS_INTFC = "UPDATE stpinterface set status = ? WHERE nodeid = ? AND ifindex = ?";
    private static final String SQL_UPDATE_IPROUTEINTERFACE_STATUS_INTFC = "UPDATE iprouteinterface set status = ? WHERE nodeid = ? AND routeifindex = ?";
    private static final String SQL_UPDATE_DATALINKINTERFACE_STATUS_INTFC = "UPDATE datalinkinterface set status = ? WHERE (nodeid = ? and ifindex = ?) OR (nodeparentid = ? AND parentifindex = ?)";

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private Connection getConnection() throws SQLException {
        return this.jdbcTemplate.getDataSource().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDiscoveryLink(DiscoveryLink discovery) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            int i;
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            PreparedStatement stmt = null;
            ResultSet rs = null;
            NodeToNodeLink[] links = discovery.getLinks();
            if (this.log().isDebugEnabled()) {
                this.log().debug("storelink: Storing " + links.length + " NodeToNodeLink information into database");
            }
            for (int i2 = 0; i2 < links.length; ++i2) {
                NodeToNodeLink lk = links[i2];
                int nodeid = lk.getNodeId();
                int ifindex = lk.getIfindex();
                int nodeparentid = lk.getNodeparentid();
                int parentifindex = lk.getParentifindex();
                DbDataLinkInterfaceEntry dbentry = DbDataLinkInterfaceEntry.get(dbConn, nodeid, ifindex);
                if (dbentry == null) {
                    dbentry = DbDataLinkInterfaceEntry.create(nodeid, ifindex);
                }
                dbentry.updateNodeParentId(nodeparentid);
                dbentry.updateParentIfIndex(parentifindex);
                dbentry.updateStatus('A');
                dbentry.set_lastpolltime(now);
                dbentry.store(dbConn);
                dbentry = DbDataLinkInterfaceEntry.get(dbConn, nodeparentid, parentifindex);
                if (dbentry == null || dbentry.get_nodeparentid() != nodeid || dbentry.get_parentifindex() != ifindex || dbentry.get_status() == 'D') continue;
                dbentry.updateStatus('D');
                dbentry.store(dbConn);
            }
            MacToNodeLink[] linkmacs = discovery.getMacLinks();
            if (this.log().isDebugEnabled()) {
                this.log().debug("storelink: Storing " + linkmacs.length + " MacToNodeLink information into database");
            }
            for (i = 0; i < linkmacs.length; ++i) {
                MacToNodeLink lkm = linkmacs[i];
                String macaddr = lkm.getMacAddress();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("storelink: finding nodeid,ifindex on DB using mac address: " + macaddr);
                }
                stmt = dbConn.prepareStatement(SQL_GET_NODEID_IFINDEX);
                d.watch((Object)stmt);
                stmt.setString(1, macaddr);
                rs = stmt.executeQuery();
                d.watch((Object)rs);
                if (this.log().isDebugEnabled()) {
                    this.log().debug("storelink: finding nodeid,ifindex on DB. Sql Statement SELECT atinterface.nodeid, atinterface.ipaddr, ipinterface.ifindex from atinterface left JOIN ipinterface ON atinterface.nodeid = ipinterface.nodeid AND atinterface.ipaddr = ipinterface.ipaddr WHERE atphysaddr = ? AND atinterface.status <> 'D' with mac address " + macaddr);
                }
                if (!rs.next()) {
                    if (!this.log().isDebugEnabled()) continue;
                    this.log().debug("storelink: no nodeid found on DB for mac address " + macaddr + " on link. .... Skipping");
                    continue;
                }
                int ndx = 1;
                int nodeid = rs.getInt(ndx++);
                if (rs.wasNull()) {
                    if (!this.log().isDebugEnabled()) continue;
                    this.log().debug("storelink: no nodeid found on DB for mac address " + macaddr + " on link. .... Skipping");
                    continue;
                }
                String ipaddr = rs.getString(ndx++);
                if (rs.wasNull()) {
                    if (!this.log().isDebugEnabled()) continue;
                    this.log().debug("storelink: no ipaddr found on DB for mac address " + macaddr + " on link. .... Skipping");
                    continue;
                }
                if (!Linkd.getInstance().isInterfaceInPackage(ipaddr, discovery.getPackageName())) {
                    if (!this.log().isDebugEnabled()) continue;
                    this.log().debug("storelink: not in package ipaddr found: " + ipaddr + " on link. .... Skipping");
                    continue;
                }
                int ifindex = rs.getInt(ndx++);
                if (rs.wasNull()) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("storelink: no ifindex found on DB for mac address " + macaddr + " on link.");
                    }
                    ifindex = -1;
                }
                int nodeparentid = lkm.getNodeparentid();
                int parentifindex = lkm.getParentifindex();
                DbDataLinkInterfaceEntry dbentry = DbDataLinkInterfaceEntry.get(dbConn, nodeid, ifindex);
                if (dbentry == null) {
                    dbentry = DbDataLinkInterfaceEntry.create(nodeid, ifindex);
                }
                dbentry.updateNodeParentId(nodeparentid);
                dbentry.updateParentIfIndex(parentifindex);
                dbentry.updateStatus('A');
                dbentry.set_lastpolltime(now);
                dbentry.store(dbConn);
            }
            stmt = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE);
            d.watch((Object)stmt);
            stmt.setTimestamp(1, now);
            i = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("storelink: datalinkinterface - updated to NOT ACTIVE status " + i + " rows ");
            }
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkableNode storeSnmpCollection(LinkableNode node, SnmpCollection snmpcoll) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Iterator<Object> ite3;
            int ifindex;
            SnmpTableEntry ent;
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            if (snmpcoll.hasIpNetToMediaTable()) {
                Iterator ite1 = snmpcoll.getIpNetToMediaTable().getEntries().iterator();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("store: saving IpNetToMediaTable to atinterface table in DB");
                }
                ArrayList<AtInterface> atInterfaces = new ArrayList<AtInterface>();
                while (ite1.hasNext()) {
                    AtInterface at;
                    ent = (IpNetToMediaTableEntry)((Object)ite1.next());
                    ifindex = ((IpNetToMediaTableEntry)ent).getIpNetToMediaIfIndex();
                    if (ifindex < 0) {
                        this.log().warn("store: invalid ifindex " + ifindex);
                        continue;
                    }
                    InetAddress ipaddress = ((IpNetToMediaTableEntry)ent).getIpNetToMediaNetAddress();
                    if (ipaddress == null || ipaddress.isLoopbackAddress() || ipaddress.getHostAddress().equals("0.0.0.0")) {
                        this.log().warn("store: ipNetToMedia invalid ip " + ipaddress.getHostAddress());
                        continue;
                    }
                    String physAddr = ((IpNetToMediaTableEntry)ent).getIpNetToMediaPhysAddress();
                    if (physAddr == null || physAddr.equals("000000000000") || physAddr.equalsIgnoreCase("ffffffffffff")) {
                        this.log().warn("store: ipNetToMedia invalid mac address " + physAddr + " for ip " + ipaddress.getHostAddress());
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("store: trying save ipNetToMedia info: ipaddr " + ipaddress.getHostName() + " mac address " + physAddr + " ifindex " + ifindex);
                    }
                    if ((at = this.getNodeidIfindexFromIp(dbConn, ipaddress)) == null) {
                        this.log().warn("getNodeidIfindexFromIp: no nodeid found for ipaddress " + ipaddress + ".");
                        this.sendNewSuspectEvent(ipaddress, snmpcoll.getTarget(), snmpcoll.getPackageName());
                        continue;
                    }
                    at.setMacAddress(physAddr);
                    atInterfaces.add(at);
                    DbAtInterfaceEntry atInterfaceEntry = DbAtInterfaceEntry.get(dbConn, at.getNodeId(), ipaddress.getHostAddress());
                    if (atInterfaceEntry == null) {
                        atInterfaceEntry = DbAtInterfaceEntry.create(at.getNodeId(), ipaddress.getHostAddress());
                    }
                    atInterfaceEntry.updateAtPhysAddr(physAddr);
                    atInterfaceEntry.updateSourceNodeId(node.getNodeId());
                    atInterfaceEntry.updateIfIndex(ifindex);
                    atInterfaceEntry.updateStatus('A');
                    atInterfaceEntry.set_lastpolltime(now);
                    atInterfaceEntry.store(dbConn);
                }
                node.setAtInterfaces(atInterfaces);
            }
            if (snmpcoll.hasCdpCacheTable()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("store: saving CdpCacheTable into SnmpLinkableNode");
                }
                ArrayList<CdpInterface> cdpInterfaces = new ArrayList<CdpInterface>();
                for (CdpCacheTableEntry cdpEntry : snmpcoll.getCdpCacheTable().getEntries()) {
                    int targetCdpNodeId;
                    String cdpTargetDevicePort;
                    int cdpIfIndex;
                    int cdpAddrType = cdpEntry.getCdpCacheAddressType();
                    if (cdpAddrType != 1) {
                        this.log().warn(" cdp Address Type not valid " + cdpAddrType);
                        continue;
                    }
                    InetAddress cdpTargetIpAddr = cdpEntry.getCdpCacheAddress();
                    if (cdpTargetIpAddr == null || cdpTargetIpAddr.isLoopbackAddress() || cdpTargetIpAddr.getHostAddress().equals("0.0.0.0")) {
                        this.log().warn(" cdp Ip Address is not valid " + cdpTargetIpAddr);
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug(" cdp ip address found " + cdpTargetIpAddr.getHostAddress());
                    }
                    if ((cdpIfIndex = cdpEntry.getCdpCacheIfIndex()) < 0) {
                        this.log().warn(" cdpIfIndex not valid " + cdpIfIndex);
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug(" cdp ifindex found " + cdpIfIndex);
                    }
                    if ((cdpTargetDevicePort = cdpEntry.getCdpCacheDevicePort()) == null) {
                        this.log().warn(" cdpTargetDevicePort null. Skipping. ");
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug(" cdp Target device port name found " + cdpTargetDevicePort);
                    }
                    if ((targetCdpNodeId = this.getNodeidFromIp(dbConn, cdpTargetIpAddr)) == -1) {
                        this.log().warn("No nodeid found: cdp interface not added to Linkable Snmp Node. Skipping");
                        this.sendNewSuspectEvent(cdpTargetIpAddr, snmpcoll.getTarget(), snmpcoll.getPackageName());
                        continue;
                    }
                    int cdpTargetIfindex = this.getIfIndexByName(dbConn, targetCdpNodeId, cdpTargetDevicePort);
                    if (cdpTargetIfindex == -1) {
                        this.log().warn("No valid if target index found: cdp interface not added to Linkable Snmp Node. Skipping");
                        continue;
                    }
                    CdpInterface cdpIface = new CdpInterface(cdpIfIndex);
                    cdpIface.setCdpTargetNodeId(targetCdpNodeId);
                    cdpIface.setCdpTargetIpAddr(cdpTargetIpAddr);
                    cdpIface.setCdpTargetIfIndex(cdpTargetIfindex);
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("Adding cdp interface to Linkable Snmp Node." + cdpIface.toString());
                    }
                    cdpInterfaces.add(cdpIface);
                }
                node.setCdpInterfaces(cdpInterfaces);
            }
            if (snmpcoll.hasRouteTable()) {
                ArrayList<RouterInterface> routeInterfaces = new ArrayList<RouterInterface>();
                ite3 = snmpcoll.getIpRouteTable().getEntries().iterator();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("store: saving ipRouteTable to iprouteinterface table in DB");
                }
                while (ite3.hasNext()) {
                    ent = (IpRouteTableEntry)((Object)ite3.next());
                    ifindex = ((IpRouteTableEntry)ent).getIpRouteIfIndex();
                    if (ifindex < 0) {
                        this.log().warn("store: Not valid ifindex" + ifindex + " Skipping...");
                        continue;
                    }
                    InetAddress nexthop = ((IpRouteTableEntry)ent).getIpRouteNextHop();
                    if (nexthop == null) {
                        this.log().warn("storeSnmpCollection: next hop null found skipping.");
                        continue;
                    }
                    InetAddress routedest = ((IpRouteTableEntry)ent).getIpRouteDest();
                    if (routedest == null) {
                        this.log().warn("storeSnmpCollection: route dest null found skipping.");
                        continue;
                    }
                    InetAddress routemask = ((IpRouteTableEntry)ent).getIpRouteMask();
                    if (routemask == null) {
                        this.log().warn("storeSnmpCollection: route dest null found skipping.");
                        continue;
                    }
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("storeSnmpCollection: parsing routedest/routemask/nexthop: " + routedest + "/" + routemask + "/" + nexthop + " ifindex " + (ifindex < 1 ? "less than 1" : Integer.valueOf(ifindex)));
                    }
                    int routemetric1 = ((IpRouteTableEntry)ent).getIpRouteMetric1();
                    RouterInterface routeIface = this.getNodeidMaskFromIp(dbConn, nexthop);
                    if (routeIface == null) {
                        routeIface = this.getNodeFromIp(dbConn, nexthop);
                    }
                    if (routeIface == null) {
                        this.log().warn("store: No nodeid found for next hop ip" + nexthop + " Skipping ip route interface add to Linkable Snmp Node");
                        this.sendNewSuspectEvent(nexthop, snmpcoll.getTarget(), snmpcoll.getPackageName());
                    } else {
                        int snmpiftype = -2;
                        if (ifindex > 0) {
                            snmpiftype = this.getSnmpIfType(dbConn, node.getNodeId(), ifindex);
                        }
                        if (snmpiftype == -1) {
                            this.log().warn("store: interface has wrong or null snmpiftype " + snmpiftype + " . Skipping saving to discoverylink. ");
                        } else if (nexthop.isLoopbackAddress()) {
                            if (this.log().isInfoEnabled()) {
                                this.log().info("storeSnmpCollection: next hop loopbackaddress found. Skipping saving \tto discoverylink.");
                            }
                        } else if (nexthop.getHostAddress().equals("0.0.0.0")) {
                            if (this.log().isInfoEnabled()) {
                                this.log().info("storeSnmpCollection: next hop broadcast address found. Skipping saving to discoverylink.");
                            }
                        } else if (nexthop.isMulticastAddress()) {
                            if (this.log().isInfoEnabled()) {
                                this.log().info("storeSnmpCollection: next hop multicast address found. Skipping saving to discoverylink.");
                            }
                        } else if (routemetric1 < 0) {
                            if (this.log().isInfoEnabled()) {
                                this.log().info("storeSnmpCollection: route metric is invalid. Skipping saving to discoverylink.");
                            }
                        } else {
                            if (this.log().isDebugEnabled()) {
                                this.log().debug("store: interface has snmpiftype " + snmpiftype + " . Adding to DiscoverLink ");
                            }
                            routeIface.setRouteDest(routedest);
                            routeIface.setRoutemask(routemask);
                            routeIface.setSnmpiftype(snmpiftype);
                            routeIface.setIfindex(ifindex);
                            routeIface.setMetric(routemetric1);
                            routeIface.setNextHop(nexthop);
                            routeInterfaces.add(routeIface);
                        }
                    }
                    int routemetric2 = ((IpRouteTableEntry)ent).getIpRouteMetric2();
                    int routemetric3 = ((IpRouteTableEntry)ent).getIpRouteMetric3();
                    int routemetric4 = ((IpRouteTableEntry)ent).getIpRouteMetric4();
                    int routemetric5 = ((IpRouteTableEntry)ent).getIpRouteMetric5();
                    int routetype = ((IpRouteTableEntry)ent).getIpRouteType();
                    int routeproto = ((IpRouteTableEntry)ent).getIpRouteProto();
                    if (!snmpcoll.getSaveIpRouteTable()) continue;
                    DbIpRouteInterfaceEntry iprouteInterfaceEntry = DbIpRouteInterfaceEntry.get(dbConn, node.getNodeId(), routedest.getHostAddress());
                    if (iprouteInterfaceEntry == null) {
                        iprouteInterfaceEntry = DbIpRouteInterfaceEntry.create(node.getNodeId(), routedest.getHostAddress());
                    }
                    iprouteInterfaceEntry.updateRouteMask(routemask.getHostAddress());
                    iprouteInterfaceEntry.updateRouteNextHop(nexthop.getHostAddress());
                    iprouteInterfaceEntry.updateIfIndex(ifindex);
                    iprouteInterfaceEntry.updateRouteMetric1(routemetric1);
                    iprouteInterfaceEntry.updateRouteMetric2(routemetric2);
                    iprouteInterfaceEntry.updateRouteMetric3(routemetric3);
                    iprouteInterfaceEntry.updateRouteMetric4(routemetric4);
                    iprouteInterfaceEntry.updateRouteMetric5(routemetric5);
                    iprouteInterfaceEntry.updateRouteType(routetype);
                    iprouteInterfaceEntry.updateRouteProto(routeproto);
                    iprouteInterfaceEntry.updateStatus('A');
                    iprouteInterfaceEntry.set_lastpolltime(now);
                    iprouteInterfaceEntry.store(dbConn);
                }
                node.setRouteInterfaces(routeInterfaces);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("store: saving VlanTable in DB");
            }
            if (snmpcoll.hasVlanTable()) {
                ArrayList<Vlan> vlans = new ArrayList<Vlan>();
                ite3 = snmpcoll.getVlanTable().getEntries().iterator();
                if (this.log().isDebugEnabled()) {
                    this.log().debug("store: saving Snmp Vlan Table to vlan table in DB");
                }
                while (ite3.hasNext()) {
                    ent = (SnmpTableEntry)((Object)ite3.next());
                    Integer vlanindex = ent.getInt32("vtpVlanIndex");
                    if (vlanindex == null || vlanindex < 0) {
                        this.log().warn("store: Not valid vlan ifindex" + vlanindex + " Skipping...");
                        continue;
                    }
                    String vlanName = ent.getDisplayString("vtpVlanName");
                    if (vlanName == null) {
                        this.log().warn("store: Null vlan name. forcing to default...");
                        vlanName = "default";
                    }
                    Integer vlantype = ent.getInt32("vtpVlanType");
                    Integer vlanstatus = ent.getInt32("vtpVlanStatus");
                    DbVlanEntry vlanEntry = DbVlanEntry.get(dbConn, node.getNodeId(), vlanindex);
                    if (vlanEntry == null) {
                        vlanEntry = DbVlanEntry.create(node.getNodeId(), vlanindex);
                    }
                    vlanEntry.updateVlanName(vlanName);
                    if (vlantype != null) {
                        vlanEntry.updateVlanType(vlantype);
                    } else {
                        vlantype = -1;
                    }
                    if (vlanstatus != null) {
                        vlanEntry.updateVlanStatus(vlanstatus);
                    } else {
                        vlanstatus = -1;
                    }
                    vlanEntry.updateStatus('A');
                    vlanEntry.set_lastpolltime(now);
                    vlanEntry.store(dbConn);
                    Vlan vlan = new Vlan(vlanindex, vlanName, vlanstatus, vlantype);
                    vlans.add(vlan);
                }
                node.setVlans(vlans);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("store: saving SnmpVlanCollection's in DB");
            }
            Iterator<Map.Entry<Vlan, SnmpVlanCollection>> ite4 = snmpcoll.getSnmpVlanCollections().entrySet().iterator();
            SnmpVlanCollection snmpVlanColl = null;
            Vlan vlan = null;
            while (ite4.hasNext()) {
                int curfdbstatus;
                Map.Entry<Vlan, SnmpVlanCollection> entry = ite4.next();
                vlan = entry.getKey();
                int vlanid = vlan.getVlanIndex();
                String vlanname = vlan.getVlanName();
                String vlanindex = Integer.toString(vlanid);
                if (this.log().isDebugEnabled()) {
                    this.log().debug("store: parsing VLAN " + vlanindex + " VLAN_NAME " + vlanname);
                }
                if (!(snmpVlanColl = entry.getValue()).hasDot1dBase()) continue;
                if (this.log().isDebugEnabled()) {
                    this.log().debug("store: saving Dot1dBaseGroup in stpnode table");
                }
                Dot1dBaseGroup dod1db = snmpVlanColl.getDot1dBase();
                DbStpNodeEntry dbStpNodeEntry = null;
                String baseBridgeAddress = dod1db.getBridgeAddress();
                if (baseBridgeAddress == null || baseBridgeAddress == "000000000000") {
                    this.log().warn("store: invalid base bridge address " + baseBridgeAddress);
                    continue;
                }
                node.addBridgeIdentifier(baseBridgeAddress, vlanindex);
                int basenumports = dod1db.getNumberOfPorts();
                int bridgetype = dod1db.getBridgeType();
                if (snmpcoll.getSaveStpNodeTable()) {
                    dbStpNodeEntry = DbStpNodeEntry.get(dbConn, node.getNodeId(), vlanid);
                    if (dbStpNodeEntry == null) {
                        dbStpNodeEntry = DbStpNodeEntry.create(node.getNodeId(), vlanid);
                    }
                    dbStpNodeEntry.updateBaseBridgeAddress(baseBridgeAddress);
                    dbStpNodeEntry.updateBaseNumPorts(basenumports);
                    dbStpNodeEntry.updateBaseType(bridgetype);
                    dbStpNodeEntry.updateBaseVlanName(vlanname);
                }
                if (snmpVlanColl.hasDot1dStp()) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("store: adding Dot1dStpGroup in stpnode table");
                    }
                    Dot1dStpGroup dod1stp = snmpVlanColl.getDot1dStp();
                    int protospec = dod1stp.getStpProtocolSpecification();
                    int stppriority = dod1stp.getStpPriority();
                    int stprootcost = dod1stp.getStpRootCost();
                    int stprootport = dod1stp.getStpRootPort();
                    String stpDesignatedRoot = dod1stp.getStpDesignatedRoot();
                    if (stpDesignatedRoot == null || stpDesignatedRoot == "0000000000000000") {
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("store: Dot1dStpGroup found stpDesignatedRoot " + stpDesignatedRoot + " not adding to Linkable node");
                        }
                        stpDesignatedRoot = "0000000000000000";
                    } else {
                        node.setVlanStpRoot(vlanindex, stpDesignatedRoot);
                    }
                    if (snmpcoll.getSaveStpNodeTable()) {
                        dbStpNodeEntry.updateStpProtocolSpecification(protospec);
                        dbStpNodeEntry.updateStpPriority(stppriority);
                        dbStpNodeEntry.updateStpDesignatedRoot(stpDesignatedRoot);
                        dbStpNodeEntry.updateStpRootCost(stprootcost);
                        dbStpNodeEntry.updateStpRootPort(stprootport);
                    }
                }
                if (snmpcoll.getSaveStpNodeTable()) {
                    dbStpNodeEntry.updateStatus('A');
                    dbStpNodeEntry.set_lastpolltime(now);
                    dbStpNodeEntry.store(dbConn);
                }
                if (snmpVlanColl.hasDot1dBasePortTable()) {
                    Iterator sub_ite = snmpVlanColl.getDot1dBasePortTable().getEntries().iterator();
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("store: saving Dot1dBasePortTable in stpinterface table");
                    }
                    while (sub_ite.hasNext()) {
                        Dot1dBasePortTableEntry dot1dbaseptentry = (Dot1dBasePortTableEntry)((Object)sub_ite.next());
                        int baseport = dot1dbaseptentry.getBaseBridgePort();
                        int ifindex2 = dot1dbaseptentry.getBaseBridgePortIfindex();
                        if (baseport == -1 || ifindex2 == -1) {
                            this.log().warn("store: Dot1dBasePortTable invalid baseport or ifindex " + baseport + " / " + ifindex2);
                            continue;
                        }
                        node.setIfIndexBridgePort(ifindex2, baseport);
                        if (!snmpcoll.getSaveStpInterfaceTable()) continue;
                        DbStpInterfaceEntry dbStpIntEntry = DbStpInterfaceEntry.get(dbConn, node.getNodeId(), baseport, vlanid);
                        if (dbStpIntEntry == null) {
                            dbStpIntEntry = DbStpInterfaceEntry.create(node.getNodeId(), baseport, vlanid);
                        }
                        dbStpIntEntry.updateIfIndex(ifindex2);
                        dbStpIntEntry.updateStatus('A');
                        dbStpIntEntry.set_lastpolltime(now);
                        dbStpIntEntry.store(dbConn);
                    }
                }
                if (snmpVlanColl.hasDot1dStpPortTable()) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug(" store: adding Dot1dStpPortTable in stpinterface table");
                    }
                    for (Dot1dStpPortTableEntry dot1dstpptentry : snmpVlanColl.getDot1dStpPortTable().getEntries()) {
                        DbStpInterfaceEntry dbStpIntEntry = null;
                        int stpport = dot1dstpptentry.getDot1dStpPort();
                        if (stpport == -1) {
                            this.log().warn("store: Dot1dStpPortTable found invalid stp port. Skipping");
                            continue;
                        }
                        if (snmpcoll.getSaveStpInterfaceTable() && (dbStpIntEntry = DbStpInterfaceEntry.get(dbConn, node.getNodeId(), stpport, vlanid)) == null) {
                            this.log().warn("store: StpInterface not found in database when storing STP info for bridge node with nodeid " + node.getNodeId() + " bridgeport number " + stpport + " and vlan index " + vlanindex + " skipping.");
                        }
                        String stpPortDesignatedBridge = dot1dstpptentry.getDot1dStpPortDesignatedBridge();
                        String stpPortDesignatedPort = dot1dstpptentry.getDot1dStpPortDesignatedPort();
                        if (stpPortDesignatedBridge == null || stpPortDesignatedBridge.equals("0000000000000000")) {
                            this.log().warn("store: " + stpPortDesignatedBridge + " designated bridge is invalid not adding to discoveryLink");
                            stpPortDesignatedBridge = "0000000000000000";
                        } else if (stpPortDesignatedPort == null || stpPortDesignatedPort.equals("0000")) {
                            this.log().warn("store: " + stpPortDesignatedPort + " designated port is invalid not adding to discoveryLink");
                            stpPortDesignatedPort = "0000";
                        } else {
                            BridgeStpInterface stpIface = new BridgeStpInterface(stpport, vlanindex);
                            stpIface.setStpPortDesignatedBridge(stpPortDesignatedBridge);
                            stpIface.setStpPortDesignatedPort(stpPortDesignatedPort);
                            node.addStpInterface(stpIface);
                        }
                        if (!snmpcoll.getSaveStpInterfaceTable()) continue;
                        dbStpIntEntry.updateStpPortState(dot1dstpptentry.getDot1dStpPortState());
                        dbStpIntEntry.updateStpPortPathCost(dot1dstpptentry.getDot1dStpPortPathCost());
                        dbStpIntEntry.updateStpportDesignatedBridge(stpPortDesignatedBridge);
                        dbStpIntEntry.updateStpportDesignatedRoot(dot1dstpptentry.getDot1dStpPortDesignatedRoot());
                        dbStpIntEntry.updateStpPortDesignatedCost(dot1dstpptentry.getDot1dStpPortDesignatedCost());
                        dbStpIntEntry.updateStpportDesignatedPort(stpPortDesignatedPort);
                        dbStpIntEntry.updateStatus('A');
                        dbStpIntEntry.set_lastpolltime(now);
                        dbStpIntEntry.store(dbConn);
                    }
                }
                if (snmpVlanColl.hasDot1dTpFdbTable()) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("store: parsing Dot1dTpFdbTable");
                    }
                    for (Dot1dTpFdbTableEntry dot1dfdbentry : snmpVlanColl.getDot1dFdbTable().getEntries()) {
                        int fdbport;
                        String curMacAddress = dot1dfdbentry.getDot1dTpFdbAddress();
                        if (curMacAddress == null || curMacAddress.equals("000000000000")) {
                            this.log().warn("store: Dot1dTpFdbTable invalid macaddress " + curMacAddress + " Skipping.");
                            continue;
                        }
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("store: Dot1dTpFdbTable found macaddress " + curMacAddress);
                        }
                        if ((fdbport = dot1dfdbentry.getDot1dTpFdbPort()) == 0 || fdbport == -1) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("store: Dot1dTpFdbTable mac learned on invalid port " + fdbport + " . Skipping");
                            continue;
                        }
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("store: Dot1dTpFdbTable mac address found  on bridge port " + fdbport);
                        }
                        if ((curfdbstatus = dot1dfdbentry.getDot1dTpFdbStatus()) == 3) {
                            node.addMacAddress(fdbport, curMacAddress, vlanindex);
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("store: Dot1dTpFdbTable found learned status on bridge port ");
                            continue;
                        }
                        if (curfdbstatus == 4) {
                            node.addBridgeIdentifier(curMacAddress);
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("store: Dot1dTpFdbTable mac is bridge identifier");
                            continue;
                        }
                        if (curfdbstatus == 2) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("store: Dot1dTpFdbTable found INVALID status. Skipping");
                            continue;
                        }
                        if (curfdbstatus == 5) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("store: Dot1dTpFdbTable found MGMT status. Skipping");
                            continue;
                        }
                        if (curfdbstatus == 1) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("store: Dot1dTpFdbTable found OTHER status. Skipping");
                            continue;
                        }
                        if (curfdbstatus != -1) continue;
                        this.log().warn("store: Dot1dTpFdbTable null status found. Skipping");
                    }
                }
                if (snmpVlanColl.hasQBridgeDot1dTpFdbTable()) {
                    if (this.log().isDebugEnabled()) {
                        this.log().debug("store: parsing QBridgeDot1dTpFdbTable");
                    }
                    for (QBridgeDot1dTpFdbTableEntry dot1dfdbentry : snmpVlanColl.getQBridgeDot1dFdbTable().getEntries()) {
                        int fdbport;
                        String curMacAddress = dot1dfdbentry.getQBridgeDot1dTpFdbAddress();
                        if (curMacAddress == null || curMacAddress.equals("000000000000")) {
                            this.log().warn("store: QBridgeDot1dTpFdbTable invalid macaddress " + curMacAddress + " Skipping.");
                            continue;
                        }
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("store: Dot1dTpFdbTable found macaddress " + curMacAddress);
                        }
                        if ((fdbport = dot1dfdbentry.getQBridgeDot1dTpFdbPort()) == 0 || fdbport == -1) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("store: QBridgeDot1dTpFdbTable mac learned on invalid port " + fdbport + " . Skipping");
                            continue;
                        }
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("store: QBridgeDot1dTpFdbTable mac address found  on bridge port " + fdbport);
                        }
                        if ((curfdbstatus = dot1dfdbentry.getQBridgeDot1dTpFdbStatus()) == 3) {
                            node.addMacAddress(fdbport, curMacAddress, vlanindex);
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("store: QBridgeDot1dTpFdbTable found learned status on bridge port ");
                            continue;
                        }
                        if (curfdbstatus == 4) {
                            node.addBridgeIdentifier(curMacAddress);
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("store: QBridgeDot1dTpFdbTable mac is bridge identifier");
                            continue;
                        }
                        if (curfdbstatus == 2) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("store: QBridgeDot1dTpFdbTable found INVALID status. Skipping");
                            continue;
                        }
                        if (curfdbstatus == 5) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("store: QBridgeDot1dTpFdbTable found MGMT status. Skipping");
                            continue;
                        }
                        if (curfdbstatus == 1) {
                            if (!this.log().isDebugEnabled()) continue;
                            this.log().debug("store: QBridgeDot1dTpFdbTable found OTHER status. Skipping");
                            continue;
                        }
                        if (curfdbstatus != -1) continue;
                        this.log().warn("store: QBridgeDot1dTpFdbTable null status found. Skipping");
                    }
                }
                PreparedStatement stmt = null;
                stmt = dbConn.prepareStatement(SQL_GET_SNMPPHYSADDR_SNMPINTERFACE);
                d.watch((Object)stmt);
                stmt.setInt(1, node.getNodeId());
                ResultSet rs = stmt.executeQuery();
                d.watch((Object)rs);
                while (rs.next()) {
                    String macaddr = rs.getString("snmpphysaddr");
                    if (macaddr == null) continue;
                    node.addBridgeIdentifier(macaddr);
                    if (!this.log().isDebugEnabled()) continue;
                    this.log().debug("setBridgeIdentifierFromSnmpInterface: found bridge identifier " + macaddr + " from snmpinterface db table");
                }
            }
            this.update(dbConn, now, node.getNodeId());
            LinkableNode linkableNode = node;
            return linkableNode;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Connection dbConn, Timestamp now, int nodeid) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = null;
            int i = 0;
            stmt = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("store: SQL statement UPDATE atinterface set status = 'N'  WHERE sourcenodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + ".");
            }
            stmt = dbConn.prepareStatement(SQL_UPDATE_VLAN);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("store: SQL statement UPDATE vlan set status = 'N'  WHERE nodeid =? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + ".");
            }
            stmt = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("store: SQL statement UPDATE iprouteinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + ".");
            }
            stmt = dbConn.prepareStatement(SQL_UPDATE_STPNODE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("store: SQL statement UPDATE stpnode set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + ".");
            }
            stmt = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setTimestamp(2, now);
            i = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("store: SQL statement UPDATE stpinterface set status = 'N'  WHERE nodeid = ? AND lastpolltime < ? AND status = 'A'. " + i + " rows UPDATED for nodeid=" + nodeid + ".");
            }
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(int nodeid, char status) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            PreparedStatement stmt = null;
            int i = 0;
            stmt = dbConn.prepareStatement(SQL_UPDATE_VLAN_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            i = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("update: SQL statement UPDATE vlan set status = ?  WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + ".");
            }
            stmt = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            stmt.setInt(3, nodeid);
            i = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("update: SQL statement UPDATE atinterface set status = ?  WHERE sourcenodeid = ? OR nodeid = ?. " + i + " rows UPDATED for nodeid=" + nodeid + ".");
            }
            stmt = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            i = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("update: SQL statement UPDATE iprouteinterface set status = ? WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + ".");
            }
            stmt = dbConn.prepareStatement(SQL_UPDATE_STPNODE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            i = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("update: SQL statement UPDATE stpnode set status = ?  WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + ".");
            }
            stmt = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            i = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("update: SQL statement UPDATE stpinterface set status = ? WHERE nodeid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + ".");
            }
            stmt = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE_STATUS);
            d.watch((Object)stmt);
            stmt.setString(1, new String(new char[]{status}));
            stmt.setInt(2, nodeid);
            stmt.setInt(3, nodeid);
            i = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug("update: SQL statement UPDATE datalinkinterface set status = ? WHERE nodeid = ? OR nodeparentid = ? . " + i + " rows UPDATED for nodeid=" + nodeid + ".");
            }
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNodeidFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        if (ipaddr.isLoopbackAddress() || ipaddr.getHostAddress().equals("0.0.0.0")) {
            return -1;
        }
        int nodeid = -1;
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = null;
            stmt = dbConn.prepareStatement(SQL_GET_NODEID);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr.getHostAddress());
            if (this.log().isDebugEnabled()) {
                this.log().debug("getNodeidFromIp: executing query SELECT node.nodeid FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with ip address=" + ipaddr.getHostAddress());
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getNodeidFromIp: no entries found in ipinterface");
                }
                int n = -1;
                return n;
            }
            int ndx = 1;
            nodeid = rs.getInt(ndx++);
            if (rs.wasNull()) {
                nodeid = -1;
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("getNodeidFromIp: found nodeid " + nodeid);
            }
        }
        finally {
            d.cleanUp();
        }
        return nodeid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RouterInterface getNodeidMaskFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        if (ipaddr.isLoopbackAddress() || ipaddr.getHostAddress().equals("0.0.0.0")) {
            return null;
        }
        int nodeid = -1;
        int ifindex = -1;
        String netmask = null;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_GET_NODEID__IFINDEX_MASK);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr.getHostAddress());
            if (this.log().isDebugEnabled()) {
                this.log().debug("getNodeidMaskFromIp: executing query SELECT node.nodeid,snmpinterface.snmpifindex,snmpinterface.snmpipadentnetmask FROM node LEFT JOIN snmpinterface ON node.nodeid = snmpinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with ip address=" + ipaddr.getHostAddress());
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getNodeidMaskFromIp: no entries found in snmpinterface");
                }
                RouterInterface routerInterface = null;
                return routerInterface;
            }
            nodeid = rs.getInt("nodeid");
            if (rs.wasNull()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getNodeidMaskFromIp: no nodeid found");
                }
                RouterInterface routerInterface = null;
                return routerInterface;
            }
            ifindex = rs.getInt("snmpifindex");
            if (rs.wasNull()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getNodeidMaskFromIp: no snmsnmpifindex found");
                }
                ifindex = -1;
            }
            netmask = rs.getString("snmpipadentnetmask");
            if (rs.wasNull()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getNodeidMaskFromIp: no snmpipadentnetmask found");
                }
                netmask = "255.255.255.255";
            }
        }
        finally {
            d.cleanUp();
        }
        RouterInterface ri = new RouterInterface(nodeid, ifindex, netmask);
        return ri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RouterInterface getNodeFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        if (ipaddr.isLoopbackAddress() || ipaddr.getHostAddress().equals("0.0.0.0")) {
            return null;
        }
        int nodeid = -1;
        int ifindex = -1;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_GET_NODEID);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr.getHostAddress());
            if (this.log().isDebugEnabled()) {
                this.log().debug("getNodeFromIp: executing query SELECT node.nodeid FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with ip address=" + ipaddr.getHostAddress());
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getNodeFromIp: no entries found in snmpinterface");
                }
                RouterInterface routerInterface = null;
                return routerInterface;
            }
            nodeid = rs.getInt("nodeid");
            if (rs.wasNull()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getNodeFromIp: no nodeid found");
                }
                RouterInterface routerInterface = null;
                return routerInterface;
            }
        }
        finally {
            d.cleanUp();
        }
        RouterInterface ri = new RouterInterface(nodeid, ifindex);
        return ri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtInterface getNodeidIfindexFromIp(Connection dbConn, InetAddress ipaddr) throws SQLException {
        if (ipaddr.isLoopbackAddress() || ipaddr.getHostAddress().equals("0.0.0.0")) {
            return null;
        }
        int atnodeid = -1;
        int atifindex = -1;
        AtInterface ati = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = dbConn.prepareStatement(SQL_GET_NODEID_IFINDEX_IPINT);
            d.watch((Object)stmt);
            stmt.setString(1, ipaddr.getHostAddress());
            if (this.log().isDebugEnabled()) {
                this.log().debug("getNodeidIfindexFromIp: executing SQL Statement SELECT node.nodeid,ipinterface.ifindex FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND ipaddr = ? with ip address=" + ipaddr.getHostAddress());
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                AtInterface atInterface = null;
                return atInterface;
            }
            atnodeid = rs.getInt("nodeid");
            if (rs.wasNull()) {
                AtInterface atInterface = null;
                return atInterface;
            }
            ati = new AtInterface(atnodeid, ipaddr.getHostAddress());
            atifindex = rs.getInt("ifindex");
            if (rs.wasNull()) {
                if (this.log().isInfoEnabled()) {
                    this.log().info("getNodeidIfindexFromIp: nodeid " + atnodeid + " no ifindex (-1) found for ipaddress " + ipaddr + ".");
                }
            } else {
                if (this.log().isInfoEnabled()) {
                    this.log().info("getNodeidIfindexFromIp: nodeid " + atnodeid + " ifindex " + atifindex + " found for ipaddress " + ipaddr + ".");
                }
                ati.setIfindex(atifindex);
            }
        }
        finally {
            d.cleanUp();
        }
        return ati;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSnmpIfType(Connection dbConn, int nodeid, int ifindex) throws SQLException {
        int snmpiftype = -1;
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            stmt = dbConn.prepareStatement(SQL_GET_SNMPIFTYPE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setInt(2, ifindex);
            if (this.log().isDebugEnabled()) {
                this.log().debug("getSnmpIfType: executing query SELECT snmpiftype FROM snmpinterface WHERE nodeid = ? AND snmpifindex = ? with nodeid=" + nodeid + " and ifindex=" + ifindex);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getSnmpIfType: no entries found in snmpinterface");
                }
                int n = -1;
                return n;
            }
            int ndx = 1;
            snmpiftype = rs.getInt(ndx++);
            if (rs.wasNull()) {
                snmpiftype = -1;
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("getSnmpIfType: found in snmpinterface snmpiftype=" + snmpiftype);
            }
            int n = snmpiftype;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIfIndexByName(Connection dbConn, int nodeid, String ifName) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = null;
            stmt = dbConn.prepareStatement(SQL_GET_IFINDEX_SNMPINTERFACE_NAME);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            stmt.setString(2, ifName);
            stmt.setString(3, ifName);
            if (this.log().isDebugEnabled()) {
                this.log().debug("getIfIndexByName: executing querySELECT snmpifindex FROM snmpinterface WHERE nodeid = ? AND (snmpifname = ? OR snmpifdescr = ?) nodeid =" + nodeid + "and ifName=" + ifName);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (!rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getIfIndexByName: no entries found in snmpinterface");
                }
                int n = -1;
                return n;
            }
            int ndx = 1;
            if (rs.wasNull()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getIfIndexByName: no entries found in snmpinterface");
                }
                int n = -1;
                return n;
            }
            int ifindex = rs.getInt(ndx++);
            if (this.log().isDebugEnabled()) {
                this.log().debug("getIfIndexByName: found ifindex=" + ifindex);
            }
            int n = ifindex;
            return n;
        }
        finally {
            d.cleanUp();
        }
    }

    private void sendNewSuspectEvent(InetAddress ipaddress, InetAddress ipowner, String name) {
        Linkd.getInstance().sendNewSuspectEvent(ipaddress.getHostAddress(), ipowner.getHostAddress(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkableNode getSnmpNode(int nodeid) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            LinkableNode node = null;
            PreparedStatement stmt = dbConn.prepareStatement(SQL_SELECT_SNMP_NODE);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            if (this.log().isDebugEnabled()) {
                this.log().debug("getSnmpCollection: execute 'SELECT nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE node.nodeid = ? AND nodetype = 'A' AND issnmpprimary = 'P'' with nodeid =" + nodeid);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                String sysoid = rs.getString("nodesysoid");
                if (sysoid == null) {
                    sysoid = "-1";
                }
                String ipaddr = rs.getString("ipaddr");
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getSnmpCollection: found nodeid " + nodeid + " ipaddr " + ipaddr + " sysoid " + sysoid);
                }
                node = new LinkableNode(nodeid, ipaddr, sysoid);
            }
            LinkableNode linkableNode = node;
            return linkableNode;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LinkableNode> getSnmpNodeList() throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            ArrayList<LinkableNode> linknodes = new ArrayList<LinkableNode>();
            PreparedStatement ps = dbConn.prepareStatement(SQL_SELECT_SNMP_NODES);
            d.watch((Object)ps);
            ResultSet rs = ps.executeQuery();
            d.watch((Object)rs);
            if (this.log().isDebugEnabled()) {
                this.log().debug("getNodesInfo: execute query: \" SELECT node.nodeid, nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND issnmpprimary = 'P'\"");
            }
            while (rs.next()) {
                int nodeid = rs.getInt("nodeid");
                String ipaddr = rs.getString("ipaddr");
                String sysoid = rs.getString("nodesysoid");
                if (sysoid == null) {
                    sysoid = "-1";
                }
                if (this.log().isDebugEnabled()) {
                    this.log().debug("getNodesInfo: found node element: nodeid " + nodeid + " ipaddr " + ipaddr + " sysoid " + sysoid);
                }
                LinkableNode node = new LinkableNode(nodeid, ipaddr, sysoid);
                linknodes.add(node);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("getNodesInfo: found " + linknodes.size() + " snmp primary ip nodes");
            }
            ArrayList<LinkableNode> arrayList = linknodes;
            return arrayList;
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeletedNodes() throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            int i = 0;
            PreparedStatement ps = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            if (this.log().isInfoEnabled()) {
                this.log().info("updateDeletedNodes: execute 'UPDATE atinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ' updated rows: " + i);
            }
            ps = dbConn.prepareStatement(SQL_UPDATE_VLAN_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            if (this.log().isInfoEnabled()) {
                this.log().info("updateDeletedNodes: execute 'UPDATE vlan set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ' updated rows: " + i);
            }
            ps = dbConn.prepareStatement(SQL_UPDATE_STPNODE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            if (this.log().isInfoEnabled()) {
                this.log().info("updateDeletedNodes: execute 'UPDATE stpnode set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'' updated rows: " + i);
            }
            ps = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            if (this.log().isInfoEnabled()) {
                this.log().info("updateDeletedNodes: execute 'UPDATE stpinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'' updated rows: " + i);
            }
            ps = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            if (this.log().isInfoEnabled()) {
                this.log().info("updateDeletedNodes: execute 'UPDATE iprouteinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D''updated rows: " + i);
            }
            ps = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE_D);
            d.watch((Object)ps);
            i = ps.executeUpdate();
            if (this.log().isInfoEnabled()) {
                this.log().info("updateDeletedNodes: execute 'UPDATE datalinkinterface set status = 'D' WHERE (nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) OR nodeparentid IN (SELECT nodeid from node WHERE nodetype = 'D' )) AND status <> 'D'' updated rows: " + i);
            }
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateForInterface(int nodeId, String ipAddr, int ifIndex, char status) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            PreparedStatement ps = null;
            int i = 0;
            if (!EventUtils.isNonIpInterface(ipAddr)) {
                ps = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE_STATUS_INTFC);
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setString(3, ipAddr);
                i = ps.executeUpdate();
                if (this.log().isInfoEnabled()) {
                    this.log().info("updateForInterface: atinterface: node = " + nodeId + ", IP Address = " + ipAddr + ", status = " + status + ": updated rows = " + i);
                }
            }
            if (ifIndex > -1) {
                ps = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE_STATUS_SRC_INTFC);
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setInt(3, ifIndex);
                i = ps.executeUpdate();
                if (this.log().isInfoEnabled()) {
                    this.log().info("updateForInterface: atinterface: source node = " + nodeId + ", ifIndex = " + ifIndex + ", status = " + status + ": updated rows = " + i);
                }
                ps = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE_STATUS_INTFC);
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setInt(3, ifIndex);
                i = ps.executeUpdate();
                if (this.log().isInfoEnabled()) {
                    this.log().info("updateForInterface: stpinterface: node = " + nodeId + ", ifIndex = " + ifIndex + ", status = " + status + ": updated rows = " + i);
                }
                ps = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE_STATUS_INTFC);
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setInt(3, ifIndex);
                i = ps.executeUpdate();
                if (this.log().isInfoEnabled()) {
                    this.log().info("updateForInterface: iprouteinterface: node = " + nodeId + ", rpouteIfIndex = " + ifIndex + ", status = " + status + ": updated rows = " + i);
                }
                ps = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE_STATUS_INTFC);
                d.watch((Object)ps);
                ps.setString(1, new String(new char[]{status}));
                ps.setInt(2, nodeId);
                ps.setInt(3, ifIndex);
                ps.setInt(4, nodeId);
                ps.setInt(5, ifIndex);
                i = ps.executeUpdate();
                if (this.log().isInfoEnabled()) {
                    this.log().info("updateForInterface: datalinkinterface: node = " + nodeId + ", ifIndex = " + ifIndex + ", status = " + status + ": updated rows = " + i);
                }
            }
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSnmpPrimaryIp(int nodeid) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection dbConn = this.getConnection();
            d.watch((Object)dbConn);
            String ipaddr = null;
            PreparedStatement stmt = dbConn.prepareStatement(SQL_SELECT_SNMP_IP_ADDR);
            d.watch((Object)stmt);
            stmt.setInt(1, nodeid);
            if (this.log().isDebugEnabled()) {
                this.log().debug("getSnmpPrimaryIp: SQL statement = " + stmt.toString());
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                ipaddr = rs.getString("ipaddr");
                if (ipaddr == null) {
                    String string = null;
                    return string;
                }
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug("getSnmpPrimaryIp: found node element: nodeid " + nodeid + " ipaddr " + ipaddr);
            }
            String string = ipaddr;
            return string;
        }
        finally {
            d.cleanUp();
        }
    }

    @Override
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

