/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.linkd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.linkd.DbAtInterfaceEntry;

final class DbDataLinkInterfaceEntry {
    static final char STATUS_ACTIVE = 'A';
    static final char STATUS_NOT_POLLED = 'N';
    static final char STATUS_DELETE = 'D';
    static final char STATUS_UNKNOWN = 'K';
    int m_nodeId;
    int m_ifindex;
    int m_nodeparentid;
    int m_parentifindex;
    char m_status = (char)75;
    Timestamp m_lastPollTime;
    private static final String SQL_LOAD_DATALINKINTERFACE = "SELECT nodeparentid,parentIfIndex,status,lastpolltime FROM datalinkinterface WHERE nodeid = ? AND ifindex = ? ";
    private boolean m_fromDb;
    private int m_changed;
    private static final int CHANGED_PARENTNODEID = 1;
    private static final int CHANGED_PARENTIFINDEX = 2;
    private static final int CHANGED_STATUS = 4;
    private static final int CHANGED_POLLTIME = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(Connection c) throws SQLException {
        if (this.m_fromDb) {
            throw new IllegalStateException("The record already exists in the database");
        }
        String queryString = "INSERT INTO DataLinkInterface (nodeid,ifindex,nodeparentid,parentIfIndex,status,lastpolltime) VALUES (?,?,?,?,?,?)";
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = c.prepareStatement(queryString);
            d.watch((Object)stmt);
            queryString = null;
            int ndx = 1;
            stmt.setInt(ndx++, this.m_nodeId);
            stmt.setInt(ndx++, this.m_ifindex);
            stmt.setInt(ndx++, this.m_nodeparentid);
            stmt.setInt(ndx++, this.m_parentifindex);
            stmt.setString(ndx++, new String(new char[]{this.m_status}));
            stmt.setTimestamp(ndx++, this.m_lastPollTime);
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
        this.m_fromDb = true;
        this.m_changed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        StringBuffer sqlText = new StringBuffer("UPDATE DataLinkInterface SET ");
        int comma = 32;
        if ((this.m_changed & 1) == 1) {
            sqlText.append((char)comma).append("nodeparentid = ?");
            comma = 44;
        }
        if ((this.m_changed & 2) == 2) {
            sqlText.append((char)comma).append("parentIfIndex = ?");
            comma = 44;
        }
        if ((this.m_changed & 4) == 4) {
            sqlText.append((char)comma).append("status = ?");
            comma = 44;
        }
        if ((this.m_changed & 8) == 8) {
            sqlText.append((char)comma).append("lastpolltime = ?");
            comma = 44;
        }
        sqlText.append(" WHERE nodeid = ? AND ifindex = ? ");
        DBUtils d = new DBUtils(this.getClass());
        try {
            PreparedStatement stmt = c.prepareStatement(sqlText.toString());
            d.watch((Object)stmt);
            int ndx = 1;
            if ((this.m_changed & 1) == 1) {
                stmt.setInt(ndx++, this.m_nodeparentid);
            }
            if ((this.m_changed & 2) == 2) {
                stmt.setInt(ndx++, this.m_parentifindex);
            }
            if ((this.m_changed & 4) == 4) {
                stmt.setString(ndx++, new String(new char[]{this.m_status}));
            }
            if ((this.m_changed & 8) == 8) {
                stmt.setTimestamp(ndx++, this.m_lastPollTime);
            }
            stmt.setInt(ndx++, this.m_nodeId);
            stmt.setInt(ndx++, this.m_ifindex);
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
        this.m_changed = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean load(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            String str;
            stmt = c.prepareStatement(SQL_LOAD_DATALINKINTERFACE);
            d.watch((Object)stmt);
            stmt.setInt(1, this.m_nodeId);
            stmt.setInt(2, this.m_ifindex);
            ResultSet rset = stmt.executeQuery();
            d.watch((Object)rset);
            if (!rset.next()) {
                if (log.isDebugEnabled()) {
                    log.debug("DataLinkInterfaceEntry.load: no result found");
                }
                boolean bl = false;
                return bl;
            }
            int ndx = 1;
            this.m_nodeparentid = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_nodeparentid = -1;
            }
            this.m_parentifindex = rset.getInt(ndx++);
            if (rset.wasNull()) {
                this.m_ifindex = -1;
            }
            this.m_status = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)75;
            this.m_lastPollTime = rset.getTimestamp(ndx++);
        }
        finally {
            d.cleanUp();
        }
        if (log.isDebugEnabled()) {
            log.debug("DataInterfaceEntry.load: result found");
        }
        this.m_changed = 0;
        return true;
    }

    DbDataLinkInterfaceEntry() {
        throw new UnsupportedOperationException("Default constructor not supported!");
    }

    DbDataLinkInterfaceEntry(int nodeId, int ifindex, boolean exists) {
        this.m_nodeId = nodeId;
        this.m_ifindex = ifindex;
        this.m_fromDb = exists;
        this.m_nodeparentid = -1;
        this.m_parentifindex = -1;
    }

    DbDataLinkInterfaceEntry(int nodeId, boolean exists) {
        this.m_nodeId = nodeId;
        this.m_ifindex = -1;
        this.m_fromDb = exists;
        this.m_nodeparentid = -1;
        this.m_parentifindex = -1;
    }

    static DbDataLinkInterfaceEntry create(int nodeid, int ifindex) {
        return new DbDataLinkInterfaceEntry(nodeid, ifindex, false);
    }

    static DbDataLinkInterfaceEntry create(int nodeid) {
        return new DbDataLinkInterfaceEntry(nodeid, false);
    }

    public int get_nodeId() {
        return this.m_nodeId;
    }

    public int get_ifindex() {
        return this.m_ifindex;
    }

    public int get_nodeparentid() {
        return this.m_nodeparentid;
    }

    void set_nodeparentid(int nodeparentid) {
        this.m_nodeparentid = nodeparentid;
        this.m_changed |= 1;
    }

    boolean hasNodeParentIdChanged() {
        return (this.m_changed & 1) == 1;
    }

    boolean updateNodeParentId(int nodeparentid) {
        if (nodeparentid != this.m_nodeparentid) {
            this.set_nodeparentid(nodeparentid);
            return true;
        }
        return false;
    }

    public int get_parentifindex() {
        return this.m_parentifindex;
    }

    void set_parentifindex(int parentifindex) {
        this.m_parentifindex = parentifindex;
        this.m_changed |= 2;
    }

    boolean hasParentIfIndexChanged() {
        return (this.m_changed & 2) == 2;
    }

    boolean updateParentIfIndex(int parentifindex) {
        if (parentifindex != this.m_parentifindex) {
            this.set_parentifindex(parentifindex);
            return true;
        }
        return false;
    }

    public char get_status() {
        return this.m_status;
    }

    void set_status(char status) {
        if (status == 'A' || status == 'N' || status == 'D') {
            this.m_status = status;
        }
        this.m_changed |= 4;
    }

    boolean hasStatusChanged() {
        return (this.m_changed & 4) == 4;
    }

    boolean updateStatus(char status) {
        if (status != this.m_status) {
            this.set_status(status);
            return true;
        }
        return false;
    }

    Timestamp get_lastpolltime() {
        return this.m_lastPollTime;
    }

    String getLastPollTimeString() {
        String result = null;
        if (this.m_lastPollTime != null) {
            result = this.m_lastPollTime.toString();
        }
        return result;
    }

    void set_lastpolltime(String time) throws ParseException {
        if (time == null) {
            this.m_lastPollTime = null;
        } else {
            Date tmpDate = EventConstants.parseToDate((String)time);
            this.m_lastPollTime = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 8;
    }

    void set_lastpolltime(Date time) {
        this.m_lastPollTime = new Timestamp(time.getTime());
        this.m_changed |= 8;
    }

    void set_lastpolltime(Timestamp time) {
        this.m_lastPollTime = time;
        this.m_changed |= 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store() throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            Connection db = null;
            try {
                db = DataSourceFactory.getInstance().getConnection();
                this.store(db);
                if (!db.getAutoCommit()) {
                    db.commit();
                }
            }
            finally {
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (SQLException e) {
                    ThreadCategory.getInstance(this.getClass()).warn("Exception closing JDBC connection", (Throwable)e);
                }
            }
        }
    }

    void store(Connection db) throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            if (this.m_fromDb) {
                this.update(db);
            } else {
                this.insert(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbDataLinkInterfaceEntry get(int nid, int ifindex) throws SQLException {
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            DbDataLinkInterfaceEntry dbDataLinkInterfaceEntry = DbDataLinkInterfaceEntry.get(db, nid, ifindex);
            return dbDataLinkInterfaceEntry;
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(DbAtInterfaceEntry.class).warn("Exception closing JDBC connection", (Throwable)e);
            }
        }
    }

    static DbDataLinkInterfaceEntry get(Connection db, int nid, int ifindex) throws SQLException {
        DbDataLinkInterfaceEntry entry = new DbDataLinkInterfaceEntry(nid, ifindex, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbDataLinkInterfaceEntry get(int nid) throws SQLException {
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            DbDataLinkInterfaceEntry dbDataLinkInterfaceEntry = DbDataLinkInterfaceEntry.get(db, nid);
            return dbDataLinkInterfaceEntry;
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(DbAtInterfaceEntry.class).warn("Exception closing JDBC connection", (Throwable)e);
            }
        }
    }

    static DbDataLinkInterfaceEntry get(Connection db, int nid) throws SQLException {
        DbDataLinkInterfaceEntry entry = new DbDataLinkInterfaceEntry(nid, true);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("from db = ").append(this.m_fromDb).append(sep);
        buf.append("node id = ").append(this.m_nodeId).append(sep);
        buf.append("ifindex = ").append(this.m_ifindex).append(sep);
        buf.append("node parent id = ").append(this.m_nodeparentid).append(sep);
        buf.append("parent interface ifindex = ").append(this.m_parentifindex).append(sep);
        buf.append("status = ").append(this.m_status).append(sep);
        buf.append("last poll time = ").append(this.m_lastPollTime).append(sep);
        return buf.toString();
    }
}

