/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors.tcp;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.eventd.adaptors.EventHandlerMBeanProxy;
import org.opennms.netmgt.eventd.adaptors.EventReceiver;
import org.opennms.netmgt.eventd.adaptors.tcp.TcpEventReceiverMBean;
import org.opennms.netmgt.eventd.adaptors.tcp.TcpServer;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TcpEventReceiver
implements EventReceiver,
TcpEventReceiverMBean {
    public static final int UNLIMITED_EVENTS = -1;
    private Thread m_worker;
    private TcpServer m_server;
    private List<EventHandler> m_eventHandlers = new ArrayList<EventHandler>(3);
    private volatile int m_status = 0;
    private int m_tcpPort;
    private String m_logPrefix;
    private int m_recsPerConn;
    private String m_ipAddress;

    public TcpEventReceiver() throws UnknownHostException {
        this(5817, "127.0.0.1");
    }

    public TcpEventReceiver(int port, String ipAddress) throws UnknownHostException {
        this.m_tcpPort = port;
        this.m_ipAddress = ipAddress;
        this.m_server = null;
        this.m_worker = null;
        this.m_logPrefix = null;
        this.m_recsPerConn = -1;
    }

    public synchronized void start() {
        this.assertNotRunning();
        this.m_status = 1;
        try {
            InetAddress address = "*".equals(this.m_ipAddress) ? null : InetAddress.getByName(this.m_ipAddress);
            this.m_server = new TcpServer((Fiber)this, this.m_eventHandlers, this.m_tcpPort, address);
            if (this.m_logPrefix != null) {
                this.m_server.setLogPrefix(this.m_logPrefix);
            }
            if (this.m_recsPerConn != -1) {
                this.m_server.setEventsPerConnection(this.m_recsPerConn);
            }
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e, "Error opening server socket: " + e);
        }
        this.m_worker = new Thread((Runnable)this.m_server, "Event TCP Server[" + this.m_tcpPort + "]");
        try {
            this.m_worker.start();
        }
        catch (RuntimeException e) {
            this.m_worker.interrupt();
            this.m_status = 4;
            throw e;
        }
        this.m_status = 2;
    }

    public synchronized void stop() {
        if (this.m_status == 4) {
            return;
        }
        if (this.m_status == 0) {
            this.m_status = 4;
            return;
        }
        this.m_status = 3;
        try {
            this.m_server.stop();
        }
        catch (InterruptedException e) {
            this.log().warn("Thread Interrupted while attempting to join server socket thread", (Throwable)e);
        }
        this.m_server = null;
        this.m_worker = null;
        this.m_status = 4;
    }

    public String getName() {
        return "Event TCP Receiver[" + this.m_tcpPort + "]";
    }

    public int getStatus() {
        return this.m_status;
    }

    public String getStatusText() {
        return STATUS_NAMES[this.getStatus()];
    }

    public String status() {
        return this.getStatusText();
    }

    public void init() {
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventHandler(EventHandler handler) {
        List<EventHandler> list = this.m_eventHandlers;
        synchronized (list) {
            if (!this.m_eventHandlers.contains(handler)) {
                this.m_eventHandlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventHandler(EventHandler handler) {
        List<EventHandler> list = this.m_eventHandlers;
        synchronized (list) {
            this.m_eventHandlers.remove(handler);
        }
    }

    public List<EventHandler> getEventHandlers() {
        return this.m_eventHandlers;
    }

    public void setEventHandlers(List<EventHandler> eventHandlers) {
        this.m_eventHandlers = eventHandlers;
    }

    public String getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.assertNotRunning();
        this.m_ipAddress = ipAddress;
    }

    @Override
    public Integer getPort() {
        return new Integer(this.m_tcpPort);
    }

    @Override
    public void setPort(Integer port) {
        this.assertNotRunning();
        this.m_tcpPort = port;
    }

    @Override
    public void addEventHandler(String name) throws MalformedObjectNameException, InstanceNotFoundException {
        this.addEventHandler(new EventHandlerMBeanProxy(new ObjectName(name)));
    }

    @Override
    public void removeEventHandler(String name) throws MalformedObjectNameException, InstanceNotFoundException {
        this.removeEventHandler(new EventHandlerMBeanProxy(new ObjectName(name)));
    }

    @Override
    public void setLogPrefix(String prefix) {
        this.m_logPrefix = prefix;
    }

    @Override
    public void setEventsPerConnection(Integer number) {
        this.assertNotRunning();
        this.m_recsPerConn = number;
    }

    private void assertNotRunning() {
        Assert.state((this.m_status == 0 || this.m_status == 4 ? 1 : 0) != 0, (String)"The fiber is already running and cannot be modified or started");
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

