/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.adaptors;

import java.util.ArrayList;
import java.util.Iterator;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.adaptors.EventHandler;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.EventReceipt;

public class EventHandlerMBeanProxy
implements EventHandler {
    private MBeanServer m_mbserver;
    private ObjectName m_listener;

    private void findServer() throws InstanceNotFoundException {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        Iterator i = servers.iterator();
        while (i.hasNext()) {
            try {
                MBeanServer sx = (MBeanServer)i.next();
                if (sx.getObjectInstance(this.m_listener) == null) continue;
                this.m_mbserver = sx;
                break;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
        }
        if (this.m_mbserver == null) {
            throw new InstanceNotFoundException("could not locate mbean server instance");
        }
    }

    public EventHandlerMBeanProxy(String name) throws MalformedObjectNameException, InstanceNotFoundException {
        this.m_listener = new ObjectName(name);
        this.findServer();
    }

    public EventHandlerMBeanProxy(ObjectName name) throws InstanceNotFoundException {
        this.m_listener = name;
        this.findServer();
    }

    public EventHandlerMBeanProxy(ObjectName name, MBeanServer server) {
        this.m_listener = name;
        this.m_mbserver = server;
    }

    public boolean processEvent(Event event) {
        boolean result = false;
        try {
            Boolean r = (Boolean)this.m_mbserver.invoke(this.m_listener, "processEvent", new Object[]{event}, new String[]{"org.opennms.netmgt.xml.event.Event"});
            result = r;
        }
        catch (Throwable t) {
            ThreadCategory.getInstance(this.getClass()).warn("Invocation on object " + this.m_listener + " failed", t);
        }
        return result;
    }

    public void receiptSent(EventReceipt receipt) {
        try {
            this.m_mbserver.invoke(this.m_listener, "receiptSent", new Object[]{receipt}, new String[]{"org.opennms.netmgt.xml.event.EventReceipt"});
        }
        catch (Throwable t) {
            ThreadCategory.getInstance(this.getClass()).warn("Invocation on object " + this.m_listener + " failed", t);
        }
    }

    public boolean equals(Object obj) {
        boolean rc = false;
        if (this == obj) {
            rc = true;
        } else if (obj != null && obj instanceof EventHandlerMBeanProxy) {
            EventHandlerMBeanProxy p = (EventHandlerMBeanProxy)obj;
            if (p.m_mbserver.equals(this.m_mbserver) && p.m_listener.equals(this.m_listener)) {
                rc = true;
            }
        }
        return rc;
    }
}

