/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventdServiceManager;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.util.Assert;

public class JdbcEventdServiceManager
implements InitializingBean,
EventdServiceManager {
    private DataSource m_dataSource;
    private Map<String, Integer> m_serviceMap = new HashMap<String, Integer>();

    public synchronized int getServiceId(String serviceName) throws DataAccessException {
        int serviceId;
        Assert.notNull((Object)serviceName, (String)"The serviceName argument must not be null");
        if (this.m_serviceMap.containsKey(serviceName)) {
            return this.m_serviceMap.get(serviceName);
        }
        this.log().debug("Could not find entry for '" + serviceName + "' in service name cache.  Looking up in database.");
        try {
            serviceId = new JdbcTemplate(this.m_dataSource).queryForInt("SELECT serviceID FROM service WHERE serviceName = ?", new Object[]{serviceName});
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0) {
                this.log().debug("Did not find entry for '" + serviceName + "' in database.");
                return -1;
            }
            throw e;
        }
        this.m_serviceMap.put(serviceName, new Integer(serviceId));
        this.log().debug("Found entry for '" + serviceName + "' (ID " + serviceId + ") in database.  Adding to service name cache.");
        return serviceId;
    }

    public synchronized void dataSourceSync() {
        this.m_serviceMap.clear();
        new JdbcTemplate(this.m_dataSource).query("SELECT serviceID, serviceName FROM service", new RowCallbackHandler(){

            public void processRow(ResultSet resultSet) throws SQLException {
                JdbcEventdServiceManager.this.m_serviceMap.put(resultSet.getString(2), new Integer(resultSet.getInt(1)));
            }
        });
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_dataSource != null ? 1 : 0) != 0, (String)"property dataSource must be set");
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }
}

