/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.config.common.Header;
import org.opennms.netmgt.config.views.Categories;
import org.opennms.netmgt.config.views.Category;
import org.opennms.netmgt.config.views.Member;
import org.opennms.netmgt.config.views.Membership;
import org.opennms.netmgt.config.views.View;
import org.opennms.netmgt.config.views.Viewinfo;
import org.opennms.netmgt.config.views.Views;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewFactory {
    private static ViewFactory instance;
    protected static File usersFile;
    protected static HashMap<String, View> m_views;
    private static boolean initialized;
    private static Header oldHeader;

    ViewFactory() {
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (!initialized) {
            ViewFactory.reload();
        }
    }

    public static synchronized ViewFactory getInstance() {
        if (!initialized) {
            return null;
        }
        if (instance == null) {
            instance = new ViewFactory();
        }
        return instance;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        Viewinfo viewinfo = (Viewinfo)CastorUtils.unmarshal(Viewinfo.class, (Resource)new FileSystemResource(ConfigFileConstants.getFile((int)ConfigFileConstants.VIEWS_CONF_FILE_NAME)));
        Views views = viewinfo.getViews();
        oldHeader = viewinfo.getHeader();
        List viewsList = views.getViewCollection();
        m_views = new HashMap();
        for (View curView : viewsList) {
            m_views.put(curView.getName(), curView);
        }
        initialized = true;
    }

    public synchronized void saveView(String name, View details) throws Exception {
        if (name == null || details == null) {
            throw new Exception("UserFactory:saveUser  null");
        }
        m_views.put(name, details);
        Views views = new Views();
        Collection<View> viewList = m_views.values();
        views.setView(new ArrayList<View>(viewList));
        this.saveViews(views);
    }

    public synchronized void deleteUser(String name) throws Exception {
        HashMap<String, View> map;
        if (name != null) {
            Set<String> viewKeys = m_views.keySet();
            map = new HashMap<String, View>();
            Iterator<String> iter = viewKeys.iterator();
            while (iter.hasNext()) {
                View view;
                View newView = new View();
                newView = view = m_views.get(iter.next());
                Membership membership = new Membership();
                Membership viewmembers = view.getMembership();
                if (viewmembers != null) {
                    for (Member member : viewmembers.getMemberCollection()) {
                        if (member.getType().equals("user")) {
                            if (member.getContent().equals(name)) continue;
                            membership.addMember(member);
                            continue;
                        }
                        membership.addMember(member);
                    }
                }
                newView.setMembership(membership);
                map.put(newView.getName(), newView);
            }
        } else {
            throw new Exception("ViewFactory:delete Invalid user name:" + name);
        }
        m_views.clear();
        Views views = new Views();
        views.setView(new ArrayList(map.values()));
        this.saveViews(views);
    }

    public synchronized void renameUser(String oldName, String newName) throws Exception {
        if (oldName == null || oldName == "") {
            throw new Exception("ViewFactory:renameUser Invalid old name");
        }
        if (newName == null || newName == "") {
            throw new Exception("ViewFactory:renameUser Invalid new name");
        }
        Collection<View> coll = m_views.values();
        Iterator<View> iter = coll.iterator();
        HashMap<String, View> map = new HashMap<String, View>();
        while (iter.hasNext()) {
            List memberColl;
            View view = iter.next();
            Membership membership = view.getMembership();
            if (membership != null && (memberColl = membership.getMemberCollection()) != null) {
                Iterator iterMember = memberColl.iterator();
                while (iterMember != null && iterMember.hasNext()) {
                    String name;
                    Member member = (Member)iterMember.next();
                    if (!member.getType().equals("user") || !(name = member.getContent()).equals(oldName)) continue;
                    member.setContent(newName);
                }
            }
            view.setMembership(membership);
            map.put(view.getName(), view);
        }
        m_views.clear();
        Views views = new Views();
        views.setView(new ArrayList(map.values()));
        this.saveViews(views);
    }

    public synchronized void renameView(String oldName, String newName) throws Exception {
        if (oldName == null || oldName == "") {
            throw new Exception("ViewFactory:rename Invalid old view name");
        }
        if (newName == null || newName == "") {
            throw new Exception("ViewFactory:rename Invalid new view name");
        }
        if (m_views.containsKey(oldName)) {
            View view = m_views.get(oldName);
            m_views.remove(oldName);
            view.setName(newName);
            m_views.put(newName, view);
        }
        Collection<View> coll = m_views.values();
        Views views = new Views();
        views.setView(new ArrayList<View>(coll));
        this.saveViews(views);
    }

    public synchronized void deleteView(String name) throws Exception {
        if (name == null || name.equals("")) {
            throw new Exception("ViewFactory:deleteView  " + name);
        }
        if (!m_views.containsKey(name)) {
            throw new Exception("ViewFactory:deleteView  View:" + name + " not found ");
        }
        m_views.remove(name);
        Views views = new Views();
        Collection<View> viewList = m_views.values();
        views.setView(new ArrayList<View>(viewList));
        this.saveViews(views);
    }

    public synchronized void saveViews(Views views) throws IOException, MarshalException, ValidationException {
        Viewinfo vinfo = new Viewinfo();
        Header header = oldHeader;
        vinfo.setViews(views);
        header.setCreated(EventConstants.formatToString((Date)new Date()));
        vinfo.setHeader(header);
        File ofile = ConfigFileConstants.getFile((int)ConfigFileConstants.VIEWS_CONF_FILE_NAME);
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)vinfo, (Writer)stringWriter);
        if (stringWriter.toString() != null) {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ofile), "UTF-8");
            fileWriter.write(stringWriter.toString());
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        m_views.clear();
        Enumeration en = views.enumerateView();
        while (en.hasMoreElements()) {
            View curView = (View)en.nextElement();
            m_views.put(curView.getName(), curView);
        }
    }

    public String getCategoryComments(String viewName, String categoryName) {
        View view = m_views.get(viewName);
        Categories categories = view.getCategories();
        List category = categories.getCategoryCollection();
        for (Category cat : category) {
            String name = cat.getLabel();
            if (name == null || !name.equals(categoryName)) continue;
            return this.stripWhiteSpace(cat.getCategoryComment());
        }
        return null;
    }

    private String stripWhiteSpace(String comment) {
        StringBuffer buffer = new StringBuffer(comment);
        try {
            RE whiteSpaceRE = new RE("[:space:]");
            for (int i = 0; i < buffer.length(); ++i) {
                int end;
                int start = i;
                boolean foundWhiteSpace = false;
                for (end = start + 1; end < buffer.length() && whiteSpaceRE.match(buffer.substring(end - 1, end)); ++end) {
                    foundWhiteSpace = true;
                }
                if (!foundWhiteSpace) continue;
                buffer.replace(start, end - 1, " ");
            }
        }
        catch (RESyntaxException e) {
            return comment;
        }
        return buffer.toString();
    }

    public View getView(String name) {
        return m_views.get(name);
    }

    public Map<String, View> getViews() {
        return m_views;
    }

    static {
        initialized = false;
    }
}

