/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.IPSorter;
import org.opennms.core.utils.IpListFromUrl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.threshd.ExcludeRange;
import org.opennms.netmgt.config.threshd.IncludeRange;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Service;
import org.opennms.netmgt.config.threshd.ThreshdConfiguration;
import org.opennms.netmgt.dao.castor.CastorUtils;
import org.opennms.netmgt.filter.FilterDaoFactory;

public abstract class ThreshdConfigManager {
    protected ThreshdConfiguration m_config;
    private Map<String, List<String>> m_urlIPMap;
    private Map<Package, List<String>> m_pkgIpMap;
    protected boolean m_verifyServer;
    protected String m_localServer;

    @Deprecated
    public ThreshdConfigManager(Reader rdr, String localServer, boolean verifyServer) throws MarshalException, ValidationException {
        this.m_config = (ThreshdConfiguration)CastorUtils.unmarshal(ThreshdConfiguration.class, (Reader)rdr);
        this.createUrlIpMap();
        this.m_verifyServer = verifyServer;
        this.m_localServer = localServer;
        this.createPackageIpListMap();
    }

    public ThreshdConfigManager(InputStream stream, String localServer, boolean verifyServer) throws MarshalException, ValidationException {
        this.m_config = (ThreshdConfiguration)CastorUtils.unmarshal(ThreshdConfiguration.class, (InputStream)stream);
        this.createUrlIpMap();
        this.m_verifyServer = verifyServer;
        this.m_localServer = localServer;
        this.createPackageIpListMap();
    }

    protected void createUrlIpMap() {
        this.m_urlIPMap = new HashMap<String, List<String>>();
        for (Package pkg : this.m_config.getPackageCollection()) {
            for (String urlname : pkg.getIncludeUrlCollection()) {
                List iplist = IpListFromUrl.parse((String)urlname);
                if (iplist.size() <= 0) continue;
                this.m_urlIPMap.put(urlname, iplist);
            }
        }
    }

    protected void createPackageIpListMap() {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        this.m_pkgIpMap = new HashMap<Package, List<String>>();
        Enumeration pkgEnum = this.m_config.enumeratePackage();
        while (pkgEnum.hasMoreElements()) {
            Package pkg = (Package)pkgEnum.nextElement();
            StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
            try {
                List ipList;
                if (this.m_verifyServer) {
                    filterRules.append(" & (serverName == ");
                    filterRules.append('\"');
                    filterRules.append(this.m_localServer);
                    filterRules.append('\"');
                    filterRules.append(")");
                }
                if (log.isDebugEnabled()) {
                    log.debug("createPackageIpMap: package is " + pkg.getName() + ". filer rules are  " + filterRules.toString());
                }
                if ((ipList = FilterDaoFactory.getInstance().getIPList(filterRules.toString())).size() <= 0) continue;
                this.m_pkgIpMap.put(pkg, ipList);
            }
            catch (Throwable t) {
                if (!log.isEnabledFor((Priority)Level.ERROR)) continue;
                log.error("createPackageIpMap: failed to map package: " + pkg.getName() + " to an IP List", t);
            }
        }
    }

    public synchronized void rebuildPackageIpListMap() {
        this.createPackageIpListMap();
    }

    public synchronized void saveCurrent() throws MarshalException, IOException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_config, (Writer)stringWriter);
        String xmlString = stringWriter.toString();
        if (xmlString != null) {
            this.saveXML(xmlString);
        }
        this.reloadXML();
    }

    public abstract void reloadXML() throws IOException, MarshalException, ValidationException;

    protected abstract void saveXML(String var1) throws IOException;

    public synchronized ThreshdConfiguration getConfiguration() {
        return this.m_config;
    }

    public synchronized Package getPackage(String name) {
        for (Package thisPackage : this.m_config.getPackageCollection()) {
            if (!thisPackage.getName().equals(name)) continue;
            return thisPackage;
        }
        return null;
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    public synchronized boolean interfaceInPackage(String iface, Package pkg) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        boolean filterPassed = false;
        List<String> ipList = this.m_pkgIpMap.get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(iface);
        }
        if (log.isDebugEnabled()) {
            log.debug("interfaceInPackage: Interface " + iface + " passed filter for package " + pkg.getName() + "?: " + filterPassed);
        }
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRangeCount() == 0 && pkg.getSpecificCount() == 0;
        long addr = IPSorter.convertToLong((String)iface);
        Enumeration eincs = pkg.enumerateIncludeRange();
        while (!has_range_include && eincs.hasMoreElements()) {
            IncludeRange rng = (IncludeRange)eincs.nextElement();
            long start = IPSorter.convertToLong((String)rng.getBegin());
            if (addr > start) {
                long end = IPSorter.convertToLong((String)rng.getEnd());
                if (addr > end) continue;
                has_range_include = true;
                continue;
            }
            if (addr != start) continue;
            has_range_include = true;
        }
        Enumeration espec = pkg.enumerateSpecific();
        while (!has_specific && espec.hasMoreElements()) {
            long speca = IPSorter.convertToLong((String)((String)espec.nextElement()));
            if (speca != addr) continue;
            has_specific = true;
        }
        Enumeration eurl = pkg.enumerateIncludeUrl();
        while (!has_specific && eurl.hasMoreElements()) {
            has_specific = this.interfaceInUrl(iface, (String)eurl.nextElement());
        }
        Enumeration eex = pkg.enumerateExcludeRange();
        while (!has_range_exclude && !has_specific && eex.hasMoreElements()) {
            ExcludeRange rng = (ExcludeRange)eex.nextElement();
            long start = IPSorter.convertToLong((String)rng.getBegin());
            if (addr > start) {
                long end = IPSorter.convertToLong((String)rng.getEnd());
                if (addr > end) continue;
                has_range_exclude = true;
                continue;
            }
            if (addr != start) continue;
            has_range_exclude = true;
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    public synchronized boolean serviceInPackageAndEnabled(String svcName, Package pkg) {
        boolean result = false;
        for (Service tsvc : pkg.getServiceCollection()) {
            String status;
            if (!tsvc.getName().equalsIgnoreCase(svcName) || !(status = tsvc.getStatus()).equals("on")) continue;
            result = true;
            break;
        }
        return result;
    }
}

