/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionAttribute;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.AttributeGroup;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionAttribute;
import org.opennms.netmgt.collectd.CollectionAttributeType;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.Persister;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.HttpCollectionConfigFactory;
import org.opennms.netmgt.config.httpdatacollection.Attrib;
import org.opennms.netmgt.config.httpdatacollection.HttpCollection;
import org.opennms.netmgt.config.httpdatacollection.Parameter;
import org.opennms.netmgt.config.httpdatacollection.Uri;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.model.events.EventProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpCollector
implements ServiceCollector {
    private static final int DEFAULT_RETRY_COUNT = 2;
    private static final String DEFAULT_SO_TIMEOUT = "3000";
    private final HashMap<Integer, String> m_scheduledNodes = new HashMap();
    private NumberFormat parser = NumberFormat.getNumberInstance();
    private NumberFormat rrdFormatter = null;

    public HttpCollector() {
        ((DecimalFormat)this.parser).setParseBigDecimal(true);
        this.rrdFormatter = NumberFormat.getNumberInstance();
        this.rrdFormatter.setMinimumFractionDigits(0);
        this.rrdFormatter.setMaximumFractionDigits(Integer.MAX_VALUE);
        this.rrdFormatter.setMinimumIntegerDigits(1);
        this.rrdFormatter.setMaximumIntegerDigits(Integer.MAX_VALUE);
        this.rrdFormatter.setGroupingUsed(false);
    }

    @Override
    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, String> parameters) {
        HttpCollectionSet collectionSet = new HttpCollectionSet(agent, parameters);
        collectionSet.collect();
        return collectionSet;
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCollection(HttpCollectionSet collectionSet, HttpCollectionResource collectionResource) throws HttpCollectorException {
        HttpClient client = null;
        HttpMethod method = null;
        try {
            try {
                client = new HttpClient(this.buildParams(collectionSet));
                method = this.buildHttpMethod(collectionSet);
                this.buildCredentials(collectionSet, client, method);
                this.log().info("doCollection: collecting for client: " + client + " using method: " + method);
                client.executeMethod(method);
                this.persistResponse(collectionSet, collectionResource, client, method);
            }
            catch (URIException e) {
                throw new HttpCollectorException("Error building HttpClient URI", client);
            }
            catch (HttpException e) {
                throw new HttpCollectorException("Error building HttpMethod", client);
            }
            catch (IOException e) {
                throw new HttpCollectorException("IO Error retrieving page", client);
            }
            Object var7_5 = null;
            if (method == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (method == null) throw throwable;
            method.releaseConnection();
            throw throwable;
        }
        method.releaseConnection();
    }

    private List<HttpCollectionAttribute> processResponse(String responseBodyAsString, HttpCollectionSet collectionSet, HttpCollectionResource collectionResource) {
        this.log().debug("processResponse:");
        this.log().debug("responseBody = " + responseBodyAsString);
        this.log().debug("getmatches = " + collectionSet.getUriDef().getUrl().getMatches());
        LinkedList<HttpCollectionAttribute> butes = new LinkedList<HttpCollectionAttribute>();
        int flags = 0;
        if (collectionSet.getUriDef().getUrl().getCanonicalEquivalence()) {
            flags |= 0x80;
        }
        if (collectionSet.getUriDef().getUrl().getCaseInsensitive()) {
            flags |= 2;
        }
        if (collectionSet.getUriDef().getUrl().getComments()) {
            flags |= 4;
        }
        if (collectionSet.getUriDef().getUrl().getDotall()) {
            flags |= 0x20;
        }
        if (collectionSet.getUriDef().getUrl().getLiteral()) {
            flags |= 0x10;
        }
        if (collectionSet.getUriDef().getUrl().getMultiline()) {
            flags |= 8;
        }
        if (collectionSet.getUriDef().getUrl().getUnicodeCase()) {
            flags |= 0x40;
        }
        if (collectionSet.getUriDef().getUrl().getUnixLines()) {
            flags |= 1;
        }
        this.log().debug("flags = " + flags);
        Pattern p = Pattern.compile(collectionSet.getUriDef().getUrl().getMatches(), flags);
        Matcher m = p.matcher(responseBodyAsString);
        boolean matches = m.matches();
        if (matches) {
            this.log().debug("processResponse: found matching attributes: " + matches);
            List attribDefs = collectionSet.getUriDef().getAttributes().getAttribCollection();
            AttributeGroupType groupType = new AttributeGroupType(collectionSet.getUriDef().getName(), "all");
            for (Attrib attribDef : attribDefs) {
                if (!attribDef.getType().matches("^([Oo](ctet|CTET)[Ss](tring|TRING))|([Ss](tring|TRING))$")) {
                    try {
                        Number num = NumberFormat.getNumberInstance().parse(m.group(attribDef.getMatchGroup()));
                        HttpCollectionAttribute bute = new HttpCollectionAttribute(collectionResource, new HttpCollectionAttributeType(attribDef, groupType), attribDef.getAlias(), attribDef.getType(), num);
                        this.log().debug("processResponse: adding found numeric attribute: " + bute);
                        butes.add(bute);
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.log().error("IndexOutOfBoundsException thrown while trying to find regex group, your regex does not contain the following group index: " + attribDef.getMatchGroup());
                        this.log().error("Regex statement: " + collectionSet.getUriDef().getUrl().getMatches());
                    }
                    catch (ParseException e) {
                        this.log().error("attribute " + attribDef.getAlias() + " failed to match a parsable number! Matched \"" + m.group(attribDef.getMatchGroup()) + "\" instead.");
                    }
                    continue;
                }
                HttpCollectionAttribute bute = new HttpCollectionAttribute(collectionResource, new HttpCollectionAttributeType(attribDef, groupType), attribDef.getAlias(), attribDef.getType(), m.group(attribDef.getMatchGroup()));
                this.log().debug("processResponse: adding found string attribute: " + bute);
                butes.add(bute);
            }
        } else {
            this.log().debug("processResponse: found matching attributes: " + matches);
        }
        return butes;
    }

    private void persistResponse(HttpCollectionSet collectionSet, HttpCollectionResource collectionResource, HttpClient client, HttpMethod method) throws IOException {
        List<HttpCollectionAttribute> butes = this.processResponse(method.getResponseBodyAsString(), collectionSet, collectionResource);
        if (butes.isEmpty()) {
            String url = client.getHostConfiguration() == null ? "null" : client.getHostConfiguration().getHostURL();
            this.log().warn("doCollection: no attributes defined for the response from: " + url + " were found that match the expression: '" + collectionSet.getUriDef().getUrl().getMatches() + "'");
            throw new HttpCollectorException("No attributes specified were found: ", client);
        }
        collectionSet.storeResults(butes, collectionResource);
    }

    private void buildCredentials(HttpCollectionSet collectionSet, HttpClient client, HttpMethod method) {
        String userInfo;
        String[] streetCred;
        if (collectionSet.getUriDef().getUrl().getUserInfo() != null && (streetCred = (userInfo = collectionSet.getUriDef().getUrl().getUserInfo()).split(":", 2)).length == 2) {
            client.getState().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)new UsernamePasswordCredentials(streetCred[0], streetCred[1]));
            method.setDoAuthentication(true);
        }
    }

    private HttpClientParams buildParams(HttpCollectionSet collectionSet) {
        HttpClientParams params = new HttpClientParams(DefaultHttpParams.getDefaultParams());
        params.setVersion(this.computeVersion(collectionSet.getUriDef()));
        params.setSoTimeout(Integer.parseInt(ParameterMap.getKeyedString(collectionSet.getParameters(), (String)"timeout", (String)DEFAULT_SO_TIMEOUT)));
        params.setVirtualHost(collectionSet.getUriDef().getUrl().getVirtualHost());
        String key = "retry";
        if (collectionSet.getParameters().containsKey("retries")) {
            key = "retries";
        }
        Integer retryCount = ParameterMap.getKeyedInteger(collectionSet.getParameters(), (String)key, (int)2);
        params.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(retryCount.intValue(), false));
        params.setParameter("http.useragent", (Object)this.determineUserAgent(collectionSet, params));
        return params;
    }

    private String determineUserAgent(HttpCollectionSet collectionSet, HttpClientParams params) {
        String userAgent = collectionSet.getUriDef().getUrl().getUserAgent();
        return userAgent == null ? params.getParameter("http.useragent") : userAgent;
    }

    private HttpVersion computeVersion(Uri uri) {
        return new HttpVersion(Integer.parseInt(uri.getUrl().getHttpVersion().substring(0, 1)), Integer.parseInt(uri.getUrl().getHttpVersion().substring(2)));
    }

    private HttpMethod buildHttpMethod(HttpCollectionSet collectionSet) throws URIException {
        Object method = "GET".equals(collectionSet.getUriDef().getUrl().getMethod()) ? this.buildGetMethod(collectionSet) : this.buildPostMethod(collectionSet);
        method.setURI(this.buildUri(collectionSet));
        return method;
    }

    private PostMethod buildPostMethod(HttpCollectionSet collectionSet) {
        PostMethod method = new PostMethod();
        NameValuePair[] postParams = this.buildRequestParameters(collectionSet);
        if (postParams.length > 0) {
            method.setRequestBody(postParams);
        }
        return method;
    }

    private GetMethod buildGetMethod(HttpCollectionSet collectionSet) {
        GetMethod method = new GetMethod();
        NameValuePair[] queryParams = this.buildRequestParameters(collectionSet);
        if (queryParams.length > 0) {
            method.setQueryString(queryParams);
        }
        return method;
    }

    private NameValuePair[] buildRequestParameters(HttpCollectionSet collectionSet) {
        NameValuePair[] nvpArray = new NameValuePair[]{};
        ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
        if (collectionSet.getUriDef().getUrl().getParameters() == null) {
            return nvpArray;
        }
        List parameters = collectionSet.getUriDef().getUrl().getParameters().getParameterCollection();
        if (parameters.size() > 0) {
            nvps = new ArrayList();
            for (Parameter p : parameters) {
                nvps.add(new NameValuePair(p.getKey(), p.getValue()));
            }
        }
        return nvps.toArray(nvpArray);
    }

    private URI buildUri(HttpCollectionSet collectionSet) throws URIException {
        HashMap<String, String> substitutions = new HashMap<String, String>();
        substitutions.put("ipaddr", collectionSet.getAgent().getInetAddress().getHostAddress());
        substitutions.put("nodeid", Integer.toString(collectionSet.getAgent().getNodeId()));
        return new URI(collectionSet.getUriDef().getUrl().getScheme(), collectionSet.getUriDef().getUrl().getUserInfo(), this.substituteKeywords(substitutions, collectionSet.getUriDef().getUrl().getHost(), "getHost"), collectionSet.getUriDef().getUrl().getPort(), this.substituteKeywords(substitutions, collectionSet.getUriDef().getUrl().getPath(), "getURL"), this.substituteKeywords(substitutions, collectionSet.getUriDef().getUrl().getQuery(), "getQuery"), this.substituteKeywords(substitutions, collectionSet.getUriDef().getUrl().getFragment(), "getFragment"));
    }

    private String substituteKeywords(HashMap<String, String> substitutions, String urlFragment, String desc) {
        String newFragment = urlFragment;
        if (newFragment != null) {
            for (String key : substitutions.keySet()) {
                newFragment = newFragment.replaceAll("\\$\\{" + key + "\\}", substitutions.get(key));
            }
            if (this.log().isDebugEnabled() && newFragment.compareTo(urlFragment) != 0) {
                this.log().debug("doSubs: " + desc + " substituted as \"" + newFragment + "\"");
            }
        }
        return newFragment;
    }

    @Override
    public void initialize(Map<String, String> parameters) {
        this.log().debug("initialize: Initializing HttpCollector.");
        this.m_scheduledNodes.clear();
        this.initHttpCollecionConfig();
        this.initDatabaseConnectionFactory();
        this.initializeRrdRepository();
    }

    private void initHttpCollecionConfig() {
        try {
            this.log().debug("initialize: Initializing collector: " + this.getClass());
            HttpCollectionConfigFactory.init();
        }
        catch (MarshalException e) {
            this.log().fatal("initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal("initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (FileNotFoundException e) {
            this.log().fatal("initialize: Error locating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            this.log().fatal("initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initializeRrdRepository() {
        this.log().debug("initializeRrdRepository: Initializing RRD repo from HttpCollector...");
        this.initializeRrdDirs();
    }

    private void initializeRrdDirs() {
        File f = new File(HttpCollectionConfigFactory.getInstance().getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            StringBuffer sb = new StringBuffer();
            sb.append("initializeRrdDirs: Unable to create RRD file repository.  Path doesn't already exist and could not make directory: ");
            sb.append(HttpCollectionConfigFactory.getInstance().getRrdPath());
            this.log().error(sb.toString());
            throw new RuntimeException(sb.toString());
        }
    }

    private void initDatabaseConnectionFactory() {
        try {
            DataSourceFactory.init();
        }
        catch (IOException e) {
            this.log().fatal("initDatabaseConnectionFactory: IOException getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (MarshalException e) {
            this.log().fatal("initDatabaseConnectionFactory: Marshall Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal("initDatabaseConnectionFactory: Validation Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            this.log().fatal("initDatabaseConnectionFactory: Failed loading database driver.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void initialize(CollectionAgent agent, Map<String, String> parameters) {
        this.log().debug("initialize: Initializing HTTP collection for agent: " + agent);
        Integer scheduledNodeKey = new Integer(agent.getNodeId());
        String scheduledAddress = this.m_scheduledNodes.get(scheduledNodeKey);
        if (scheduledAddress != null) {
            this.log().info("initialize: Not scheduling interface for collection: " + scheduledAddress);
            StringBuffer sb = new StringBuffer();
            sb.append("initialize service: ");
            sb.append(this.determineServiceName(parameters));
            sb.append(" for address: ");
            sb.append(scheduledAddress);
            sb.append(" already scheduled for collection on node: ");
            sb.append(agent);
            this.log().debug(sb.toString());
            throw new IllegalStateException(sb.toString());
        }
        this.log().info("initialize: Scheduling interface for collection: " + scheduledAddress);
        this.m_scheduledNodes.put(scheduledNodeKey, scheduledAddress);
    }

    private String determineServiceName(Map<String, String> parameters) {
        return ParameterMap.getKeyedString(parameters, (String)"service-name", (String)"HTTP");
    }

    @Override
    public void release() {
    }

    @Override
    public void release(CollectionAgent agent) {
    }

    @Override
    public RrdRepository getRrdRepository(String collectionName) {
        return HttpCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }

    class HttpCollectionAttributeType
    implements CollectionAttributeType {
        Attrib m_attribute;
        AttributeGroupType m_groupType;

        protected HttpCollectionAttributeType(Attrib attribute, AttributeGroupType groupType) {
            this.m_groupType = groupType;
            this.m_attribute = attribute;
        }

        public AttributeGroupType getGroupType() {
            return this.m_groupType;
        }

        public void storeAttribute(CollectionAttribute attribute, Persister persister) {
            if (this.m_attribute.getType().equals("string")) {
                persister.persistStringAttribute(attribute);
            } else {
                persister.persistNumericAttribute(attribute);
            }
        }

        public String getName() {
            return this.m_attribute.getAlias();
        }

        public String getType() {
            return this.m_attribute.getType();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HttpCollectionResource
    implements CollectionResource {
        CollectionAgent m_agent;
        AttributeGroup m_attribGroup;

        HttpCollectionResource(CollectionAgent agent, Uri uriDef) {
            this.m_agent = agent;
            this.m_attribGroup = new AttributeGroup(this, new AttributeGroupType(uriDef.getName(), "all"));
        }

        public void storeResults(List<HttpCollectionAttribute> results) {
            for (HttpCollectionAttribute attrib : results) {
                this.m_attribGroup.addAttribute(attrib);
            }
        }

        @Override
        public boolean rescanNeeded() {
            return false;
        }

        @Override
        public boolean shouldPersist(ServiceParameters params) {
            return true;
        }

        @Override
        public String getOwnerName() {
            return this.m_agent.getHostAddress();
        }

        @Override
        public File getResourceDir(RrdRepository repository) {
            return new File(repository.getRrdBaseDir(), Integer.toString(this.m_agent.getNodeId()));
        }

        @Override
        public void visit(CollectionSetVisitor visitor) {
            visitor.visitResource(this);
            this.m_attribGroup.visit(visitor);
            visitor.completeResource(this);
        }

        @Override
        public int getType() {
            return -1;
        }

        @Override
        public String getResourceTypeName() {
            return "node";
        }

        @Override
        public String getInstance() {
            return null;
        }

        @Override
        public String getLabel() {
            return null;
        }
    }

    public class HttpCollectorException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        HttpClient m_client;

        HttpCollectorException(String message, HttpClient client) {
            super(message);
            this.m_client = client;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(super.toString());
            buffer.append(": client URL: ");
            HostConfiguration hostConfiguration = this.m_client.getHostConfiguration();
            if (hostConfiguration != null) {
                buffer.append(hostConfiguration.getHostURL() == null ? "null" : hostConfiguration.getHostURL());
            }
            return buffer.toString();
        }
    }

    class HttpCollectionAttribute
    extends AbstractCollectionAttribute
    implements AttributeDefinition {
        String m_alias;
        String m_type;
        Object m_value;
        HttpCollectionResource m_resource;
        HttpCollectionAttributeType m_attribType;

        HttpCollectionAttribute(HttpCollectionResource resource, HttpCollectionAttributeType attribType, String alias, String type, Number value) {
            this.m_resource = resource;
            this.m_attribType = attribType;
            this.m_alias = alias;
            this.m_type = type;
            this.m_value = value;
        }

        HttpCollectionAttribute(HttpCollectionResource resource, HttpCollectionAttributeType attribType, String alias, String type, String value) {
            this.m_resource = resource;
            this.m_attribType = attribType;
            this.m_alias = alias;
            this.m_type = type;
            this.m_value = value;
        }

        public String getName() {
            return this.m_alias;
        }

        public String getType() {
            return this.m_type;
        }

        public Object getValue() {
            return this.m_value;
        }

        public String getNumericValue() {
            Object val = this.getValue();
            if (val instanceof Number) {
                return val.toString();
            }
            try {
                return Double.valueOf(val.toString()).toString();
            }
            catch (NumberFormatException numberFormatException) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("Value for attribute " + this + " does not appear to be a number, skipping");
                }
                return null;
            }
        }

        public String getStringValue() {
            return this.getValue().toString();
        }

        public String getValueAsString() {
            if (this.m_value instanceof Number) {
                return HttpCollector.this.rrdFormatter.format(this.m_value);
            }
            return this.m_value.toString();
        }

        public boolean equals(Object obj) {
            if (obj instanceof HttpCollectionAttribute) {
                HttpCollectionAttribute other = (HttpCollectionAttribute)obj;
                return this.getName().equals(other.getName());
            }
            return false;
        }

        public CollectionAttributeType getAttributeType() {
            return this.m_attribType;
        }

        public CollectionResource getResource() {
            return this.m_resource;
        }

        public boolean shouldPersist(ServiceParameters params) {
            return true;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("HttpAttribute: ");
            buffer.append(this.getName());
            buffer.append(":");
            buffer.append(this.getType());
            buffer.append(":");
            buffer.append(this.getValueAsString());
            return buffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HttpCollectionSet
    implements CollectionSet {
        private CollectionAgent m_agent;
        private Map<String, String> m_parameters;
        private Uri m_uriDef;
        private int m_status;
        private List<HttpCollectionResource> m_collectionResourceList;

        public Uri getUriDef() {
            return this.m_uriDef;
        }

        public void setUriDef(Uri uriDef) {
            this.m_uriDef = uriDef;
        }

        HttpCollectionSet(CollectionAgent agent, Map<String, String> parameters) {
            this.m_agent = agent;
            this.m_parameters = parameters;
            this.m_status = 2;
        }

        public void collect() {
            String collectionName = this.m_parameters.get("collection");
            if (collectionName == null) {
                collectionName = this.m_parameters.get("http-collection");
            }
            HttpCollection collection = HttpCollectionConfigFactory.getInstance().getHttpCollection(collectionName);
            this.m_collectionResourceList = new ArrayList<HttpCollectionResource>();
            List uriDefs = collection.getUris().getUriCollection();
            Iterator i$ = uriDefs.iterator();
            while (i$.hasNext()) {
                Uri uriDef;
                this.m_uriDef = uriDef = (Uri)i$.next();
                HttpCollectionResource collectionResource = new HttpCollectionResource(this.m_agent, uriDef);
                try {
                    HttpCollector.this.doCollection(this, collectionResource);
                    this.m_collectionResourceList.add(collectionResource);
                }
                catch (HttpCollectorException e) {
                    HttpCollector.this.log().error("collect: http collection failed: " + e, (Throwable)e);
                    this.m_status = 2;
                }
            }
            this.m_status = 1;
        }

        public CollectionAgent getAgent() {
            return this.m_agent;
        }

        public void setAgent(CollectionAgent agent) {
            this.m_agent = agent;
        }

        public Map<String, String> getParameters() {
            return this.m_parameters;
        }

        public void setParameters(Map<String, String> parameters) {
            this.m_parameters = parameters;
        }

        @Override
        public int getStatus() {
            return this.m_status;
        }

        public void storeResults(List<HttpCollectionAttribute> results, HttpCollectionResource collectionResource) {
            collectionResource.storeResults(results);
        }

        @Override
        public void visit(CollectionSetVisitor visitor) {
            visitor.visitCollectionSet(this);
            for (HttpCollectionResource collectionResource : this.m_collectionResourceList) {
                collectionResource.visit(visitor);
            }
            visitor.completeCollectionSet(this);
        }

        @Override
        public boolean ignorePersist() {
            return false;
        }
    }
}

