/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SmtpPlugin
extends AbstractPlugin {
    private static final RE MULTILINE_RESULT;
    private static final String PROTOCOL_NAME = "SMTP";
    private static final int DEFAULT_PORT = 25;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static String LOCALHOST_NAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServer(InetAddress host, int port, int retries, int timeout) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        boolean isAServer = false;
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(host, port), timeout);
                socket.setSoTimeout(timeout);
                log.debug("SmtpPlugin: connected to host: " + host + " on port: " + port);
                BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String result = null;
                while ((result = lineRdr.readLine()) != null && result.length() > 0 && MULTILINE_RESULT.match(result)) {
                }
                if (result == null || result.length() == 0) {
                    log.info("Received truncated response from SMTP server " + host.getHostAddress());
                    continue;
                }
                StringTokenizer t = new StringTokenizer(result);
                int rc = Integer.parseInt(t.nextToken());
                if (rc != 220) continue;
                String cmd = "HELO " + LOCALHOST_NAME + "\r\n";
                socket.getOutputStream().write(cmd.getBytes());
                while ((result = lineRdr.readLine()) != null && result.length() > 0 && MULTILINE_RESULT.match(result)) {
                }
                if (result == null || result.length() == 0) {
                    log.info("Received truncated response from SMTP server " + host.getHostAddress());
                    continue;
                }
                t = new StringTokenizer(result);
                rc = Integer.parseInt(t.nextToken());
                if (rc != 250) continue;
                cmd = "QUIT\r\n";
                socket.getOutputStream().write(cmd.getBytes());
                while ((result = lineRdr.readLine()) != null && result.length() > 0 && MULTILINE_RESULT.match(result)) {
                }
                if (result == null || result.length() == 0) {
                    log.info("Received truncated response from SMTP server " + host.getHostAddress());
                    continue;
                }
                t = new StringTokenizer(result);
                rc = Integer.parseInt(t.nextToken());
                if (rc != 221) continue;
                isAServer = true;
                continue;
            }
            catch (NumberFormatException e) {
                log.info("SmtpPlugin: received invalid result code from server " + host.getHostAddress(), (Throwable)e);
                isAServer = false;
                continue;
            }
            catch (ConnectException cE) {
                log.debug("SmtpPlugin: connection refused to " + host.getHostAddress() + ":" + port);
                isAServer = false;
                continue;
            }
            catch (NoRouteToHostException e) {
                e.fillInStackTrace();
                log.info("SmtpPlugin: Unable to test host " + host.getHostAddress() + ", no route available", (Throwable)e);
                isAServer = false;
                throw new UndeclaredThrowableException(e);
            }
            catch (InterruptedIOException e) {
                log.debug("SmtpPlugin: did not connect to host within timeout: " + timeout + " attempt: " + attempts);
                isAServer = false;
                continue;
            }
            catch (IOException e) {
                log.info("SmtpPlugin: Error communicating with host " + host.getHostAddress(), (Throwable)e);
                isAServer = false;
                continue;
            }
            catch (Throwable t) {
                log.warn("SmtpPlugin: Undeclared throwable exception caught contacting host " + host.getHostAddress(), t);
                isAServer = false;
                continue;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        return isAServer;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress address) {
        return this.isServer(address, 25, 0, 5000);
    }

    @Override
    public boolean isProtocolSupported(InetAddress address, Map<String, Object> qualifiers) {
        boolean result;
        int retries = 0;
        int timeout = 5000;
        int port = 25;
        if (qualifiers != null) {
            retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)5000);
            port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)25);
        }
        if ((result = this.isServer(address, port, retries, timeout)) && qualifiers != null && !qualifiers.containsKey("port")) {
            qualifiers.put("port", new Integer(port));
        }
        return result;
    }

    static {
        try {
            LOCALHOST_NAME = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhE) {
            ThreadCategory.getInstance(SmtpPlugin.class).error("Failed to resolve localhost name, using localhost");
            LOCALHOST_NAME = "localhost";
        }
        try {
            MULTILINE_RESULT = new RE("^[1-5][0-9]{2}-");
        }
        catch (RESyntaxException re) {
            throw new UndeclaredThrowableException(re);
        }
    }
}

