/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.plugins.SnmpPlugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BgpSessionPlugin
extends SnmpPlugin {
    private static final String PROTOCOL_NAME = "BGP_Session";
    private static final String BGP_PEER_STATE_OID = ".1.3.6.1.2.1.15.3.1.2";
    private static final String BGP_PEER_ADMIN_STATE_OID = ".1.3.6.1.2.1.15.3.1.3";

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public boolean isProtocolSupported(InetAddress ipaddr, Map<String, Object> qualifiers) {
        try {
            String bgpPeerIp = ParameterMap.getKeyedString(qualifiers, (String)"bgpPeerIp", null);
            if (bgpPeerIp == null) {
                BgpSessionPlugin.log().warn("poll: No BGP-Peer IP Defined! ");
                return false;
            }
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
            if (agentConfig == null) {
                throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
            }
            if (qualifiers != null) {
                SnmpObjId bgpPeerAdminStateSnmpObject;
                SnmpValue bgpPeerAdminState;
                if (qualifiers.get("port") != null) {
                    int port = ParameterMap.getKeyedInteger(qualifiers, (String)"port", (int)agentConfig.getPort());
                    agentConfig.setPort(port);
                }
                if (qualifiers.get("timeout") != null) {
                    int timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)agentConfig.getTimeout());
                    agentConfig.setTimeout(timeout);
                }
                if (qualifiers.get("retry") != null) {
                    int retry = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)agentConfig.getRetries());
                    agentConfig.setRetries(retry);
                }
                if (qualifiers.get("force version") != null) {
                    String version = (String)qualifiers.get("force version");
                    if (version.equalsIgnoreCase("snmpv1")) {
                        agentConfig.setVersion(1);
                    } else if (version.equalsIgnoreCase("snmpv2") || version.equalsIgnoreCase("snmpv2c")) {
                        agentConfig.setVersion(2);
                    } else if (version.equalsIgnoreCase("snmpv3")) {
                        agentConfig.setVersion(3);
                    }
                }
                if ((bgpPeerAdminState = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)(bgpPeerAdminStateSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.3." + bgpPeerIp))))) == null) {
                    BgpSessionPlugin.log().warn("Cannot receive bgpAdminState");
                    return false;
                }
                if (BgpSessionPlugin.log().isDebugEnabled()) {
                    BgpSessionPlugin.log().debug("poll: bgpPeerAdminState: " + bgpPeerAdminState);
                }
                if (Integer.parseInt(bgpPeerAdminState.toString()) != BGP_PEER_ADMIN_STATE.START.value()) {
                    return false;
                }
                SnmpObjId bgpPeerStateSnmpObject = SnmpObjId.get((String)(".1.3.6.1.2.1.15.3.1.2." + bgpPeerIp));
                SnmpValue bgpPeerState = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)bgpPeerStateSnmpObject);
                if (bgpPeerState == null) {
                    BgpSessionPlugin.log().warn("No BGP peer state received!");
                    return false;
                }
                if (BgpSessionPlugin.log().isDebugEnabled()) {
                    BgpSessionPlugin.log().debug("poll: bgpPeerState: " + bgpPeerState);
                }
                if (Integer.parseInt(bgpPeerState.toString()) >= BGP_PEER_STATE.IDLE.value() && Integer.parseInt(bgpPeerState.toString()) <= BGP_PEER_STATE.ESTABLISHED.value()) {
                    if (BgpSessionPlugin.log().isDebugEnabled()) {
                        BgpSessionPlugin.log().debug("poll: bgpPeerState: " + bgpPeerState + " is valid, protocol supported.");
                    }
                    return true;
                }
            }
        }
        catch (NullPointerException e) {
            BgpSessionPlugin.log().warn("SNMP not available or RFC1269-MIB not supported!");
        }
        catch (NumberFormatException e) {
            BgpSessionPlugin.log().warn("Number operator used on a non-number " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            BgpSessionPlugin.log().warn("Invalid Snmp Criteria: " + e.getMessage());
        }
        catch (Throwable t) {
            BgpSessionPlugin.log().warn("Unexpected exception during SNMP poll of interface " + ipaddr, t);
        }
        return false;
    }

    public static ThreadCategory log() {
        return ThreadCategory.getInstance(BgpSessionPlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BGP_PEER_ADMIN_STATE {
        STOP(1),
        START(2);

        private final int state;

        private BGP_PEER_ADMIN_STATE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BGP_PEER_STATE {
        IDLE(1),
        CONNECT(2),
        ACTIVE(3),
        OPEN_SENT(4),
        OPEN_CONFIRM(5),
        ESTABLISHED(6);

        private final int state;

        private BGP_PEER_STATE(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }
}

