/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionConfig {
    InetAddress m_inetAddress;
    Map<String, Object> m_qualifiers;
    int m_port;
    int m_timeout;
    int m_retry;

    public ConnectionConfig(InetAddress inetAddress, Map<String, Object> qualifiers, int port, int timeout, int retry) {
        this.m_inetAddress = inetAddress;
        this.m_qualifiers = qualifiers;
        this.m_port = port;
        this.m_timeout = timeout;
        this.m_retry = retry;
    }

    public ConnectionConfig(InetAddress address, int port) {
        this.m_inetAddress = address;
        this.m_port = port;
    }

    public ConnectionConfig(InetAddress inetAddress, int port, int timeout, int retry) {
        this(inetAddress, null, port, timeout, retry);
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public void setQualifiers(Map<String, Object> qualifiers) {
        this.m_qualifiers = qualifiers;
    }

    public InetAddress getInetAddress() {
        return this.m_inetAddress;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.m_inetAddress = inetAddress;
    }

    public int getKeyedInteger(String key, int defaultVal) {
        if (this.m_qualifiers == null) {
            return defaultVal;
        }
        return ParameterMap.getKeyedInteger(this.m_qualifiers, (String)key, (int)defaultVal);
    }

    public boolean getKeyedBoolean(String key, boolean defaultVal) {
        if (this.m_qualifiers == null) {
            return defaultVal;
        }
        return ParameterMap.getKeyedBoolean(this.m_qualifiers, (String)key, (boolean)defaultVal);
    }

    public String getKeyedString(String key, String defaultVal) {
        if (this.m_qualifiers == null) {
            return defaultVal;
        }
        return ParameterMap.getKeyedString(this.m_qualifiers, (String)key, (String)defaultVal);
    }

    public void saveKeyedInteger(String key, int value) {
        if (this.m_qualifiers != null && !this.m_qualifiers.containsKey(key)) {
            this.m_qualifiers.put(key, new Integer(value));
        }
    }

    public int getPort() {
        return this.m_port;
    }

    public int getRetry() {
        return this.m_retry;
    }

    public void setRetry(int retry) {
        this.m_retry = retry;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }
}

