/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.spring.xml;

import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.spring.xml.AspectJTestEventHandler;
import org.opennms.spring.xml.AspectJTestEventHandlerInteceptor;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

public class AspectJTest
extends AbstractDependencyInjectionSpringContextTests {
    private MockEventIpcManager m_eventIpcManager;
    private AspectJTestEventHandler m_handler;
    private AspectJTestEventHandlerInteceptor m_interceptor;

    protected String[] getConfigLocations() {
        return new String[]{"classpath:/org/opennms/spring/xml/applicationContext-testAOP.xml"};
    }

    protected void onSetUp() throws Exception {
        this.m_handler.reset();
        this.m_interceptor.reset();
    }

    public void setEventIpcManager(MockEventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public void setHandler(AspectJTestEventHandler handler) {
        this.m_handler = handler;
    }

    public void setInterceptor(AspectJTestEventHandlerInteceptor interceptor) {
        this.m_interceptor = interceptor;
    }

    public void testAOPProxying() throws Throwable {
        AspectJTest.assertEquals((int)0, (int)this.m_handler.getHandlerCallCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getPreEventCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getPostEventCount());
        this.m_handler.handleAnEvent(this.createEvent("uei.opennms.org/internal/capsd/addInterface"));
        AspectJTest.assertEquals((int)1, (int)this.m_handler.getHandlerCallCount());
        AspectJTest.assertEquals((int)1, (int)this.m_interceptor.getPreEventCount());
        AspectJTest.assertEquals((int)1, (int)this.m_interceptor.getPostEventCount());
    }

    public void testEventAdapterOnProxy() {
        AspectJTest.assertEquals((int)0, (int)this.m_handler.getHandlerCallCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getPreEventCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getPostEventCount());
        this.sendEvent("uei.opennms.org/internal/capsd/addInterface");
        AspectJTest.assertEquals((int)1, (int)this.m_handler.getHandlerCallCount());
        AspectJTest.assertEquals((int)1, (int)this.m_interceptor.getPreEventCount());
        AspectJTest.assertEquals((int)1, (int)this.m_interceptor.getPostEventCount());
    }

    public void testHandledException() {
        AspectJTest.assertEquals((int)0, (int)this.m_handler.getHandlerCallCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getPreEventCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getPostEventCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getHandledExceptionCount());
        this.m_handler.setThrownException(new RuntimeException("test exception"));
        this.sendEvent("uei.opennms.org/internal/capsd/addInterface");
        AspectJTest.assertEquals((int)1, (int)this.m_handler.getHandlerCallCount());
        AspectJTest.assertEquals((int)1, (int)this.m_interceptor.getPreEventCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getPostEventCount());
        AspectJTest.assertEquals((int)1, (int)this.m_interceptor.getHandledExceptionCount());
    }

    public void testUnhandledException() {
        AspectJTest.assertEquals((int)0, (int)this.m_handler.getHandlerCallCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getPreEventCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getPostEventCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getHandledExceptionCount());
        this.m_handler.setThrownException(new Exception("test exception"));
        this.sendEvent("uei.opennms.org/internal/capsd/addInterface");
        AspectJTest.assertEquals((int)1, (int)this.m_handler.getHandlerCallCount());
        AspectJTest.assertEquals((int)1, (int)this.m_interceptor.getPreEventCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getPostEventCount());
        AspectJTest.assertEquals((int)0, (int)this.m_interceptor.getHandledExceptionCount());
    }

    private void sendEvent(String uei) {
        this.m_eventIpcManager.sendNow(this.createEvent(uei));
    }

    private Event createEvent(String uei) {
        return new EventBuilder(uei, "Test").getEvent();
    }
}

