/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.dns;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.opennms.protocols.dns.DNSAddressRR;
import org.opennms.protocols.dns.DNSAddressRequest;

public class DNSAddressRequestTest
extends TestCase {
    private static final byte[] normalResponseBytes = new byte[]{-98, -14, -127, -128, 0, 1, 0, 1, 0, 0, 0, 0, 9, 108, 111, 99, 97, 108, 104, 111, 115, 116, 0, 0, 1, 0, 1, -64, 12, 0, 1, 0, 1, 0, 10, 0, 0, 0, 4, 127, 0, 0, 1};
    private static final byte[] servFailResponseBytes = new byte[]{94, -108, -127, -126, 0, 1, 0, 0, 0, 0, 0, 0, 6, 103, 114, 101, 103, 111, 114, 3, 99, 111, 109, 0, 0, 1, 0, 1};
    private static final byte[] nxDomainResponseBytes = new byte[]{47, 62, -127, -125, 0, 1, 0, 0, 0, 1, 0, 0, 9, 108, 111, 99, 97, 108, 104, 111, 115, 116, 0, 0, 1, 0, 1, 0, 0, 6, 0, 1, 0, 1, 63, 10, 0, 64, 1, 65, 12, 82, 79, 79, 84, 45, 83, 69, 82, 86, 69, 82, 83, 3, 78, 69, 84, 0, 5, 78, 83, 84, 76, 68, 12, 86, 69, 82, 73, 83, 73, 71, 78, 45, 71, 82, 83, 3, 67, 79, 77, 0, 119, -50, 126, -32, 0, 0, 7, 8, 0, 0, 3, -124, 0, 9, 58, -128, 0, 1, 81, -128};
    private DNSAddressRequest m_request;

    @Before
    public void setUp() throws UnknownHostException {
        String question = InetAddress.getLocalHost().getCanonicalHostName();
        this.m_request = new DNSAddressRequest(question);
    }

    @Test
    public void testNormalResponse() throws Exception {
        this.m_request.m_reqID = 40690;
        this.m_request.verifyResponse(normalResponseBytes, normalResponseBytes.length);
        this.m_request.receiveResponse(normalResponseBytes, normalResponseBytes.length);
        DNSAddressRequestTest.assertEquals((int)1, (int)this.m_request.getAnswers().size());
        DNSAddressRR answer = (DNSAddressRR)this.m_request.getAnswers().get(0);
        DNSAddressRequestTest.assertEquals((int)4, (int)answer.getAddress().length);
        DNSAddressRequestTest.assertEquals((int)127, (int)answer.getAddress()[0]);
        DNSAddressRequestTest.assertEquals((int)0, (int)answer.getAddress()[1]);
        DNSAddressRequestTest.assertEquals((int)0, (int)answer.getAddress()[2]);
        DNSAddressRequestTest.assertEquals((int)1, (int)answer.getAddress()[3]);
    }

    @Test
    public void testServerFailed() throws Exception {
        this.m_request.m_reqID = 24212;
        try {
            this.m_request.verifyResponse(servFailResponseBytes, servFailResponseBytes.length);
        }
        catch (IOException ioe) {
            DNSAddressRequestTest.assertEquals((String)"Server Failure (2)", (String)ioe.getMessage());
            return;
        }
        throw new Exception("Should have caught an IOException for ServFail!");
    }

    @Test
    public void testNxDomainPass() throws Exception {
        ArrayList<Integer> fatalCodes = new ArrayList<Integer>();
        fatalCodes.add(2);
        fatalCodes.add(3);
        this.m_request.m_reqID = 12094;
        this.m_request.setFatalResponseCodes(fatalCodes);
        try {
            this.m_request.verifyResponse(nxDomainResponseBytes, nxDomainResponseBytes.length);
        }
        catch (IOException ioe) {
            DNSAddressRequestTest.assertEquals((String)"Non-Existent Domain (3)", (String)ioe.getMessage());
            return;
        }
        throw new Exception("Should have caught an IOException for NXDomain!");
    }
}

