/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.utils.IPLike;

public class IPLikeTest {
    @Test
    public void testCountChar() {
        Assert.assertEquals((long)2L, (long)IPLike.countChar((char)'-', (String)"test-this-please"));
        Assert.assertEquals((long)3L, (long)IPLike.countChar((char)'-', (String)"test-this-please-"));
        Assert.assertEquals((long)4L, (long)IPLike.countChar((char)'-', (String)"-test-this-please-"));
    }

    @Test
    public void testMatchRange() {
        Assert.assertTrue((boolean)IPLike.matchRange((String)"192", (String)"191-193"));
        Assert.assertTrue((boolean)IPLike.matchRange((String)"192", (String)"192"));
        Assert.assertTrue((boolean)IPLike.matchRange((String)"192", (String)"192-200"));
        Assert.assertTrue((boolean)IPLike.matchRange((String)"192", (String)"1-255"));
        Assert.assertTrue((boolean)IPLike.matchRange((String)"192", (String)"*"));
        Assert.assertFalse((boolean)IPLike.matchRange((String)"192", (String)"1-9"));
    }

    @Test
    public void testMatchOctet() {
        Assert.assertTrue((boolean)IPLike.matchNumericListOrRange((String)"192", (String)"191,192,193"));
        Assert.assertFalse((boolean)IPLike.matchNumericListOrRange((String)"192", (String)"190,191,194"));
        Assert.assertTrue((boolean)IPLike.matchNumericListOrRange((String)"192", (String)"10,172,190-193"));
        Assert.assertFalse((boolean)IPLike.matchNumericListOrRange((String)"192", (String)"10,172,193-199"));
        Assert.assertTrue((boolean)IPLike.matchNumericListOrRange((String)"205", (String)"200-300,400-500"));
        Assert.assertTrue((boolean)IPLike.matchNumericListOrRange((String)"405", (String)"200-300,400-500"));
        Assert.assertFalse((boolean)IPLike.matchNumericListOrRange((String)"505", (String)"200-300,400-500"));
    }

    @Test
    public void testVerifyIpMatch() {
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"*.*.*.*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"192.*.*.*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"*.168.*.*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"*.*.0.*"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"*.*.*.1"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"*.*.*.0-7"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"192.168.0.0-7"));
        Assert.assertTrue((boolean)IPLike.matches((String)"192.168.0.1", (String)"192.166,167,168.*.0,1,5-10"));
        Assert.assertFalse((boolean)IPLike.matches((String)"192.168.0.1", (String)"10.0.0.1"));
        Assert.assertFalse((boolean)IPLike.matches((String)"192.168.0.1", (String)"*.168.*.2"));
        Assert.assertFalse((boolean)IPLike.matches((String)"192.168.0.1", (String)"10.168.0.1"));
        Assert.assertTrue((boolean)IPLike.matches((String)"10.1.1.1", (String)"10.1.1.1"));
    }
}

