/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketd;

import java.io.Serializable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.netmgt.ticketd.DefaultTicketerServiceLayer;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.test.mock.MockLogAppender;

public class DefaultTicketerServiceLayerTest
extends TestCase {
    private DefaultTicketerServiceLayer m_defaultTicketerServiceLayer;
    private EasyMockUtils m_easyMockUtils;
    private AlarmDao m_alarmDao;
    private Plugin m_ticketerPlugin;
    private OnmsAlarm m_alarm;
    private Ticket m_ticket;
    private MockEventIpcManager m_eventIpcManager;

    protected void setUp() throws Exception {
        super.setUp();
        this.m_eventIpcManager = new MockEventIpcManager();
        EventIpcManagerFactory.setIpcManager((EventIpcManager)this.m_eventIpcManager);
        MockLogAppender.setupLogging();
        this.m_defaultTicketerServiceLayer = new DefaultTicketerServiceLayer();
        this.m_easyMockUtils = new EasyMockUtils();
        this.m_alarmDao = (AlarmDao)this.m_easyMockUtils.createMock(AlarmDao.class);
        this.m_defaultTicketerServiceLayer.setAlarmDao(this.m_alarmDao);
        this.m_ticketerPlugin = (Plugin)this.m_easyMockUtils.createMock(Plugin.class);
        this.m_defaultTicketerServiceLayer.setTicketerPlugin(this.m_ticketerPlugin);
        this.m_alarm = new OnmsAlarm();
        this.m_alarm.setId(Integer.valueOf(1));
        this.m_alarm.setLogMsg("Test Logmsg");
        this.m_alarm.setDescription("Test Description");
        this.m_ticket = new Ticket();
        this.m_ticket.setId("4");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCancelTicketForAlarm() {
        EasyMock.expect((Object)this.m_alarmDao.get((Serializable)this.m_alarm.getId())).andReturn((Object)this.m_alarm);
        try {
            EasyMock.expect((Object)this.m_ticketerPlugin.get(this.m_ticket.getId())).andReturn((Object)this.m_ticket);
        }
        catch (PluginException e) {
            e.printStackTrace();
        }
        this.expectNewTicketState(Ticket.State.CANCELLED);
        this.expectNewAlarmState(TroubleTicketState.CANCELLED);
        this.m_easyMockUtils.replayAll();
        this.m_defaultTicketerServiceLayer.cancelTicketForAlarm(this.m_alarm.getId().intValue(), this.m_ticket.getId());
        this.m_easyMockUtils.verifyAll();
    }

    public void testFailedCancelTicketForAlarm() {
        EasyMock.expect((Object)this.m_alarmDao.get((Serializable)this.m_alarm.getId())).andReturn((Object)this.m_alarm);
        try {
            this.m_ticketerPlugin.get(this.m_ticket.getId());
        }
        catch (PluginException e) {
            e.printStackTrace();
        }
        EasyMock.expectLastCall().andThrow((Throwable)new PluginException("Failed Cancel"));
        this.expectNewAlarmState(TroubleTicketState.CANCEL_FAILED);
        this.m_easyMockUtils.replayAll();
        this.m_defaultTicketerServiceLayer.cancelTicketForAlarm(this.m_alarm.getId().intValue(), this.m_ticket.getId());
        this.m_easyMockUtils.verifyAll();
    }

    private void expectNewAlarmState(final TroubleTicketState state) {
        this.m_alarmDao.saveOrUpdate((Object)this.m_alarm);
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                OnmsAlarm alarm = (OnmsAlarm)EasyMock.getCurrentArguments()[0];
                Assert.assertEquals((Object)state, (Object)alarm.getTTicketState());
                return null;
            }
        });
    }

    private void expectNewTicketState(final Ticket.State state) {
        try {
            this.m_ticketerPlugin.saveOrUpdate(this.m_ticket);
        }
        catch (PluginException e) {
            e.printStackTrace();
        }
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                Ticket ticket = (Ticket)EasyMock.getCurrentArguments()[0];
                Assert.assertEquals((Object)state, (Object)ticket.getState());
                return null;
            }
        });
    }

    private void expectNewTicket() {
        try {
            this.m_ticketerPlugin.saveOrUpdate((Ticket)EasyMock.isA(Ticket.class));
        }
        catch (PluginException e) {
            e.printStackTrace();
        }
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                Ticket ticket = (Ticket)EasyMock.getCurrentArguments()[0];
                Assert.assertNull((Object)ticket.getId());
                ticket.setId("7");
                Assert.assertEquals((String)DefaultTicketerServiceLayerTest.this.m_alarm.getLogMsg(), (String)ticket.getSummary());
                Assert.assertEquals((String)DefaultTicketerServiceLayerTest.this.m_alarm.getDescription(), (String)ticket.getDetails());
                return null;
            }
        });
    }

    public void testCloseTicketForAlarm() {
        EasyMock.expect((Object)this.m_alarmDao.get((Serializable)this.m_alarm.getId())).andReturn((Object)this.m_alarm);
        try {
            EasyMock.expect((Object)this.m_ticketerPlugin.get(this.m_ticket.getId())).andReturn((Object)this.m_ticket);
        }
        catch (PluginException e) {
            e.printStackTrace();
        }
        this.expectNewTicketState(Ticket.State.CLOSED);
        this.expectNewAlarmState(TroubleTicketState.CLOSED);
        this.m_easyMockUtils.replayAll();
        this.m_defaultTicketerServiceLayer.closeTicketForAlarm(this.m_alarm.getId().intValue(), this.m_ticket.getId());
        this.m_easyMockUtils.verifyAll();
    }

    public void testFailedCloseTicketForAlarm() {
        EasyMock.expect((Object)this.m_alarmDao.get((Serializable)this.m_alarm.getId())).andReturn((Object)this.m_alarm);
        try {
            this.m_ticketerPlugin.get(this.m_ticket.getId());
        }
        catch (PluginException pluginException) {
            // empty catch block
        }
        EasyMock.expectLastCall().andThrow((Throwable)new PluginException("Failed Close"));
        this.expectNewAlarmState(TroubleTicketState.CLOSE_FAILED);
        this.m_easyMockUtils.replayAll();
        this.m_defaultTicketerServiceLayer.closeTicketForAlarm(this.m_alarm.getId().intValue(), this.m_ticket.getId());
        this.m_easyMockUtils.verifyAll();
    }

    public void testCreateTicketForAlarm() {
        EasyMock.expect((Object)this.m_alarmDao.get((Serializable)this.m_alarm.getId())).andReturn((Object)this.m_alarm);
        this.expectNewTicket();
        this.expectNewAlarmState(TroubleTicketState.OPEN);
        this.m_easyMockUtils.replayAll();
        this.m_defaultTicketerServiceLayer.createTicketForAlarm(this.m_alarm.getId().intValue());
        this.m_easyMockUtils.verifyAll();
    }

    public void testFailedCreateTicketForAlarm() {
        EasyMock.expect((Object)this.m_alarmDao.get((Serializable)this.m_alarm.getId())).andReturn((Object)this.m_alarm);
        try {
            this.m_ticketerPlugin.saveOrUpdate((Ticket)EasyMock.isA(Ticket.class));
        }
        catch (PluginException pluginException) {
            // empty catch block
        }
        EasyMock.expectLastCall().andThrow((Throwable)new PluginException("Failed Create"));
        this.expectNewAlarmState(TroubleTicketState.CREATE_FAILED);
        this.m_easyMockUtils.replayAll();
        this.m_defaultTicketerServiceLayer.createTicketForAlarm(this.m_alarm.getId().intValue());
        this.m_easyMockUtils.verifyAll();
    }

    public void testUpdateTicketForAlarm() {
        this.m_ticket.setState(Ticket.State.CANCELLED);
        EasyMock.expect((Object)this.m_alarmDao.get((Serializable)this.m_alarm.getId())).andReturn((Object)this.m_alarm);
        try {
            EasyMock.expect((Object)this.m_ticketerPlugin.get(this.m_ticket.getId())).andReturn((Object)this.m_ticket);
        }
        catch (PluginException e) {
            e.printStackTrace();
        }
        this.expectNewAlarmState(TroubleTicketState.CANCELLED);
        this.m_easyMockUtils.replayAll();
        this.m_defaultTicketerServiceLayer.updateTicketForAlarm(this.m_alarm.getId().intValue(), this.m_ticket.getId());
        this.m_easyMockUtils.verifyAll();
    }

    public void testFailedUpdateTicketForAlarm() {
        this.m_ticket.setState(Ticket.State.CANCELLED);
        EasyMock.expect((Object)this.m_alarmDao.get((Serializable)this.m_alarm.getId())).andReturn((Object)this.m_alarm);
        try {
            this.m_ticketerPlugin.get(this.m_ticket.getId());
        }
        catch (PluginException pluginException) {
            // empty catch block
        }
        EasyMock.expectLastCall().andThrow((Throwable)new PluginException("Failed Update"));
        this.expectNewAlarmState(TroubleTicketState.UPDATE_FAILED);
        this.m_easyMockUtils.replayAll();
        this.m_defaultTicketerServiceLayer.updateTicketForAlarm(this.m_alarm.getId().intValue(), this.m_ticket.getId());
        this.m_easyMockUtils.verifyAll();
    }

    private void expectUpdatedTicket() {
        try {
            this.m_ticketerPlugin.saveOrUpdate(this.m_ticket);
        }
        catch (PluginException e) {
            e.printStackTrace();
        }
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

            public Object answer() throws Throwable {
                Ticket ticket = (Ticket)EasyMock.getCurrentArguments()[0];
                Assert.assertEquals((Object)Ticket.State.OPEN, (Object)ticket.getState());
                Assert.assertEquals((String)DefaultTicketerServiceLayerTest.this.m_alarm.getDescription(), (String)ticket.getDetails());
                return null;
            }
        });
    }
}

