/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.netmgt.dao.AbstractTransactionalDaoTestCase;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.netmgt.ticketd.TicketerServiceLayer;

public class DefaultTicketerServiceLayerIntegrationTest
extends AbstractTransactionalDaoTestCase {
    private TicketerServiceLayer m_ticketerServiceLayer;
    private TestTicketerPlugin m_ticketerPlugin;

    protected void setUpConfiguration() {
        super.setUpConfiguration();
        System.setProperty("opennms.ticketer.plugin", TestTicketerPlugin.class.getName());
    }

    protected String[] getConfigLocations() {
        String[] configs = new String[]{"classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-troubleTicketer.xml", "classpath:/org/opennms/netmgt/ticketd/applicationContext-configOverride.xml"};
        ArrayList<String> configLocation = new ArrayList<String>();
        configLocation.addAll(Arrays.asList(super.getConfigLocations()));
        configLocation.addAll(Arrays.asList(configs));
        return configLocation.toArray(new String[configLocation.size()]);
    }

    public void setTicketerPlugin(TestTicketerPlugin ticketerPlugin) {
        this.m_ticketerPlugin = ticketerPlugin;
    }

    public void setTicketerServiceLayer(TicketerServiceLayer ticketerServiceLayer) {
        this.m_ticketerServiceLayer = ticketerServiceLayer;
    }

    public void testWire() {
        DefaultTicketerServiceLayerIntegrationTest.assertNotNull((Object)this.m_ticketerServiceLayer);
        DefaultTicketerServiceLayerIntegrationTest.assertNotNull((Object)this.m_ticketerPlugin);
        boolean alarmId = true;
        OnmsAlarm alarm = (OnmsAlarm)this.getAlarmDao().get((Serializable)Integer.valueOf(1));
        DefaultTicketerServiceLayerIntegrationTest.assertNull((Object)alarm.getTTicketState());
        DefaultTicketerServiceLayerIntegrationTest.assertNull((Object)alarm.getTTicketId());
        this.m_ticketerServiceLayer.createTicketForAlarm(1);
        this.getAlarmDao().flush();
        alarm = (OnmsAlarm)this.getAlarmDao().get((Serializable)Integer.valueOf(1));
        DefaultTicketerServiceLayerIntegrationTest.assertEquals((Object)TroubleTicketState.OPEN, (Object)alarm.getTTicketState());
        DefaultTicketerServiceLayerIntegrationTest.assertNotNull((Object)alarm.getTTicketId());
        DefaultTicketerServiceLayerIntegrationTest.assertEquals((String)"testId", (String)alarm.getTTicketId());
        this.m_ticketerServiceLayer.updateTicketForAlarm(alarm.getId().intValue(), alarm.getTTicketId());
        this.getAlarmDao().flush();
        alarm = (OnmsAlarm)this.getAlarmDao().get((Serializable)Integer.valueOf(1));
        DefaultTicketerServiceLayerIntegrationTest.assertEquals((Object)TroubleTicketState.OPEN, (Object)alarm.getTTicketState());
        this.m_ticketerServiceLayer.closeTicketForAlarm(1, alarm.getTTicketId());
        this.getAlarmDao().flush();
        alarm = (OnmsAlarm)this.getAlarmDao().get((Serializable)Integer.valueOf(1));
        DefaultTicketerServiceLayerIntegrationTest.assertEquals((Object)TroubleTicketState.CLOSED, (Object)alarm.getTTicketState());
    }

    public static class TestTicketerPlugin
    implements Plugin {
        public Ticket get(String ticketId) {
            Ticket ticket = new Ticket();
            ticket.setId(ticketId);
            return ticket;
        }

        public void saveOrUpdate(Ticket ticket) {
            ticket.setId("testId");
        }
    }
}

