/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AliasedResource;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSetVisitor;
import org.opennms.netmgt.collectd.GenericIndexResource;
import org.opennms.netmgt.collectd.GenericIndexResourceType;
import org.opennms.netmgt.collectd.IfInfo;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.NodeInfo;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.config.ThreshdConfigFactory;
import org.opennms.netmgt.config.ThresholdingConfigFactory;
import org.opennms.netmgt.config.datacollection.PersistenceSelectorStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.StorageStrategy;
import org.opennms.netmgt.config.threshd.Package;
import org.opennms.netmgt.config.threshd.Parameter;
import org.opennms.netmgt.config.threshd.Service;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.support.JdbcFilterDao;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockDataCollectionConfig;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.threshd.CollectionResourceWrapper;
import org.opennms.netmgt.threshd.LatencyThresholdingSet;
import org.opennms.netmgt.threshd.ThresholdingEventProxy;
import org.opennms.netmgt.threshd.ThresholdingVisitor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.test.mock.MockLogAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThresholdingVisitorTest {
    Level m_defaultErrorLevelToCheck;
    FilterDao m_filterDao;
    EventAnticipator m_anticipator;
    List<Event> m_anticipatedEvents;
    private Comparator<Parm> m_parmComparator;
    private Comparator<Event> m_eventComparator;

    @Before
    public void setUp() throws Exception {
        System.setProperty("org.opennms.thresholds.filtersReloadEnabled", "false");
        CollectionResourceWrapper.s_cache.clear();
        this.m_defaultErrorLevelToCheck = Level.WARN;
        System.setProperty("mock.logLevel", "DEBUG");
        MockLogAppender.setupLogging();
        this.m_filterDao = (FilterDao)EasyMock.createMock(FilterDao.class);
        EasyMock.expect((Object)this.m_filterDao.getIPList((String)EasyMock.anyObject())).andReturn(Collections.singletonList("127.0.0.1")).anyTimes();
        FilterDaoFactory.setInstance((FilterDao)this.m_filterDao);
        EasyMock.replay((Object[])new Object[]{this.m_filterDao});
        this.m_anticipator = new EventAnticipator();
        MockEventIpcManager eventMgr = new MockEventIpcManager();
        eventMgr.setEventAnticipator(this.m_anticipator);
        eventMgr.setSynchronous(true);
        MockEventIpcManager eventdIpcMgr = eventMgr;
        EventIpcManagerFactory.setIpcManager((EventIpcManager)eventdIpcMgr);
        this.initFactories("/threshd-configuration.xml", "/test-thresholds.xml");
        this.m_anticipatedEvents = new ArrayList<Event>();
        this.m_parmComparator = new Comparator<Parm>(){

            @Override
            public int compare(Parm o1, Parm o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return 1;
                }
                if (o1 != null && o2 == null) {
                    return -1;
                }
                int retVal = o1.getParmName().compareTo(o2.getParmName());
                if (retVal == 0) {
                    String c1 = o1.getValue().getContent();
                    String c2 = o2.getValue().getContent();
                    if (c1 == null && c2 == null) {
                        return 0;
                    }
                    if (c1 == null && c2 != null) {
                        return 1;
                    }
                    if (c1 != null && c2 == null) {
                        return -1;
                    }
                    retVal = c1.compareTo(c2);
                }
                return retVal;
            }
        };
        this.m_eventComparator = new Comparator<Event>(){

            private int compareStrings(String s1, String s2) {
                if (s1 == null && s2 == null) {
                    return 0;
                }
                if (s1 == null && s2 != null) {
                    return 1;
                }
                if (s1 != null && s2 == null) {
                    return -1;
                }
                return s1.compareTo(s2);
            }

            @Override
            public int compare(Event e1, Event e2) {
                if (e1 == null && e2 == null) {
                    return 0;
                }
                if (e1 == null && e2 != null) {
                    return 1;
                }
                if (e1 != null && e2 == null) {
                    return -1;
                }
                int retVal = this.compareStrings(e1.getUei(), e2.getUei());
                if (retVal == 0) {
                    retVal = this.compareStrings(e1.getInterface(), e2.getInterface());
                }
                if (retVal == 0) {
                    retVal = this.compareStrings(e1.getService(), e2.getService());
                }
                if (retVal == 0) {
                    List anticipatedParms = e1.getParms().getParmCollection();
                    List receivedParms = e2.getParms().getParmCollection();
                    Collections.sort(anticipatedParms, ThresholdingVisitorTest.this.m_parmComparator);
                    Collections.sort(receivedParms, ThresholdingVisitorTest.this.m_parmComparator);
                    if (anticipatedParms.size() != receivedParms.size()) {
                        retVal = Integer.valueOf(anticipatedParms.size()).compareTo(receivedParms.size());
                    }
                    if (retVal == 0) {
                        for (int i = 0; i < anticipatedParms.size(); ++i) {
                            Parm anticipated = (Parm)anticipatedParms.get(i);
                            Parm received = (Parm)receivedParms.get(i);
                            retVal = this.compareStrings(anticipated.getParmName(), received.getParmName());
                            if (retVal == 0) {
                                retVal = this.compareStrings(anticipated.getValue().getContent(), received.getValue().getContent());
                            }
                            if (retVal != 0) break;
                        }
                    }
                }
                return retVal;
            }
        };
    }

    private void initFactories(String threshd, String thresholds) throws Exception {
        this.log().info("Initialize Threshold Factories");
        ThresholdingConfigFactory.setInstance((ThresholdingConfigFactory)new ThresholdingConfigFactory(this.getClass().getResourceAsStream(thresholds)));
        ThreshdConfigFactory.setInstance((ThreshdConfigFactory)new ThreshdConfigFactory(this.getClass().getResourceAsStream(threshd), "127.0.0.1", false));
    }

    @After
    public void tearDown() throws Exception {
        MockLogAppender.assertNotGreaterOrEqual((Level)this.m_defaultErrorLevelToCheck);
        EasyMock.verify((Object[])new Object[]{this.m_filterDao});
    }

    @Test
    public void testCreateVisitor() {
        this.createVisitor();
    }

    @Test
    public void testCreateVisitorWithoutProperEnabledIt() {
        HashMap params = new HashMap();
        ThresholdingVisitor visitor = ThresholdingVisitor.create((int)1, (String)"127.0.0.1", (String)"SNMP", (RrdRepository)this.getRepository(), params, (long)300000L);
        Assert.assertNull((Object)visitor);
    }

    @Test
    public void testResourceGaugeData() {
        this.addHighThresholdEvent(1, 10000.0, 5000.0, 15000.0, "Unknown", null, "freeMem", null, null);
        ThresholdingVisitor visitor = this.createVisitor();
        this.runGaugeDataTest(visitor, 15000L);
        this.verifyEvents(0);
    }

    @Test
    public void testResourceCounterData() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-counters.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        CollectionAgent agent = this.createCollectionAgent();
        NodeResourceType resourceType = this.createNodeResourceType(agent);
        MibObject mibObject = this.createMibObject("counter", "myCounter", "0");
        NumericAttributeType attributeType = new NumericAttributeType((org.opennms.netmgt.collectd.ResourceType)resourceType, "default", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        this.addHighThresholdEvent(1, 10.0, 5.0, 15.0, "Unknown", null, "myCounter", null, null);
        this.addHighRearmEvent(1, 10.0, 5.0, 2.0, "Unknown", null, "myCounter", null, null);
        NodeInfo resource = new NodeInfo(resourceType, agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(1000L));
        resource.visit((CollectionSetVisitor)visitor);
        resource = new NodeInfo(resourceType, agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(5500L));
        resource.visit((CollectionSetVisitor)visitor);
        resource = new NodeInfo(resourceType, agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(6100L));
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    @Test
    public void testInterfaceResourceWithDBAttributeFilter() throws Exception {
        Integer ifIndex = 1;
        Long ifSpeed = 10000000L;
        String ifName = "wlan0";
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, "Unknown", ifIndex.toString(), "ifOutOctets", ifName, ifIndex.toString());
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, "Unknown", ifIndex.toString(), "ifInOctets", ifName, ifIndex.toString());
        this.runInterfaceResource(this.createVisitor(), "127.0.0.1", ifName, ifSpeed, ifIndex, 10000L, 46000L);
        this.verifyEvents(0);
    }

    @Test
    public void testInterfaceResourceWithStringAttributeFilter() throws Exception {
        Integer ifIndex = 1;
        Long ifSpeed = 10000000L;
        String ifName = "sis0";
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, "Unknown", ifIndex.toString(), "ifOutOctets", ifName, ifIndex.toString());
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, "Unknown", ifIndex.toString(), "ifInOctets", ifName, ifIndex.toString());
        File resourceDir = new File(this.getRepository().getRrdBaseDir(), "1/" + ifName);
        resourceDir.deleteOnExit();
        resourceDir.mkdirs();
        Properties p = new Properties();
        p.put("myMockParam", "myMockValue");
        ResourceTypeUtils.saveUpdatedProperties((File)new File(resourceDir, "strings.properties"), (Properties)p);
        this.runInterfaceResource(this.createVisitor(), "127.0.0.1", ifName, ifSpeed, ifIndex, 10000L, 46000L);
        this.verifyEvents(0);
        this.deleteDirectory(new File(this.getRepository().getRrdBaseDir(), "1"));
    }

    @Test
    public void testReloadConfiguration() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        this.addHighThresholdEvent(1, 10000.0, 5000.0, 4500.0, "Unknown", null, "freeMem", null, null);
        this.runGaugeDataTest(visitor, 4500L);
        this.verifyEvents(1);
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-2.xml");
        visitor.reload();
        this.resetAnticipator();
        this.addHighThresholdEvent(1, 4000.0, 2000.0, 4500.0, "Unknown", null, "freeMem", null, null);
        this.runGaugeDataTest(visitor, 4500L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug2746() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug2746.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        CollectionAgent agent = this.createCollectionAgent();
        NodeResourceType resourceType = this.createNodeResourceType(agent);
        MibObject mibObject = this.createMibObject("gauge", "bug2746", "0");
        NumericAttributeType attributeType = new NumericAttributeType((org.opennms.netmgt.collectd.ResourceType)resourceType, "default", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        this.addHighThresholdEvent(1, 50.0, 40.0, 60.0, "Unknown", null, "bug2746", null, null);
        NodeInfo resource = new NodeInfo(resourceType, agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getGauge32(20L));
        resource.visit((CollectionSetVisitor)visitor);
        resource.visit((CollectionSetVisitor)visitor);
        resource.visit((CollectionSetVisitor)visitor);
        resource.visit((CollectionSetVisitor)visitor);
        resource = new NodeInfo(resourceType, agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getGauge32(60L));
        resource.visit((CollectionSetVisitor)visitor);
        resource = new NodeInfo(resourceType, agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getGauge32(45L));
        resource.visit((CollectionSetVisitor)visitor);
        resource = new NodeInfo(resourceType, agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getGauge32(55L));
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    @Test
    public void testBug3146_unrelatedChange() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        this.addHighThresholdEvent(1, 10000.0, 5000.0, 12000.0, "Unknown", null, "freeMem", null, null);
        this.addHighRearmEvent(1, 10000.0, 5000.0, 1000.0, "Unknown", null, "freeMem", null, null);
        this.runGaugeDataTest(visitor, 12000L);
        visitor.reload();
        this.runGaugeDataTest(visitor, 1000L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug3146_reduceTrigger() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        this.addHighThresholdEvent(1, 10000.0, 5000.0, 12000.0, "Unknown", null, "freeMem", null, null);
        this.addHighRearmEvent(1, 10000.0, 5000.0, Double.NaN, "Unknown", null, "freeMem", null, null);
        this.addHighThresholdEvent(1, 4000.0, 2000.0, 5000.0, "Unknown", null, "freeMem", null, null);
        this.addHighRearmEvent(1, 4000.0, 2000.0, 1000.0, "Unknown", null, "freeMem", null, null);
        this.runGaugeDataTest(visitor, 12000L);
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-2.xml");
        visitor.reload();
        this.runGaugeDataTest(visitor, 5000L);
        this.runGaugeDataTest(visitor, 1000L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug3146_inceaseTrigger() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        this.addHighThresholdEvent(1, 10000.0, 5000.0, 12000.0, "Unknown", null, "freeMem", null, null);
        this.addHighRearmEvent(1, 10000.0, 5000.0, Double.NaN, "Unknown", null, "freeMem", null, null);
        this.runGaugeDataTest(visitor, 12000L);
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-3.xml");
        visitor.reload();
        this.verifyEvents(0);
        this.resetAnticipator();
        this.addHighThresholdEvent(1, 15000.0, 14000.0, 13000.0, "Unknown", null, "freeMem", null, null);
        this.runGaugeDataTest(visitor, 13000L);
        this.verifyEvents(1);
        this.resetAnticipator();
        this.addHighThresholdEvent(1, 15000.0, 14000.0, 16000.0, "Unknown", null, "freeMem", null, null);
        this.addHighRearmEvent(1, 15000.0, 14000.0, 1000.0, "Unknown", null, "freeMem", null, null);
        this.runGaugeDataTest(visitor, 16000L);
        this.runGaugeDataTest(visitor, 1000L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug3146_replaceThreshold() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        String lowThresholdUei = "uei.opennms.org/threshold/lowThresholdExceeded";
        String highExpression = "(((hrStorageAllocUnits*hrStorageUsed)/(hrStorageAllocUnits*hrStorageSize))*100)";
        String lowExpression = "(100-((hrStorageAllocUnits*hrStorageUsed)/(hrStorageAllocUnits*hrStorageSize))*100)";
        this.addHighThresholdEvent(1, 30.0, 25.0, 50.0, "/opt", "1", highExpression, null, null);
        this.addHighRearmEvent(1, 30.0, 25.0, Double.NaN, "/opt", "1", highExpression, null, null);
        this.addEvent(lowThresholdUei, "127.0.0.1", "SNMP", 1, 10.0, 20.0, 5.0, "/opt", "1", lowExpression, null, null);
        this.runFileSystemDataTest(visitor, 1, "/opt", 500L, 1000L);
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-4.xml");
        visitor.reload();
        this.runFileSystemDataTest(visitor, 1, "/opt", 950L, 1000L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug3193() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3193.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        CollectionAgent agent = this.createCollectionAgent();
        NodeResourceType resourceType = this.createNodeResourceType(agent);
        MibObject mibObject = this.createMibObject("counter", "myCounter", "0");
        NumericAttributeType attributeType = new NumericAttributeType((org.opennms.netmgt.collectd.ResourceType)resourceType, "default", mibObject, new AttributeGroupType("mibGroup", "ignore"));
        this.addHighThresholdEvent(1, 100.0, 90.0, 110.0, "Unknown", null, "myCounter", null, null);
        this.addHighThresholdEvent(1, 70.0, 60.0, 80.0, "Unknown", null, "myCounter - 30", null, null);
        this.addHighRearmEvent(1, 100.0, 90.0, 40.0, "Unknown", null, "myCounter", null, null);
        this.addHighRearmEvent(1, 70.0, 60.0, 10.0, "Unknown", null, "myCounter - 30", null, null);
        NodeInfo resource = new NodeInfo(resourceType, agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(2000L));
        resource.visit((CollectionSetVisitor)visitor);
        resource = new NodeInfo(resourceType, agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(20000L));
        resource.visit((CollectionSetVisitor)visitor);
        resource = new NodeInfo(resourceType, agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(53000L));
        resource.visit((CollectionSetVisitor)visitor);
        resource = new NodeInfo(resourceType, agent);
        resource.setAttributeValue((SnmpAttributeType)attributeType, SnmpUtils.getValueFactory().getCounter32(65000L));
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    @Test
    public void testBug2711_noIpAddress() throws Exception {
        Integer ifIndex = 2;
        Long ifSpeed = 10000000L;
        String ifName = "wlan0";
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-2.xml");
        this.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "0.0.0.0", "SNMP", 1, 90.0, 50.0, 120.0, "Unknown", ifIndex.toString(), "ifOutOctets", ifName, ifIndex.toString());
        this.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "0.0.0.0", "SNMP", 1, 90.0, 50.0, 120.0, "Unknown", ifIndex.toString(), "ifInOctets", ifName, ifIndex.toString());
        this.runInterfaceResource(this.createVisitor(), "0.0.0.0", ifName, ifSpeed, ifIndex, 10000L, 46000L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug2711_noIP_badIfIndex() throws Exception {
        Integer ifIndex = -100;
        Long ifSpeed = 10000000L;
        String ifName = "wlan0";
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-2.xml");
        this.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "0.0.0.0", "SNMP", 1, 90.0, 50.0, 120.0, "Unknown", ifIndex.toString(), "ifOutOctets", ifName, ifIndex.toString());
        this.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "0.0.0.0", "SNMP", 1, 90.0, 50.0, 120.0, "Unknown", ifIndex.toString(), "ifInOctets", ifName, ifIndex.toString());
        this.runInterfaceResource(this.createVisitor(), "0.0.0.0", ifName, ifSpeed, ifIndex, 10000L, 46000L);
        this.verifyEvents(2);
    }

    @Test
    public void testBug3227() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3227.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        CollectionAgent agent = this.createCollectionAgent();
        GenericIndexResourceType resourceType = this.createGenericIndexResourceType(agent, "frCircuitIfIndex");
        SnmpInstId inst = new SnmpInstId(100);
        GenericIndexResource resource = new GenericIndexResource((org.opennms.netmgt.collectd.ResourceType)resourceType, "frCircuitIfIndex", inst);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "frReceivedOctets", "counter", "frCircuitIfIndex", 1000L);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "frSentOctets", "counter", "frCircuitIfIndex", 1000L);
        resource.visit((CollectionSetVisitor)visitor);
        LoggingEvent[] events = MockLogAppender.getEventsGreaterOrEqual((Level)Level.INFO);
        int count = 0;
        String expectedMsg = "getEntityMap: No thresholds configured for resource type frCircuitIfIndex. Not processing this collection.";
        for (LoggingEvent e : events) {
            if (!e.getMessage().equals(expectedMsg)) continue;
            ++count;
        }
        Assert.assertEquals((String)"expecting 2 events", (long)2L, (long)count);
    }

    @Test
    public void testBug3194_32bits() throws Exception {
        this.runCounterWrapTest(32.0, 200.0);
    }

    @Test
    public void testBug3194_64bits() throws Exception {
        this.runCounterWrapTest(64.0, 201.6);
    }

    @Test
    public void testBug3333() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3333.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        String expression = "hrStorageSize-hrStorageUsed";
        this.addEvent("uei.opennms.org/threshold/lowThresholdExceeded", "127.0.0.1", "SNMP", 1, 10.0, 15.0, 5.0, "/opt", "1", expression, null, null);
        this.runFileSystemDataTest(visitor, 1, "/opt", 95L, 100L);
        this.verifyEvents(0);
        this.addEvent("uei.opennms.org/threshold/lowThresholdRearmed", "127.0.0.1", "SNMP", 1, 10.0, 15.0, 60.0, "/opt", "1", expression, null, null);
        this.addHighThresholdEvent(1, 50.0, 45.0, 60.0, "/opt", "1", expression, null, null);
        this.runFileSystemDataTest(visitor, 1, "/opt", 40L, 100L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug3390() throws Exception {
        this.initFactories("/threshd-configuration-bug3390.xml", "/test-thresholds-bug3390.xml");
        ThreshdConfigFactory configManager = ThreshdConfigFactory.getInstance();
        Assert.assertEquals((long)1L, (long)configManager.getConfiguration().getPackageCount());
        Package pkg = configManager.getConfiguration().getPackage(0);
        Assert.assertEquals((long)1L, (long)pkg.getServiceCount());
        Service svc = pkg.getService(0);
        Assert.assertEquals((long)5L, (long)svc.getParameterCount());
        int count = 0;
        for (Parameter parameter : svc.getParameter()) {
            if (!parameter.getKey().equals("thresholding-group")) continue;
            ++count;
        }
        Assert.assertEquals((long)5L, (long)count);
        ThresholdingVisitor visitor = this.createVisitor();
        Assert.assertEquals((long)5L, (long)visitor.m_thresholdingSet.m_thresholdGroups.size());
    }

    @Test
    public void testBug3554_withMockFilterDao() throws Exception {
        this.initFactories("/threshd-configuration-bug3554.xml", "/test-thresholds-bug3554.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        this.runInterfaceResource(visitor, "127.0.0.1", "eth0", 10000000L, 1, 10000L, 46000L);
        this.runGaugeDataTest(visitor, 12000L);
        CollectionAgent agent = this.createCollectionAgent();
        GenericIndexResourceType resourceType = this.createGenericIndexResourceType(agent, "ciscoEnvMonTemperatureStatusIndex");
        GenericIndexResource resource = new GenericIndexResource((org.opennms.netmgt.collectd.ResourceType)resourceType, "ciscoEnvMonTemperatureStatusIndex", new SnmpInstId(45));
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
    }

    @Test
    public void testBug3554_withDBFilterDao() throws Exception {
        this.runTestForBug3554();
        int numOfPackages = ThreshdConfigFactory.getInstance().getConfiguration().getPackage().length;
        LoggingEvent[] events = MockLogAppender.getEventsGreaterOrEqual((Level)Level.DEBUG);
        int count = 0;
        String expectedMsgHeader = "createPackageIpMap: package ";
        for (LoggingEvent e : events) {
            if (!e.getMessage().toString().startsWith(expectedMsgHeader)) continue;
            ++count;
        }
        Assert.assertEquals((String)("expecting " + numOfPackages + " events"), (long)numOfPackages, (long)count);
    }

    @Test
    public void testBug3720() throws Exception {
        System.setProperty("org.opennms.thresholds.filtersReloadEnabled", "true");
        this.runTestForBug3554();
        int numOfPackages = ThreshdConfigFactory.getInstance().getConfiguration().getPackage().length;
        int expectedCalls = numOfPackages * 26;
        LoggingEvent[] events = MockLogAppender.getEventsGreaterOrEqual((Level)Level.DEBUG);
        int count = 0;
        String expectedMsgHeader = "createPackageIpMap: package ";
        for (LoggingEvent e : events) {
            if (!e.getMessage().toString().startsWith(expectedMsgHeader)) continue;
            ++count;
        }
        Assert.assertEquals((String)("expecting " + expectedCalls + " events"), (long)expectedCalls, (long)count);
        expectedCalls = 25;
        events = MockLogAppender.getEventsGreaterOrEqual((Level)Level.INFO);
        count = 0;
        expectedMsgHeader = "getThresholdGroupNames: re-initializing filters.";
        for (LoggingEvent e : events) {
            if (!e.getMessage().toString().equals(expectedMsgHeader)) continue;
            ++count;
        }
        Assert.assertEquals((String)("expecting " + expectedCalls + " events"), (long)expectedCalls, (long)count);
    }

    private void runTestForBug3554() throws Exception {
        MockLogAppender.resetEvents();
        System.err.println("----------------------------------------------------------------------------------- begin test");
        String baseIpAddress = "10.0.0.";
        int numOfNodes = 5;
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        for (int i = 1; i <= numOfNodes; ++i) {
            String ipAddress = baseIpAddress + i;
            network.addNode(i, "testNode-" + ipAddress);
            network.addInterface(ipAddress);
            network.setIfAlias("eth0");
            network.addService("ICMP");
            network.addService("SNMP");
        }
        MockDatabase db = new MockDatabase();
        db.populate(network);
        db.update("insert into categories (categoryid, categoryname) values (?, ?)", new Object[]{10, "IPRA"});
        db.update("insert into categories (categoryid, categoryname) values (?, ?)", new Object[]{11, "NAS"});
        for (int i = 1; i <= numOfNodes; ++i) {
            db.update("update snmpinterface set snmpifname=?, snmpifdescr=? where id=?", new Object[]{"eth0", "eth0", i});
            db.update("update node set nodesysoid=? where nodeid=?", new Object[]{".1.3.6.1.4.1.9.1.222", i});
            db.update("insert into category_node values (?, ?)", new Object[]{10, i});
            db.update("insert into category_node values (?, ?)", new Object[]{11, i});
        }
        DataSourceFactory.setInstance((DataSource)((Object)db));
        System.setProperty("opennms.home", "src/test/resources");
        DatabaseSchemaConfigFactory.init();
        JdbcFilterDao jdbcFilterDao = new JdbcFilterDao();
        jdbcFilterDao.setDataSource((DataSource)((Object)db));
        jdbcFilterDao.setDatabaseSchemaConfigFactory(DatabaseSchemaConfigFactory.getInstance());
        jdbcFilterDao.afterPropertiesSet();
        FilterDaoFactory.setInstance((FilterDao)jdbcFilterDao);
        this.initFactories("/threshd-configuration-bug3554.xml", "/test-thresholds-bug3554.xml");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("thresholding-enabled", "true");
        for (int i = 1; i <= numOfNodes; ++i) {
            System.err.println("----------------------------------------------------------------------------------- visitor #" + i);
            String ipAddress = baseIpAddress + i;
            ThresholdingVisitor visitor = ThresholdingVisitor.create((int)1, (String)ipAddress, (String)"SNMP", (RrdRepository)this.getRepository(), params, (long)300000L);
            Assert.assertNotNull((Object)visitor);
            Assert.assertEquals((long)4L, (long)visitor.getThresholdGroups().size());
        }
        System.err.println("----------------------------------------------------------------------------------- end");
    }

    @Test
    public void testBug3487() throws Exception {
        this.initFactories("/threshd-configuration-bug3487.xml", "/test-thresholds.xml");
        Assert.assertNotNull((Object)this.createVisitor());
        this.m_defaultErrorLevelToCheck = Level.FATAL;
        LoggingEvent[] events = MockLogAppender.getEventsGreaterOrEqual((Level)Level.ERROR);
        Assert.assertEquals((String)"expecting 1 event", (long)1L, (long)events.length);
        Assert.assertEquals((Object)"initialize: Can't process threshold group SMS_Dieta", (Object)events[0].getMessage());
    }

    @Test
    public void testBug3488() throws Exception {
        String ipAddress = "127.0.0.1";
        this.setupSnmpInterfaceDatabase(ipAddress, null);
        LatencyThresholdingSet thresholdingSet = new LatencyThresholdingSet(1, ipAddress, "HTTP", this.getRepository(), 0L);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds());
        HashMap<String, Double> attributes = new HashMap<String, Double>();
        attributes.put("http", 200.0);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds(attributes));
        this.m_defaultErrorLevelToCheck = Level.ERROR;
        ArrayList triggerEvents = new ArrayList();
        for (int i = 0; i < 5; ++i) {
            triggerEvents.addAll(thresholdingSet.applyThresholds("http", attributes));
        }
        LoggingEvent[] events = MockLogAppender.getEventsGreaterOrEqual((Level)Level.WARN);
        Assert.assertEquals((String)"expecting 5 events", (long)5L, (long)events.length);
        for (LoggingEvent e : events) {
            Assert.assertEquals((Object)"Interface (nodeId/ipAddr=1/127.0.0.1) has no ifName and no ifDescr...setting to label to 'no_ifLabel'.", (Object)e.getMessage());
        }
        Assert.assertTrue((triggerEvents.size() == 1 ? 1 : 0) != 0);
        this.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "127.0.0.1", "HTTP", 5, 100.0, 50.0, 200.0, "Unknown", "127.0.0.1[http]", "http", "no_ifLabel", null);
        ThresholdingEventProxy proxy = new ThresholdingEventProxy();
        proxy.add(triggerEvents);
        proxy.sendAllEvents();
        this.verifyEvents(0);
    }

    @Test
    public void testBug3575() throws Exception {
        this.initFactories("/threshd-configuration-bug3575.xml", "/test-thresholds-bug3575.xml");
        String ipAddress = "127.0.0.1";
        this.setupSnmpInterfaceDatabase(ipAddress, "eth0");
        LatencyThresholdingSet thresholdingSet = new LatencyThresholdingSet(1, ipAddress, "StrafePing", this.getRepository(), 0L);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds());
        HashMap<String, Double> attributes = new HashMap<String, Double>();
        for (double i = 1.0; i < 21.0; i += 1.0) {
            attributes.put("ping" + i, 2.0 * i);
        }
        attributes.put("loss", 60.0);
        attributes.put("response-time", 100.0);
        attributes.put("median", 100.0);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds(attributes));
        List triggerEvents = thresholdingSet.applyThresholds("StrafePing", attributes);
        Assert.assertTrue((triggerEvents.size() == 1 ? 1 : 0) != 0);
        this.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "127.0.0.1", "StrafePing", 1, 50.0, 25.0, 60.0, "Unknown", "127.0.0.1[StrafePing]", "loss", "eth0", null);
        ThresholdingEventProxy proxy = new ThresholdingEventProxy();
        proxy.add(triggerEvents);
        proxy.sendAllEvents();
        this.verifyEvents(0);
    }

    @Test
    public void testBug3428_noMatch() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3428.xml");
        Integer ifIndex = 1;
        Long ifSpeed = 10000000L;
        String ifName = "wlan0";
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, "Unknown", ifIndex.toString(), "ifInOctets", ifName, ifIndex.toString());
        this.runInterfaceResource(this.createVisitor(), "127.0.0.1", ifName, ifSpeed, ifIndex, 10000L, 46000L);
        this.verifyEvents(1);
    }

    @Test
    public void testBug3428_match() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3428.xml");
        Integer ifIndex = 1;
        Long ifSpeed = 100000000L;
        String ifName = "wlan0";
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, "Unknown", ifIndex.toString(), "ifInOctets", ifName, ifIndex.toString());
        this.runInterfaceResource(this.createVisitor(), "127.0.0.1", ifName, ifSpeed, ifIndex, 10000L, 46000L);
        this.verifyEvents(0);
    }

    @Test
    public void testBug3664() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3664.xml");
        Integer ifIndex = 1;
        Long ifSpeed = 10000000L;
        String ifName = "wlan0";
        String domain = "myDomain";
        String ifAlias = ifName;
        String ifAliasComment = "#";
        String label = domain + "/" + ifAlias;
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, "Unknown", null, "ifOutOctets", label, ifIndex.toString());
        this.addHighThresholdEvent(1, 90.0, 50.0, 120.0, "Unknown", null, "ifInOctets", label, ifIndex.toString());
        ThresholdingVisitor visitor = this.createVisitor();
        SnmpIfData ifData = this.createSnmpIfData("127.0.0.1", ifName, ifSpeed, ifIndex);
        CollectionAgent agent = this.createCollectionAgent();
        IfResourceType resourceType = this.createInterfaceResourceType(agent);
        IfInfo ifInfo = new IfInfo((org.opennms.netmgt.collectd.ResourceType)resourceType, agent, ifData);
        this.addAttributeToCollectionResource((SnmpCollectionResource)ifInfo, (org.opennms.netmgt.collectd.ResourceType)resourceType, "ifInOctets", "counter", "ifIndex", 10000L);
        this.addAttributeToCollectionResource((SnmpCollectionResource)ifInfo, (org.opennms.netmgt.collectd.ResourceType)resourceType, "ifOutOctets", "counter", "ifIndex", 10000L);
        AliasedResource resource = new AliasedResource((org.opennms.netmgt.collectd.ResourceType)resourceType, domain, ifInfo, ifAliasComment, ifAlias);
        resource.visit((CollectionSetVisitor)visitor);
        ifInfo = new IfInfo((org.opennms.netmgt.collectd.ResourceType)resourceType, agent, ifData);
        this.addAttributeToCollectionResource((SnmpCollectionResource)ifInfo, (org.opennms.netmgt.collectd.ResourceType)resourceType, "ifInOctets", "counter", "ifIndex", 46000L);
        this.addAttributeToCollectionResource((SnmpCollectionResource)ifInfo, (org.opennms.netmgt.collectd.ResourceType)resourceType, "ifOutOctets", "counter", "ifIndex", 46000L);
        resource = new AliasedResource((org.opennms.netmgt.collectd.ResourceType)resourceType, domain, ifInfo, ifAliasComment, ifAlias);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    @Test
    public void testLatencyThresholdingSet() throws Exception {
        Integer ifIndex = 1;
        String ifName = "lo0";
        this.setupSnmpInterfaceDatabase("127.0.0.1", ifName);
        LatencyThresholdingSet thresholdingSet = new LatencyThresholdingSet(1, "127.0.0.1", "HTTP", this.getRepository(), 0L);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds());
        HashMap<String, Double> attributes = new HashMap<String, Double>();
        attributes.put("http", 90.0);
        Assert.assertTrue((boolean)thresholdingSet.hasThresholds(attributes));
        List triggerEvents = thresholdingSet.applyThresholds("http", attributes);
        Assert.assertTrue((triggerEvents.size() == 0 ? 1 : 0) != 0);
        attributes.put("http", 200.0);
        for (int i = 1; i < 5; ++i) {
            this.log().debug("testLatencyThresholdingSet: run number " + i);
            if (!thresholdingSet.hasThresholds(attributes)) continue;
            triggerEvents = thresholdingSet.applyThresholds("http", attributes);
            Assert.assertTrue((triggerEvents.size() == 0 ? 1 : 0) != 0);
        }
        if (thresholdingSet.hasThresholds(attributes)) {
            this.log().debug("testLatencyThresholdingSet: run number 5");
            triggerEvents = thresholdingSet.applyThresholds("http", attributes);
            Assert.assertTrue((triggerEvents.size() == 1 ? 1 : 0) != 0);
        }
        List rearmEvents = null;
        if (thresholdingSet.hasThresholds(attributes)) {
            attributes.put("http", 40.0);
            rearmEvents = thresholdingSet.applyThresholds("http", attributes);
            Assert.assertTrue((rearmEvents.size() == 1 ? 1 : 0) != 0);
        }
        this.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "127.0.0.1", "HTTP", 5, 100.0, 50.0, 200.0, "Unknown", "127.0.0.1[http]", "http", ifName, ifIndex.toString());
        this.addEvent("uei.opennms.org/threshold/highThresholdRearmed", "127.0.0.1", "HTTP", 5, 100.0, 50.0, 40.0, "Unknown", "127.0.0.1[http]", "http", ifName, ifIndex.toString());
        ThresholdingEventProxy proxy = new ThresholdingEventProxy();
        proxy.add(triggerEvents);
        proxy.add(rearmEvents);
        proxy.sendAllEvents();
        this.verifyEvents(0);
    }

    @Test
    public void testThresholsFiltersOnGenericResource() throws Exception {
        ThresholdingVisitor visitor = this.createVisitor();
        String highExpression = "(((hrStorageAllocUnits*hrStorageUsed)/(hrStorageAllocUnits*hrStorageSize))*100)";
        this.addHighThresholdEvent(1, 30.0, 25.0, 50.0, "/opt", "1", highExpression, null, null);
        this.addHighThresholdEvent(1, 30.0, 25.0, 60.0, "/opt01", "2", highExpression, null, null);
        this.runFileSystemDataTest(visitor, 1, "/opt", 50L, 100L);
        this.runFileSystemDataTest(visitor, 2, "/opt01", 60L, 100L);
        this.runFileSystemDataTest(visitor, 3, "/home", 70L, 100L);
        this.verifyEvents(0);
    }

    @Test
    public void testThresholsFiltersOnNodeResource() throws Exception {
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-5.xml");
        ThresholdingVisitor visitor = this.createVisitor();
        this.addHighThresholdEvent(1, 30.0, 25.0, 50.0, "/home", null, "(hda1_hrStorageUsed/hda1_hrStorageSize)*100", null, null);
        this.addHighThresholdEvent(1, 50.0, 45.0, 60.0, "/opt", null, "(hda2_hrStorageUsed/hda2_hrStorageSize)*100", null, null);
        CollectionAgent agent = this.createCollectionAgent();
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfig)dataCollectionConfig);
        NodeResourceType resourceType = new NodeResourceType(agent, collection);
        Properties p = new Properties();
        p.put("hda1_hrStorageDescr", "/home");
        p.put("hda2_hrStorageDescr", "/opt");
        p.put("hda3_hrStorageDescr", "/usr");
        File f = new File(this.getRepository().getRrdBaseDir(), "1/strings.properties");
        ResourceTypeUtils.saveUpdatedProperties((File)f, (Properties)p);
        NodeInfo resource = new NodeInfo(resourceType, agent);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "hda1_hrStorageUsed", "gauge", "node", 50L);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "hda1_hrStorageSize", "gauge", "node", 100L);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "hda2_hrStorageUsed", "gauge", "node", 60L);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "hda2_hrStorageSize", "gauge", "node", 100L);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "hda3_hrStorageUsed", "gauge", "node", 70L);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "hda3_hrStorageSize", "gauge", "node", 100L);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        f.delete();
        this.verifyEvents(0);
    }

    private ThresholdingVisitor createVisitor() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("thresholding-enabled", "true");
        ThresholdingVisitor visitor = ThresholdingVisitor.create((int)1, (String)"127.0.0.1", (String)"SNMP", (RrdRepository)this.getRepository(), params, (long)300000L);
        Assert.assertNotNull((Object)visitor);
        return visitor;
    }

    private void runGaugeDataTest(ThresholdingVisitor visitor, long value) {
        CollectionAgent agent = this.createCollectionAgent();
        NodeResourceType resourceType = this.createNodeResourceType(agent);
        NodeInfo resource = new NodeInfo(resourceType, agent);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "freeMem", "gauge", "0", value);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
    }

    private void runInterfaceResource(ThresholdingVisitor visitor, String ipAddress, String ifName, Long ifSpeed, Integer ifIndex, long v1, long v2) {
        SnmpIfData ifData = this.createSnmpIfData(ipAddress, ifName, ifSpeed, ifIndex);
        CollectionAgent agent = this.createCollectionAgent();
        IfResourceType resourceType = this.createInterfaceResourceType(agent);
        IfInfo resource = new IfInfo((org.opennms.netmgt.collectd.ResourceType)resourceType, agent, ifData);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "ifInOctets", "counter", "ifIndex", v1);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "ifOutOctets", "counter", "ifIndex", v1);
        resource.visit((CollectionSetVisitor)visitor);
        resource = new IfInfo((org.opennms.netmgt.collectd.ResourceType)resourceType, agent, ifData);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "ifInOctets", "counter", "ifIndex", v2);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "ifOutOctets", "counter", "ifIndex", v2);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
    }

    private void runFileSystemDataTest(ThresholdingVisitor visitor, int resourceId, String fs, long value, long max) throws Exception {
        CollectionAgent agent = this.createCollectionAgent();
        GenericIndexResourceType resourceType = this.createGenericIndexResourceType(agent, "hrStorageIndex");
        Properties p = new Properties();
        p.put("hrStorageType", ".1.3.6.1.2.1.25.2.1.4");
        p.put("hrStorageDescr", fs);
        File f = new File(this.getRepository().getRrdBaseDir(), "1/hrStorageIndex/" + resourceId + "/strings.properties");
        ResourceTypeUtils.saveUpdatedProperties((File)f, (Properties)p);
        SnmpInstId inst = new SnmpInstId(resourceId);
        GenericIndexResource resource = new GenericIndexResource((org.opennms.netmgt.collectd.ResourceType)resourceType, "hrStorageIndex", inst);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "hrStorageUsed", "gauge", "hrStorageIndex", value);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "hrStorageSize", "gauge", "hrStorageIndex", max);
        this.addAttributeToCollectionResource((SnmpCollectionResource)resource, (org.opennms.netmgt.collectd.ResourceType)resourceType, "hrStorageAllocUnits", "gauge", "hrStorageIndex", 1L);
        resource.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        f.delete();
    }

    private void runCounterWrapTest(double bits, double expectedValue) throws Exception {
        Integer ifIndex = 1;
        Long ifSpeed = 10000000L;
        String ifName = "wlan0";
        this.initFactories("/threshd-configuration.xml", "/test-thresholds-bug3194.xml");
        this.addHighThresholdEvent(1, 100.0, 90.0, expectedValue, "Unknown", "1", "ifOutOctets", ifName, ifIndex.toString());
        ThresholdingVisitor visitor = this.createVisitor();
        SnmpIfData ifData = this.createSnmpIfData("127.0.0.1", ifName, ifSpeed, ifIndex);
        CollectionAgent agent = this.createCollectionAgent();
        IfResourceType resourceType = this.createInterfaceResourceType(agent);
        MibObject object = this.createMibObject("counter", "ifOutOctets", "ifIndex");
        NumericAttributeType objectType = new NumericAttributeType((org.opennms.netmgt.collectd.ResourceType)resourceType, "default", object, new AttributeGroupType("mibGroup", "ignore"));
        BigDecimal n = new BigDecimal(Math.pow(2.0, bits) - 20000.0);
        SnmpValue snmpValue1 = SnmpUtils.getValueFactory().getCounter64(n.toBigInteger());
        IfInfo resource1 = new IfInfo((org.opennms.netmgt.collectd.ResourceType)resourceType, agent, ifData);
        resource1.setAttributeValue((SnmpAttributeType)objectType, snmpValue1);
        resource1.visit((CollectionSetVisitor)visitor);
        SnmpValue snmpValue2 = SnmpUtils.getValueFactory().getCounter64(new BigInteger("40000"));
        IfInfo resource2 = new IfInfo((org.opennms.netmgt.collectd.ResourceType)resourceType, agent, ifData);
        resource2.setAttributeValue((SnmpAttributeType)objectType, snmpValue2);
        resource2.visit((CollectionSetVisitor)visitor);
        EasyMock.verify((Object[])new Object[]{agent});
        this.verifyEvents(0);
    }

    private CollectionAgent createCollectionAgent() {
        CollectionAgent agent = (CollectionAgent)EasyMock.createMock(CollectionAgent.class);
        EasyMock.expect((Object)agent.getNodeId()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)agent.getHostAddress()).andReturn((Object)"127.0.0.1").anyTimes();
        EasyMock.expect((Object)agent.getSnmpInterfaceInfo((IfResourceType)EasyMock.anyObject())).andReturn(new HashSet()).anyTimes();
        EasyMock.replay((Object[])new Object[]{agent});
        return agent;
    }

    private NodeResourceType createNodeResourceType(CollectionAgent agent) {
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfig)dataCollectionConfig);
        return new NodeResourceType(agent, collection);
    }

    private IfResourceType createInterfaceResourceType(CollectionAgent agent) {
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfig)dataCollectionConfig);
        return new IfResourceType(agent, collection);
    }

    private GenericIndexResourceType createGenericIndexResourceType(CollectionAgent agent, String resourceTypeName) {
        ResourceType type = new ResourceType();
        type.setName(resourceTypeName);
        type.setLabel(resourceTypeName);
        StorageStrategy strategy = new StorageStrategy();
        strategy.setClazz("org.opennms.netmgt.dao.support.IndexStorageStrategy");
        type.setStorageStrategy(strategy);
        PersistenceSelectorStrategy pstrategy = new PersistenceSelectorStrategy();
        pstrategy.setClazz("org.opennms.netmgt.collectd.PersistAllSelectorStrategy");
        type.setPersistenceSelectorStrategy(pstrategy);
        MockDataCollectionConfig dataCollectionConfig = new MockDataCollectionConfig();
        OnmsSnmpCollection collection = new OnmsSnmpCollection(agent, new ServiceParameters(new HashMap()), (DataCollectionConfig)dataCollectionConfig);
        return new GenericIndexResourceType(agent, collection, type);
    }

    private void addAttributeToCollectionResource(SnmpCollectionResource resource, org.opennms.netmgt.collectd.ResourceType type, String attributeName, String attributeType, String attributeInstance, long value) {
        MibObject object = this.createMibObject(attributeType, attributeName, attributeInstance);
        NumericAttributeType objectType = new NumericAttributeType(type, "default", object, new AttributeGroupType("mibGroup", "ignore"));
        SnmpValue snmpValue = attributeType.equals("counter") ? SnmpUtils.getValueFactory().getCounter32(value) : SnmpUtils.getValueFactory().getGauge32(value);
        resource.setAttributeValue((SnmpAttributeType)objectType, snmpValue);
    }

    private MibObject createMibObject(String type, String alias, String instance) {
        MibObject mibObject = new MibObject();
        mibObject.setOid(".1.1.1.1");
        mibObject.setAlias(alias);
        mibObject.setType(type);
        mibObject.setInstance(instance);
        mibObject.setMaxval(null);
        mibObject.setMinval(null);
        return mibObject;
    }

    private RrdRepository getRepository() {
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File("/tmp"));
        return repo;
    }

    private void addHighThresholdEvent(int trigger, double threshold, double rearm, double value, String label, String instance, String ds, String ifLabel, String ifIndex) {
        this.addEvent("uei.opennms.org/threshold/highThresholdExceeded", "127.0.0.1", "SNMP", trigger, threshold, rearm, value, label, instance, ds, ifLabel, ifIndex);
    }

    private void addHighRearmEvent(int trigger, double threshold, double rearm, double value, String label, String instance, String ds, String ifLabel, String ifIndex) {
        this.addEvent("uei.opennms.org/threshold/highThresholdRearmed", "127.0.0.1", "SNMP", trigger, threshold, rearm, value, label, instance, ds, ifLabel, ifIndex);
    }

    private void addEvent(String uei, String ipaddr, String service, int trigger, double threshold, double rearm, double value, String label, String instance, String ds, String ifLabel, String ifIndex) {
        Event e = new Event();
        e.setUei(uei);
        e.setNodeid(1L);
        e.setInterface(ipaddr);
        e.setService(service);
        Parms parms = new Parms();
        Parm p = new Parm();
        p.setParmName("label");
        Value v = new Value();
        v.setContent(label);
        p.setValue(v);
        parms.addParm(p);
        if (ifLabel != null) {
            p = new Parm();
            p.setParmName("ifLabel");
            v = new Value();
            v.setContent(ifLabel);
            p.setValue(v);
            parms.addParm(p);
        }
        if (ifIndex != null) {
            p = new Parm();
            p.setParmName("ifIndex");
            v = new Value();
            v.setContent(ifIndex);
            p.setValue(v);
            parms.addParm(p);
        }
        p = new Parm();
        p.setParmName("ds");
        v = new Value();
        v.setContent(ds);
        p.setValue(v);
        parms.addParm(p);
        p = new Parm();
        p.setParmName("value");
        v = new Value();
        String pattern = System.getProperty("org.opennms.threshd.value.decimalformat", "###.##");
        DecimalFormat valueFormatter = new DecimalFormat(pattern);
        v.setContent(valueFormatter.format(value));
        p.setValue(v);
        parms.addParm(p);
        p = new Parm();
        p.setParmName("instance");
        v = new Value();
        v.setContent(instance);
        p.setValue(v);
        parms.addParm(p);
        p = new Parm();
        p.setParmName("trigger");
        v = new Value();
        v.setContent(Integer.toString(trigger));
        p.setValue(v);
        parms.addParm(p);
        p = new Parm();
        p.setParmName("threshold");
        v = new Value();
        v.setContent(Double.toString(threshold));
        p.setValue(v);
        parms.addParm(p);
        p = new Parm();
        p.setParmName("rearm");
        v = new Value();
        v.setContent(Double.toString(rearm));
        p.setValue(v);
        parms.addParm(p);
        e.setParms(parms);
        this.m_anticipator.anticipateEvent(e, true);
        this.m_anticipatedEvents.add(e);
    }

    private void verifyEvents(int remainEvents) {
        if (remainEvents == 0) {
            List<Event> receivedList = this.m_anticipator.getAnticipatedEventsRecieved();
            Collections.sort(receivedList, this.m_eventComparator);
            Collections.sort(this.m_anticipatedEvents, this.m_eventComparator);
            this.log().info("verifyEvents: Anticipated=" + this.m_anticipatedEvents.size() + ", Received=" + receivedList.size());
            if (this.m_anticipatedEvents.size() != receivedList.size()) {
                for (Event e : this.m_anticipatedEvents) {
                    System.err.println("expected event " + e.getUei() + ": " + e.getDescr());
                }
                System.err.println("anticipated = " + this.m_anticipatedEvents + ", received = " + receivedList);
                Assert.fail((String)("Anticipated event count (" + this.m_anticipatedEvents.size() + ") is different from received event count (" + receivedList.size() + ")."));
            }
            for (int i = 0; i < this.m_anticipatedEvents.size(); ++i) {
                this.log().info("verifyEvents: processing event " + (i + 1));
                this.compareEvents(this.m_anticipatedEvents.get(i), receivedList.get(i));
            }
        }
        this.m_anticipator.verifyAnticipated(0L, 0L, 0L, remainEvents, 0);
    }

    private void compareEvents(Event anticipated, Event received) {
        Assert.assertEquals((String)"UEIs must match", (Object)anticipated.getUei(), (Object)received.getUei());
        Assert.assertEquals((String)"NodeIDs must match", (long)anticipated.getNodeid(), (long)received.getNodeid());
        Assert.assertEquals((String)"interfaces must match", (Object)anticipated.getInterface(), (Object)received.getInterface());
        Assert.assertEquals((String)"services must match", (Object)anticipated.getService(), (Object)received.getService());
        this.compareParms(anticipated.getParms().getParmCollection(), received.getParms().getParmCollection());
    }

    private void compareParms(List<Parm> anticipatedParms, List<Parm> receivedParms) {
        Collections.sort(anticipatedParms, this.m_parmComparator);
        Collections.sort(receivedParms, this.m_parmComparator);
        for (Parm source : anticipatedParms) {
            Parm found = null;
            for (Parm p : receivedParms) {
                if (!p.getParmName().equals(source.getParmName())) continue;
                found = p;
            }
            Assert.assertNotNull((String)("parameter " + source.getParmName() + " must be found on the received event"), (Object)found);
            if (source.getValue().getContent() == null) {
                source.getValue().setContent("null");
            }
            Assert.assertEquals((String)("content must match for parameter " + source.getParmName()), (Object)source.getValue().getContent(), (Object)found.getValue().getContent());
        }
    }

    private void resetAnticipator() {
        this.m_anticipator.reset();
        this.m_anticipatedEvents.clear();
    }

    private SnmpIfData createSnmpIfData(String ipAddress, String ifName, Long ifSpeed, Integer ifIndex) {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        node.setLabel("testNode");
        OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(ipAddress, ifIndex, node);
        snmpIface.setIfDescr(ifName);
        snmpIface.setIfName(ifName);
        snmpIface.setIfAlias(ifName);
        snmpIface.setIfSpeed(ifSpeed);
        return new SnmpIfData(snmpIface);
    }

    private void setupSnmpInterfaceDatabase(String ipAddress, String ifName) throws Exception {
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        network.addNode(1, "testNode");
        network.addInterface(ipAddress);
        if (ifName != null) {
            network.setIfAlias(ifName);
        }
        network.addService("ICMP");
        network.addService("SNMP");
        network.addService("HTTP");
        MockDatabase db = new MockDatabase();
        db.populate(network);
        if (ifName != null) {
            db.update("update snmpinterface set snmpifname=?, snmpifdescr=? where id=?", new Object[]{ifName, ifName, 1});
        }
        DataSourceFactory.setInstance((DataSource)((Object)db));
        Vault.setDataSource((DataSource)((Object)db));
    }

    private boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

