/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.threshd;

import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.ThreshdConfigManager;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.threshd.Threshd;
import org.opennms.netmgt.threshd.ThresholderTestCase;
import org.opennms.netmgt.threshd.mock.MockThreshdConfigManager;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;
import org.springframework.core.io.ClassPathResource;

public class ThreshdIntegrationTest
extends ThresholderTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        MockLogAppender.setupLogging();
        this.setupDatabase();
        ClassPathResource dbConfig = new ClassPathResource("/org/opennms/netmgt/config/test-database-schema.xml");
        DatabaseSchemaConfigFactory dscf = new DatabaseSchemaConfigFactory(dbConfig.getInputStream());
        DatabaseSchemaConfigFactory.setInstance((DatabaseSchemaConfigFactory)dscf);
        RrdTestUtils.initializeNullStrategy();
        EventIpcManagerFactory.setIpcManager((EventIpcManager)new MockEventIpcManager());
        String dirName = "target/tmp/192.168.1.1";
        String fileName = "icmp.rrd";
        int nodeId = 1;
        String ipAddress = "192.168.1.1";
        String serviceName = "ICMP";
        String groupName = "icmp-latency";
        this.setupThresholdConfig(dirName, fileName, nodeId, ipAddress, serviceName, groupName);
        ClassPathResource resource = new ClassPathResource("etc/poll-outages.xml");
        PollOutagesConfigFactory.setInstance((PollOutagesConfigFactory)new PollOutagesConfigFactory(resource.getInputStream()));
    }

    protected void tearDown() throws Exception {
        MockLogAppender.assertNoWarningsOrGreater();
        MockUtil.println((String)("------------ End Test " + this.getName() + " --------------------------"));
    }

    public void testThreshd() throws Exception {
        Threshd threshd = new Threshd();
        MockThreshdConfigManager config = new MockThreshdConfigManager(ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"threshd-configuration.xml"), "localhost", false);
        threshd.setThreshdConfig((ThreshdConfigManager)config);
        threshd.init();
        threshd.start();
        Thread.sleep(5000L);
        threshd.stop();
    }
}

