/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.InputStream;
import java.net.UnknownHostException;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Level;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.SyslogdConfigFactory;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.syslogd.SyslogClient;
import org.opennms.netmgt.syslogd.Syslogd;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.DaoTestConfigBean;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;

public class SyslogdTest
extends OpenNMSTestCase {
    private Syslogd m_syslogd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUp() throws Exception {
        DaoTestConfigBean daoTestConfig = new DaoTestConfigBean();
        daoTestConfig.setRelativeHomeDirectory("src/test/resources");
        daoTestConfig.afterPropertiesSet();
        super.setUp();
        MockUtil.println((String)("------------ Begin Test " + this.getName() + " --------------------------"));
        MockLogAppender.setupLogging();
        MockNetwork network = new MockNetwork();
        MockDatabase db = new MockDatabase();
        db.populate(network);
        DataSourceFactory.setInstance((DataSource)((Object)db));
        InputStream stream = null;
        try {
            stream = ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/etc/syslogd-configuration.xml");
            new SyslogdConfigFactory(stream);
        }
        finally {
            if (stream != null) {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        this.m_syslogd = new Syslogd();
        this.m_syslogd.init();
    }

    protected void tearDown() throws Exception {
        MockUtil.println((String)("------------ End Test " + this.getName() + " --------------------------"));
        super.tearDown();
    }

    public void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNotGreaterOrEqual((Level)Level.FATAL);
    }

    public void testSyslogdStart() {
        SyslogdTest.assertEquals((String)"START_PENDING", (String)this.m_syslogd.getStatusText());
        this.m_syslogd.start();
    }

    public void testMessaging() {
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 0, 7);
            s.syslog(3, "Hello.");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void XXXtestMyPatternsSyslogNG() {
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 host.domain.com A SyslogNG style message");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void testIPPatternsSyslogNG() {
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 127.0.0.1 A SyslogNG style message");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void testResolvePatternsSyslogNG() {
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 www.opennms.org A SyslogNG style message");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void testSubstrUEIRewrite() throws InterruptedException {
        String localhost = this.myLocalHost();
        String testPDU = "2007-01-01 www.opennms.org A CISCO message";
        String testUEI = "uei.opennms.org/tests/syslogd/substrUeiRewriteTest";
        String testMsg = "A CISCO message";
        Event e = new Event();
        e.setUei("uei.opennms.org/tests/syslogd/substrUeiRewriteTest");
        e.setSource("syslogd");
        e.setInterface(localhost);
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        logmsg.setContent("A CISCO message");
        e.setLogmsg(logmsg);
        EventAnticipator ea = new EventAnticipator();
        ea.anticipateEvent(e);
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 www.opennms.org A CISCO message");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        SyslogdTest.assertEquals((int)1, (int)ea.waitForAnticipated(1000L).size());
        Thread.sleep(2000L);
        SyslogdTest.assertEquals((int)0, (int)ea.unanticipatedEvents().size());
        SyslogdTest.assertFalse((boolean)ea.getAnticipatedEvents().isEmpty());
        Event ne = ea.getAnticipatedEvents().iterator().next();
        SyslogdTest.assertEquals((String)"uei.opennms.org/tests/syslogd/substrUeiRewriteTest", (String)ne.getUei());
        SyslogdTest.assertEquals((String)"syslogd", (String)ne.getSource());
        SyslogdTest.assertEquals((String)"A CISCO message", (String)ne.getLogmsg().getContent());
    }

    public void testRegexUEIRewrite() throws InterruptedException {
        String localhost = this.myLocalHost();
        String testPDU = "2007-01-01 www.opennms.org foo: 100 out of 666 tests failed for bar";
        String testUEI = "uei.opennms.org/tests/syslogd/regexUeiRewriteTest";
        String testMsg = "foo: 100 out of 666 tests failed for bar";
        Event e = new Event();
        e.setUei("uei.opennms.org/tests/syslogd/regexUeiRewriteTest");
        e.setSource("syslogd");
        e.setInterface(localhost);
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        logmsg.setContent("foo: 100 out of 666 tests failed for bar");
        e.setLogmsg(logmsg);
        EventAnticipator ea = new EventAnticipator();
        ea.anticipateEvent(e);
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 www.opennms.org foo: 100 out of 666 tests failed for bar");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        SyslogdTest.assertEquals((int)1, (int)ea.waitForAnticipated(1000L).size());
        Thread.sleep(2000L);
        SyslogdTest.assertEquals((int)0, (int)ea.unanticipatedEvents().size());
        SyslogdTest.assertFalse((boolean)ea.getAnticipatedEvents().isEmpty());
        Event ne = ea.getAnticipatedEvents().iterator().next();
        SyslogdTest.assertEquals((String)"uei.opennms.org/tests/syslogd/regexUeiRewriteTest", (String)ne.getUei());
        SyslogdTest.assertEquals((String)"syslogd", (String)ne.getSource());
        SyslogdTest.assertEquals((String)"foo: 100 out of 666 tests failed for bar", (String)ne.getLogmsg().getContent());
    }

    public void testSubstrTESTTestThatRemovesATESTString() throws InterruptedException {
        String localhost = this.myLocalHost();
        String testPDU = "2007-01-01 www.opennms.org A CISCO message that is also a TEST message -- hide me!";
        String testUEI = "uei.opennms.org/tests/syslogd/substrUeiRewriteTest";
        String testMsg = "The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.";
        Event e = new Event();
        e.setUei("uei.opennms.org/tests/syslogd/substrUeiRewriteTest");
        e.setSource("syslogd");
        e.setInterface(localhost);
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        logmsg.setContent("The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.");
        e.setLogmsg(logmsg);
        EventAnticipator ea = new EventAnticipator();
        ea.anticipateEvent(e);
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 www.opennms.org A CISCO message that is also a TEST message -- hide me!");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        SyslogdTest.assertEquals((int)1, (int)ea.waitForAnticipated(1000L).size());
        Thread.sleep(2000L);
        SyslogdTest.assertEquals((int)0, (int)ea.unanticipatedEvents().size());
        SyslogdTest.assertFalse((boolean)ea.getAnticipatedEvents().isEmpty());
        Event ne = ea.getAnticipatedEvents().iterator().next();
        SyslogdTest.assertEquals((String)"uei.opennms.org/tests/syslogd/substrUeiRewriteTest", (String)ne.getUei());
        SyslogdTest.assertEquals((String)"syslogd", (String)ne.getSource());
        SyslogdTest.assertEquals((String)"The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.", (String)ne.getLogmsg().getContent());
    }

    public void testRegexTESTTestThatRemovesADoubleSecretString() throws InterruptedException {
        String localhost = this.myLocalHost();
        String testPDU = "2007-01-01 www.opennms.org foo: 100 out of 666 tests failed for bar";
        String testUEI = "uei.opennms.org/tests/syslogd/regexUeiRewriteTest";
        String testMsg = "The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.";
        String[] testGroups = new String[]{"100", "666", "bar"};
        Event e = new Event();
        e.setUei("uei.opennms.org/tests/syslogd/regexUeiRewriteTest");
        e.setSource("syslogd");
        e.setInterface(localhost);
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        logmsg.setContent("The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.");
        e.setLogmsg(logmsg);
        Parms eventParms = new Parms();
        Parm eventParm = null;
        Value parmValue = null;
        eventParm = new Parm();
        eventParm.setParmName("group1");
        parmValue = new Value();
        parmValue.setContent(testGroups[0]);
        eventParm.setValue(parmValue);
        eventParm = new Parm();
        eventParm.setParmName("group2");
        parmValue = new Value();
        parmValue.setContent(testGroups[1]);
        eventParm.setValue(parmValue);
        eventParm = new Parm();
        eventParm.setParmName("group3");
        parmValue = new Value();
        parmValue.setContent(testGroups[2]);
        eventParm.setValue(parmValue);
        e.setParms(eventParms);
        EventAnticipator ea = new EventAnticipator();
        ea.anticipateEvent(e);
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 www.opennms.org foo: 100 out of 666 tests failed for bar");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        SyslogdTest.assertEquals((int)1, (int)ea.waitForAnticipated(1000L).size());
        Thread.sleep(2000L);
        SyslogdTest.assertEquals((int)0, (int)ea.unanticipatedEvents().size());
        SyslogdTest.assertFalse((boolean)ea.getAnticipatedEvents().isEmpty());
        Event ne = ea.getAnticipatedEvents().iterator().next();
        SyslogdTest.assertEquals((String)"uei.opennms.org/tests/syslogd/regexUeiRewriteTest", (String)ne.getUei());
        SyslogdTest.assertEquals((String)"syslogd", (String)ne.getSource());
        SyslogdTest.assertEquals((String)"The message logged has been removed due to configuration of Syslogd; it may contain sensitive data.", (String)ne.getLogmsg().getContent());
    }

    public void testSubstrDiscard() throws InterruptedException {
        String localhost = this.myLocalHost();
        String testPDU = "2007-01-01 www.opennms.org A JUNK message";
        String testUEI = "DISCARD-MATCHING-MESSAGES";
        String testMsg = "A JUNK message";
        Event e = new Event();
        e.setUei("DISCARD-MATCHING-MESSAGES");
        e.setSource("syslogd");
        e.setInterface(localhost);
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        logmsg.setContent("A JUNK message");
        e.setLogmsg(logmsg);
        EventAnticipator ea = new EventAnticipator();
        ea.anticipateEvent(e);
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 www.opennms.org A JUNK message");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        SyslogdTest.assertEquals((int)1, (int)ea.waitForAnticipated(1000L).size());
        Thread.sleep(2000L);
        SyslogdTest.assertEquals((int)0, (int)ea.unanticipatedEvents().size());
        SyslogdTest.assertFalse((boolean)ea.getAnticipatedEvents().isEmpty());
        Event ne = ea.getAnticipatedEvents().iterator().next();
        SyslogdTest.assertEquals((String)"DISCARD-MATCHING-MESSAGES", (String)ne.getUei());
        SyslogdTest.assertEquals((String)"syslogd", (String)ne.getSource());
        SyslogdTest.assertEquals((String)"A JUNK message", (String)ne.getLogmsg().getContent());
    }

    public void testRegexDiscard() throws InterruptedException {
        String localhost = this.myLocalHost();
        String testPDU = "2007-01-01 www.opennms.org A TrAsH message";
        String testUEI = "DISCARD-MATCHING-MESSAGES";
        String testMsg = "A TrAsH message";
        Event e = new Event();
        e.setUei("DISCARD-MATCHING-MESSAGES");
        e.setSource("syslogd");
        e.setInterface(localhost);
        Logmsg logmsg = new Logmsg();
        logmsg.setDest("logndisplay");
        logmsg.setContent("A TrAsH message");
        e.setLogmsg(logmsg);
        EventAnticipator ea = new EventAnticipator();
        ea.anticipateEvent(e);
        SyslogClient s = null;
        try {
            s = new SyslogClient(null, 10, 7);
            s.syslog(7, "2007-01-01 www.opennms.org A TrAsH message");
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        SyslogdTest.assertEquals((int)1, (int)ea.waitForAnticipated(1000L).size());
        Thread.sleep(2000L);
        SyslogdTest.assertEquals((int)0, (int)ea.unanticipatedEvents().size());
        SyslogdTest.assertFalse((boolean)ea.getAnticipatedEvents().isEmpty());
        Event ne = ea.getAnticipatedEvents().iterator().next();
        SyslogdTest.assertEquals((String)"DISCARD-MATCHING-MESSAGES", (String)ne.getUei());
        SyslogdTest.assertEquals((String)"syslogd", (String)ne.getSource());
        SyslogdTest.assertEquals((String)"A TrAsH message", (String)ne.getLogmsg().getContent());
    }
}

