/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.io.IOException;
import java.util.Properties;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.db.AbstractTransactionalTemporaryDatabaseSpringContextTests;
import org.opennms.netmgt.poller.remote.PollerFrontEnd;
import org.opennms.netmgt.poller.remote.PollerSettings;
import org.opennms.test.DaoTestConfigBean;
import org.opennms.test.FileAnticipator;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyOverrideConfigurer;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PollerFrontEndIntegrationTest
extends AbstractTransactionalTemporaryDatabaseSpringContextTests {
    private DatabasePopulator m_populator;
    private FileAnticipator m_fileAnticipator;
    private PollerFrontEnd m_frontEnd;
    private PollerSettings m_settings;
    private ClassPathXmlApplicationContext m_frontEndContext;

    protected void setUpConfiguration() throws IOException {
        DaoTestConfigBean daoTestConfig = new DaoTestConfigBean();
        daoTestConfig.afterPropertiesSet();
        this.m_fileAnticipator = new FileAnticipator();
        String filename = this.m_fileAnticipator.expecting("remote-poller.configuration").getCanonicalPath();
        filename = filename.replace("+", "%2B");
        System.setProperty("opennms.poller.configuration.resource", "file://" + filename);
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-pollerBackEnd.xml", "classpath:/META-INF/opennms/applicationContext-exportedPollerBackEnd-rmi.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/org/opennms/netmgt/poller/remote/applicationContext-configOverride.xml"};
    }

    protected void runTest() throws Throwable {
        super.runTest();
        if (this.m_fileAnticipator.isInitialized()) {
            this.m_fileAnticipator.deleteExpected();
        }
    }

    protected void onSetUpInTransactionIfEnabled() throws Exception {
        super.onSetUpInTransactionIfEnabled();
        this.getPopulator().populateDatabase();
        this.setComplete();
        this.endTransaction();
        this.m_frontEndContext = new ClassPathXmlApplicationContext(new String[]{"classpath:/META-INF/opennms/applicationContext-remotePollerBackEnd-rmi.xml", "classpath:/META-INF/opennms/applicationContext-pollerFrontEnd.xml"}, false);
        Properties props = new Properties();
        props.setProperty("configCheckTrigger.repeatInterval", "1000");
        PropertyOverrideConfigurer testPropertyConfigurer = new PropertyOverrideConfigurer();
        testPropertyConfigurer.setProperties(props);
        this.m_frontEndContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)testPropertyConfigurer);
        this.m_frontEndContext.refresh();
        this.m_frontEnd = (PollerFrontEnd)this.m_frontEndContext.getBean("pollerFrontEnd");
        this.m_settings = (PollerSettings)this.m_frontEndContext.getBean("pollerSettings");
    }

    protected void onTearDownInTransactionIfEnabled() throws Exception {
        this.m_frontEndContext.stop();
        this.m_frontEndContext.close();
        super.onTearDownInTransactionIfEnabled();
    }

    protected void onTearDownAfterTransaction() throws Exception {
        this.m_fileAnticipator.tearDown();
        super.onTearDownAfterTransaction();
    }

    public void testRegister() throws Exception {
        PollerFrontEndIntegrationTest.assertFalse((boolean)this.m_frontEnd.isRegistered());
        this.m_frontEnd.register("RDU");
        PollerFrontEndIntegrationTest.assertTrue((boolean)this.m_frontEnd.isRegistered());
        Integer monitorId = this.m_settings.getMonitorId();
        PollerFrontEndIntegrationTest.assertEquals((int)1, (int)this.getSimpleJdbcTemplate().queryForInt("select count(*) from location_monitors where id=?", new Object[]{monitorId}));
        PollerFrontEndIntegrationTest.assertEquals((int)5, (int)this.getSimpleJdbcTemplate().queryForInt("select count(*) from location_monitor_details where locationMonitorId = ?", new Object[]{monitorId}));
        PollerFrontEndIntegrationTest.assertEquals((String)System.getProperty("os.name"), (String)((String)this.getSimpleJdbcTemplate().queryForObject("select propertyValue from location_monitor_details where locationMonitorId = ? and property = ?", String.class, new Object[]{monitorId, "os.name"})));
        Thread.sleep(60000L);
        PollerFrontEndIntegrationTest.assertEquals((int)0, (int)this.getSimpleJdbcTemplate().queryForInt("select count(*) from location_monitors where status='DISCONNECTED' and id=?", new Object[]{monitorId}));
        PollerFrontEndIntegrationTest.assertTrue((String)"Could not find any pollResults", (0 < this.getSimpleJdbcTemplate().queryForInt("select count(*) from location_specific_status_changes where locationMonitorId = ?", new Object[]{monitorId}) ? 1 : 0) != 0);
        this.m_frontEnd.stop();
    }

    public DatabasePopulator getPopulator() {
        return this.m_populator;
    }

    public void setPopulator(DatabasePopulator populator) {
        this.m_populator = populator;
    }
}

