/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.remote;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.db.OpenNMSConfigurationExecutionListener;
import org.opennms.netmgt.dao.db.TemporaryDatabaseExecutionListener;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.remote.PollerBackEnd;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.test.context.support.DirtiesContextTestExecutionListener;
import org.springframework.test.context.transaction.TransactionalTestExecutionListener;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=SpringJUnit4ClassRunner.class)
@TestExecutionListeners(value={OpenNMSConfigurationExecutionListener.class, TemporaryDatabaseExecutionListener.class, DependencyInjectionTestExecutionListener.class, DirtiesContextTestExecutionListener.class, TransactionalTestExecutionListener.class})
@ContextConfiguration(locations={"classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-pollerBackEnd.xml", "classpath:/META-INF/opennms/applicationContext-exportedPollerBackEnd-rmi.xml", "classpath:/org/opennms/netmgt/poller/remote/applicationContext-configOverride.xml"})
@JUnitTemporaryDatabase
public class PollerBackEndIntegrationTest {
    @Autowired
    PollerBackEnd m_backEnd;
    @Autowired
    SessionFactory m_sessionFactory;
    @Autowired
    JdbcTemplate m_jdbcTemplate;

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
    }

    @Test
    @Transactional
    public void testRegister() {
        Collection locations = this.m_backEnd.getMonitoringLocations();
        Assert.assertNotNull((String)"locations list should not be null", (Object)locations);
        Assert.assertFalse((String)"locations list should not be empty", (boolean)locations.isEmpty());
        int initialCount = this.queryForInt("select count(*) from location_monitors", new Object[0]);
        for (OnmsMonitoringLocationDefinition location : locations) {
            int locationMonitorId = this.m_backEnd.registerLocationMonitor(location.getName());
            Assert.assertTrue((locationMonitorId > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"REGISTERED", (Object)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
        }
        Assert.assertEquals((long)(initialCount + locations.size()), (long)this.m_jdbcTemplate.queryForInt("select count(*) from location_monitors"));
    }

    @Test
    @Transactional
    public void testPollingStarted() {
        int locationMonitorId = this.m_backEnd.registerLocationMonitor("RDU");
        this.m_backEnd.pollerStarting(locationMonitorId, this.getPollerDetails());
        Assert.assertEquals((Object)"STARTED", (Object)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
        Assert.assertEquals((long)2L, (long)this.queryForInt("select count(*) from location_monitor_details where locationMonitorId = ?", locationMonitorId));
        Assert.assertEquals((Object)"WonkaOS", (Object)this.queryForString("select propertyValue from location_monitor_details where locationMonitorId = ? and property = ?", locationMonitorId, "os.name"));
    }

    @Test
    @Transactional
    public void testPollingStopped() {
        int locationMonitorId = this.m_backEnd.registerLocationMonitor("RDU");
        this.m_backEnd.pollerStarting(locationMonitorId, this.getPollerDetails());
        Assert.assertEquals((Object)"STARTED", (Object)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
        this.m_backEnd.pollerStopping(locationMonitorId);
        Assert.assertEquals((Object)"STOPPED", (Object)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
    }

    @Test
    @Transactional
    public void testPollerDisconnected() throws Exception {
        int locationMonitorId = this.m_backEnd.registerLocationMonitor("RDU");
        this.m_backEnd.pollerStarting(locationMonitorId, this.getPollerDetails());
        Assert.assertEquals((Object)"STARTED", (Object)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
        Thread.sleep(1500L);
        this.m_backEnd.checkForDisconnectedMonitors();
        Assert.assertEquals((Object)"STARTED", (Object)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
        Thread.sleep(2000L);
        this.m_backEnd.checkForDisconnectedMonitors();
        Assert.assertEquals((Object)"DISCONNECTED", (Object)this.queryForString("select status from location_monitors where id = ?", locationMonitorId));
    }

    @Test
    @Transactional
    public void testGetServiceMonitorLocators() {
        Collection results = this.m_backEnd.getServiceMonitorLocators(DistributionContext.REMOTE_MONITOR);
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((results.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    @Transactional
    public void testReportResults() throws InterruptedException {
        this.m_jdbcTemplate.execute("INSERT INTO node (nodeId, nodeCreateTime) VALUES (1, now())");
        this.m_jdbcTemplate.execute("INSERT INTO ipInterface (id, nodeId, ipAddr)  VALUES (1, 1, '192.168.1.1')");
        this.m_jdbcTemplate.execute("INSERT INTO service (serviceId, serviceName) VALUES (1, 'HTTP')");
        this.m_jdbcTemplate.execute("INSERT INTO ifServices (id, nodeId, ipAddr, serviceId, ipInterfaceId) VALUES (1, 1, '192.168.1.1', 1, 1)");
        int locationMonitorId = this.m_backEnd.registerLocationMonitor("RDU");
        int serviceId = this.findServiceId();
        String ipAddr = this.queryForString("select ipaddr from ifservices where id = ?", serviceId);
        File rrdFile = new File("target/test-data/distributed/" + locationMonitorId + "/" + ipAddr + "/http" + RrdUtils.getExtension());
        if (rrdFile.exists()) {
            rrdFile.delete();
        }
        Assert.assertFalse((boolean)rrdFile.exists());
        this.m_backEnd.reportResult(locationMonitorId, serviceId, PollStatus.available((Double)1234.0));
        Thread.sleep(1000L);
        this.m_backEnd.reportResult(locationMonitorId, serviceId, PollStatus.unavailable());
        Assert.assertEquals((long)2L, (long)this.queryForInt("select count(*) from location_specific_status_changes where locationMonitorId = ?", locationMonitorId));
        Assert.assertTrue((String)("rrd file doesn't exist at " + rrdFile.getAbsolutePath()), (boolean)rrdFile.exists());
    }

    private int findServiceId() {
        return this.m_jdbcTemplate.queryForInt("select id from ifservices, service where ifservices.serviceid = service.serviceid and service.servicename='HTTP' limit 1");
    }

    private void flush() {
        this.m_sessionFactory.getCurrentSession().flush();
    }

    private String queryForString(String sql, Object ... args) {
        this.flush();
        return (String)this.m_jdbcTemplate.queryForObject(sql, args, String.class);
    }

    public int queryForInt(String sql, Object ... args) {
        this.flush();
        return this.m_jdbcTemplate.queryForInt(sql, args);
    }

    public Map<String, String> getPollerDetails() {
        HashMap<String, String> pollerDetails = new HashMap<String, String>();
        pollerDetails.put("os.name", "WonkaOS");
        pollerDetails.put("os.version", "1.2.3");
        return pollerDetails;
    }
}

