/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.net.InetAddress;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.sql.DataSource;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.resource.Vault;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Rrd;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockEventIpcManager;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.pollables.LatencyStoringServiceMonitorAdaptor;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.test.mock.MockLogAppender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatencyStoringServiceMonitorAdaptorTest {
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private PollerConfig m_pollerConfig = (PollerConfig)this.m_mocks.createMock(PollerConfig.class);
    private RrdStrategy m_rrdStrategy = (RrdStrategy)this.m_mocks.createMock(RrdStrategy.class);

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        RrdTestUtils.initializeNullStrategy();
        RrdUtils.setStrategy((RrdStrategy)this.m_rrdStrategy);
    }

    @After
    public void tearDown() throws Throwable {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testUpdateRrdWithLocaleThatUsesCommasForDecimals() throws Exception {
        Locale.setDefault(Locale.FRENCH);
        NumberFormat nf = NumberFormat.getInstance();
        Assert.assertEquals((String)("ensure that the newly set default locale (" + Locale.getDefault() + ") uses ',' as the decimal marker"), (Object)"1,5", (Object)nf.format(1.5));
        LatencyStoringServiceMonitorAdaptor adaptor = new LatencyStoringServiceMonitorAdaptor(null, this.m_pollerConfig, new Package());
        LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
        map.put("cheese", 1.5);
        EasyMock.expect((Object)this.m_pollerConfig.getStep((Package)EasyMock.isA(Package.class))).andReturn((Object)0).anyTimes();
        EasyMock.expect((Object)this.m_pollerConfig.getRRAList((Package)EasyMock.isA(Package.class))).andReturn(new ArrayList(0));
        EasyMock.expect((Object)this.m_rrdStrategy.getDefaultFileExtension()).andReturn((Object)".rrd").anyTimes();
        EasyMock.expect((Object)this.m_rrdStrategy.createDefinition((String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), EasyMock.anyInt(), LatencyStoringServiceMonitorAdaptorTest.isAList(RrdDataSource.class), LatencyStoringServiceMonitorAdaptorTest.isAList(String.class))).andReturn(new Object());
        this.m_rrdStrategy.createFile(EasyMock.isA(Object.class));
        EasyMock.expect((Object)this.m_rrdStrategy.openFile((String)EasyMock.isA(String.class))).andReturn(new Object());
        this.m_rrdStrategy.updateFile(EasyMock.isA(Object.class), (String)EasyMock.isA(String.class), EasyMock.endsWith((String)":1.5"));
        this.m_rrdStrategy.closeFile(EasyMock.isA(Object.class));
        this.m_mocks.replayAll();
        adaptor.updateRRD("foo", InetAddress.getLocalHost(), "baz", map);
        this.m_mocks.verifyAll();
    }

    @Test
    public void testThresholds() throws Exception {
        System.setProperty("opennms.home", "src/test/resources");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("rrd-repository", "/tmp");
        parameters.put("ds-name", "icmp");
        parameters.put("rrd-base-name", "icmp");
        parameters.put("thresholding-enabled", "true");
        FilterDao filterDao = (FilterDao)this.m_mocks.createMock(FilterDao.class);
        EasyMock.expect((Object)filterDao.getIPList((String)EasyMock.anyObject())).andReturn(Collections.singletonList("127.0.0.1")).anyTimes();
        FilterDaoFactory.setInstance((FilterDao)filterDao);
        MonitoredService svc = (MonitoredService)this.m_mocks.createMock(MonitoredService.class);
        EasyMock.expect((Object)svc.getNodeId()).andReturn((Object)1);
        EasyMock.expect((Object)svc.getIpAddr()).andReturn((Object)"127.0.0.1");
        EasyMock.expect((Object)svc.getAddress()).andReturn((Object)InetAddress.getByName("127.0.0.1"));
        EasyMock.expect((Object)svc.getSvcName()).andReturn((Object)"ICMP");
        ServiceMonitor service = (ServiceMonitor)this.m_mocks.createMock(ServiceMonitor.class);
        PollStatus value = PollStatus.get((int)1, (Double)100.0);
        EasyMock.expect((Object)service.poll(svc, parameters)).andReturn((Object)value);
        int step = 300;
        List<String> rras = Collections.singletonList("RRA:AVERAGE:0.5:1:2016");
        Package pkg = new Package();
        Rrd rrd = new Rrd();
        rrd.setStep(step);
        rrd.setRra(rras);
        pkg.setRrd(rrd);
        EasyMock.expect((Object)this.m_pollerConfig.getRRAList(pkg)).andReturn(rras);
        EasyMock.expect((Object)this.m_pollerConfig.getStep(pkg)).andReturn((Object)step).anyTimes();
        EasyMock.expect((Object)this.m_rrdStrategy.getDefaultFileExtension()).andReturn((Object)".rrd").anyTimes();
        EasyMock.expect((Object)this.m_rrdStrategy.createDefinition((String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), (String)EasyMock.isA(String.class), EasyMock.anyInt(), LatencyStoringServiceMonitorAdaptorTest.isAList(RrdDataSource.class), LatencyStoringServiceMonitorAdaptorTest.isAList(String.class))).andReturn(new Object());
        this.m_rrdStrategy.createFile(EasyMock.isA(Object.class));
        EasyMock.expect((Object)this.m_rrdStrategy.openFile((String)EasyMock.isA(String.class))).andReturn(new Object());
        this.m_rrdStrategy.updateFile(EasyMock.isA(Object.class), (String)EasyMock.isA(String.class), EasyMock.endsWith((String)":100"));
        this.m_rrdStrategy.closeFile(EasyMock.isA(Object.class));
        EventAnticipator anticipator = new EventAnticipator();
        MockEventIpcManager eventMgr = new MockEventIpcManager();
        eventMgr.setEventAnticipator(anticipator);
        eventMgr.setSynchronous(true);
        MockEventIpcManager eventdIpcMgr = eventMgr;
        EventIpcManagerFactory.setIpcManager((EventIpcManager)eventdIpcMgr);
        MockNetwork network = new MockNetwork();
        network.setCriticalService("ICMP");
        network.addNode(1, "testNode");
        network.addInterface("127.0.0.1");
        network.setIfAlias("eth0");
        network.addService("ICMP");
        network.addService("SNMP");
        MockDatabase db = new MockDatabase();
        db.populate(network);
        db.update("update snmpinterface set snmpifname=?, snmpifdescr=? where id=?", new Object[]{"eth0", "eth0", 1});
        DataSourceFactory.setInstance((DataSource)((Object)db));
        Vault.setDataSource((DataSource)((Object)db));
        Event event = new Event();
        event.setUei("uei.opennms.org/threshold/highThresholdExceeded");
        event.setNodeid(1L);
        event.setInterface("127.0.0.1");
        event.setService("ICMP");
        anticipator.anticipateEvent(event);
        this.m_mocks.replayAll();
        LatencyStoringServiceMonitorAdaptor adaptor = new LatencyStoringServiceMonitorAdaptor(service, this.m_pollerConfig, pkg);
        adaptor.poll(svc, parameters);
        this.m_mocks.verifyAll();
        anticipator.verifyAnticipated();
    }

    private static <T> List<T> isAList(Class<T> clazz) {
        return (List)EasyMock.isA(List.class);
    }
}

