/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.mock;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.poller.pollables.PendingPollEvent;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.mock.MockUtil;

public class MockPollContext
implements PollContext,
EventListener {
    private String m_critSvcName;
    private boolean m_nodeProcessingEnabled;
    private boolean m_pollingAllIfCritServiceUndefined;
    private boolean m_serviceUnresponsiveEnabled;
    private EventIpcManager m_eventMgr;
    private MockDatabase m_db;
    private MockNetwork m_mockNetwork;
    private List<PendingPollEvent> m_pendingPollEvents = new LinkedList<PendingPollEvent>();

    public String getCriticalServiceName() {
        return this.m_critSvcName;
    }

    public void setCriticalServiceName(String svcName) {
        this.m_critSvcName = svcName;
    }

    public boolean isNodeProcessingEnabled() {
        return this.m_nodeProcessingEnabled;
    }

    public void setNodeProcessingEnabled(boolean nodeProcessingEnabled) {
        this.m_nodeProcessingEnabled = nodeProcessingEnabled;
    }

    public boolean isPollingAllIfCritServiceUndefined() {
        return this.m_pollingAllIfCritServiceUndefined;
    }

    public void setPollingAllIfCritServiceUndefined(boolean pollingAllIfCritServiceUndefined) {
        this.m_pollingAllIfCritServiceUndefined = pollingAllIfCritServiceUndefined;
    }

    public void setEventMgr(EventIpcManager eventMgr) {
        if (this.m_eventMgr != null) {
            this.m_eventMgr.removeEventListener((EventListener)this);
        }
        this.m_eventMgr = eventMgr;
        if (this.m_eventMgr != null) {
            this.m_eventMgr.addEventListener((EventListener)this);
        }
    }

    public void setDatabase(MockDatabase db) {
        this.m_db = db;
    }

    public void setMockNetwork(MockNetwork network) {
        this.m_mockNetwork = network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollEvent sendEvent(Event event) {
        PendingPollEvent pollEvent = new PendingPollEvent(event);
        MockPollContext mockPollContext = this;
        synchronized (mockPollContext) {
            this.m_pendingPollEvents.add(pollEvent);
        }
        this.m_eventMgr.sendNow(event);
        return pollEvent;
    }

    public Event createEvent(String uei, int nodeId, InetAddress address, String svcName, Date date, String reason) {
        EventBuilder e = MockEventUtil.createEventBuilder((String)"Test", (String)uei, (int)nodeId, (String)(address == null ? null : address.getHostAddress()), (String)svcName, (String)reason);
        e.setCreationTime(date);
        e.setTime(date);
        return e.getEvent();
    }

    public void openOutage(final PollableService pSvc, final PollEvent svcLostEvent) {
        Runnable r = new Runnable(){

            public void run() {
                MockPollContext.this.writeOutage(pSvc, svcLostEvent);
            }
        };
        if (svcLostEvent instanceof PendingPollEvent) {
            ((PendingPollEvent)svcLostEvent).addPending(r);
        } else {
            r.run();
        }
    }

    private void writeOutage(PollableService pSvc, PollEvent svcLostEvent) {
        MockService mSvc = this.m_mockNetwork.getService(pSvc.getNodeId(), pSvc.getIpAddr(), pSvc.getSvcName());
        Timestamp eventTime = this.m_db.convertEventTimeToTimeStamp(EventConstants.formatToString((Date)svcLostEvent.getDate()));
        MockUtil.println((String)("Opening Outage for " + mSvc));
        this.m_db.createOutage(mSvc, svcLostEvent.getEventId(), eventTime);
    }

    public void resolveOutage(final PollableService pSvc, final PollEvent svcRegainEvent) {
        Runnable r = new Runnable(){

            public void run() {
                MockPollContext.this.closeOutage(pSvc, svcRegainEvent);
            }
        };
        if (svcRegainEvent instanceof PendingPollEvent) {
            ((PendingPollEvent)svcRegainEvent).addPending(r);
        } else {
            r.run();
        }
    }

    public void closeOutage(PollableService pSvc, PollEvent svcRegainEvent) {
        MockService mSvc = this.m_mockNetwork.getService(pSvc.getNodeId(), pSvc.getIpAddr(), pSvc.getSvcName());
        Timestamp eventTime = this.m_db.convertEventTimeToTimeStamp(EventConstants.formatToString((Date)svcRegainEvent.getDate()));
        MockUtil.println((String)("Resolving Outage for " + mSvc));
        this.m_db.resolveOutage(mSvc, svcRegainEvent.getEventId(), eventTime);
    }

    public void reparentOutages(String ipAddr, int oldNodeId, int newNodeId) {
        this.m_db.update("update outages set nodeId = ? where nodeId = ? and ipaddr = ?", new Object[]{newNodeId, oldNodeId, ipAddr});
    }

    public boolean isServiceUnresponsiveEnabled() {
        return this.m_serviceUnresponsiveEnabled;
    }

    public void setServiceUnresponsiveEnabled(boolean serviceUnresponsiveEnabled) {
        this.m_serviceUnresponsiveEnabled = serviceUnresponsiveEnabled;
    }

    public String getName() {
        return "MockPollContext";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onEvent(Event e) {
        List<PendingPollEvent> list = this.m_pendingPollEvents;
        synchronized (list) {
            PendingPollEvent pollEvent2;
            for (PendingPollEvent pollEvent2 : this.m_pendingPollEvents) {
                if (!e.equals(pollEvent2.getEvent())) continue;
                pollEvent2.complete(e);
            }
            Iterator<PendingPollEvent> it = this.m_pendingPollEvents.iterator();
            while (it.hasNext() && !(pollEvent2 = it.next()).isPending()) {
                pollEvent2.processPending();
                it.remove();
            }
        }
    }
}

