/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.notifd.BroadcastEventProcessor;
import org.opennms.netmgt.notifd.NotificationsTestCase;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Logmsg;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;

public class BroadcastEventProcessorTest
extends NotificationsTestCase {
    private BroadcastEventProcessor m_processor;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.m_processor = new BroadcastEventProcessor();
        this.m_processor.initExpandRe();
        this.m_anticipator.setExpectedDifference(3000L);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown(true);
    }

    @Test
    public void testExpandNotifParms() throws Exception {
        String expandResult = BroadcastEventProcessor.expandNotifParms((String)"%foo%", new TreeMap());
        Assert.assertEquals((Object)"%foo%", (Object)expandResult);
        expandResult = BroadcastEventProcessor.expandNotifParms((String)"Notice %noticeid%: Disk threshold exceeded on %nodelabel%: %parm[all]%.", new TreeMap());
        Assert.assertEquals((Object)"Notice %noticeid%: Disk threshold exceeded on %nodelabel%: %parm[all]%.", (Object)expandResult);
        Event event = new Event();
        event.setUei("uei.opennms.org/threshold/highThresholdExceeded");
        event.setDescr("High threshold exceeded for %service% datasource %parm[ds]% on interface %interface%, parms: %parm[all]%");
        Logmsg logmsg = new Logmsg();
        logmsg.setContent("High threshold exceeded for %service% datasource %parm[ds]% on interface %interface%, parms: %parm[all]%");
        logmsg.setNotify(true);
        event.setLogmsg(logmsg);
        event.setNodeid(0L);
        event.setInterface("0.0.0.0");
        Parms parms = new Parms();
        Parm parm = new Parm();
        parm.setParmName("ds");
        Value value = new Value();
        value.setContent("dsk-usr-pcent");
        parm.setValue(value);
        parms.addParm(parm);
        parm = new Parm();
        parm.setParmName("value");
        value = new Value();
        value.setContent("Crap! There's only 15% free on the SAN and we need 20%! RUN AWAY!");
        parm.setValue(value);
        parms.addParm(parm);
        parm = new Parm();
        parm.setParmName("threshold");
        value = new Value();
        value.setContent("");
        parm.setValue(value);
        parms.addParm(parm);
        parm = new Parm();
        parm.setParmName("trigger");
        value = new Value();
        value.setContent("");
        parm.setValue(value);
        parms.addParm(parm);
        parm = new Parm();
        parm.setParmName("rearm");
        value = new Value();
        value.setContent("");
        parm.setValue(value);
        parms.addParm(parm);
        parm = new Parm();
        parm.setParmName("label");
        value = new Value();
        value.setContent("");
        parm.setValue(value);
        parms.addParm(parm);
        parm = new Parm();
        parm.setParmName("ifIndex");
        value = new Value();
        value.setContent("");
        parm.setValue(value);
        parms.addParm(parm);
        event.setParms(parms);
        Notification[] notifications = null;
        notifications = this.m_notificationManager.getNotifForEvent(null);
        Assert.assertNull((Object)notifications);
        notifications = this.m_notificationManager.getNotifForEvent(event);
        Assert.assertNotNull((Object)notifications);
        Assert.assertEquals((long)1L, (long)notifications.length);
        Map paramMap = BroadcastEventProcessor.buildParameterMap((Notification)notifications[0], (Event)event, (int)9999);
        Assert.assertEquals((Object)"High disk Threshold exceeded on 0.0.0.0, dsk-usr-pcent with Crap! There's only 15% free on the SAN and we need 20%! RUN AWAY!", paramMap.get("-tm"));
        expandResult = BroadcastEventProcessor.expandNotifParms((String)"Notice #%noticeid%: Disk threshold exceeded on %nodelabel%: %parm[all]%.", (Map)paramMap);
        Assert.assertEquals((Object)"Notice #9999: Disk threshold exceeded on %nodelabel%: %parm[all]%.", (Object)expandResult);
    }

    @Test
    public void testExpandNoticeId_Bug1745() throws Exception {
        MockService svc = this.m_network.getService(1, "192.168.1.1", "ICMP");
        Event event = MockEventUtil.createServiceEvent((String)"Test", (String)"uei.opennms.org/test/noticeIdExpansion", (MockService)svc, null);
        String antNID = Integer.toString(this.m_notificationManager.getNoticeId() + 1);
        Date testDate = new Date();
        long finishedNotifs = this.anticipateNotificationsForGroup("notification '" + antNID + "'", "Notification '" + antNID + "'", "InitialGroup", testDate, 0L);
        MockEventUtil.setEventTime((Event)event, (Date)testDate);
        this.m_eventMgr.sendEventToListeners(event);
        this.verifyAnticipated(finishedNotifs, 1000L);
    }
}

