/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.mock.EventWrapper;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.mock.Outage;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.mock.MockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutageAnticipator
implements EventListener {
    private final MockDatabase m_db;
    private int m_expectedOpenCount;
    private int m_expectedOutageCount;
    private final Map<EventWrapper, List<Outage>> m_pendingOpens = new HashMap<EventWrapper, List<Outage>>();
    private final Map<EventWrapper, List<Outage>> m_pendingCloses = new HashMap<EventWrapper, List<Outage>>();
    private final Set<Outage> m_expectedOutages = new HashSet<Outage>();

    public OutageAnticipator(MockDatabase db) {
        this.m_db = db;
        this.reset();
    }

    public synchronized void reset() {
        this.m_expectedOpenCount = this.m_db.countOpenOutages();
        this.m_expectedOutageCount = this.m_db.countOutages();
        this.m_expectedOutages.clear();
        this.m_expectedOutages.addAll(this.m_db.getOutages());
    }

    public synchronized void anticipateOutageOpened(MockElement element, final Event lostService) {
        MockVisitorAdapter outageCounter = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                if (!OutageAnticipator.this.m_db.hasOpenOutage(svc) || OutageAnticipator.this.anticipatesClose(svc)) {
                    OutageAnticipator.this.m_expectedOpenCount++;
                    OutageAnticipator.this.m_expectedOutageCount++;
                    Outage outage = new Outage(svc);
                    MockUtil.println((String)("Anticipating outage open: " + outage));
                    OutageAnticipator.this.addToOutageList(OutageAnticipator.this.m_pendingOpens, lostService, outage);
                }
            }
        };
        element.visit((MockVisitor)outageCounter);
    }

    protected synchronized boolean anticipatesClose(MockService svc) {
        return this.anticipates(this.m_pendingCloses, svc);
    }

    private synchronized boolean anticipates(Map<EventWrapper, List<Outage>> pending, MockService svc) {
        for (List<Outage> outageList : pending.values()) {
            for (Outage outage : outageList) {
                if (!outage.isForService(svc)) continue;
                return true;
            }
        }
        return false;
    }

    protected synchronized void addToOutageList(Map<EventWrapper, List<Outage>> outageMap, Event outageEvent, Outage outage) {
        EventWrapper w = new EventWrapper(outageEvent);
        List<Outage> list = outageMap.get(w);
        if (list == null) {
            list = new LinkedList<Outage>();
            outageMap.put(w, list);
        }
        list.add(outage);
    }

    protected synchronized void removeFromOutageList(Map<EventWrapper, List<Outage>> outageMap, Event outageEvent, Outage outage) {
        EventWrapper w = new EventWrapper(outageEvent);
        List<Outage> list = outageMap.get(w);
        if (list == null) {
            return;
        }
        list.remove(outage);
    }

    public synchronized void deanticipateOutageClosed(MockElement element, final Event regainService) {
        MockVisitorAdapter outageCounter = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                if (OutageAnticipator.this.anticipatesClose(svc)) {
                    OutageAnticipator.this.m_expectedOpenCount++;
                    for (Outage outage : OutageAnticipator.this.m_db.getOpenOutages(svc)) {
                        MockUtil.println((String)("Deanticipating outage closed: " + outage));
                        OutageAnticipator.this.removeFromOutageList(OutageAnticipator.this.m_pendingCloses, regainService, outage);
                    }
                }
            }
        };
        element.visit((MockVisitor)outageCounter);
    }

    public synchronized void anticipateOutageClosed(MockElement element, final Event regainService) {
        MockVisitorAdapter outageCounter = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                if ((OutageAnticipator.this.m_db.hasOpenOutage(svc) || OutageAnticipator.this.anticipatesOpen(svc)) && !OutageAnticipator.this.anticipatesClose(svc)) {
                    OutageAnticipator.this.m_expectedOpenCount--;
                    for (Outage outage : OutageAnticipator.this.m_db.getOpenOutages(svc)) {
                        MockUtil.println((String)("Anticipating outage closed: " + outage));
                        OutageAnticipator.this.addToOutageList(OutageAnticipator.this.m_pendingCloses, regainService, outage);
                    }
                }
            }
        };
        element.visit((MockVisitor)outageCounter);
    }

    protected boolean anticipatesOpen(MockService svc) {
        return this.anticipates(this.m_pendingOpens, svc);
    }

    public int getExpectedOpens() {
        return this.m_expectedOpenCount;
    }

    public int getActualOpens() {
        return this.m_db.countOpenOutages();
    }

    public int getExpectedOutages() {
        return this.m_expectedOutageCount;
    }

    public int getActualOutages() {
        return this.m_db.countOutages();
    }

    public synchronized boolean checkAnticipated() {
        int openCount = this.m_db.countOpenOutages();
        int outageCount = this.m_db.countOutages();
        if (openCount != this.m_expectedOpenCount || outageCount != this.m_expectedOutageCount) {
            return false;
        }
        if (this.m_pendingOpens.size() != 0 || this.m_pendingCloses.size() != 0) {
            return false;
        }
        HashSet<Outage> currentOutages = new HashSet<Outage>(this.m_db.getOutages());
        if (!((Object)this.m_expectedOutages).equals(currentOutages)) {
            for (Outage expectedOutage : this.m_expectedOutages) {
                if (currentOutages.contains(expectedOutage)) {
                    currentOutages.remove(expectedOutage);
                    continue;
                }
                this.log().warn("Expected outage " + expectedOutage.toDetailedString() + " not in current Set");
            }
            for (Outage unexpectedOutage : currentOutages) {
                this.log().warn("Unexpected outage " + unexpectedOutage.toDetailedString() + " in database");
            }
            return false;
        }
        return true;
    }

    public String getName() {
        return "OutageAnticipator";
    }

    public synchronized void onEvent(Event e) {
        for (Outage outage : this.getOutageList(this.m_pendingOpens, e)) {
            outage.setLostEvent(e.getDbid(), MockEventUtil.convertEventTimeIntoTimestamp((String)e.getTime()));
            this.m_expectedOutages.add(outage);
        }
        this.clearOutageList(this.m_pendingOpens, e);
        for (Outage outage : this.getOutageList(this.m_pendingCloses, e)) {
            this.closeExpectedOutages(e, outage);
        }
        this.clearOutageList(this.m_pendingCloses, e);
    }

    private synchronized void closeExpectedOutages(Event e, Outage pendingOutage) {
        for (Outage outage : this.m_expectedOutages) {
            if (!pendingOutage.equals(outage)) continue;
            outage.setRegainedEvent(e.getDbid(), MockEventUtil.convertEventTimeIntoTimestamp((String)e.getTime()));
        }
    }

    private synchronized void clearOutageList(Map<EventWrapper, List<Outage>> pending, Event e) {
        pending.remove(new EventWrapper(e));
    }

    private synchronized List<Outage> getOutageList(Map<EventWrapper, List<Outage>> pending, Event e) {
        EventWrapper w = new EventWrapper(e);
        if (pending.containsKey(w)) {
            return pending.get(w);
        }
        return new ArrayList<Outage>(0);
    }

    public void anticipateReparent(String ipAddr, int nodeId, int nodeId2) {
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(OutageAnticipator.class);
    }
}

