/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.opennms.netmgt.config.EventConfDao;
import org.opennms.netmgt.config.EventdConfigManager;
import org.opennms.netmgt.eventd.EventIpcBroadcaster;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventIpcManagerProxy;
import org.opennms.netmgt.eventd.processor.EventExpander;
import org.opennms.netmgt.mock.EventAnticipator;
import org.opennms.netmgt.mock.EventWrapper;
import org.opennms.netmgt.mock.EventWriter;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Log;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.test.mock.MockUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockEventIpcManager
implements EventIpcManager,
EventIpcBroadcaster,
InitializingBean {
    private EventAnticipator m_anticipator;
    private EventWriter m_eventWriter = new EventWriter(){

        public void writeEvent(org.opennms.netmgt.xml.event.Event e) {
        }
    };
    private List<ListenerKeeper> m_listeners = new ArrayList<ListenerKeeper>();
    private int m_pendingEvents;
    private int m_eventDelay = 20;
    private boolean m_synchronous = true;
    private ScheduledExecutorService m_scheduler = null;
    private EventIpcManagerProxy m_proxy;

    public MockEventIpcManager() {
        this.m_anticipator = new EventAnticipator();
    }

    public void addEventListener(EventListener listener) {
        this.m_listeners.add(new ListenerKeeper(listener, null));
    }

    public void addEventListener(EventListener listener, Collection<String> ueis) {
        this.m_listeners.add(new ListenerKeeper(listener, new HashSet<String>(ueis)));
    }

    public void addEventListener(EventListener listener, String uei) {
        this.m_listeners.add(new ListenerKeeper(listener, Collections.singleton(uei)));
    }

    public void broadcastNow(org.opennms.netmgt.xml.event.Event event) {
        MockUtil.println((String)("Sending: " + new EventWrapper(event)));
        ArrayList<ListenerKeeper> listeners = new ArrayList<ListenerKeeper>(this.m_listeners);
        for (ListenerKeeper k : listeners) {
            k.sendEventIfAppropriate(event);
        }
    }

    public void setEventWriter(EventWriter eventWriter) {
        this.m_eventWriter = eventWriter;
    }

    public EventAnticipator getEventAnticipator() {
        return this.m_anticipator;
    }

    public void setEventAnticipator(EventAnticipator anticipator) {
        this.m_anticipator = anticipator;
    }

    public void removeEventListener(EventListener listener) {
        this.m_listeners.remove(new ListenerKeeper(listener, null));
    }

    public void removeEventListener(EventListener listener, Collection<String> ueis) {
        this.m_listeners.remove(new ListenerKeeper(listener, new HashSet<String>(ueis)));
    }

    public void removeEventListener(EventListener listener, String uei) {
        this.m_listeners.remove(new ListenerKeeper(listener, Collections.singleton(uei)));
    }

    public void setEventDelay(int millis) {
        this.m_eventDelay = millis;
    }

    public void sendEventToListeners(org.opennms.netmgt.xml.event.Event event) {
        this.m_eventWriter.writeEvent(event);
        this.broadcastNow(event);
    }

    public void setSynchronous(boolean syncState) {
        this.m_synchronous = syncState;
    }

    public boolean isSynchronous() {
        return this.m_synchronous;
    }

    public synchronized void sendNow(final org.opennms.netmgt.xml.event.Event event) {
        EventExpander expander = new EventExpander();
        expander.setEventConfDao((EventConfDao)new EmptyEventConfDao());
        expander.expandEvent(event);
        ++this.m_pendingEvents;
        MockUtil.println((String)("StartEvent processing: m_pendingEvents = " + this.m_pendingEvents));
        MockUtil.println((String)("Received: " + new EventWrapper(event)));
        this.m_anticipator.eventReceived(event);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    MockEventIpcManager.this.m_eventWriter.writeEvent(event);
                    MockEventIpcManager.this.broadcastNow(event);
                    MockEventIpcManager.this.m_anticipator.eventProcessed(event);
                }
                finally {
                    MockEventIpcManager mockEventIpcManager = MockEventIpcManager.this;
                    synchronized (mockEventIpcManager) {
                        MockEventIpcManager.this.m_pendingEvents--;
                        MockUtil.println((String)("Finished processing event m_pendingEvents = " + MockEventIpcManager.this.m_pendingEvents));
                        MockEventIpcManager.this.notifyAll();
                    }
                }
            }
        };
        if (this.isSynchronous()) {
            r.run();
        } else {
            this.getScheduler().schedule(r, (long)this.m_eventDelay, TimeUnit.MILLISECONDS);
        }
    }

    ScheduledExecutorService getScheduler() {
        if (this.m_scheduler == null) {
            this.m_scheduler = Executors.newSingleThreadScheduledExecutor();
        }
        return this.m_scheduler;
    }

    public void sendNow(Log eventLog) {
        for (org.opennms.netmgt.xml.event.Event event : eventLog.getEvents().getEventCollection()) {
            this.sendNow(event);
        }
    }

    public synchronized void finishProcessingEvents() {
        while (this.m_pendingEvents > 0) {
            MockUtil.println((String)("Waiting for event processing: m_pendingEvents = " + this.m_pendingEvents));
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public EventdConfigManager getEventdConfigMgr() {
        return null;
    }

    public void setEventdConfigMgr(EventdConfigManager eventdConfigMgr) {
    }

    public void setDataSource(DataSource instance) {
    }

    public void reset() {
        this.m_listeners = new ArrayList<ListenerKeeper>();
        this.m_anticipator.reset();
    }

    public void setEventIpcManagerProxy(EventIpcManagerProxy proxy) {
        this.m_proxy = proxy;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_proxy, (String)"expected to have proxy set");
        this.m_proxy.setDelegate((EventIpcManager)this);
    }

    public void send(org.opennms.netmgt.xml.event.Event event) throws EventProxyException {
        this.sendNow(event);
    }

    public void send(Log eventLog) throws EventProxyException {
        this.sendNow(eventLog);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyEventConfDao
    implements EventConfDao {
        private EmptyEventConfDao() {
        }

        public void addEvent(Event event) {
        }

        public void addEventToProgrammaticStore(Event event) {
        }

        public Event findByEvent(org.opennms.netmgt.xml.event.Event matchingEvent) {
            return null;
        }

        public Event findByUei(String uei) {
            return null;
        }

        public String getEventLabel(String uei) {
            return null;
        }

        public Map<String, String> getEventLabels() {
            return null;
        }

        public List<String> getEventUEIs() {
            return null;
        }

        public List<Event> getEvents(String uei) {
            return null;
        }

        public List<Event> getEventsByLabel() {
            return null;
        }

        public boolean isSecureTag(String tag) {
            return false;
        }

        public void reload() throws DataAccessException {
        }

        public boolean removeEventFromProgrammaticStore(Event event) {
            return false;
        }

        public void saveCurrent() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ListenerKeeper {
        EventListener m_listener;
        Set<String> m_ueiList;

        ListenerKeeper(EventListener listener, Set<String> ueiList) {
            this.m_listener = listener;
            this.m_ueiList = ueiList;
        }

        public boolean equals(Object o) {
            if (o instanceof ListenerKeeper) {
                ListenerKeeper keeper = (ListenerKeeper)o;
                return this.m_listener.equals(keeper.m_listener) && (this.m_ueiList == null ? keeper.m_ueiList == null : ((Object)this.m_ueiList).equals(keeper.m_ueiList));
            }
            return false;
        }

        private boolean eventMatches(org.opennms.netmgt.xml.event.Event e) {
            if (this.m_ueiList == null) {
                return true;
            }
            return this.m_ueiList.contains(e.getUei());
        }

        public void sendEventIfAppropriate(org.opennms.netmgt.xml.event.Event e) {
            if (this.eventMatches(e)) {
                this.m_listener.onEvent(e);
            }
        }
    }
}

