/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd.datablock;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.core.utils.Base64;
import org.opennms.netmgt.config.DefaultEventConfDao;
import org.opennms.netmgt.config.EventConfDao;
import org.opennms.netmgt.config.EventconfFactory;
import org.opennms.netmgt.eventd.datablock.EventConfData;
import org.opennms.netmgt.mock.EventConfWrapper;
import org.opennms.netmgt.mock.EventWrapper;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Logmsg;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventConfDataTest {
    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging((boolean)false);
        DefaultEventConfDao eventConfDao = new DefaultEventConfDao();
        eventConfDao.setConfigResource((Resource)new FileSystemResource(ConfigurationTestUtils.getFileForResource((Object)this, (String)"eventconf.xml")));
        eventConfDao.afterPropertiesSet();
        EventconfFactory.setInstance((EventConfDao)eventConfDao);
    }

    public void finishUp() {
    }

    @After
    public void tearDown() {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testEventValuePassesMaskValueExactFail() {
        Assert.assertFalse((boolean)EventConfData.eventValuePassesMaskValue((String)"George Clinton, father of funk", Collections.singletonList("George Clinton, teh father of funk")));
    }

    @Test
    public void testEventValuePassesMaskValueExactPass() {
        Assert.assertTrue((boolean)EventConfData.eventValuePassesMaskValue((String)"George Clinton, father of funk", Collections.singletonList("George Clinton, father of funk")));
    }

    @Test
    public void testEventValuePassesMaskValueSubStringFail() {
        Assert.assertFalse((boolean)EventConfData.eventValuePassesMaskValue((String)"George Clinton, teh father of funk", Collections.singletonList("George Clinton, father of %")));
    }

    @Test
    public void testEventValuePassesMaskValueSubStringPass() {
        Assert.assertTrue((boolean)EventConfData.eventValuePassesMaskValue((String)"George Clinton, father of funk", Collections.singletonList("George Clinton, father of %")));
    }

    @Test
    public void testEventValuePassesMaskValueSubStringPassEmpty() {
        Assert.assertTrue((boolean)EventConfData.eventValuePassesMaskValue((String)"", Collections.singletonList("%")));
    }

    @Test
    public void testEventValuePassesMaskValueRegexAnchoredFail() {
        Assert.assertFalse((boolean)EventConfData.eventValuePassesMaskValue((String)"George Clinton, father of funk", Collections.singletonList("~^Bill.*Clinton.*funk$")));
    }

    @Test
    public void testEventValuePassesMaskValueRegexAnchoredPass() {
        Assert.assertTrue((boolean)EventConfData.eventValuePassesMaskValue((String)"George Clinton, father of funk", Collections.singletonList("~^George.*Clinton.*funk$")));
    }

    @Test
    public void testEventValuePassesMaskValueRegexUnanchoredPass() {
        Assert.assertTrue((boolean)EventConfData.eventValuePassesMaskValue((String)"Is FooBar On Air", Collections.singletonList("~.*Foo[Bb]ar.*")));
    }

    @Test
    public void testV1TrapNewSuspect() throws Exception {
        this.anticipateAndSend(null, "v1", null, 6, 1);
    }

    @Test
    public void testV2TrapNewSuspect() throws Exception {
        this.anticipateAndSend(null, "v2c", null, 6, 1);
    }

    @Test
    public void testV1EnterpriseIdAndGenericMatch() throws Exception {
        this.anticipateAndSend("uei.opennms.org/IETF/BGP/traps/bgpEstablished", "v1", ".1.3.6.1.2.1.15.7", 6, 1);
    }

    @Test
    public void testV2EnterpriseIdAndGenericAndSpecificMatch() throws Exception {
        this.anticipateAndSend("uei.opennms.org/IETF/BGP/traps/bgpEstablished", "v2c", ".1.3.6.1.2.1.15.7", 6, 1);
    }

    @Test
    public void testV2EnterpriseIdAndGenericAndSpecificMissWithExtraZeros() throws Exception {
        this.anticipateAndSend(null, "v2c", ".1.3.6.1.2.1.15.7.0.0", 6, 1);
    }

    @Test
    public void testV1EnterpriseIdAndGenericAndSpecificMissWithWrongGeneric() throws Exception {
        this.anticipateAndSend(null, "v1", ".1.3.6.1.2.1.15.7", 5, 1);
    }

    @Test
    public void testV1EnterpriseIdAndGenericAndSpecificMissWithWrongSpecific() throws Exception {
        this.anticipateAndSend(null, "v1", ".1.3.6.1.2.1.15.7", 6, 50);
    }

    @Test
    public void testV1GenericMatch() throws Exception {
        this.anticipateAndSend("uei.opennms.org/generic/traps/SNMP_Cold_Start", "v1", null, 0, 0);
    }

    @Test
    public void testV2GenericMatch() throws Exception {
        this.anticipateAndSend("uei.opennms.org/generic/traps/SNMP_Cold_Start", "v2c", ".1.3.6.1.6.3.1.1.5.1", 0, 0);
    }

    @Test
    public void testV1TrapDroppedEvent() throws Exception {
        this.anticipateAndSend(null, "v1", ".1.3.6.1.2.1.15.7", 6, 2);
    }

    @Test
    public void testV2TrapDroppedEvent() throws Exception {
        this.anticipateAndSend(null, "v2c", ".1.3.6.1.2.1.15.7", 6, 2);
    }

    @Test
    public void testV1TrapDefaultEvent() throws Exception {
        this.anticipateAndSend(null, "v1", null, 6, 1);
    }

    @Test
    public void testV2TrapDefaultEvent() throws Exception {
        this.anticipateAndSend(null, "v2c", null, 6, 1);
    }

    @Test
    public void testV1TrapDroppedIPEvent() throws Exception {
        this.anticipateAndSend(null, "v1", null, 0, 0, "192.168.1.1");
    }

    @Test
    public void testV1TrapNotDroppedIPOffEvent() throws Exception {
        this.anticipateAndSend("uei.opennms.org/generic/traps/SNMP_Cold_Start", "v1", null, 0, 0, "192.168.1.2");
    }

    @Test
    public void testV1TrapDroppedNetwork1Event() throws Exception {
        this.anticipateAndSend(null, "v1", ".1.3.6.1.2.1.15.7", 6, 1, "192.168.1.1");
    }

    @Test
    public void testV1TrapDroppedNetwork2Event() throws Exception {
        this.anticipateAndSend(null, "v1", ".1.3.6.1.2.1.15.7", 6, 1, "192.168.1.2");
    }

    @Test
    public void testV1TrapNotDroppedNetworkOffEvent() throws Exception {
        this.anticipateAndSend("uei.opennms.org/IETF/BGP/traps/bgpEstablished", "v1", ".1.3.6.1.2.1.15.7", 6, 1, "192.168.2.1");
    }

    @Test
    @Ignore(value="This is a test for unwritten functionality.. see comment in test")
    public void testV1EnterpriseIdAndGenericAndSpecificAndMatchWithVarbindsAndTC() throws Exception {
        LinkedHashMap<String, String> varbinds = new LinkedHashMap<String, String>();
        byte[] macAddr = new byte[]{0, 20, -15, -83, -89, 80};
        String encoded = new String(Base64.encodeBase64((byte[])macAddr));
        varbinds.put(".1.3.6.1.4.1.14179.2.6.2.20.0", encoded);
        this.anticipateAndSend("uei.opennms.org/vendor/cisco/bsnAPNoiseProfileUpdatedToPass", "v1", ".1.3.6.1.4.1.14179.2.6.3", 6, 38, "192.168.2.1", varbinds);
    }

    public org.opennms.netmgt.xml.event.Event createEvent(String uei) {
        org.opennms.netmgt.xml.event.Event event = new org.opennms.netmgt.xml.event.Event();
        event.setInterface("127.0.0.1");
        event.setNodeid(0L);
        event.setUei(uei);
        System.out.println("Event created: " + new EventWrapper(event));
        return event;
    }

    public org.opennms.netmgt.xml.event.Event createEvent(String version, String enterprise, int generic, int specific) {
        org.opennms.netmgt.xml.event.Event event = new org.opennms.netmgt.xml.event.Event();
        event.setInterface("127.0.0.1");
        event.setNodeid(0L);
        Snmp snmp = new Snmp();
        snmp.setVersion(version);
        snmp.setId(enterprise);
        snmp.setGeneric(generic);
        snmp.setSpecific(specific);
        event.setSnmp(snmp);
        event.setSnmphost("127.0.0.1");
        return event;
    }

    public org.opennms.netmgt.xml.event.Event createEvent(String version, String enterprise, int generic, int specific, String snmphost) {
        org.opennms.netmgt.xml.event.Event event = this.createEvent(version, enterprise, generic, specific);
        event.setSnmphost(snmphost);
        return event;
    }

    private org.opennms.netmgt.xml.event.Event createEvent(String version, String enterprise, int generic, int specific, String snmphost, LinkedHashMap<String, String> varbinds) {
        org.opennms.netmgt.xml.event.Event event = this.createEvent(version, enterprise, generic, specific, snmphost);
        EventBuilder blder = new EventBuilder(event);
        for (Map.Entry<String, String> entry : varbinds.entrySet()) {
            blder.addParam(entry.getKey(), entry.getValue());
        }
        return blder.getEvent();
    }

    private void anticipateAndSend(String event, String version, String enterprise, int generic, int specific, String snmphost, LinkedHashMap<String, String> varbinds) {
        org.opennms.netmgt.xml.event.Event snmp = this.createEvent(version, enterprise, generic, specific, snmphost, varbinds);
        this.anticipateAndSend(event, snmp);
    }

    public void anticipateAndSend(String event, String version, String enterprise, int generic, int specific) throws Exception {
        org.opennms.netmgt.xml.event.Event snmp = this.createEvent(version, enterprise, generic, specific);
        this.anticipateAndSend(event, snmp);
    }

    public void anticipateAndSend(String event, String version, String enterprise, int generic, int specific, String snmphost) throws Exception {
        org.opennms.netmgt.xml.event.Event snmp = this.createEvent(version, enterprise, generic, specific, snmphost);
        this.anticipateAndSend(event, snmp);
    }

    public void anticipateAndSend(String event, org.opennms.netmgt.xml.event.Event snmp) {
        Event econf = EventconfFactory.getInstance().findByEvent(snmp);
        System.out.println("Eventconf: " + (econf == null ? null : new EventConfWrapper(econf)));
        if (event != null) {
            if (econf == null) {
                Assert.fail((String)("Was expecting to match an eventconf with a UEI of \"" + event + "\", but no matching eventconf was found."));
            } else if (!event.equals(econf.getUei())) {
                Assert.fail((String)("Was expecting to match an eventconf with a UEI of \"" + event + "\", but received an eventconf with a UEI of \"" + econf.getUei() + "\""));
            }
        } else if (econf != null) {
            String dest;
            boolean complain = true;
            Logmsg logmsg = econf.getLogmsg();
            if (logmsg != null && "discardtraps".equals(dest = logmsg.getDest())) {
                complain = false;
            }
            if (complain) {
                Assert.fail((String)("Was not expecting an eventconf, but received an eventconf with an UEI of \"" + econf.getUei() + "\""));
            }
        }
        this.finishUp();
    }
}

