/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.eventd;

import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.OpenNMSTestCase;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.AlarmData;
import org.opennms.test.DaoTestConfigBean;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.jdbc.core.JdbcTemplate;

public class EventdTest
extends OpenNMSTestCase {
    protected void setUp() throws Exception {
        DaoTestConfigBean daoTestConfig = new DaoTestConfigBean();
        daoTestConfig.setRelativeHomeDirectory("src/test/resources");
        daoTestConfig.afterPropertiesSet();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        m_eventd.stop();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    public void testPersistEvent() throws Exception {
        EventdTest.assertEquals((int)0, (int)m_db.countRows("select * from events", new Object[0]));
        MockNode node = m_network.getNode(1);
        this.sendNodeDownEvent(null, node);
        this.sleep(1000L);
        EventdTest.assertEquals((int)1, (int)m_db.countRows("select * from events", new Object[0]));
    }

    public void testPersistEventWithService() throws Exception {
        EventdTest.assertEquals((int)0, (int)m_db.countRows("select * from events", new Object[0]));
        MockNode node = m_network.getNode(1);
        MockInterface intf = node.getInterface("192.168.1.1");
        MockService svc = intf.getService("ICMP");
        this.sendServiceDownEvent(null, svc);
        this.sleep(1000L);
        EventdTest.assertEquals((String)"event count", (int)1, (int)m_db.countRows("select * from events", new Object[0]));
        EventdTest.assertNotSame((String)"service ID for event", (Object)0, (Object)new JdbcTemplate(m_db.getDataSource()).queryForInt("select serviceID from events"));
    }

    private void sendNodeDownEvent(String reductionKey, MockNode node) {
        EventBuilder e = MockEventUtil.createNodeDownEventBuilder((String)"Test", (MockNode)node);
        if (reductionKey != null) {
            AlarmData data = new AlarmData();
            data.setAlarmType(1);
            data.setReductionKey(reductionKey);
            e.setAlarmData(data);
        } else {
            e.setAlarmData(null);
        }
        e.setLogDest("logndisplay");
        e.setLogMessage("testing");
        m_eventdIpcMgr.sendNow(e.getEvent());
    }

    private void sendServiceDownEvent(String reductionKey, MockService svc) {
        EventBuilder e = MockEventUtil.createServiceUnresponsiveEventBuilder((String)"Test", (MockService)svc, (String)"Not responding");
        if (reductionKey != null) {
            AlarmData data = new AlarmData();
            data.setAlarmType(1);
            data.setReductionKey(reductionKey);
            e.setAlarmData(data);
        } else {
            e.setAlarmData(null);
        }
        e.setLogDest("logndisplay");
        e.setLogMessage("testing");
        m_eventdIpcMgr.sendNow(e.getEvent());
    }
}

