/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.XmlrpcdConfigFactory;
import org.opennms.netmgt.config.xmlrpcd.ExternalServers;
import org.opennms.netmgt.config.xmlrpcd.Subscription;
import org.opennms.test.ConfigurationTestUtils;

public class XmlrpcdConfigFactoryTest
extends TestCase {
    public void testReadOldStyleConfiguration() throws MarshalException, ValidationException, IOException {
        XmlrpcdConfigFactory f = new XmlrpcdConfigFactory(ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/etc/xmlrpcd-configuration-old.xml"));
        XmlrpcdConfigFactoryTest.assertEquals((String)"one external server", (int)1, (int)f.getExternalServerCollection().size());
        XmlrpcdConfigFactoryTest.assertEquals((String)"one subscription", (int)1, (int)f.getSubscriptionCollection().size());
        ExternalServers e = (ExternalServers)f.getExternalServerCollection().iterator().next();
        XmlrpcdConfigFactoryTest.assertEquals((String)"one subscription", (int)1, (int)e.getServerSubscriptionCount());
        XmlrpcdConfigFactoryTest.assertTrue((String)"subscription should be autogenerated", (boolean)e.getServerSubscription(0).startsWith("legacyServerSubscription-"));
        Subscription s = (Subscription)f.getSubscriptionCollection().iterator().next();
        XmlrpcdConfigFactoryTest.assertEquals((String)"subscription name matches external-servers entry", (String)e.getServerSubscription(0), (String)s.getName());
        XmlrpcdConfigFactoryTest.assertEquals((String)"subscription should have 6 UEIs", (int)6, (int)s.getSubscribedEventCount());
    }

    public void testReadNewStyleConfiguration() throws MarshalException, ValidationException, IOException {
        XmlrpcdConfigFactory f = new XmlrpcdConfigFactory(ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"/etc/xmlrpcd-configuration-new.xml"));
        ExternalServers e = null;
        Subscription s = null;
        XmlrpcdConfigFactoryTest.assertEquals((String)"number of external-server entries", (int)2, (int)f.getExternalServerCollection().size());
        XmlrpcdConfigFactoryTest.assertEquals((String)"number of subscriptions", (int)3, (int)f.getSubscriptionCollection().size());
        Iterator es = f.getExternalServerCollection().iterator();
        e = (ExternalServers)es.next();
        XmlrpcdConfigFactoryTest.assertEquals((String)"two subscriptions", (int)2, (int)e.getServerSubscriptionCount());
        XmlrpcdConfigFactoryTest.assertTrue((String)"first subscription should be serviceEvents", (boolean)e.getServerSubscription(0).equals("serviceEvents"));
        e = (ExternalServers)es.next();
        XmlrpcdConfigFactoryTest.assertEquals((String)"should have one serverSubscription", (int)1, (int)e.getServerSubscriptionCount());
        XmlrpcdConfigFactoryTest.assertTrue((String)"should be autogenerated", (boolean)e.getServerSubscription(0).startsWith("legacyServerSubscription-"));
        Iterator is = f.getSubscriptionCollection().iterator();
        s = (Subscription)is.next();
        XmlrpcdConfigFactoryTest.assertEquals((String)"first entry is serviceEvents", (String)"serviceEvents", (String)s.getName());
        XmlrpcdConfigFactoryTest.assertEquals((String)"serviceEvents has 2 entries", (int)2, (int)s.getSubscribedEventCount());
        s = (Subscription)is.next();
        XmlrpcdConfigFactoryTest.assertEquals((String)"second entry is otherEvents", (String)"otherEvents", (String)s.getName());
        XmlrpcdConfigFactoryTest.assertEquals((String)"otherEvents has 5 entries", (int)7, (int)s.getSubscribedEventCount());
        s = (Subscription)is.next();
        XmlrpcdConfigFactoryTest.assertEquals((String)"third entry is generated", (String)e.getServerSubscription(0), (String)s.getName());
        XmlrpcdConfigFactoryTest.assertEquals((String)"autogenerated entries have 9 UEIs", (int)9, (int)s.getSubscribedEventCount());
    }
}

