/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import junit.framework.TestCase;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.MergeableDefinition;
import org.opennms.netmgt.config.SnmpConfigManager;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.snmp.SnmpConfig;
import org.opennms.test.ConfigurationTestUtils;

public class SnmpEventInfoTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        Reader rdr = ConfigurationTestUtils.getReaderForResource((Object)((Object)this), (String)"snmp-config-snmpEventInfoTest.xml");
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(rdr));
    }

    public final void testModifySpecificInDef() throws MarshalException, ValidationException, IOException {
        String snmpConfigXml = "<?xml version=\"1.0\"?>\n<snmp-config retry=\"3\" timeout=\"800\"\n   read-community=\"public\" write-community=\"private\">\n   <definition version=\"v2c\">\n       <specific>192.168.0.5</specific>\n   </definition>\n\n</snmp-config>\n";
        StringReader rdr = new StringReader(snmpConfigXml);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        SnmpEventInfo info = new SnmpEventInfo();
        info.setCommunityString("abc");
        info.setFirstIPAddress("192.168.0.5");
        MergeableDefinition configDef = new MergeableDefinition(SnmpPeerFactory.getSnmpConfig().getDefinition(0));
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        MergeableDefinition matchingDef = mgr.findDefMatchingAttributes(info.createDef());
        SnmpEventInfoTest.assertNull((Object)matchingDef);
        SnmpEventInfoTest.assertTrue((boolean)configDef.hasMatchingSpecific(info.getFirstIPAddress()));
        SnmpEventInfoTest.assertNull((Object)configDef.getConfigDef().getReadCommunity());
        mgr.mergeIntoConfig(info.createDef());
        matchingDef = mgr.findDefMatchingAttributes(info.createDef());
        SnmpEventInfoTest.assertNotNull((Object)matchingDef);
        SnmpEventInfoTest.assertFalse((boolean)configDef.hasMatchingSpecific(info.getFirstIPAddress()));
        SnmpEventInfoTest.assertTrue((boolean)matchingDef.hasMatchingSpecific(info.getFirstIPAddress()));
        SnmpEventInfoTest.assertEquals((long)InetAddressUtils.toIpAddrLong((InetAddress)InetAddress.getByName("192.168.0.5")), (long)InetAddressUtils.toIpAddrLong((InetAddress)InetAddress.getByName(matchingDef.getConfigDef().getSpecific(0))));
        SnmpEventInfoTest.assertEquals((String)"abc", (String)matchingDef.getConfigDef().getReadCommunity());
        SnmpEventInfoTest.assertEquals((int)1, (int)SnmpPeerFactory.getSnmpConfig().getDefinitionCount());
    }

    public final void testAddAdjacentSpecificToDef() throws MarshalException, ValidationException, IOException {
        String snmpConfigXml = "<?xml version=\"1.0\"?>\n<snmp-config retry=\"3\" timeout=\"800\"\n   read-community=\"public\" write-community=\"private\">\n   <definition version=\"v2c\">\n       <specific>192.168.0.5</specific>\n   </definition>\n\n</snmp-config>\n";
        StringReader rdr = new StringReader(snmpConfigXml);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("192.168.0.6");
        MergeableDefinition configDef = new MergeableDefinition(SnmpPeerFactory.getSnmpConfig().getDefinition(0));
        MergeableDefinition matchingDef = mgr.findDefMatchingAttributes(info.createDef());
        SnmpEventInfoTest.assertNotNull((Object)matchingDef);
        SnmpEventInfoTest.assertFalse((boolean)matchingDef.hasMatchingSpecific(info.getFirstIPAddress()));
        SnmpEventInfoTest.assertEquals((int)1, (int)matchingDef.getConfigDef().getSpecificCount());
        SnmpEventInfoTest.assertEquals((int)0, (int)matchingDef.getConfigDef().getRangeCount());
        SnmpEventInfoTest.assertNull((Object)configDef.getConfigDef().getReadCommunity());
        mgr.mergeIntoConfig(info.createDef());
        SnmpEventInfoTest.assertEquals((Object)matchingDef.getConfigDef(), (Object)mgr.findDefMatchingAttributes(info.createDef()).getConfigDef());
        SnmpEventInfoTest.assertFalse((boolean)matchingDef.hasMatchingSpecific(info.getFirstIPAddress()));
        SnmpEventInfoTest.assertEquals((int)0, (int)matchingDef.getConfigDef().getSpecificCount());
        SnmpEventInfoTest.assertEquals((int)1, (int)matchingDef.getConfigDef().getRangeCount());
        SnmpEventInfoTest.assertEquals((String)"192.168.0.5", (String)matchingDef.getConfigDef().getRange(0).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.0.6", (String)matchingDef.getConfigDef().getRange(0).getEnd());
        SnmpEventInfoTest.assertNull((Object)configDef.getConfigDef().getReadCommunity());
    }

    public void testSplitRange() throws MarshalException, ValidationException, IOException {
        String snmpConfigXml = "<?xml version=\"1.0\"?>\n<snmp-config retry=\"3\" timeout=\"800\"\n   read-community=\"public\" write-community=\"private\">\n   <definition version=\"v2c\">\n       <range begin=\"192.168.1.100\" end=\"192.168.1.200\"/>   </definition>\n\n</snmp-config>\n";
        StringReader rdr = new StringReader(snmpConfigXml);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.1.120");
        info.setLastIPAddress("192.168.1.130");
        mgr.mergeIntoConfig(info.createDef());
        SnmpEventInfoTest.assertEquals((int)2, (int)mgr.getConfig().getDefinitionCount());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.100", (String)mgr.getConfig().getDefinition(0).getRange(0).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.119", (String)mgr.getConfig().getDefinition(0).getRange(0).getEnd());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.131", (String)mgr.getConfig().getDefinition(0).getRange(1).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.200", (String)mgr.getConfig().getDefinition(0).getRange(1).getEnd());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.120", (String)mgr.getConfig().getDefinition(1).getRange(0).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.130", (String)mgr.getConfig().getDefinition(1).getRange(0).getEnd());
    }

    public void testRemoveSpecificFromRange() throws MarshalException, ValidationException, IOException {
        String snmpConfigXml = "<?xml version=\"1.0\"?>\n<snmp-config retry=\"3\" timeout=\"800\"\n   read-community=\"public\" write-community=\"private\">\n   <definition version=\"v2c\">\n       <range begin=\"192.168.1.100\" end=\"192.168.1.200\"/>   </definition>\n\n</snmp-config>\n";
        StringReader rdr = new StringReader(snmpConfigXml);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.1.120");
        mgr.mergeIntoConfig(info.createDef());
        SnmpEventInfoTest.assertEquals((int)2, (int)mgr.getConfig().getDefinitionCount());
        SnmpEventInfoTest.assertEquals((int)2, (int)mgr.getConfig().getDefinition(0).getRangeCount());
        SnmpEventInfoTest.assertEquals((int)0, (int)mgr.getConfig().getDefinition(0).getSpecificCount());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.100", (String)mgr.getConfig().getDefinition(0).getRange(0).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.119", (String)mgr.getConfig().getDefinition(0).getRange(0).getEnd());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.121", (String)mgr.getConfig().getDefinition(0).getRange(1).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.200", (String)mgr.getConfig().getDefinition(0).getRange(1).getEnd());
        SnmpEventInfoTest.assertEquals((int)0, (int)mgr.getConfig().getDefinition(1).getRangeCount());
        SnmpEventInfoTest.assertEquals((int)1, (int)mgr.getConfig().getDefinition(1).getSpecificCount());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.120", (String)mgr.getConfig().getDefinition(1).getSpecific(0));
    }

    public void testRecombineSpecificIntoRange() throws MarshalException, ValidationException, IOException {
        String snmpConfigXml = "<?xml version=\"1.0\"?>\n<snmp-config retry=\"3\" timeout=\"800\"\n   read-community=\"public\" write-community=\"private\">\n   <definition version=\"v2c\">\n       <range begin=\"192.168.1.10\" end=\"192.168.1.14\"/>       <range begin=\"192.168.1.16\" end=\"192.168.1.40\"/>   </definition>\n   <definition version=\"v1\">\n       <specific>192.168.1.15</specific>\n   </definition>\n\n</snmp-config>\n";
        StringReader rdr = new StringReader(snmpConfigXml);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("192.168.1.15");
        mgr.mergeIntoConfig(info.createDef());
        SnmpEventInfoTest.assertEquals((int)1, (int)mgr.getConfig().getDefinitionCount());
        SnmpEventInfoTest.assertEquals((int)1, (int)mgr.getConfig().getDefinition(0).getRangeCount());
        SnmpEventInfoTest.assertEquals((int)0, (int)mgr.getConfig().getDefinition(0).getSpecificCount());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.10", (String)mgr.getConfig().getDefinition(0).getRange(0).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.40", (String)mgr.getConfig().getDefinition(0).getRange(0).getEnd());
    }

    public void testRemoveSpecificInSeparateDefWithNewRange() throws MarshalException, ValidationException, IOException {
        String snmpConfigXml = "<?xml version=\"1.0\"?>\n<snmp-config retry=\"3\" timeout=\"800\"\n   read-community=\"public\" write-community=\"private\">\n   <definition version=\"v2c\">\n       <specific>192.168.1.30</specific>       <specific>10.1.1.1</specific>   </definition>\n\n</snmp-config>\n";
        StringReader rdr = new StringReader(snmpConfigXml);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.1.15");
        info.setLastIPAddress("192.168.1.35");
        mgr.mergeIntoConfig(info.createDef());
        SnmpEventInfoTest.assertEquals((int)2, (int)mgr.getConfig().getDefinitionCount());
        SnmpEventInfoTest.assertEquals((int)0, (int)mgr.getConfig().getDefinition(0).getRangeCount());
        SnmpEventInfoTest.assertEquals((int)1, (int)mgr.getConfig().getDefinition(0).getSpecificCount());
        SnmpEventInfoTest.assertEquals((int)1, (int)mgr.getConfig().getDefinition(1).getRangeCount());
        SnmpEventInfoTest.assertEquals((int)0, (int)mgr.getConfig().getDefinition(1).getSpecificCount());
        SnmpEventInfoTest.assertEquals((String)"10.1.1.1", (String)mgr.getConfig().getDefinition(0).getSpecific(0));
        SnmpEventInfoTest.assertEquals((String)"192.168.1.15", (String)mgr.getConfig().getDefinition(1).getRange(0).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.35", (String)mgr.getConfig().getDefinition(1).getRange(0).getEnd());
    }

    public void testInvalidRange() throws MarshalException, ValidationException, IOException {
        String snmpConfigXml = "<?xml version=\"1.0\"?>\n<snmp-config retry=\"3\" timeout=\"800\"\n   read-community=\"public\" write-community=\"private\">\n   <definition version=\"v2c\">\n       <range begin=\"192.168.0.3\" end=\"192.168.0.100\"/>   </definition>\n\n</snmp-config>\n";
        StringReader rdr = new StringReader(snmpConfigXml);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.0.3");
        info.setLastIPAddress("192.168.0.1");
        try {
            mgr.mergeIntoConfig(info.createDef());
            SnmpEventInfoTest.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void testNewSpecifcSameAsBeginInOldDef() throws MarshalException, ValidationException, IOException {
        String snmpConfigXml = "<?xml version=\"1.0\"?>\n<snmp-config retry=\"3\" timeout=\"800\"\n   read-community=\"public\" write-community=\"private\">\n   <definition version=\"v2c\">\n       <range begin=\"192.168.0.3\" end=\"192.168.0.100\"/>   </definition>\n\n</snmp-config>\n";
        StringReader rdr = new StringReader(snmpConfigXml);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.0.3");
        mgr.mergeIntoConfig(info.createDef());
        SnmpEventInfoTest.assertEquals((int)2, (int)mgr.getConfig().getDefinitionCount());
        SnmpEventInfoTest.assertEquals((int)1, (int)mgr.getConfig().getDefinition(0).getRangeCount());
        SnmpEventInfoTest.assertEquals((int)0, (int)mgr.getConfig().getDefinition(0).getSpecificCount());
        SnmpEventInfoTest.assertEquals((int)0, (int)mgr.getConfig().getDefinition(1).getRangeCount());
        SnmpEventInfoTest.assertEquals((int)1, (int)mgr.getConfig().getDefinition(1).getSpecificCount());
        SnmpEventInfoTest.assertEquals((String)"192.168.0.4", (String)mgr.getConfig().getDefinition(0).getRange(0).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.0.100", (String)mgr.getConfig().getDefinition(0).getRange(0).getEnd());
        SnmpEventInfoTest.assertEquals((String)"192.168.0.3", (String)mgr.getConfig().getDefinition(1).getSpecific(0));
    }

    public void testOverlapsTwoRanges() throws MarshalException, ValidationException, IOException {
        String snmpConfigXml = "<?xml version=\"1.0\"?>\n<snmp-config retry=\"3\" timeout=\"800\"\n   read-community=\"public\" write-community=\"private\">\n   <definition version=\"v2c\">\n       <range begin=\"192.168.1.10\" end=\"192.168.1.20\"/>       <range begin=\"192.168.1.30\" end=\"192.168.1.40\"/>   </definition>\n\n</snmp-config>\n";
        StringReader rdr = new StringReader(snmpConfigXml);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.1.15");
        info.setLastIPAddress("192.168.1.35");
        mgr.mergeIntoConfig(info.createDef());
        SnmpEventInfoTest.assertEquals((int)2, (int)mgr.getConfig().getDefinitionCount());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.10", (String)mgr.getConfig().getDefinition(0).getRange(0).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.14", (String)mgr.getConfig().getDefinition(0).getRange(0).getEnd());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.36", (String)mgr.getConfig().getDefinition(0).getRange(1).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.40", (String)mgr.getConfig().getDefinition(0).getRange(1).getEnd());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.15", (String)mgr.getConfig().getDefinition(1).getRange(0).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.35", (String)mgr.getConfig().getDefinition(1).getRange(0).getEnd());
    }

    public void testRecombineRanges() throws MarshalException, ValidationException, IOException {
        String snmpConfigXml = "<?xml version=\"1.0\"?>\n<snmp-config retry=\"3\" timeout=\"800\"\n   read-community=\"public\" write-community=\"private\">\n   <definition version=\"v2c\">\n       <range begin=\"192.168.1.10\" end=\"192.168.1.14\"/>       <range begin=\"192.168.1.36\" end=\"192.168.1.40\"/>   </definition>\n   <definition version=\"v1\">\n       <range begin=\"192.168.1.15\" end=\"192.168.1.35\"/>   </definition>\n\n</snmp-config>\n";
        StringReader rdr = new StringReader(snmpConfigXml);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("192.168.1.15");
        info.setLastIPAddress("192.168.1.35");
        mgr.mergeIntoConfig(info.createDef());
        SnmpEventInfoTest.assertEquals((int)1, (int)mgr.getConfig().getDefinitionCount());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.10", (String)mgr.getConfig().getDefinition(0).getRange(0).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.40", (String)mgr.getConfig().getDefinition(0).getRange(0).getEnd());
    }

    public void testRecombineRangesNonAdjacentRange() throws MarshalException, ValidationException, IOException {
        String snmpConfigXml = "<?xml version=\"1.0\"?>\n<snmp-config retry=\"3\" timeout=\"800\"\n   read-community=\"public\" write-community=\"private\">\n   <definition version=\"v2c\">\n       <range begin=\"192.168.1.10\" end=\"192.168.1.14\"/>       <range begin=\"192.168.1.36\" end=\"192.168.1.40\"/>   </definition>\n   <definition version=\"v1\">\n       <range begin=\"192.168.1.15\" end=\"192.168.1.35\"/>   </definition>\n\n</snmp-config>\n";
        StringReader rdr = new StringReader(snmpConfigXml);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v2c");
        info.setFirstIPAddress("192.168.1.12");
        info.setLastIPAddress("192.168.1.38");
        mgr.mergeIntoConfig(info.createDef());
        SnmpEventInfoTest.assertEquals((int)1, (int)mgr.getConfig().getDefinitionCount());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.10", (String)mgr.getConfig().getDefinition(0).getRange(0).getBegin());
        SnmpEventInfoTest.assertEquals((String)"192.168.1.40", (String)mgr.getConfig().getDefinition(0).getRange(0).getEnd());
    }

    public final void testAddNewSpecificToConfig() throws MarshalException, ValidationException, IOException {
        String snmpConfigXml = "<?xml version=\"1.0\"?>\n<snmp-config retry=\"3\" timeout=\"800\"\n   read-community=\"public\" write-community=\"private\">\n   <definition version=\"v2c\">\n       <specific>192.168.0.5</specific>\n       <specific>192.168.0.6</specific>\n   </definition>\n\n</snmp-config>\n";
        StringReader rdr = new StringReader(snmpConfigXml);
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory((Reader)rdr));
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        info.setVersion("v1");
        info.setFirstIPAddress("192.168.0.6");
        MergeableDefinition configDef = new MergeableDefinition(SnmpPeerFactory.getSnmpConfig().getDefinition(0));
        MergeableDefinition matchingDef = mgr.findDefMatchingAttributes(info.createDef());
        SnmpEventInfoTest.assertNull((Object)matchingDef);
        SnmpEventInfoTest.assertTrue((boolean)configDef.hasMatchingSpecific(info.getFirstIPAddress()));
        SnmpEventInfoTest.assertEquals((int)2, (int)configDef.getConfigDef().getSpecificCount());
        SnmpEventInfoTest.assertEquals((int)0, (int)configDef.getConfigDef().getRangeCount());
        SnmpEventInfoTest.assertNull((Object)configDef.getConfigDef().getReadCommunity());
        SnmpEventInfoTest.assertEquals((String)"v2c", (String)configDef.getConfigDef().getVersion());
        mgr.mergeIntoConfig(info.createDef());
        matchingDef = mgr.findDefMatchingAttributes(info.createDef());
        SnmpEventInfoTest.assertNotNull((Object)matchingDef);
        SnmpEventInfoTest.assertFalse((boolean)configDef.hasMatchingSpecific(info.getFirstIPAddress()));
        SnmpEventInfoTest.assertEquals((int)1, (int)configDef.getConfigDef().getSpecificCount());
        SnmpEventInfoTest.assertEquals((int)0, (int)configDef.getConfigDef().getRangeCount());
        SnmpEventInfoTest.assertEquals((String)"v2c", (String)configDef.getConfigDef().getVersion());
        SnmpEventInfoTest.assertEquals((int)1, (int)matchingDef.getConfigDef().getSpecificCount());
        SnmpEventInfoTest.assertEquals((int)0, (int)matchingDef.getConfigDef().getRangeCount());
        SnmpEventInfoTest.assertTrue((boolean)matchingDef.hasMatchingSpecific(info.getFirstIPAddress()));
        SnmpEventInfoTest.assertNull((Object)matchingDef.getConfigDef().getReadCommunity());
        SnmpEventInfoTest.assertEquals((String)"v1", (String)matchingDef.getConfigDef().getVersion());
        SnmpEventInfoTest.assertTrue((matchingDef.getConfigDef() != configDef.getConfigDef() ? 1 : 0) != 0);
        SnmpEventInfoTest.assertEquals((int)2, (int)SnmpPeerFactory.getSnmpConfig().getDefinitionCount());
    }

    public final void testOptimizeAllDefs() throws MarshalException, ValidationException, IOException {
        SnmpConfigManager mgr = new SnmpConfigManager(SnmpPeerFactory.getSnmpConfig());
        SnmpEventInfo info = new SnmpEventInfo();
        SnmpConfig SnmpConfig2 = SnmpPeerFactory.getSnmpConfig();
        SnmpEventInfoTest.assertEquals((int)6, (int)SnmpConfig2.getDefinitionCount());
        info.setCommunityString("opennmsrules2");
        MergeableDefinition def = mgr.findDefMatchingAttributes(info.createDef());
        SnmpEventInfoTest.assertNotNull((Object)def);
        SnmpEventInfoTest.assertEquals((int)9, (int)def.getConfigDef().getRangeCount());
        mgr.optimizeAllDefs();
        def = mgr.findDefMatchingAttributes(info.createDef());
        SnmpEventInfoTest.assertNotNull((Object)def);
        SnmpEventInfoTest.assertEquals((int)2, (int)def.getConfigDef().getRangeCount());
    }
}

