/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.test.ThrowableAnticipator;

public class DataCollectionConfigFactoryTest {
    private static String m_xml = "<?xml version=\"1.0\"?>\n<datacollection-config\n   rrdRepository = \"/wonka/rrd/snmp/\">\n   <snmp-collection name=\"default\"\n       snmpStorageFlag = \"select\">\n       <rrd step = \"300\">\n           <rra>RRA:AVERAGE:0.5:1:8928</rra>\n           <rra>RRA:AVERAGE:0.5:12:8784</rra>\n           <rra>RRA:MIN:0.5:12:8784</rra>\n           <rra>RRA:MAX:0.5:12:8784</rra>\n       </rrd>\n       <groups>\n           <!-- data from standard (mib-2) sources -->\n           <group  name = \"mib2-interfaces\" ifType = \"all\">\n             <mibObj oid=\".1.3.6.1.2.1.2.2.1.10\" instance=\"ifIndex\" alias=\"ifInOctets\"    type=\"counter\"/>\n             <mibObj oid=\".1.3.6.1.2.1.2.2.1.11\" instance=\"ifIndex\" alias=\"ifInUcastpkts\"   type=\"counter\"/>\n             <mibObj oid=\".1.3.6.1.2.1.2.2.1.12\" instance=\"ifIndex\" alias=\"ifInNUcastpkts\"  type=\"counter\"/>\n             <mibObj oid=\".1.3.6.1.2.1.2.2.1.13\" instance=\"ifIndex\" alias=\"ifInDiscards\"  type=\"counter\"/>\n             <mibObj oid=\".1.3.6.1.2.1.2.2.1.14\" instance=\"ifIndex\" alias=\"ifInErrors\"    type=\"counter\"/>\n             <mibObj oid=\".1.3.6.1.2.1.2.2.1.16\" instance=\"ifIndex\" alias=\"ifOutOctets\"   type=\"counter\"/>\n             <mibObj oid=\".1.3.6.1.2.1.2.2.1.17\" instance=\"ifIndex\" alias=\"ifOutUcastPkts\"   type=\"counter\"/>\n             <mibObj oid=\".1.3.6.1.2.1.2.2.1.18\" instance=\"ifIndex\" alias=\"ifOutNUcastPkts\" type=\"counter\"/>\n             <mibObj oid=\".1.3.6.1.2.1.2.2.1.19\" instance=\"ifIndex\" alias=\"ifOutDiscards\"   type=\"counter\"/>\n             <mibObj oid=\".1.3.6.1.2.1.2.2.1.20\" instance=\"ifIndex\" alias=\"ifOutErrors\"   type=\"counter\"/>\n             <mibObj oid=\".1.3.6.1.2.1.31.1.1.1.6\" instance=\"ifIndex\" alias=\"ifHCInOctets\"  type=\"counter\"/>\n             <mibObj oid=\".1.3.6.1.2.1.31.1.1.1.10\" instance=\"ifIndex\" alias=\"ifHCOutOctets\" type=\"counter\"/>\n           </group>\n           <group name=\"mib2-tcp\" ifType=\"ignore\">\n             <mibObj oid=\".1.3.6.1.2.1.6.5\" instance=\"0\" alias=\"tcpActiveOpens\" type=\"Counter32\"/>\n             <mibObj oid=\".1.3.6.1.2.1.6.6\" instance=\"0\" alias=\"tcpPassiveOpens\" type=\"Counter32\"/>\n             <mibObj oid=\".1.3.6.1.2.1.6.7\" instance=\"0\" alias=\"tcpAttemptFails\" type=\"Counter32\"/>\n             <mibObj oid=\".1.3.6.1.2.1.6.8\" instance=\"0\" alias=\"tcpEstabResets\" type=\"Counter32\"/>\n             <mibObj oid=\".1.3.6.1.2.1.6.9\" instance=\"0\" alias=\"tcpCurrEstab\" type=\"Gauge32\"/>\n             <mibObj oid=\".1.3.6.1.2.1.6.10\" instance=\"0\" alias=\"tcpInSegs\" type=\"Counter32\"/>\n             <mibObj oid=\".1.3.6.1.2.1.6.11\" instance=\"0\" alias=\"tcpOutSegs\" type=\"Counter32\"/>\n             <mibObj oid=\".1.3.6.1.2.1.6.12\" instance=\"0\" alias=\"tcpRetransSegs\" type=\"Counter32\"/>\n             <mibObj oid=\".1.3.6.1.2.1.6.14\" instance=\"0\" alias=\"tcpInErrors\" type=\"Counter32\"/>\n             <mibObj oid=\".1.3.6.1.2.1.6.15\" instance=\"0\" alias=\"tcpOutRsts\" type=\"Counter32\"/>\n           </group>\n       </groups>\n       <systems>\n           <systemDef name = \"Enterprise\">\n               <sysoidMask>.1.3.6.1.4.1.</sysoidMask>\n               <collect>\n                   <includeGroup>mib2-interfaces</includeGroup>\n                   <includeGroup>mib2-tcp</includeGroup>\n               </collect>\n           </systemDef>        \n\n       </systems>\n   </snmp-collection>\n</datacollection-config>\n";
    private String m_brocadeXmlFragment = "       <resourceType name=\"brocadeIndex\" label=\"Brocade Switches\">\n         <persistenceSelectorStrategy class=\"foo\"/>\n         <storageStrategy class=\"foo\"/>\n       </resourceType>\n";

    @Test
    public void testSetInstance() throws MarshalException, ValidationException, IOException {
        DataCollectionConfigFactory.setInstance((DataCollectionConfig)new DataCollectionConfigFactory((Reader)new StringReader(m_xml)));
        DataCollectionConfigFactory.init();
        Assert.assertEquals((Object)"/wonka/rrd/snmp", (Object)DataCollectionConfigFactory.getInstance().getRrdPath());
    }

    @Test
    public void testValidResourceType() throws MarshalException, ValidationException, IOException {
        String modifiedXml = m_xml.replaceFirst("ifIndex", "brocadeIndex").replaceFirst("<groups", this.m_brocadeXmlFragment + "<groups");
        DataCollectionConfigFactory.setInstance((DataCollectionConfig)new DataCollectionConfigFactory((Reader)new StringReader(modifiedXml)));
    }

    @Test
    public void testInvalidResourceType() throws MarshalException, ValidationException, IOException {
        String modifiedXml = m_xml.replaceFirst("ifIndex", "brocadeIndex");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("instance 'brocadeIndex' invalid in mibObj definition for OID '.1.3.6.1.2.1.2.2.1.10' in collection 'default' for group 'mib2-interfaces'.  Allowable instance values: any positive number, 'ifIndex', or any of the configured resourceTypes: (none)"));
        try {
            DataCollectionConfigFactory.setInstance((DataCollectionConfig)new DataCollectionConfigFactory((Reader)new StringReader(modifiedXml)));
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }
}

