/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.IOException;
import java.io.InputStream;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.collectd.CollectorConfigDaoImpl;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.DataCollectionConfig;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.DatabaseSchemaConfigFactory;
import org.opennms.netmgt.config.JMXDataCollectionConfigFactory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.CollectorConfigDao;
import org.opennms.netmgt.dao.support.RrdTestUtils;
import org.opennms.netmgt.mock.MockDatabase;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;

public class CollectorConfigDaoImplTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        MockUtil.println((String)("------------ Begin Test " + this.getName() + " --------------------------"));
        MockLogAppender.setupLogging();
        MockDatabase m_db = new MockDatabase();
        DataSourceFactory.setInstance((DataSource)((Object)m_db));
    }

    public void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNoWarningsOrGreater();
    }

    protected void tearDown() throws Exception {
        MockUtil.println((String)("------------ End Test " + this.getName() + " --------------------------"));
        super.tearDown();
    }

    private InputStream getInputStreamForFile(String fileName) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
    }

    public void testInstantiate() throws MarshalException, ValidationException, IOException, Exception {
        this.initialize();
    }

    private CollectorConfigDao initialize() throws IOException, MarshalException, ValidationException, Exception {
        RrdTestUtils.initialize();
        InputStream stream = null;
        stream = this.getInputStreamForFile("/org/opennms/netmgt/config/test-database-schema.xml");
        DatabaseSchemaConfigFactory.setInstance((DatabaseSchemaConfigFactory)new DatabaseSchemaConfigFactory(stream));
        stream.close();
        stream = this.getInputStreamForFile("/org/opennms/netmgt/config/jmx-datacollection-testdata.xml");
        JMXDataCollectionConfigFactory.setInstance((JMXDataCollectionConfigFactory)new JMXDataCollectionConfigFactory(stream));
        stream.close();
        stream = this.getInputStreamForFile("/org/opennms/netmgt/config/snmp-config.xml");
        SnmpPeerFactory.setInstance((SnmpPeerFactory)new SnmpPeerFactory(stream));
        stream.close();
        stream = this.getInputStreamForFile("/org/opennms/netmgt/config/datacollection-config.xml");
        DataCollectionConfigFactory.setInstance((DataCollectionConfig)new DataCollectionConfigFactory(stream));
        stream.close();
        stream = this.getInputStreamForFile("/org/opennms/netmgt/config/collectd-testdata.xml");
        CollectdConfigFactory.setInstance((CollectdConfigFactory)new CollectdConfigFactory(stream, "localhost", false));
        stream.close();
        return new CollectorConfigDaoImpl();
    }
}

