/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dhcpd.Dhcpd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DhcpTestDetector {
    private static final Integer PORT_NUMBER = new Integer(67);
    private static final String PROTOCOL_NAME = "DHCP";
    private static final int DEFAULT_RETRY = 3;
    private static final int DEFAULT_TIMEOUT = 3000;

    private boolean isServer(InetAddress host, int retries, int timeout) {
        ThreadCategory log = ThreadCategory.getInstance(this.getClass());
        boolean isAServer = false;
        long responseTime = -1L;
        try {
            responseTime = Dhcpd.isServer((InetAddress)host, (long)timeout, (int)retries);
        }
        catch (InterruptedIOException ioE) {
            if (log.isDebugEnabled()) {
                ioE.fillInStackTrace();
                log.debug("isServer: The DHCP discovery operation was interrupted", (Throwable)ioE);
            }
            ioE.printStackTrace();
        }
        catch (IOException ioE) {
            log.warn("isServer: An I/O exception occured during DHCP discovery", (Throwable)ioE);
            isAServer = false;
            ioE.printStackTrace();
        }
        catch (Throwable t) {
            log.error("isServer: An undeclared throwable exception was caught during test", t);
            isAServer = false;
            t.printStackTrace();
        }
        if (responseTime >= 0L) {
            isAServer = true;
        }
        return isAServer;
    }

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean isProtocolSupported(InetAddress host) {
        return this.isServer(host, 3, 3000);
    }

    public boolean isProtocolSupported(InetAddress host, Map<String, Object> qualifiers) {
        boolean isAServer;
        int retries = 3;
        int timeout = 3000;
        if (qualifiers != null) {
            retries = ParameterMap.getKeyedInteger(qualifiers, (String)"retry", (int)3);
            timeout = ParameterMap.getKeyedInteger(qualifiers, (String)"timeout", (int)3000);
        }
        if ((isAServer = this.isServer(host, retries, timeout)) && qualifiers != null) {
            qualifiers.put("port", PORT_NUMBER);
        }
        return isAServer;
    }
}

