/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import junit.framework.TestCase;
import org.opennms.netmgt.capsd.DbIpInterfaceEntry;
import org.opennms.netmgt.capsd.DbSnmpInterfaceEntry;
import org.opennms.netmgt.capsd.RescanProcessor;
import org.opennms.netmgt.capsd.snmp.IfTableEntry;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.mock.TestSnmpValue;
import org.opennms.test.mock.MockLogAppender;

public class RescanProcessorTest
extends TestCase {
    protected void setUp() {
        MockLogAppender.setupLogging();
    }

    public void testBadSnmpIfSpeed() {
        int nodeId = 1;
        int ifIndex = 10;
        RescanProcessor.setQueuedRescansTracker(new HashSet());
        RescanProcessor processor = new RescanProcessor(nodeId, false, null, null);
        IfTableEntry ifTableEntry = new IfTableEntry();
        ifTableEntry.storeResult(new SnmpResult(SnmpObjId.get((String)".1.3.6.1.2.1.2.2.1.5"), new SnmpInstId("0"), (SnmpValue)new TestSnmpValue.StringSnmpValue("")));
        DbSnmpInterfaceEntry dbSnmpInterfaceEntry = DbSnmpInterfaceEntry.create((int)nodeId, (int)ifIndex);
        processor.updateSpeed(ifIndex, ifTableEntry, null, dbSnmpInterfaceEntry);
        RescanProcessorTest.assertEquals((String)"DbSnmpInterfaceEntry ifSpeed value", (long)0L, (long)dbSnmpInterfaceEntry.getSpeed());
    }

    public void testScannableInterface() throws UnknownHostException {
        InetAddress ifaddr1 = InetAddress.getByName("127.0.0.1");
        DbIpInterfaceEntry entry1 = DbIpInterfaceEntry.create((int)1, (InetAddress)ifaddr1, (int)1);
        DbIpInterfaceEntry[] dbInterfaces = new DbIpInterfaceEntry[]{entry1};
        RescanProcessorTest.assertTrue((String)"Should scan 127.0.0.1 if it is the only interface in the list", (boolean)RescanProcessor.scannableInterface((DbIpInterfaceEntry[])dbInterfaces, (InetAddress)ifaddr1));
        dbInterfaces = new DbIpInterfaceEntry[2];
        InetAddress ifaddr2 = InetAddress.getByName("10.0.0.1");
        DbIpInterfaceEntry entry2 = DbIpInterfaceEntry.create((int)2, (InetAddress)ifaddr2, (int)1);
        dbInterfaces[0] = entry1;
        dbInterfaces[1] = entry2;
        RescanProcessorTest.assertFalse((String)"Do not rescan 127.0.0.1 when there are multiple interfaces in the list.", (boolean)RescanProcessor.scannableInterface((DbIpInterfaceEntry[])dbInterfaces, (InetAddress)ifaddr1));
        RescanProcessorTest.assertTrue((boolean)RescanProcessor.scannableInterface((DbIpInterfaceEntry[])dbInterfaces, (InetAddress)ifaddr2));
    }
}

