//
// This file is part of the OpenNMS(R) Application.
//
// OpenNMS(R) is Copyright (C) 2006 The OpenNMS Group, Inc.  All rights reserved.
// OpenNMS(R) is a derivative work, containing both original code, included code and modified
// code that was published under the GNU General Public License. Copyrights for modified
// and included code are below.
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
//
// Original code base Copyright (C) 1999-2001 Oculan Corp.  All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// For more information contact:
//      OpenNMS Licensing       <license@opennms.org>
//      http://www.opennms.org/
//      http://www.opennms.com/
//
package org.opennms.netmgt.threshd;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.opennms.core.utils.ThreadCategory;

public class ThresholdGroup {

	private String m_name;
	private File m_rrdRepository;
	private ThresholdResourceType m_nodeResourceType;
	private ThresholdResourceType m_ifResourceType;
	private Map<String,ThresholdResourceType> m_genericResourceTypeMap = new HashMap<String,ThresholdResourceType>();

	public ThresholdResourceType getIfResourceType() {
		return m_ifResourceType;
	}

	public void setIfResourceType(ThresholdResourceType ifResourceType) {
		m_ifResourceType = ifResourceType;
	}

	public void setName(String name) {
		m_name = name;
	}

	public ThresholdGroup(String name) {
		m_name = name;
	}

	public String getName() {
		return m_name;
	}
	
	
	public void setRrdRepository(File rrdRepository) {
		m_rrdRepository = rrdRepository;
	}

	public File getRrdRepository() {
		return m_rrdRepository;
	}

	ThreadCategory log() {
		return ThreadCategory.getInstance(getClass());
	}

	public void setNodeResourceType(ThresholdResourceType nodeResourceType) {
		m_nodeResourceType = nodeResourceType;
		
	}

	public ThresholdResourceType getNodeResourceType() {
		return m_nodeResourceType;
	}

	/*
	 * There are many GenericResourceTypes, for this reason, this will be mapped using a Map indexed by GenericResourceType name.
	 */
	public Map<String,ThresholdResourceType> getGenericResourceTypeMap() {
	    return m_genericResourceTypeMap;
	}

	public void setGenericResourceTypeMap(Map<String,ThresholdResourceType> genericResourceTypeMap) {
	    m_genericResourceTypeMap = genericResourceTypeMap;
	}
	
	public String toString() {
	    StringBuilder buf = new StringBuilder();
	    buf.append(getName() + "={node:{");
	    if (getNodeResourceType() != null) {
	        buf.append(getNodeResourceType().getThresholdMap().values());
	    }
	    buf.append("}; iface:{");
	    if (getIfResourceType() != null) {
	        buf.append(getIfResourceType().getThresholdMap().values());
	    }
	    if (getGenericResourceTypeMap() != null) {
	        for (String rType : getGenericResourceTypeMap().keySet()) {
	            buf.append("}; " + rType + ":{");
	            buf.append(getGenericResourceTypeMap().get(rType).getThresholdMap().values());
	            buf.append("}");
	        }
	    }
	    buf.append("}");
	    String toString = buf.toString();
	    return toString;
	}
	
	public void delete() {
	    delete(getNodeResourceType());
	    delete(getIfResourceType());
	    for (String type : getGenericResourceTypeMap().keySet())
	        delete(getGenericResourceTypeMap().get(type));
	}

	private void delete(ThresholdResourceType type) {
	    Map<String,Set<ThresholdEntity>> entityMap = type.getThresholdMap();
	    for (String key : entityMap.keySet()) 
	        for (ThresholdEntity e : entityMap.get(key))
	            e.delete();
	}
	
}
