/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.jmx.connectors;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.log4j.Category;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.protocols.jmx.connectors.MX4JConnectionWrapper;

public class MX4JConnectionFactory {
    static Category log = ThreadCategory.getInstance(MX4JConnectionFactory.class);

    public static MX4JConnectionWrapper getMBeanServerConnection(Map propertiesMap, InetAddress address) {
        MX4JConnectionWrapper connectionWrapper = null;
        JMXServiceURL url = null;
        String factory = ParameterMap.getKeyedString((Map)propertiesMap, (String)"factory", (String)"STANDARD");
        int port = ParameterMap.getKeyedInteger((Map)propertiesMap, (String)"port", (int)1099);
        String protocol = ParameterMap.getKeyedString((Map)propertiesMap, (String)"protocol", (String)"rmi");
        String urlPath = ParameterMap.getKeyedString((Map)propertiesMap, (String)"urlPath", (String)"/jmxrmi");
        log.debug((Object)("JMX: " + factory + " - service:" + protocol + "//" + address.getHostAddress() + ":" + port + urlPath));
        if (factory == null || factory.equals("STANDARD")) {
            try {
                url = new JMXServiceURL(protocol, address.getHostAddress(), port, urlPath);
                JMXConnector connector = JMXConnectorFactory.connect(url);
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connectionWrapper = new MX4JConnectionWrapper(connector, connection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (factory.equals("PASSWORD-CLEAR")) {
            try {
                String username = ParameterMap.getKeyedString((Map)propertiesMap, (String)"username", null);
                String password = ParameterMap.getKeyedString((Map)propertiesMap, (String)"password", null);
                HashMap<String, String[]> env = new HashMap<String, String[]>();
                String[] credentials = new String[]{username, password};
                env.put("jmx.remote.credentials", credentials);
                url = new JMXServiceURL(protocol, address.getHostAddress(), port, urlPath);
                JMXConnector connector = JMXConnectorFactory.newJMXConnector(url, null);
                try {
                    connector.connect(env);
                }
                catch (SecurityException x) {
                    log.error((Object)"Security exception: bad credentials");
                    throw x;
                }
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                connectionWrapper = new MX4JConnectionWrapper(connector, connection);
            }
            catch (Exception e) {
                log.error((Object)("Unable to get MBeanServerConnection: " + url), (Throwable)e);
            }
        }
        return connectionWrapper;
    }
}

