/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Category;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.xmlrpcd.XmlrpcServer;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.netmgt.xmlrpcd.TimeoutSecureXmlRpcClient;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlRpcNotifier {
    private static final String XMLRPC_SERVER_SUCCESS_COMMAND = "notifySuccess";
    private static final String XMLRPC_SERVER_FAILURE_COMMAND = "notifyFailure";
    private static final String XMLRPC_SERVER_RECEIVE_EVENT_COMMAND = "notifyReceivedEvent";
    private static final String XMLRPC_SERVICE_UP_COMMAND = "sendServiceUpEvent";
    private static final String XMLRPC_SERVICE_DOWN_COMMAND = "sendServiceDownEvent";
    private static final String XMLRPC_NODE_UP_COMMAND = "sendNodeUpEvent";
    private static final String XMLRPC_NODE_DOWN_COMMAND = "sendNodeDownEvent";
    private static final String XMLRPC_INTERFACE_UP_COMMAND = "sendInterfaceUpEvent";
    private static final String XMLRPC_INTERFACE_DOWN_COMMAND = "sendInterfaceDownEvent";
    private static final String XMLRPC_GENERIC_COMMAND = "sendEvent";
    private static final String XMLRPC_SNMP_TRAP_COMMAND = "sendSnmpTrapEvent";
    private XmlrpcServer[] m_rpcServers;
    private int m_retries;
    private int m_elapseTime;
    private XmlRpcClient m_xmlrpcClient;
    private boolean m_verifyServer;
    private String m_localServer;

    public XmlRpcNotifier(XmlrpcServer[] rpcServers, int retries, int elapseTime, boolean verifyServer, String localServer) {
        this.m_rpcServers = rpcServers;
        this.m_retries = retries;
        this.m_elapseTime = elapseTime;
        this.createConnection();
        this.m_verifyServer = verifyServer;
        if (this.m_verifyServer) {
            this.m_localServer = localServer;
        }
    }

    public boolean notifySuccess(long txNo, String uei, String message) {
        Assert.notNull((Object)uei, (String)"uei must not be null");
        Assert.notNull((Object)message, (String)"message must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(txNo));
        params.addElement(uei);
        params.addElement(message);
        return this.sendXmlrpcRequest(XMLRPC_SERVER_SUCCESS_COMMAND, params);
    }

    public boolean notifyFailure(long txNo, String uei, String reason) {
        Assert.notNull((Object)uei, (String)"uei must not be null");
        Assert.notNull((Object)reason, (String)"reason must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(txNo));
        params.addElement(uei);
        params.addElement(reason);
        return this.sendXmlrpcRequest(XMLRPC_SERVER_FAILURE_COMMAND, params);
    }

    public boolean notifyReceivedEvent(long txNo, String uei, String message) {
        Assert.notNull((Object)uei, (String)"uei must not be null");
        Assert.notNull((Object)message, (String)"message must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(txNo));
        params.addElement(uei);
        params.addElement(message);
        return this.sendXmlrpcRequest(XMLRPC_SERVER_RECEIVE_EVENT_COMMAND, params);
    }

    public boolean sendServiceDownEvent(Event event) {
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(this.getLabelForEventNode(event)));
        params.addElement(String.valueOf(event.getInterface()));
        params.addElement(String.valueOf(event.getService()));
        params.addElement(String.valueOf("Not Available"));
        params.addElement(String.valueOf(this.getEventHost(event)));
        params.addElement(String.valueOf(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_SERVICE_DOWN_COMMAND, params);
    }

    private String getEventHost(Event event) {
        return this.m_verifyServer ? this.m_localServer : event.getHost();
    }

    public boolean sendServiceUpEvent(Event event) {
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(this.getLabelForEventNode(event)));
        params.addElement(String.valueOf(event.getInterface()));
        params.addElement(String.valueOf(event.getService()));
        params.addElement(String.valueOf("Not Available"));
        params.addElement(String.valueOf(this.getEventHost(event)));
        params.addElement(String.valueOf(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_SERVICE_UP_COMMAND, params);
    }

    public boolean sendInterfaceDownEvent(Event event) {
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(this.getLabelForEventNode(event)));
        params.addElement(String.valueOf(event.getInterface()));
        params.addElement(String.valueOf(this.getEventHost(event)));
        params.addElement(String.valueOf(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_INTERFACE_DOWN_COMMAND, params);
    }

    public boolean sendInterfaceUpEvent(Event event) {
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(this.getLabelForEventNode(event)));
        params.addElement(String.valueOf(event.getInterface()));
        params.addElement(String.valueOf(event.getHost()));
        params.addElement(String.valueOf(this.getEventHost(event)));
        params.addElement(String.valueOf(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_INTERFACE_UP_COMMAND, params);
    }

    public boolean sendNodeDownEvent(Event event) {
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(this.getLabelForEventNode(event)));
        params.addElement(String.valueOf(this.getEventHost(event)));
        params.addElement(String.valueOf(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_NODE_DOWN_COMMAND, params);
    }

    public boolean sendNodeUpEvent(Event event) {
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        params.addElement(String.valueOf(this.getLabelForEventNode(event)));
        params.addElement(String.valueOf(this.getEventHost(event)));
        params.addElement(String.valueOf(event.getTime()));
        return this.sendXmlrpcRequest(XMLRPC_NODE_UP_COMMAND, params);
    }

    public boolean sendEvent(Event event) {
        Parms eventParams;
        String severity;
        String descr;
        String service;
        String host;
        String label;
        Assert.notNull((Object)event, (String)"event object must not be null");
        Vector<Object> params = new Vector<Object>();
        Hashtable<String, String> table = new Hashtable<String, String>();
        params.addElement(table);
        if (event.getSource() != null) {
            table.put("source", event.getSource());
        }
        if ((label = this.getLabelForEventNode(event)) != null) {
            table.put("nodeLabel", label);
        }
        if ((host = this.getEventHost(event)) != null) {
            table.put("host", host);
        }
        table.put("time", String.valueOf(event.getTime()));
        table.put("uei", String.valueOf(event.getUei()));
        table.put("nodeId", Long.toString(event.getNodeid()));
        String intf = event.getInterface();
        if (intf != null) {
            table.put("interface", intf);
        }
        if ((service = event.getService()) != null) {
            table.put("service", service);
        }
        if ((descr = event.getDescr()) != null) {
            table.put("description", descr);
        }
        if ((severity = event.getSeverity()) != null) {
            table.put("severity", event.getSeverity());
        }
        if ((eventParams = event.getParms()) != null) {
            int numParams = eventParams.getParmCount();
            for (int i = 0; i < numParams; ++i) {
                Parm p = eventParams.getParm(i);
                Value v = p.getValue();
                table.put("param" + i + " name", p.getParmName());
                table.put("param" + i + " type", v.getType());
                table.put("param" + i + " value", v.getContent());
            }
        }
        if (event.getSnmp() == null) {
            return this.sendXmlrpcRequest(XMLRPC_GENERIC_COMMAND, params);
        }
        Snmp trapInfo = event.getSnmp();
        table.put("communityString", String.valueOf(trapInfo.getCommunity()));
        table.put("genericTrapNumber", Integer.toString(trapInfo.getGeneric()));
        table.put("enterpriseId", String.valueOf(trapInfo.getId()));
        if (trapInfo.getIdtext() != null) {
            table.put("enterpriseIdText", trapInfo.getIdtext());
        }
        table.put("specificTrapNumber", Integer.toString(trapInfo.getSpecific()));
        table.put("timeStamp", Long.toString(trapInfo.getTimeStamp()));
        table.put("version", String.valueOf(trapInfo.getVersion()));
        return this.sendXmlrpcRequest(XMLRPC_SNMP_TRAP_COMMAND, params);
    }

    private String getLabelForEventNode(Event event) {
        return this.getNodeLabel(event.getNodeid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNodeLabel(long nodeId) {
        Connection dbConn = null;
        String nodeLabel = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            dbConn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)dbConn);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("getNodeLabel: retrieve node label for: " + nodeId));
            }
            PreparedStatement stmt = dbConn.prepareStatement("SELECT nodelabel FROM NODE WHERE nodeid = ?");
            d.watch((Object)stmt);
            stmt.setLong(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                nodeLabel = rs.getString(1);
            }
        }
        catch (SQLException sqle) {
            this.log().warn((Object)("SQL exception while retrieving nodeLabel for: " + nodeId), (Throwable)sqle);
        }
        finally {
            d.cleanUp();
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("getNodeLabel: retrieved node label '" + nodeLabel + "' for: " + nodeId));
        }
        return nodeLabel;
    }

    private Category log() {
        return ThreadCategory.getInstance(XmlRpcNotifier.class);
    }

    private boolean sendXmlrpcRequest(String command, Vector<Object> params) {
        if (this.m_xmlrpcClient == null) {
            return false;
        }
        boolean success = false;
        for (int i = 0; i < this.m_retries; ++i) {
            try {
                Object reply = this.m_xmlrpcClient.execute(command, params);
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Response from XMLRPC server: " + this.m_xmlrpcClient.getURL().toString() + "\n\t" + reply));
                }
                success = true;
            }
            catch (XmlRpcException e) {
                this.log().warn((Object)("Failed to send message to XMLRPC server " + this.m_xmlrpcClient.getURL() + ": " + (Object)((Object)e)), (Throwable)e);
            }
            catch (ConnectException e) {
                this.log().warn((Object)("Failed to send message to XMLRPC server due to connect exception " + this.m_xmlrpcClient.getURL() + ": " + e));
            }
            catch (IOException e) {
                this.log().warn((Object)("Failed to send message to XMLRPC server: " + this.m_xmlrpcClient.getURL() + ": " + e), (Throwable)e);
            }
            catch (Throwable t) {
                this.log().error((Object)"Received unknown error: ", t);
            }
            if (success) break;
        }
        if (!success) {
            this.log().error((Object)("Could not successfully communicate with XMLRPC server '" + this.m_xmlrpcClient.getURL() + "' after " + this.m_retries + " tries"));
        }
        return success;
    }

    public void createConnection() {
        Vector<String> params = new Vector<String>();
        params.addElement(Long.toString(0L));
        params.addElement("uei.opennms.org/internal/capsd/xmlrpcNotification");
        params.addElement("test connection");
        boolean success = false;
        for (int i = 0; i < this.m_rpcServers.length; ++i) {
            XmlrpcServer xServer = this.m_rpcServers[i];
            String url = xServer.getUrl();
            int timeout = xServer.getTimeout();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("Start to set up communication to XMLRPC server: " + url));
                this.log().debug((Object)("Setting timeout value to: " + timeout));
            }
            try {
                this.m_xmlrpcClient = new TimeoutSecureXmlRpcClient(url, timeout);
            }
            catch (MalformedURLException e) {
                this.log().error((Object)("Failed to send message to XMLRPC server: " + url), (Throwable)e);
                continue;
            }
            for (int k = 0; k < this.m_retries; ++k) {
                try {
                    Object reply = this.m_xmlrpcClient.execute(XMLRPC_SERVER_RECEIVE_EVENT_COMMAND, params);
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("Response from XMLRPC server: " + url + "\n\t" + reply.toString()));
                    }
                    success = true;
                }
                catch (XmlRpcException e) {
                    this.log().warn((Object)("Failed to send message to XMLRPC server: " + url), (Throwable)e);
                }
                catch (ConnectException e) {
                    this.log().warn((Object)("Failed to send message to XMLRPC server due to connect exception " + url + ": " + e));
                }
                catch (IOException e) {
                    this.log().warn((Object)("Failed to send message to XMLRPC server: " + url), (Throwable)e);
                }
                if (success) break;
                try {
                    Thread.sleep(this.m_elapseTime);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            if (success) break;
        }
        if (!success) {
            this.log().error((Object)"Can not set up communication with any XMLRPC server");
            this.m_xmlrpcClient = null;
        }
    }
}

