/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xmlrpcd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.xmlrpcd.SubscribedEvent;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BroadcastEventProcessor
implements EventListener {
    private final FifoQueue<Event> m_eventQ;
    private final int m_maxQSize;
    private final HashSet<String> m_events;
    private final String m_nameSuffix;

    BroadcastEventProcessor(String nameSuffix, FifoQueue<Event> eventQ, int maxQSize, List<SubscribedEvent> eventList) {
        this.m_nameSuffix = nameSuffix;
        ArrayList<String> ueiList = new ArrayList<String>();
        for (SubscribedEvent event : eventList) {
            ueiList.add(event.getUei());
        }
        this.m_eventQ = eventQ;
        this.m_maxQSize = maxQSize;
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener(this, ueiList);
        this.m_events = new HashSet();
        this.m_events.addAll(ueiList);
    }

    public void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener(this);
    }

    public void onEvent(Event event) {
        String eventUei = event.getUei();
        if (eventUei == null) {
            return;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Received event: " + eventUei));
        }
        try {
            if (this.m_events.contains(eventUei)) {
                if (this.m_eventQ.size() >= this.m_maxQSize) {
                    this.m_eventQ.remove(1000L);
                    if (this.log().isDebugEnabled()) {
                        this.log().debug((Object)("Event " + eventUei + " removed from event queue"));
                    }
                }
                this.m_eventQ.add((Object)event);
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("Event " + eventUei + " added to event queue"));
                }
            }
        }
        catch (InterruptedException ex) {
            this.log().error((Object)"Failed to process event", (Throwable)ex);
            return;
        }
        catch (FifoQueueException ex) {
            this.log().error((Object)"Failed to process event", (Throwable)ex);
            return;
        }
        catch (Throwable t) {
            this.log().error((Object)"Failed to process event", t);
            return;
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String getName() {
        return "Xmlrpcd:BroadcastEventProcessor_" + this.m_nameSuffix;
    }
}

