/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vulnscand;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.VulnscandConfigFactory;
import org.opennms.netmgt.vulnscand.DescrValues;
import org.opennms.netmgt.vulnscand.NessusConnectionFactory;
import org.opennms.netmgt.vulnscand.NessusParser;
import org.opennms.netmgt.vulnscand.NessusScanConfiguration;
import org.opennms.netmgt.vulnscand.PortValues;

class NessusScan
implements Runnable {
    private static final String NTP_VERSION_STRING = "< NTP/1.2 >< md5_caching plugins_cve_id plugins_version>";
    private static final String NTP_CLIENT_ENTITY = "CLIENT";
    private static final String NTP_SERVER_ENTITY = "SERVER";
    private static final String NTP_USERNAME_PROMPT = "User : ";
    private static final String NTP_PASSWORD_PROMPT = "Password : ";
    private static final String NTP_SEP = " <|> ";
    private static final int PORTSCAN_PLUGIN_ID = 0;
    public static final int SCAN_SUCCESS = 0;
    public static final int SCAN_HOST_DOWN = 1;
    public static final int SCAN_FATAL_ERROR = 2;
    public static final int SCAN_NON_FATAL_ERROR = 4;
    public static final int SCAN_COMPLETE = 8;
    private static final String SELECT_NEXT_ID = "SELECT NEXTVAL('vulnNxtId')";
    private static final String SELECT_ALL_VULNERABILITIES = "SELECT vulnerabilityid FROM vulnerabilities WHERE ipaddr = ? AND resolvedtime IS NULL";
    private static final String SELECT_PLUGIN_INFO = "SELECT name, summary FROM vulnplugins WHERE pluginid = ? AND pluginsubid = ?";
    private static final String INSERT_NEW_VULNERABILITY = "INSERT INTO vulnerabilities (vulnerabilityid, nodeid, ipaddr, serviceid, creationtime, lastattempttime, lastscantime, severity, pluginid, pluginsubid, logmsg, descr, port, protocol, cveentry) VALUES (?,?,?,?, ?,?,?, ?, ?,?, ?,?, ?,?, ?)";
    private static final String SELECT_OPEN_VULNERABILITY = "SELECT vulnerabilityid FROM vulnerabilities WHERE ipaddr = ? AND port = ? AND protocol = ? AND pluginid = ? AND pluginsubid = ? AND resolvedtime IS NULL";
    private static final String VULNERABILITY_SCANNED = "UPDATE vulnerabilities SET lastattempttime = ?, lastscantime = ? WHERE vulnerabilityid = ?";
    private static final String VULNERABILITY_SCAN_ATTEMPTED = "UPDATE vulnerabilities SET lastattempttime = ? WHERE vulnerabilityid = ?";
    private static final String RESOLVE_VULNERABILITY = "UPDATE vulnerabilities SET lastattempttime = ?, resolvedtime = ? WHERE vulnerabilityid = ?";
    private NessusScanConfiguration config;
    private RE ntpTokenizer = null;
    private Set openVulnerabilities = new HashSet();
    private String[] pluginLists = null;
    private boolean[] safeChecks = null;
    private int lastPlugin;
    private int totalPlugins;

    public NessusScan(NessusScanConfiguration newConfig) throws IllegalArgumentException {
        if (!newConfig.isValid()) {
            throw new IllegalArgumentException("NessusScanConfiguration was invalid");
        }
        this.config = newConfig;
        try {
            this.ntpTokenizer = new RE(" <\\|> ");
        }
        catch (RESyntaxException ex) {
            ThreadCategory.getInstance(NessusScan.class).error((Object)"FATAL ERROR in regex in NessusScan.java. Correct this error and rebuild.", (Throwable)ex);
        }
        this.init();
    }

    private void init() {
        this.pluginLists = VulnscandConfigFactory.getInstance().getPluginLists();
        this.safeChecks = VulnscandConfigFactory.getInstance().getSafeChecks();
        this.lastPlugin = -1;
        this.totalPlugins = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Logger log = ThreadCategory.getInstance(this.getClass());
        FifoQueue lines = null;
        boolean found = false;
        Connection conn = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
        }
        catch (SQLException ex) {
            log.error((Object)"Could not open DB connection", (Throwable)ex);
            return;
        }
        try {
            PreparedStatement stmt = conn.prepareStatement(SELECT_ALL_VULNERABILITIES);
            d.watch((Object)stmt);
            stmt.setString(1, this.config.targetAddress.getHostAddress());
            ResultSet openVulnerabilitiesRS = stmt.executeQuery();
            d.watch((Object)openVulnerabilitiesRS);
            while (openVulnerabilitiesRS.next()) {
                this.openVulnerabilities.add(new Integer(openVulnerabilitiesRS.getInt("vulnerabilityid")));
            }
        }
        catch (SQLException ex) {
            log.error((Object)"Error when querying database for open vulnerabilities.");
            log.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            return;
        }
        finally {
            d.cleanUp();
        }
        Socket nessusSocket = null;
        try {
            String line;
            nessusSocket = NessusConnectionFactory.getConnection(this.config.hostname, this.config.hostport);
            if (nessusSocket == null) {
                throw new IOException("Factory returned null connection");
            }
            InputStream in = nessusSocket.getInputStream();
            OutputStream out = nessusSocket.getOutputStream();
            log.debug((Object)"Attached streams to the Nessus socket.");
            out.write("< NTP/1.2 >< md5_caching plugins_cve_id plugins_version>\n".getBytes());
            log.debug((Object)"Sent NTP version string.");
            lines = this.readLines(in);
            found = false;
            while (!found) {
                while (lines.size() > 0) {
                    line = (String)lines.remove();
                    log.debug((Object)("NTP string response: " + line));
                    if (line.indexOf(NTP_USERNAME_PROMPT) == -1) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                lines = this.readLines(in);
            }
            out.write((this.config.username + "\n").getBytes());
            log.debug((Object)"Sent username string.");
            found = false;
            while (!found) {
                while (lines.size() > 0) {
                    line = (String)lines.remove();
                    log.debug((Object)("Username response: " + line));
                    if (line.indexOf(NTP_PASSWORD_PROMPT) == -1) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                lines = this.readLines(in);
            }
            out.write((this.config.password + "\n").getBytes());
            log.debug((Object)"Sent password string.");
            found = false;
            while (!found) {
                while (lines.size() > 0) {
                    line = (String)lines.remove();
                    log.debug((Object)("Password response: " + line));
                    if (line.indexOf(" <|> SERVER".trim()) == -1) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                lines = this.readLines(in);
            }
            found = false;
            while (!found) {
                while (lines.size() > 0) {
                    line = (String)lines.remove();
                    log.debug((Object)("Preferences: " + line));
                    if (line.indexOf(" <|> SERVER".trim()) == -1) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                lines = this.readLines(in);
            }
            found = false;
            while (!found) {
                while (lines.size() > 0) {
                    line = (String)lines.remove();
                    log.debug((Object)("Rules: " + line));
                    if (line.indexOf(" <|> SERVER".trim()) == -1) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                lines = this.readLines(in);
            }
            out.write(this.buildPreferencesString().getBytes());
            log.debug((Object)"Sent preferences string.");
            found = false;
            while (!found) {
                while (lines.size() > 0) {
                    line = (String)lines.remove();
                    log.debug((Object)("Preferences response: " + line));
                    if (line.indexOf(" <|> SERVER".trim()) == -1) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                lines = this.readLines(in);
            }
            out.write(("CLIENT <|> NEW_ATTACK <|> " + this.config.targetAddress.getCanonicalHostName() + NTP_SEP + NTP_CLIENT_ENTITY + "\n").getBytes());
            log.debug((Object)("Sent NEW_ATTACK directive against target: " + this.config.targetAddress.getCanonicalHostName()));
            int returnCode = 0;
            while (returnCode == 0 || returnCode == 4) {
                while (lines.size() > 0) {
                    String line2 = (String)lines.remove();
                    log.debug((Object)("Nessus attack response: " + line2.replace('\n', ' ')));
                    if (line2.indexOf("the server killed it") == -1) {
                        returnCode = this.processScanMessage(line2);
                        continue;
                    }
                    log.error((Object)("Discarded inappropriate Nessus message: " + line2));
                }
                if (returnCode != 0 && returnCode != 4) continue;
                lines = this.readLines(in);
            }
            out.write(this.buildStopWholeTestString().getBytes());
            if (this.openVulnerabilities.size() > 0) {
                try {
                    conn = DataSourceFactory.getInstance().getConnection();
                    d.watch((Object)conn);
                }
                catch (SQLException ex) {
                    log.error((Object)"Could not open DB connection", (Throwable)ex);
                    log.info((Object)"Releasing Nessus socket connection");
                    if (nessusSocket != null) {
                        NessusConnectionFactory.releaseConnection(nessusSocket);
                    }
                    return;
                }
                try {
                    PreparedStatement stmt = conn.prepareStatement(RESOLVE_VULNERABILITY);
                    d.watch((Object)stmt);
                    Timestamp currentTime = new Timestamp(new Date().getTime());
                    Iterator vuln = this.openVulnerabilities.iterator();
                    while (vuln.hasNext()) {
                        stmt.setTimestamp(1, currentTime);
                        if (returnCode == 8 && this.lastPlugin == this.totalPlugins) {
                            stmt.setTimestamp(2, currentTime);
                        } else {
                            stmt.setNull(2, 93);
                        }
                        stmt.setInt(3, (Integer)vuln.next());
                        stmt.executeUpdate();
                    }
                }
                catch (SQLException ex) {
                    log.error((Object)"Error when querying database for open vulnerabilities.");
                    log.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                    log.info((Object)"Releasing Nessus socket connection");
                    if (nessusSocket != null) {
                        NessusConnectionFactory.releaseConnection(nessusSocket);
                    }
                    return;
                }
                finally {
                    d.cleanUp();
                }
            }
            log.debug((Object)("Sent STOP_WHOLE_TEST directive against target " + this.config.targetAddress.toString()));
        }
        catch (FifoQueueException ex) {
            log.warn((Object)ex, (Throwable)ex);
        }
        catch (InterruptedException ex) {
            log.warn((Object)ex, (Throwable)ex);
        }
        catch (IOException ex) {
            log.warn((Object)ex, (Throwable)ex);
        }
        finally {
            log.info((Object)"Releasing Nessus socket connection");
            if (nessusSocket != null) {
                NessusConnectionFactory.releaseConnection(nessusSocket);
            }
        }
        this.config.setScheduled(false);
        this.config.setLastScanned(new Date());
    }

    private String buildStopWholeTestString() {
        return "CLIENT <|> STOP_WHOLE_TEST <|> CLIENT\n";
    }

    private String buildStopScanString() {
        return "CLIENT <|> STOP_ATTACK" + this.config.targetAddress.toString() + NTP_SEP + NTP_CLIENT_ENTITY + "\n";
    }

    private String buildPreferencesString() {
        String retval = "CLIENT <|> PREFERENCES <|> \nplugin_set <|> " + this.pluginLists[this.config.scanLevel] + "\n" + "safe_checks" + NTP_SEP;
        retval = this.safeChecks[this.config.scanLevel] ? retval + "yes" : retval + "no";
        retval = retval + "\nmax_hosts <|> 1\nntp_short_status <|> yes\nreverse_lookup <|> yes\n <|> CLIENT";
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processScanMessage(String message) {
        Logger log = ThreadCategory.getInstance(this.getClass());
        int vulnerabilityId = -1;
        Connection conn = null;
        if (message.startsWith("SERVER <|> ".trim())) {
            int i = 0;
            String[] tokens = this.ntpTokenizer.split(message = message.substring("SERVER <|> ".length()).trim());
            String next = tokens[i++];
            if (next.equals("INFO") || next.equals("HOLE")) {
                NessusParser parser = NessusParser.getInstance();
                PortValues portvals = null;
                DescrValues descrvals = null;
                int pluginId = -1;
                int pluginSubId = -1;
                String pluginLogmsg = "";
                String hostname = tokens[i++];
                String portString = tokens[i++];
                try {
                    portvals = parser.parsePort(portString);
                }
                catch (IllegalArgumentException ex) {
                    log.error((Object)("Could not parse the port and protocol information out of this string: " + portString));
                    portvals = NessusParser.getDefaultPortValues();
                }
                String descrString = tokens[i++];
                try {
                    descrvals = parser.parseDescr(descrString);
                }
                catch (IllegalArgumentException ex) {
                    log.error((Object)("Could not parse the severity, descr, and/or CVE entry information out of this string: \n" + descrString));
                    descrvals = NessusParser.getDefaultDescrValues();
                }
                String pluginIdString = tokens[i++];
                try {
                    pluginId = Integer.parseInt(pluginIdString);
                }
                catch (NumberFormatException ex) {
                    log.error((Object)("Could not parse the plugin ID out of the string: " + pluginIdString), (Throwable)ex);
                }
                pluginSubId = 0;
                DBUtils d = new DBUtils(this.getClass());
                try {
                    conn = DataSourceFactory.getInstance().getConnection();
                    d.watch((Object)conn);
                }
                catch (SQLException ex) {
                    log.error((Object)"Could not open DB connection", (Throwable)ex);
                    return 2;
                }
                try {
                    PreparedStatement stmt = conn.prepareStatement(SELECT_OPEN_VULNERABILITY);
                    d.watch((Object)stmt);
                    stmt.setString(1, this.config.targetAddress.getHostAddress());
                    if (portvals.port > 0) {
                        stmt.setInt(2, portvals.port);
                    } else {
                        stmt.setNull(2, 4);
                    }
                    if (portvals.protocol != null) {
                        stmt.setString(3, portvals.protocol);
                    } else {
                        stmt.setNull(2, 12);
                    }
                    stmt.setInt(4, pluginId);
                    stmt.setInt(5, pluginSubId);
                    ResultSet openVuln = stmt.executeQuery();
                    d.watch((Object)openVuln);
                    if (openVuln.next()) {
                        stmt = conn.prepareStatement(VULNERABILITY_SCANNED);
                        Timestamp currentTime = new Timestamp(new Date().getTime());
                        stmt.setTimestamp(1, currentTime);
                        stmt.setTimestamp(2, currentTime);
                        stmt.setInt(3, openVuln.getInt("vulnerabilityid"));
                        int rowCount = stmt.executeUpdate();
                        if (rowCount != 1) {
                            log.error((Object)("UNEXPECTED CONDITION: " + rowCount + " row(s) updated during last scan successful UPDATE call"));
                        } else {
                            this.openVulnerabilities.remove(new Integer(openVuln.getInt("vulnerabilityid")));
                        }
                        if (openVuln.next()) {
                            log.error((Object)"UNEXPECTED CONDITION: There are multiple rows that match this vulnerability, ignoring subsequent rows.");
                        }
                    } else {
                        stmt = conn.prepareStatement(SELECT_NEXT_ID);
                        d.watch((Object)stmt);
                        ResultSet idRS = stmt.executeQuery();
                        d.watch((Object)idRS);
                        idRS.next();
                        int vulnId = idRS.getInt(1);
                        idRS.close();
                        idRS = null;
                        stmt = conn.prepareStatement(INSERT_NEW_VULNERABILITY);
                        d.watch((Object)stmt);
                        stmt.setInt(1, vulnId);
                        int nodeId = VulnscandConfigFactory.getInterfaceDbNodeId(conn, this.config.targetAddress);
                        if (nodeId > 0) {
                            stmt.setInt(2, nodeId);
                        } else {
                            stmt.setNull(2, 4);
                        }
                        stmt.setString(3, this.config.targetAddress.getHostAddress());
                        stmt.setNull(4, 4);
                        Timestamp currentTime = new Timestamp(new Date().getTime());
                        stmt.setTimestamp(5, currentTime);
                        stmt.setTimestamp(6, currentTime);
                        stmt.setTimestamp(7, currentTime);
                        stmt.setInt(8, descrvals.severity);
                        stmt.setInt(9, pluginId);
                        stmt.setInt(10, pluginSubId);
                        PreparedStatement pluginStmt = conn.prepareStatement(SELECT_PLUGIN_INFO);
                        d.watch((Object)pluginStmt);
                        pluginStmt.setInt(1, pluginId);
                        pluginStmt.setInt(2, pluginSubId);
                        ResultSet plugRS = pluginStmt.executeQuery();
                        d.watch((Object)plugRS);
                        if (plugRS.next()) {
                            if (plugRS.getString("name") != null && plugRS.getString("name").length() > 0) {
                                pluginLogmsg = plugRS.getString("name");
                            }
                            if (plugRS.getString("summary") != null && plugRS.getString("summary").length() > 0) {
                                if (!pluginLogmsg.equals("")) {
                                    pluginLogmsg = pluginLogmsg + ": ";
                                }
                                pluginLogmsg = pluginLogmsg + plugRS.getString("summary");
                            }
                        }
                        if (pluginLogmsg.equals("")) {
                            pluginLogmsg = portvals.port >= 0 ? "A vulnerability was detected on port " + portvals.port + ". See the description for more information." : "A vulnerability was detected. See the description for more information.";
                        }
                        stmt.setString(11, pluginLogmsg);
                        stmt.setString(12, descrvals.descr);
                        if (portvals.port >= 0) {
                            stmt.setInt(13, portvals.port);
                        } else {
                            stmt.setNull(13, 4);
                        }
                        stmt.setString(14, portvals.protocol);
                        if (descrvals.cveEntry != null) {
                            stmt.setString(15, descrvals.cveEntry);
                        } else {
                            stmt.setNull(15, 12);
                        }
                        if (stmt.executeUpdate() < 1) {
                            log.error((Object)"UNEXPECTED CONDITION: No rows inserted during last INSERT call.");
                        }
                    }
                }
                catch (SQLException ex) {
                    log.error((Object)("Error when querying database after " + next + " was found"));
                    log.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                    int openVuln = 2;
                    return openVuln;
                }
                finally {
                    d.cleanUp();
                }
                return 0;
            }
            if (next.equals("PORT")) {
                NessusParser parser = NessusParser.getInstance();
                PortValues portvals = null;
                int pluginId = -1;
                int pluginSubId = -1;
                String hostname = tokens[i++];
                String portString = tokens[i++];
                try {
                    portvals = parser.parsePort(portString);
                }
                catch (IllegalArgumentException ex) {
                    log.error((Object)("Could not parse the port and protocol information out of this string: " + portString));
                    portvals = NessusParser.getDefaultPortValues();
                }
                if (portvals.port < 0) {
                    log.error((Object)("Port could not be determined from Nessus PORT message (" + portvals.port + "), dropping the message."));
                    return 4;
                }
                DBUtils d = new DBUtils(this.getClass());
                try {
                    conn = DataSourceFactory.getInstance().getConnection();
                    d.watch((Object)conn);
                }
                catch (SQLException ex) {
                    log.error((Object)"Could not open DB connection", (Throwable)ex);
                    return 2;
                }
                try {
                    PreparedStatement stmt = conn.prepareStatement(SELECT_OPEN_VULNERABILITY);
                    d.watch((Object)stmt);
                    stmt.setString(1, this.config.targetAddress.getHostAddress());
                    if (portvals.port > 0) {
                        stmt.setInt(2, portvals.port);
                    } else {
                        stmt.setNull(2, 4);
                    }
                    if (portvals.protocol != null) {
                        stmt.setString(3, portvals.protocol);
                    } else {
                        stmt.setNull(2, 12);
                    }
                    stmt.setInt(4, 0);
                    stmt.setInt(5, 0);
                    ResultSet openVuln = stmt.executeQuery();
                    d.watch((Object)openVuln);
                    if (openVuln.next()) {
                        stmt = conn.prepareStatement(VULNERABILITY_SCANNED);
                        d.watch((Object)stmt);
                        Timestamp currentTime = new Timestamp(new Date().getTime());
                        stmt.setTimestamp(1, currentTime);
                        stmt.setTimestamp(2, currentTime);
                        stmt.setInt(3, openVuln.getInt("vulnerabilityid"));
                        int rowCount = stmt.executeUpdate();
                        if (rowCount != 1) {
                            log.error((Object)("UNEXPECTED CONDITION: " + rowCount + " row(s) updated during last scan successful UPDATE call"));
                        } else {
                            this.openVulnerabilities.remove(new Integer(openVuln.getInt("vulnerabilityid")));
                        }
                        if (openVuln.next()) {
                            log.error((Object)"UNEXPECTED CONDITION: There are multiple rows that match this vulnerability, ignoring subsequent rows.");
                        }
                    } else {
                        stmt = conn.prepareStatement(SELECT_NEXT_ID);
                        d.watch((Object)stmt);
                        ResultSet idRS = stmt.executeQuery();
                        d.watch((Object)idRS);
                        idRS.next();
                        int vulnId = idRS.getInt(1);
                        stmt = conn.prepareStatement(INSERT_NEW_VULNERABILITY);
                        d.watch((Object)stmt);
                        stmt.setInt(1, vulnId);
                        int nodeId = VulnscandConfigFactory.getInterfaceDbNodeId(conn, this.config.targetAddress);
                        if (nodeId > 0) {
                            stmt.setInt(2, nodeId);
                        } else {
                            stmt.setNull(2, 4);
                        }
                        stmt.setString(3, this.config.targetAddress.getHostAddress());
                        stmt.setNull(4, 4);
                        Timestamp currentTime = new Timestamp(new Date().getTime());
                        stmt.setTimestamp(5, currentTime);
                        stmt.setTimestamp(6, currentTime);
                        stmt.setTimestamp(7, currentTime);
                        stmt.setInt(8, 3);
                        stmt.setInt(9, 0);
                        stmt.setInt(10, 0);
                        stmt.setString(11, "Port " + portvals.port + " is open on this host.");
                        stmt.setString(12, "Port " + portvals.port + " is open on this host.");
                        if (portvals.port >= 0) {
                            stmt.setInt(13, portvals.port);
                        } else {
                            stmt.setNull(13, 4);
                        }
                        stmt.setString(14, portvals.protocol);
                        stmt.setNull(15, 12);
                        if (stmt.executeUpdate() < 1) {
                            log.error((Object)"UNEXPECTED CONDITION: No rows inserted during last INSERT call.");
                        }
                    }
                }
                catch (SQLException ex) {
                    log.error((Object)("Error when querying database after " + next + " was found"));
                    log.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                    int n = 2;
                    return n;
                }
                finally {
                    d.cleanUp();
                }
                return 0;
            }
            if (next.equals("STATUS")) {
                log.error((Object)"Weird... a non-abbreviated STATUS message. Check your code.");
                return 4;
            }
            if (next.equals("BYE")) {
                log.debug((Object)"BYE message received, ending scan");
                if (this.lastPlugin == this.totalPlugins) {
                    return 8;
                }
                return 2;
            }
            log.warn((Object)("Unhandled message type from Nessus: " + next + "\n" + message));
            return 4;
        }
        if (message.startsWith("s:")) {
            message = message.substring("s:".length()).trim();
            StringTokenizer parts = new StringTokenizer(message, ":");
            try {
                String next = parts.nextToken();
                if (next.equals("p")) {
                    String type = "portscan";
                    return 0;
                }
                if (next.equals("a")) {
                    String type = "attack";
                    String hostname = parts.nextToken();
                    int last = Integer.parseInt(parts.nextToken());
                    int total = Integer.parseInt(parts.nextToken());
                    if (this.lastPlugin >= 0 && last < this.lastPlugin) {
                        log.warn((Object)"UNEXPECTED CONDITION: The completed plugin counter decreased. Reporting the current scan complete.");
                        return 8;
                    }
                    this.lastPlugin = last;
                    log.debug((Object)("Last plugin: " + this.lastPlugin));
                    if (this.totalPlugins <= 0) {
                        this.totalPlugins = total;
                        log.debug((Object)("Plugin total: " + this.totalPlugins));
                    }
                    return 0;
                }
                log.error((Object)("UNEXPECTED CONDITION: Invalid abbreviated status message from Nessus, discarding...  \n\t" + message));
                return 4;
            }
            catch (NoSuchElementException ex) {
                log.error((Object)("UNEXPECTED CONDITION: Invalid abbreviated status message from Nessus, discarding...  \n\t" + message));
                return 2;
            }
            catch (NumberFormatException ex) {
                log.error((Object)("UNEXPECTED CONDITION: Could not parse integers out of this Nessus status message: " + message));
                return 2;
            }
        }
        log.warn((Object)("UNEXPECTED CONDITION: Unhandled message from Nessus: " + message));
        return 4;
    }

    public FifoQueue readLines(InputStream in) {
        Logger log = ThreadCategory.getInstance(this.getClass());
        String EOL = "\n";
        String alreadyRecdData = null;
        FifoQueueImpl retval = new FifoQueueImpl();
        ByteArrayOutputStream xmlStr = new ByteArrayOutputStream();
        int bytesInThisRead = 0;
        block4: while (true) {
            try {
                do {
                    byte[] message = new byte[1024];
                    bytesInThisRead = in.read(message);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("bytesInThisRead: " + bytesInThisRead));
                    }
                    if (bytesInThisRead < 0) break block4;
                    String newData = new String(message, 0, bytesInThisRead);
                    String tempStr = alreadyRecdData != null ? alreadyRecdData + newData : newData;
                    int index = -1;
                    while ((index = tempStr.indexOf(EOL)) != -1) {
                        int tlen = index + EOL.length();
                        if (tlen > tempStr.length()) {
                            tlen = tempStr.length();
                        }
                        byte[] tempb = tempStr.substring(0, tlen).getBytes();
                        xmlStr.write(tempb, 0, tlen);
                        retval.add((Object)new String(xmlStr.toByteArray(), 0, xmlStr.size()));
                        xmlStr.reset();
                        alreadyRecdData = null;
                        if (tlen != tempStr.length()) {
                            tempStr = tempStr.substring(tlen);
                            continue;
                        }
                        if (tlen != tempStr.length()) continue;
                        tempStr = "";
                    }
                    if (tempStr.length() == 0) continue;
                    alreadyRecdData = tempStr;
                } while (bytesInThisRead >= 1024);
                if (alreadyRecdData == null || alreadyRecdData.length() == 0) break;
                retval.add((Object)alreadyRecdData);
            }
            catch (FifoQueueException ex) {
                log.warn((Object)ex);
                continue;
            }
            catch (InterruptedException ex) {
                log.warn((Object)ex);
                continue;
            }
            catch (IOException e) {
                log.warn((Object)e);
                continue;
            }
            break;
        }
        return retval;
    }
}

