/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vulnscand;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.xml.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BroadcastEventProcessor
implements EventListener {
    private static String SQL_RETRIEVE_NODEID = "select nodeid from ipinterface where ipaddr=? and isManaged!='D'";
    private final FifoQueue<Runnable> m_suspectQ;
    private final Object m_scheduler;

    private void installMessageSelector() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/vulnscand/specificVulnerabilityScan");
        EventIpcManagerFactory.getIpcManager().addEventListener(this, ueiList);
    }

    BroadcastEventProcessor(FifoQueue<Runnable> suspectQ, Object scheduler) {
        this.m_suspectQ = suspectQ;
        this.m_scheduler = scheduler;
        this.installMessageSelector();
    }

    synchronized void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener(this);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void onEvent(Event event) {
        Logger log = ThreadCategory.getInstance(this.getClass());
        String eventUei = event.getUei();
        if (eventUei == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received event: " + eventUei));
        }
        if (!eventUei.equals("uei.opennms.org/vulnscand/specificVulnerabilityScan")) {
            log.error((Object)("Cannot process event with UEI: " + event.getUei()));
        }
    }

    public String getName() {
        return "Vulnscand:BroadcastEventProcessor";
    }
}

