/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vacuumd;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;

public class Transaction {
    private static ThreadLocal<Transaction> s_threadTX = new ThreadLocal();
    private Map<String, Connection> m_connections = new HashMap<String, Connection>();
    private List<Statement> m_statements = new LinkedList<Statement>();
    private List<ResultSet> m_resultSets = new LinkedList<ResultSet>();
    private boolean m_rollbackOnly = false;
    private DBUtils m_dbUtils = new DBUtils(Transaction.class);

    private static Transaction getTX() {
        Transaction tx = s_threadTX.get();
        if (tx == null) {
            throw new IllegalStateException("No transaction has been started for this thread!");
        }
        return tx;
    }

    private static void clearTX() {
        s_threadTX.set(null);
    }

    public static void begin() {
        Transaction.log().debug((Object)("About to being Transaction for " + Thread.currentThread()));
        Transaction tx = s_threadTX.get();
        if (tx != null) {
            throw new IllegalStateException("Cannot begin a transaction.. one has already been begun");
        }
        Transaction.log().debug((Object)("Began Transaction for " + Thread.currentThread()));
        s_threadTX.set(new Transaction());
    }

    private static Category log() {
        return ThreadCategory.getInstance(Transaction.class);
    }

    public static Connection getConnection(String dsName) throws SQLException {
        return Transaction.getTX().doGetConnection(dsName);
    }

    public static void register(Statement stmt) {
        Transaction.getTX().doRegister(stmt);
    }

    public static void register(ResultSet rs) {
        Transaction.getTX().doRegister(rs);
    }

    public static void rollbackOnly() throws SQLException {
        Transaction.getTX().doRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void end() throws SQLException {
        Transaction.log().debug((Object)("Ending transaction for " + Thread.currentThread()));
        try {
            Transaction tx = Transaction.getTX();
            tx.doEnd();
            Transaction.log().debug((Object)((tx.m_rollbackOnly ? "Rolled Back" : "Committed") + " transcation for " + Thread.currentThread()));
        }
        finally {
            Transaction.clearTX();
        }
    }

    private void doRegister(Statement stmt) {
        this.m_dbUtils.watch((Object)stmt);
        this.m_statements.add(stmt);
    }

    private void doRegister(ResultSet rs) {
        this.m_dbUtils.watch((Object)rs);
        this.m_resultSets.add(rs);
    }

    private void doClose() throws SQLException {
        this.m_dbUtils.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEnd() throws SQLException {
        try {
            for (Connection conn : this.m_connections.values()) {
                if (this.m_rollbackOnly) {
                    conn.rollback();
                    continue;
                }
                conn.commit();
            }
        }
        finally {
            this.doClose();
        }
    }

    private void doRollbackOnly() throws SQLException {
        this.m_rollbackOnly = true;
    }

    private Connection doGetConnection(String dsName) throws SQLException {
        if (!this.m_connections.containsKey(dsName)) {
            DataSource ds = DataSourceFactory.getDataSource((String)dsName);
            Connection conn = ds.getConnection();
            this.m_dbUtils.watch((Object)conn);
            this.m_connections.put(dsName, conn);
            conn.setAutoCommit(false);
        }
        return this.m_connections.get(dsName);
    }

    public void finalize() {
        this.m_dbUtils.cleanUp();
    }
}

