/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

public class SocketChannelUtil {
    public static SocketChannel getConnectedSocketChannel(InetAddress host, int port, int timeout) throws IOException, InterruptedException {
        SocketChannel sChannel = null;
        try {
            sChannel = SocketChannel.open();
            sChannel.configureBlocking(false);
            sChannel.connect(new InetSocketAddress(host, port));
            long startConnectTime = System.currentTimeMillis();
            do {
                if (sChannel.finishConnect()) continue;
                Thread.sleep(100L);
            } while (!sChannel.isConnected() && System.currentTimeMillis() - startConnectTime <= (long)timeout);
            if (!sChannel.isConnected()) {
                if (sChannel.socket() != null) {
                    sChannel.socket().close();
                }
                sChannel.close();
                sChannel = null;
            } else {
                sChannel.configureBlocking(true);
                sChannel.socket().setSoTimeout(timeout);
            }
        }
        catch (IOException e) {
            if (sChannel != null) {
                if (sChannel.socket() != null) {
                    sChannel.socket().close();
                }
                sChannel.close();
                sChannel = null;
            }
            throw e;
        }
        catch (InterruptedException e) {
            if (sChannel != null) {
                if (sChannel.socket() != null) {
                    sChannel.socket().close();
                }
                sChannel.close();
                sChannel = null;
            }
            throw e;
        }
        return sChannel;
    }
}

