/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.utils;

import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.opennms.core.utils.ThreadCategory;

public class IpValidator {
    public static boolean isIpValid(String ipAddr) {
        Logger log = ThreadCategory.getInstance(IpValidator.class);
        StringTokenizer token = new StringTokenizer(ipAddr, ".");
        if (token.countTokens() != 4) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid format for IpAddress " + ipAddr));
            }
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            try {
                int temp = Integer.parseInt(token.nextToken(), 10);
                if (temp >= 0 && temp <= 255) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid value " + temp + " in IpAddress"));
                }
                return false;
            }
            catch (NumberFormatException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid format for IpAddress, " + ex));
                }
                return false;
            }
        }
        return true;
    }
}

